/*
 * Decompiled with CFR 0.152.
 */
package io;

import emu98.Console;
import io.DisplayInterface;
import io.IOinterface;
import io.KeyboardInterface;
import io.MagneticCardReaderInterface;
import java.util.Enumeration;
import java.util.Vector;

public class IOregister {
    static final int DIO_mask = 255;
    static final int SIO_mask = 3840;
    static final int CO_mask = 61440;
    static final int SD_mask = 4095;
    public static final int devStatusReady = 256;
    public int SSI;
    public boolean SSF;
    public boolean STP;
    public boolean SIH;
    public boolean CEO;
    public boolean MCR;
    public boolean MLS;
    public boolean MFL;
    public boolean PEN;
    public boolean DEN;
    public boolean KLS;
    public boolean dispSRQ;
    public Counter dispCounter;
    public Counter keyCounter;
    public final int DISP_INSTR = 1000;
    public final int KEYB_INSTR = 1000;
    private int value;
    public boolean line10_20;
    public boolean reset = true;
    public Bus bus = new Bus(0);
    int mask;
    public int time_1ms = 1;
    public int time_7ms = 7;
    public int time_10ms = 10;
    public int time_12ms = 12;
    public int time_16ms = 16;
    public int time_30ms = 30;
    public int time_32ms = 32;
    public int time_100ms = 100;
    Console console;

    public IOregister(int bitMask, int initValue) {
        this.mask = bitMask;
        this.value = initValue;
        this.SSI = 0;
        this.MFL = false;
        this.KLS = false;
        this.DEN = false;
        this.PEN = false;
        this.MCR = false;
        this.CEO = false;
        this.STP = false;
        this.SSF = false;
        this.SIH = true;
        this.line10_20 = false;
        this.dispCounter = new Counter(1000);
        this.keyCounter = new Counter(1000);
        System.out.print("Timing calibration in progress ");
        this.time_1ms = this.checkTiming(1);
        this.time_7ms = this.checkTiming(7);
        this.time_10ms = this.checkTiming(10);
        this.time_12ms = this.checkTiming(12);
        this.time_16ms = this.checkTiming(16);
        this.time_30ms = this.checkTiming(30);
        this.time_32ms = this.checkTiming(32);
        this.time_100ms = this.checkTiming(100);
        System.out.print(" done.\n");
        System.out.println("HP9800 I/O register at select code 1:0 loaded.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int checkTiming(int time) {
        long t = 0L;
        int num = 100 / time;
        IOregister iOregister = this;
        synchronized (iOregister) {
            int i = 1;
            while (i <= num) {
                t -= System.nanoTime();
                try {
                    Thread.sleep(time);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                t += System.nanoTime();
                ++i;
            }
        }
        time = (int)(1000000L * (long)num * (long)time * (long)time / t);
        System.out.print(".");
        return time;
    }

    public void setDisassemblerOutput(Console console) {
        this.console = console;
    }

    public void instructionCounter() {
        if (this.dispCounter.count()) {
            this.bus.display.blank();
        }
        if (this.keyCounter.count()) {
            this.bus.keyboard.release();
        }
    }

    public synchronized int getSelectCode() {
        return (this.value & 0xF000) >> 12;
    }

    synchronized void setValue(int value) {
        this.value = value;
    }

    synchronized void setStatusData(int value) {
        this.value = this.value & 0xF000 | value & 0xFFF;
    }

    synchronized void setSelectCode(int value) {
        this.value = value << 12 & 0xF000 | this.value & 0xFFF;
    }

    public synchronized int getValue() {
        return this.value;
    }

    synchronized int getStatus() {
        return this.value & 0xF00;
    }

    synchronized int getData() {
        return this.value & 0xFF;
    }

    synchronized void setData(int dio) {
        this.value = this.value & 0xFF00 | (dio &= 0xFF);
    }

    synchronized void setStatus(int sio) {
        this.value = this.value & 0xF0FF | (sio &= 0xF00);
    }

    public synchronized void input() {
        this.value = this.value & 0xF000 | this.bus.value & 0xFFF;
    }

    public synchronized boolean serviceRequested() {
        return !this.SSF && (!this.SIH && this.SSI != 0) | this.STP;
    }

    public synchronized void serviceRequestAcknowledge() {
        this.SSF = true;
        this.SIH = true;
        this.dispSRQ = true;
        this.setSelectCode(0);
        if (this.line10_20) {
            this.bus.value = this.SSI == 2048 ? 0 : this.SSI & 0xFFFF;
        }
        this.input();
    }

    public class Bus {
        public Vector devices;
        IOinterface device;
        public KeyboardInterface keyboard;
        public DisplayInterface display;
        public MagneticCardReaderInterface cardReader;
        Enumeration devEnum = null;
        public int value;

        public Bus(int value) {
            this.value = value;
            this.devices = new Vector();
            System.out.println("HP9800 I/O bus loaded.");
        }

        public IOinterface selectDevice() {
            int selectCode = IOregister.this.getSelectCode();
            if (selectCode != 0) {
                this.devEnum = this.devices.elements();
                while (this.devEnum.hasMoreElements()) {
                    IOinterface device = (IOinterface)this.devEnum.nextElement();
                    if (device.selectCode != selectCode) continue;
                    return device;
                }
            }
            this.devEnum = null;
            return null;
        }

        public IOinterface nextDevice() {
            int selectCode = IOregister.this.getSelectCode();
            if (this.devEnum != null) {
                while (this.devEnum.hasMoreElements()) {
                    IOinterface device = (IOinterface)this.devEnum.nextElement();
                    if (device.selectCode != selectCode) continue;
                    return device;
                }
                this.devEnum = null;
            }
            return null;
        }

        public synchronized void setCEO() {
            IOregister.this.CEO = true;
            this.device = this.selectDevice();
            if (this.device != null) {
                IOregister.this.CEO = this.device.output();
                if (IOregister.this.CEO) {
                    IOregister.this.CEO = this.device.input();
                }
            }
        }

        synchronized void setData(int dio) {
            this.value = this.value & 0xFF00 | (dio &= 0xFF);
        }

        synchronized void setStatus(int sio) {
            this.value = this.value & 0xF0FF | (sio &= 0xF00);
        }
    }

    public class Counter {
        private int value;
        private int initialValue;

        public Counter(int init) {
            this.initialValue = init;
            this.value = 0;
        }

        public synchronized void restart() {
            this.value = this.initialValue;
        }

        public synchronized boolean count() {
            return this.value > 0 && --this.value == 0;
        }

        public synchronized boolean running() {
            return this.value > 0;
        }
    }
}

