/*
 * Decompiled with CFR 0.152.
 */
package io;

import io.HP9800Mainframe;
import io.IOinterface;
import io.IOregister;
import io.SoundMedia;
import java.io.IOException;
import java.io.RandomAccessFile;

public class MagneticCardReaderInterface
extends IOinterface {
    static final int CARD_DATA = 7;
    static final int CARD_END_RECORD = 8;
    static final int CARD_IN = 16;
    static final int CARD_UNPROTECTED = 32;
    static final int CARD_END_LOAD = 64;
    static final int STROBE_DATA = 8;
    static final int INHIBIT_SOURCE = 16;
    static final int MOTOR_CONTROL = 32;
    static int WAIT_BYTE = 7;
    static int WAIT_INSERT = 200;
    static final int WAIT_CARD = 3000;
    static final int WAIT_IDLE = 10000;
    static final boolean asyncMode = false;
    public HP9800Mainframe mainframe;
    public IOregister ioReg;
    int outBuffer = 0;
    int dataStrobe = 0;
    int sensors = 0;
    RandomAccessFile cardFile;
    SoundMedia motorSound;
    SoundMedia startSound;
    SoundMedia loopSound;
    SoundMedia cardSound;
    int timerValue = 10000;
    boolean readMode = false;
    boolean debug = false;

    public MagneticCardReaderInterface() {
    }

    public MagneticCardReaderInterface(HP9800Mainframe mainframe, IOregister ioReg) {
        super(0, ioReg, "MCR");
        this.mainframe = mainframe;
        this.ioReg = ioReg;
        WAIT_BYTE = ioReg.time_7ms;
        WAIT_INSERT = 2 * ioReg.time_100ms;
        this.startSound = new SoundMedia("media/HP9800/HP9800_CARD_START.wav");
        this.loopSound = new SoundMedia("media/HP9800/HP9800_CARD_MOTOR.wav");
        this.cardSound = new SoundMedia("media/HP9800/HP9800_CARD_IN.wav");
        System.out.println("HP9800 Magnetic Card Reader at select code 2:0 loaded.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            try {
                Thread.sleep(this.timerValue);
            }
            catch (InterruptedException e) {
                continue;
            }
            IOregister iOregister = this.ioReg;
            synchronized (iOregister) {
                switch (this.sensors) {
                    case 0: {
                        break;
                    }
                    case 8: {
                        if (this.cardFile != null) break;
                        this.motorSound = this.loopSound;
                        this.motorSound.loop();
                        if (this.openCardFile()) {
                            this.sensors |= 0x50;
                            this.ioReg.bus.value = this.sensors;
                            this.motorSound.stop();
                            this.motorSound = this.cardSound;
                            this.motorSound.loop();
                            boolean bl = this.readMode = (this.outBuffer & 0x10) != 0;
                            if (this.readMode) {
                                this.timerValue = 3000;
                                break;
                            }
                            this.timerValue = 3000;
                            break;
                        }
                        this.ioReg.bus.value = this.sensors = 0;
                        break;
                    }
                    case 88: 
                    case 120: {
                        if (this.readMode) {
                            // empty if block
                        }
                        this.ioReg.MFL = false;
                        this.ioReg.bus.value = this.sensors = 0;
                    }
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    boolean openCardFile() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean closeCardFile() {
        if (this.cardFile != null) {
            try {
                this.cardFile.close();
                this.cardFile = null;
            }
            catch (IOException iOException) {}
        } else {
            this.motorSound.stop();
        }
        IOregister iOregister = this.ioReg;
        synchronized (iOregister) {
            this.readMode = false;
            this.ioReg.MFL = false;
            this.ioReg.bus.value = this.sensors = 0;
            this.timerValue = 10000;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean output() {
        IOregister iOregister = this.ioReg;
        synchronized (iOregister) {
            int value = this.ioReg.getValue();
            if (this.ioReg.MLS) {
                this.outBuffer = value;
                if ((this.outBuffer & 0x20) != 0) {
                    switch (this.sensors) {
                        case 0: {
                            this.startSound.start();
                            this.ioReg.bus.value = this.sensors = 8;
                            this.timerValue = WAIT_INSERT;
                            this.devThread.interrupt();
                            break;
                        }
                        case 120: {
                            try {
                                this.cardFile.writeByte(~this.outBuffer & 7);
                                try {
                                    Thread.sleep(0L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                if (!this.debug) break;
                                this.ioReg.console.append("HP9800 MC write " + Integer.toHexString(~this.outBuffer & 7) + "\n");
                                break;
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                if (this.debug) {
                    this.ioReg.console.append("HP9800 MLS " + Integer.toHexString(value) + "\n");
                }
                this.ioReg.MLS = false;
            }
            if (this.ioReg.MCR) {
                this.dataStrobe = value & 8;
                if (this.debug) {
                    this.ioReg.console.append("HP9800 MCR " + Integer.toHexString(value) + "\n");
                }
            }
            if ((this.outBuffer & 0x20) != 0) {
                this.ioReg.bus.value = this.sensors;
            } else {
                this.closeCardFile();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean input() {
        if (this.readMode && this.cardFile != null) {
            try {
                IOregister iOregister = this.ioReg;
                synchronized (iOregister) {
                    this.ioReg.bus.value = this.cardFile.readByte() | this.sensors;
                    this.ioReg.MFL = true;
                }
                if (this.debug) {
                    this.ioReg.console.append("HP9800 MC read " + Integer.toHexString(this.ioReg.bus.value & 7) + "\n");
                }
            }
            catch (IOException e) {
                this.readMode = false;
            }
        }
        return true;
    }
}

