/*
 * Decompiled with CFR 0.152.
 */
package emu98;

import emu98.Emulator;
import emu98.Memory;
import io.ImageMedia;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;

public class Console
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JLabel columnLabels = null;
    private JTextArea disassemblerOutput = null;
    private JPanel buttons = null;
    private JButton runButton = null;
    private JScrollPane disassemblerOutputScrollPane = null;
    private JButton stepButton = null;
    private JCheckBox disassembleCheckBox = null;
    private JComboBox timerComboBox = null;
    private JLabel timerLabel = null;
    private static final int MAX_LINES = 4096;
    private Emulator emu;
    private JButton clearButton = null;
    private JLabel disasmLabel = null;
    private JLabel programLabel = null;
    private JLabel outputLabel = null;
    private JButton keyLogButton = null;
    private JButton traceButton = null;
    private JCheckBox keyLogCheckBox = null;

    public Console(Frame owner, Emulator emu) {
        super(owner);
        this.initialize();
        this.emu = emu;
    }

    private void initialize() {
        this.setResizable(true);
        this.setBounds(new Rectangle(0, 0, 550, 350));
        this.setContentPane(this.getJContentPane());
        this.setTitle("HP9800 Console");
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = 1;
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridy = 1;
            gridBagConstraints5.weighty = 1.0;
            gridBagConstraints5.weightx = 1.0;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.ipadx = 500;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridy = 0;
            this.columnLabels = new JLabel();
            this.columnLabels.setText(" A       B       E IO   mcisKDPMCS      PC      OPCODE  INSTR           AR1                     AR2");
            this.columnLabels.setForeground(new Color(253, 253, 253));
            this.columnLabels.setPreferredSize(new Dimension(700, 17));
            this.columnLabels.setFont(new Font("Monospaced", 0, 12));
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.setBackground(new Color(87, 87, 75));
            this.jContentPane.add((Component)this.columnLabels, gridBagConstraints2);
            this.jContentPane.add((Component)this.getDisassemblerOutputScrollPane(), gridBagConstraints5);
            this.jContentPane.add((Component)this.getButtons(), gridBagConstraints4);
        }
        return this.jContentPane;
    }

    private JTextArea getDisassemblerOutput() {
        if (this.disassemblerOutput == null) {
            this.disassemblerOutput = new JTextArea();
            this.disassemblerOutput.setFont(new Font("Monospaced", 0, 12));
            this.disassemblerOutput.setForeground(Color.blue);
            this.disassemblerOutput.setBackground(new Color(230, 230, 230));
        }
        return this.disassemblerOutput;
    }

    private JPanel getButtons() {
        if (this.buttons == null) {
            GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
            gridBagConstraints31.gridx = 1;
            gridBagConstraints31.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints31.gridy = 2;
            GridBagConstraints gridBagConstraints24 = new GridBagConstraints();
            gridBagConstraints24.gridx = 0;
            gridBagConstraints24.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints24.gridy = 1;
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.gridx = 1;
            gridBagConstraints13.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints13.gridy = 1;
            GridBagConstraints gridBagConstraints41 = new GridBagConstraints();
            gridBagConstraints41.gridx = 2;
            gridBagConstraints41.gridy = 0;
            this.outputLabel = new JLabel();
            this.outputLabel.setText("OUTPUT");
            this.outputLabel.setFont(new Font("Dialog", 0, 12));
            this.outputLabel.setForeground(new Color(253, 253, 253));
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 4;
            gridBagConstraints3.gridwidth = 2;
            gridBagConstraints3.gridy = 0;
            this.programLabel = new JLabel();
            this.programLabel.setText("______ PROGRAM ______");
            this.programLabel.setForeground(new Color(253, 253, 253));
            this.programLabel.setFont(new Font("Dialog", 0, 12));
            GridBagConstraints gridBagConstraints23 = new GridBagConstraints();
            gridBagConstraints23.gridx = 0;
            gridBagConstraints23.gridwidth = 2;
            gridBagConstraints23.gridy = 0;
            this.disasmLabel = new JLabel();
            this.disasmLabel.setText("_______ MODE _______");
            this.disasmLabel.setFont(new Font("Dialog", 0, 12));
            this.disasmLabel.setForeground(new Color(253, 253, 253));
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 2;
            gridBagConstraints11.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints11.gridy = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 0;
            this.timerLabel = new JLabel();
            this.timerLabel.setText("WAIT");
            this.timerLabel.setForeground(new Color(253, 253, 253));
            this.timerLabel.setFont(new Font("Dialog", 0, 12));
            GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
            gridBagConstraints22.gridy = 1;
            gridBagConstraints22.ipadx = 40;
            gridBagConstraints22.ipady = 0;
            gridBagConstraints22.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints22.gridx = 3;
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 0;
            gridBagConstraints12.insets = new Insets(0, 0, 5, 0);
            gridBagConstraints12.gridy = 2;
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridx = 4;
            gridBagConstraints21.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints21.gridy = 1;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 5;
            gridBagConstraints1.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints1.gridy = 1;
            this.buttons = new JPanel();
            this.buttons.setLayout(new GridBagLayout());
            this.buttons.setBackground(new Color(87, 87, 75));
            this.buttons.add((Component)this.getTraceButton(), gridBagConstraints24);
            this.buttons.add((Component)this.getDisassembleCheckBox(), gridBagConstraints12);
            this.buttons.add((Component)this.getKeyLogButton(), gridBagConstraints13);
            this.buttons.add((Component)this.getKeyLogCheckBox(), gridBagConstraints31);
            this.buttons.add((Component)this.getClearButton(), gridBagConstraints11);
            this.buttons.add((Component)this.getTimerComboBox(), gridBagConstraints22);
            this.buttons.add((Component)this.getStepButton(), gridBagConstraints21);
            this.buttons.add((Component)this.getRunButton(), gridBagConstraints1);
            this.buttons.add((Component)this.timerLabel, gridBagConstraints);
            this.buttons.add((Component)this.disasmLabel, gridBagConstraints23);
            this.buttons.add((Component)this.programLabel, gridBagConstraints3);
            this.buttons.add((Component)this.outputLabel, gridBagConstraints41);
        }
        return this.buttons;
    }

    private JButton getRunButton() {
        if (this.runButton == null) {
            this.runButton = new JButton();
            this.runButton.setActionCommand("Run");
            this.runButton.setIcon(new ImageIcon(new ImageMedia("media/HP9800/RUN.jpg").getImage()));
            this.runButton.setMnemonic(0);
            this.runButton.setPreferredSize(new Dimension(70, 25));
            this.runButton.addActionListener(this);
        }
        return this.runButton;
    }

    private JButton getClearButton() {
        if (this.clearButton == null) {
            this.clearButton = new JButton();
            this.clearButton.setIcon(new ImageIcon(new ImageMedia("media/HP9800/CLEAR.jpg").getImage()));
            this.clearButton.setPreferredSize(new Dimension(70, 25));
            this.clearButton.setActionCommand("Clear");
            this.clearButton.addActionListener(this);
        }
        return this.clearButton;
    }

    private JCheckBox getDisassembleCheckBox() {
        if (this.disassembleCheckBox == null) {
            this.disassembleCheckBox = new JCheckBox();
            this.disassembleCheckBox.setForeground(new Color(253, 253, 253));
            this.disassembleCheckBox.setIcon(new ImageIcon(new ImageMedia("media/HP9810A/HP9810A_LED_Large_Off.jpg").getImage()));
            this.disassembleCheckBox.setSelectedIcon(new ImageIcon(new ImageMedia("media/HP9810A/HP9810A_LED_Large_On.jpg").getImage()));
            this.disassembleCheckBox.setFont(new Font("Dialog", 0, 12));
            this.disassembleCheckBox.setBackground(new Color(87, 87, 75));
            this.disassembleCheckBox.setDisabledIcon(new ImageIcon(new ImageMedia("media/HP9810A/HP9810A_LED_Large_Off.jpg").getImage()));
            this.disassembleCheckBox.setActionCommand("TraceLED");
            this.disassembleCheckBox.addActionListener(this);
        }
        return this.disassembleCheckBox;
    }

    private JCheckBox getKeyLogCheckBox() {
        if (this.keyLogCheckBox == null) {
            this.keyLogCheckBox = new JCheckBox();
            this.keyLogCheckBox.setBackground(new Color(87, 87, 75));
            this.keyLogCheckBox.setForeground(new Color(253, 253, 253));
            this.keyLogCheckBox.setDisabledIcon(new ImageIcon(new ImageMedia("media/HP9810A/HP9810A_LED_Large_Off.jpg").getImage()));
            this.keyLogCheckBox.setIcon(new ImageIcon(new ImageMedia("media/HP9810A/HP9810A_LED_Large_Off.jpg").getImage()));
            this.keyLogCheckBox.setSelectedIcon(new ImageIcon(new ImageMedia("media/HP9810A/HP9810A_LED_Large_On.jpg").getImage()));
            this.keyLogCheckBox.setActionCommand("KeylogLED");
            this.keyLogCheckBox.addActionListener(this);
        }
        return this.keyLogCheckBox;
    }

    private JComboBox getTimerComboBox() {
        if (this.timerComboBox == null) {
            this.timerComboBox = new JComboBox();
            this.timerComboBox.setEditable(true);
            this.timerComboBox.setName("TimerValue");
            this.timerComboBox.setActionCommand("timerChanged");
            this.timerComboBox.setBackground(new Color(87, 87, 75));
            this.timerComboBox.setPreferredSize(new Dimension(30, 25));
            this.timerComboBox.addItem("INFINITE");
            this.timerComboBox.addItem("100000");
            this.timerComboBox.addItem("10000");
            this.timerComboBox.addItem("1000");
            this.timerComboBox.addItem("100");
            this.timerComboBox.addItem("10");
            this.timerComboBox.addItem("1");
            this.timerComboBox.addActionListener(this);
        }
        return this.timerComboBox;
    }

    private JScrollPane getDisassemblerOutputScrollPane() {
        if (this.disassemblerOutputScrollPane == null) {
            this.disassemblerOutputScrollPane = new JScrollPane();
            this.disassemblerOutputScrollPane.setHorizontalScrollBarPolicy(31);
            this.disassemblerOutputScrollPane.setVerticalScrollBarPolicy(22);
            this.disassemblerOutputScrollPane.setViewportView(this.getDisassemblerOutput());
        }
        return this.disassemblerOutputScrollPane;
    }

    private JButton getStepButton() {
        if (this.stepButton == null) {
            this.stepButton = new JButton();
            this.stepButton.setIcon(new ImageIcon(new ImageMedia("media/HP9800/STEP.jpg").getImage()));
            this.stepButton.setPreferredSize(new Dimension(70, 25));
            this.stepButton.setActionCommand("Step");
            this.stepButton.addActionListener(this);
        }
        return this.stepButton;
    }

    private JButton getKeyLogButton() {
        if (this.keyLogButton == null) {
            this.keyLogButton = new JButton();
            this.keyLogButton.setPreferredSize(new Dimension(70, 25));
            this.keyLogButton.setIcon(new ImageIcon(new ImageMedia("media/HP9800/KEYLOG.jpg").getImage()));
            this.keyLogButton.setActionCommand("KeyLog");
            this.keyLogButton.addActionListener(this);
        }
        return this.keyLogButton;
    }

    private JButton getTraceButton() {
        if (this.traceButton == null) {
            this.traceButton = new JButton();
            this.traceButton.setPreferredSize(new Dimension(70, 25));
            this.traceButton.setIcon(new ImageIcon(new ImageMedia("media/HP9800/TRACE.jpg").getImage()));
            this.traceButton.setActionCommand("Trace");
            this.traceButton.addActionListener(this);
        }
        return this.traceButton;
    }

    public void append(String line) {
        int lines = this.disassemblerOutput.getLineCount();
        int num = 0;
        if (lines > 4096) {
            try {
                num = this.disassemblerOutput.getLineEndOffset(0);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            this.disassemblerOutput.replaceRange(null, 0, num);
        }
        this.disassemblerOutput.append(line);
        this.disassemblerOutputScrollPane.getVerticalScrollBar().setValue(100000000);
    }

    public void clear() {
        int lines = this.disassemblerOutput.getLineCount();
        int num = 0;
        try {
            num = this.disassemblerOutput.getLineEndOffset(lines - 1);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        this.disassemblerOutput.replaceRange(null, 0, num);
    }

    public void breakpoint() {
        this.disassembleCheckBox.setEnabled(false);
        this.disassembleCheckBox.setSelected(false);
        this.traceButton.setEnabled(false);
        this.runButton.setEnabled(true);
        Memory.trace = true;
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd.equals("Trace")) {
            this.disassembleCheckBox.setSelected(!this.disassembleCheckBox.isSelected());
            this.stepButton.setEnabled(!this.disassembleCheckBox.isSelected());
            this.emu.setDisassemblerMode(this.disassembleCheckBox.isSelected());
        }
        if (cmd.equals("TraceLED")) {
            this.stepButton.setEnabled(!this.disassembleCheckBox.isSelected());
            this.emu.setDisassemblerMode(this.disassembleCheckBox.isSelected());
        }
        if (cmd.equals("timerChanged")) {
            try {
                this.emu.timerValue = Integer.parseInt(this.timerComboBox.getSelectedItem().toString());
            }
            catch (NumberFormatException e) {
                this.emu.timerValue = 0;
            }
        }
        if (cmd.equals("Clear")) {
            this.clear();
        }
        if (cmd.equals("Step")) {
            this.disassembleCheckBox.setEnabled(false);
            this.disassembleCheckBox.setSelected(false);
            this.traceButton.setEnabled(false);
            this.runButton.setEnabled(true);
            Memory.trace = true;
            this.emu.emuThread.interrupt();
        }
        if (cmd.equals("Run")) {
            this.disassembleCheckBox.setEnabled(true);
            this.traceButton.setEnabled(true);
            this.runButton.setEnabled(false);
            Memory.trace = false;
            this.emu.emuThread.interrupt();
        }
        if (cmd.equals("KeyLog")) {
            this.keyLogCheckBox.setSelected(!this.keyLogCheckBox.isSelected());
            this.emu.keyLogMode = this.keyLogCheckBox.isSelected();
        }
        if (cmd.equals("KeyLogLED")) {
            this.emu.keyLogMode = this.keyLogCheckBox.isSelected();
        }
    }
}

