/*
 * Decompiled with CFR 0.152.
 */
package emu98;

import emu98.Console;
import emu98.Memory;
import emu98.MemoryBlock;
import emu98.ProgramCounter;
import emu98.Register;
import io.HP11202HostFileIO;
import io.HP11305A;
import io.HP9860A;
import io.HP9861A;
import io.HP9862A;
import io.HP9865A;
import io.HP9866A;
import io.IOinstruction;
import io.IOregister;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Emulator
implements Runnable {
    public String model;
    public String version;
    public IOregister ioRegister;
    public Memory[] memory;
    public Hashtable memoryBlocks;
    public Hashtable ioDevices;
    public Hashtable keyCodes;
    public Hashtable keyStrings;
    Thread emuThread;
    public Console console;
    DataInputStream asmFile;
    Register register;
    Register registerA = new Register("A", 65535, 0);
    Register registerB = new Register("B", 65535, 0);
    Register registerE = new Register("E", 15, 0);
    ProgramCounter registerP = new ProgramCounter(Short.MAX_VALUE, 0);
    IOinstruction ioInstruction;
    private Memory unusedMemory;
    public long minExecTime;
    public long maxExecTime;
    public long sumExecTime;
    public long numOps;
    public boolean measure = false;
    int timerValue = 0;
    boolean emulate;
    boolean disassemble;
    boolean dumpRegisters;
    boolean dumpFPregisters;
    boolean FPop;
    public boolean keyLogMode = false;
    private String instr;
    static final int AR1 = 996;
    static final int AR2 = 1004;
    static final int systemProgramCounter = 960;
    static final int systemStackPointer = 1023;
    static final int startupVector = 0;
    static final int interruptVector = 2;

    public Emulator(String machine) {
        this.ioRegister = new IOregister(65535, 0);
        this.ioInstruction = new IOinstruction(this.ioRegister);
        this.memory = new Memory[32768];
        this.unusedMemory = new Memory(false, -1, 0);
        int i = 0;
        while (i <= Short.MAX_VALUE) {
            this.memory[i] = this.unusedMemory;
            ++i;
        }
        Memory.emu = this;
        this.dumpFPregisters = false;
        this.dumpRegisters = false;
        this.disassemble = false;
        this.emulate = true;
        this.emuThread = new Thread((Runnable)this, "HP9800 CPU");
        this.emuThread.setPriority(4);
        System.out.println("HP9800 CPU loaded.");
        this.memoryBlocks = new Hashtable();
        this.loadConfig(machine);
        this.keyCodes = new Hashtable();
        this.keyStrings = new Hashtable();
        this.loadKeyConfig(machine);
        this.setDisassemblerMode(false);
    }

    public void start() {
        this.emuThread.start();
    }

    public void setDisassemblerMode(boolean disasmMode) {
        this.dumpRegisters = this.dumpFPregisters = disasmMode;
        this.disassemble = this.dumpFPregisters;
    }

    public void setConsole(Console console) {
        this.console = console;
    }

    public void setEmulatorMode(boolean emuMode) {
        this.emulate = emuMode;
    }

    public void startMeasure() {
        this.minExecTime = 100000000000L;
        this.numOps = 0L;
        this.sumExecTime = 0L;
        this.maxExecTime = 0L;
        this.measure = true;
    }

    public void stopMeasure() {
        this.measure = false;
    }

    public char asciiChar(char c) {
        if (c < ' ' || c > '_') {
            c = (char)32;
        }
        return c;
    }

    public String intToOctalString(int value, int digits) {
        String oct_value = Integer.toOctalString(value);
        return String.valueOf("0000000000".substring(10 - digits).substring(oct_value.length())) + oct_value;
    }

    public String intToHexString(int value, int digits) {
        String hex_value = Integer.toHexString(value);
        return String.valueOf("0000000000".substring(10 - digits).substring(hex_value.length())) + hex_value;
    }

    public void pushStack(int address) {
        int sp = this.memory[1023].getValue() & Short.MAX_VALUE;
        this.memory[sp].setValue(address);
        this.memory[1023].setValue(sp + 1);
    }

    public int popStack() {
        int sp = this.memory[1023].getValue() - 1;
        this.memory[1023].setValue(sp);
        return this.memory[sp].getValue();
    }

    public String memoryReferenceGroup(int opcode, int address) {
        boolean indirect;
        String indStr = null;
        int memory_address = opcode & 0x3FF;
        if ((opcode & 0x400) != 0) {
            memory_address |= address & 0x7FC00;
        }
        int direct_address = memory_address;
        boolean bl = indirect = (opcode & 0x8000) != 0;
        if (indirect && this.emulate) {
            while (((memory_address = this.memory[memory_address & Short.MAX_VALUE].getValue()) & 0x8000) != 0) {
            }
        }
        if (this.disassemble) {
            indStr = indirect ? ",I" : "";
        }
        Memory m = this.memory[memory_address];
        switch (opcode & 0x7800) {
            case 0: 
            case 2048: {
                if (this.disassemble) {
                    this.instr = "AD" + this.register.name;
                }
                if (!this.emulate) break;
                int regVal = this.register.getValue() + m.getValue();
                if (regVal > this.register.mask) {
                    this.registerE.setValue(1);
                }
                this.register.setValue(regVal);
                break;
            }
            case 4096: 
            case 6144: {
                if (this.disassemble) {
                    this.instr = "CP" + this.register.name;
                }
                if (!this.emulate || this.register.getValue() == m.getValue()) break;
                this.registerP.setValue(address + 2);
                break;
            }
            case 8192: 
            case 10240: {
                if (this.disassemble) {
                    this.instr = "LD" + this.register.name;
                }
                if (!this.emulate) break;
                this.register.setValue(m.getValue());
                break;
            }
            case 12288: 
            case 14336: {
                if (this.disassemble) {
                    this.instr = "ST" + this.register.name;
                }
                if (!this.emulate) break;
                m.setValue(this.register.getValue());
                break;
            }
            case 16384: {
                if (this.disassemble) {
                    this.instr = "IOR";
                }
                if (!this.emulate) break;
                this.registerA.setValue(this.registerA.getValue() | m.getValue());
                break;
            }
            case 18432: {
                if (this.disassemble) {
                    this.instr = "ISZ";
                }
                if (!this.emulate || m.setValue(m.getValue() + 1) != 0) break;
                this.registerP.setValue(address + 2);
                break;
            }
            case 20480: {
                if (this.disassemble) {
                    this.instr = "AND";
                }
                if (!this.emulate) break;
                this.registerA.setValue(this.registerA.getValue() & m.getValue());
                break;
            }
            case 22528: {
                if (this.disassemble) {
                    this.instr = "DSZ";
                }
                if (!this.emulate || m.setValue(m.getValue() - 1) != 0) break;
                this.registerP.setValue(address + 2);
                break;
            }
            case 24576: {
                if (this.disassemble) {
                    this.instr = "JSM";
                }
                if (!this.emulate) break;
                this.pushStack(this.registerP.getValue());
                this.registerP.setValue(memory_address);
                break;
            }
            case 26624: {
                if (this.disassemble) {
                    this.instr = "JMP";
                }
                if (!this.emulate) break;
                this.registerP.setValue(memory_address);
                break;
            }
            default: {
                return this.instr;
            }
        }
        if (this.disassemble) {
            this.instr = String.valueOf(this.instr) + " " + this.intToOctalString(direct_address, 6) + indStr;
        }
        return this.instr;
    }

    public String shiftRotateGroup(int opcode) {
        int shift = ((opcode & 0x1E0) >> 5) + 1;
        switch (opcode & 7) {
            case 0: {
                if (this.disassemble) {
                    this.instr = "A" + this.register.name + "R";
                }
                if (!this.emulate) break;
                int regVal = this.register.getValue();
                if ((regVal & 0x8000) != 0) {
                    regVal |= 0xFFFF0000;
                }
                this.register.setValue(regVal >> shift);
                break;
            }
            case 2: {
                if (this.disassemble) {
                    this.instr = "S" + this.register.name + "R";
                }
                if (!this.emulate) break;
                this.register.setValue(this.register.getValue() >> shift);
                break;
            }
            case 4: {
                shift = 17 - shift;
                if (this.disassemble) {
                    this.instr = "S" + this.register.name + "L";
                }
                if (!this.emulate) break;
                this.register.setValue(this.register.getValue() << shift);
                break;
            }
            case 6: {
                if (this.disassemble) {
                    this.instr = "R" + this.register.name + "R";
                }
                if (!this.emulate) break;
                int regVal = this.register.getValue();
                regVal = regVal << 16 | regVal;
                this.register.setValue(regVal >> shift);
                break;
            }
            default: {
                return this.instr;
            }
        }
        if (this.disassemble) {
            this.instr = String.valueOf(this.instr) + " " + Integer.toString(shift);
        }
        return this.instr;
    }

    public String alterSkipGroup(int opcode, int address) {
        boolean set;
        String skipcode = null;
        String testbit_SC = null;
        int skip = (opcode & 0x3E0) >> 5;
        if (skip >= 16) {
            skip -= 32;
        }
        address += skip;
        boolean clear = (opcode & 0x10) != 0;
        boolean bl = set = (opcode & 0x400) != 0;
        if (this.disassemble) {
            skipcode = "*" + (skip >= 0 ? "+" : "") + Integer.toString(skip);
            testbit_SC = set ? ",S" : (clear ? ",C" : "");
        }
        switch (opcode & 7) {
            case 0: {
                switch (opcode & 0x410) {
                    case 0: {
                        if (this.disassemble) {
                            this.instr = "SZ";
                        }
                        if (!this.emulate || this.register.getValue() != 0) break;
                        this.registerP.setValue(address);
                        break;
                    }
                    case 1024: {
                        if (this.disassemble) {
                            this.instr = "RZ";
                        }
                        if (!this.emulate || this.register.getValue() == 0) break;
                        this.registerP.setValue(address);
                        break;
                    }
                    case 16: {
                        if (this.disassemble) {
                            this.instr = "SI";
                        }
                        if (!this.emulate) break;
                        int regVal = this.register.getValue();
                        if (regVal == 0) {
                            this.registerP.setValue(address);
                        }
                        this.register.setValue(regVal + 1);
                        break;
                    }
                    case 1040: {
                        if (this.disassemble) {
                            this.instr = "RI";
                        }
                        if (!this.emulate) break;
                        int regVal = this.register.getValue();
                        if (regVal != 0) {
                            this.registerP.setValue(address);
                        }
                        this.register.setValue(regVal + 1);
                    }
                }
                if (this.disassemble) {
                    this.instr = String.valueOf(this.instr) + this.register.name + " " + skipcode;
                }
                return this.instr;
            }
            case 1: {
                if (this.disassemble) {
                    this.instr = "SL" + this.register.name;
                }
                if (!this.emulate) break;
                int regVal = this.register.getValue();
                if ((regVal & 1) == 0) {
                    this.registerP.setValue(address);
                }
                if (clear) {
                    this.register.setValue(regVal & 0xFFFE);
                }
                if (!set) break;
                this.register.setValue(regVal | 1);
                break;
            }
            case 2: {
                if (this.disassemble) {
                    this.instr = "S" + this.register.name + "M";
                }
                if (!this.emulate) break;
                int regVal = this.register.getValue();
                if ((regVal & 0x8000) != 0) {
                    this.registerP.setValue(address);
                }
                if (clear) {
                    this.register.setValue(regVal & Short.MAX_VALUE);
                }
                if (!set) break;
                this.register.setValue(regVal | 0x8000);
                break;
            }
            case 3: {
                if (this.disassemble) {
                    this.instr = "S" + this.register.name + "P";
                }
                if (!this.emulate) break;
                int regVal = this.register.getValue();
                if ((regVal & 0x8000) == 0) {
                    this.registerP.setValue(address);
                }
                if (clear) {
                    this.register.setValue(regVal & Short.MAX_VALUE);
                }
                if (!set) break;
                this.register.setValue(regVal | 0x8000);
                break;
            }
            case 4: {
                if (this.disassemble) {
                    this.instr = "SES";
                }
                if (!this.emulate) break;
                if ((this.registerE.getValue() & 1) != 0) {
                    this.registerP.setValue(address);
                }
                if (clear) {
                    this.registerE.setValue(0);
                }
                if (!set) break;
                this.registerE.setValue(15);
                break;
            }
            case 5: {
                if (this.disassemble) {
                    this.instr = "SEC";
                }
                if (!this.emulate) break;
                if ((this.registerE.getValue() & 1) == 0) {
                    this.registerP.setValue(address);
                }
                if (clear) {
                    this.registerE.setValue(0);
                }
                if (!set) break;
                this.registerE.setValue(15);
                break;
            }
            default: {
                return this.instr;
            }
        }
        if (this.disassemble) {
            this.instr = String.valueOf(this.instr) + " " + skipcode + testbit_SC;
        }
        return this.instr;
    }

    public String registerReferenceGroup(int opcode, int address) {
        boolean indirect;
        int regValue;
        String indStr = "";
        Memory m = null;
        int memory_address = regValue = this.register.getValue();
        boolean bl = indirect = (opcode & 0x100) != 0;
        if (indirect) {
            if (this.disassemble) {
                indStr = ",I";
            }
            if (this.emulate) {
                while ((memory_address & 0x8000) != 0) {
                    memory_address = this.memory[memory_address & Short.MAX_VALUE].getValue();
                }
                m = this.memory[memory_address];
                regValue = m.getValue();
            }
        }
        Register opRegister = (opcode & 0x10) == 0 ? this.registerA : this.registerB;
        switch (opcode & 0xF0) {
            case 0: 
            case 16: {
                if (this.disassemble) {
                    this.instr = "AD" + opRegister.name;
                }
                if (!this.emulate) break;
                int regVal = opRegister.getValue() + regValue;
                if (regVal > this.register.mask) {
                    this.registerE.setValue(1);
                }
                opRegister.setValue(regVal);
                break;
            }
            case 32: 
            case 48: {
                if (this.disassemble) {
                    this.instr = "CP" + opRegister.name;
                }
                if (!this.emulate || opRegister.getValue() == regValue) break;
                this.registerP.setValue(address + 2);
                break;
            }
            case 64: 
            case 80: {
                if (this.disassemble) {
                    this.instr = "LD" + opRegister.name;
                }
                if (!this.emulate) break;
                opRegister.setValue(regValue);
                break;
            }
            case 96: 
            case 112: {
                if (this.disassemble) {
                    this.instr = "ST" + opRegister.name;
                }
                if (!this.emulate) break;
                if (indirect) {
                    m.setValue(opRegister.getValue());
                    break;
                }
                this.register.setValue(opRegister.getValue());
                break;
            }
            case 128: {
                if (this.disassemble) {
                    this.instr = "IOR";
                }
                if (!this.emulate) break;
                this.registerA.setValue(this.registerA.getValue() | regValue);
                break;
            }
            case 144: {
                if (this.disassemble) {
                    this.instr = "ISZ";
                }
                if (!this.emulate) break;
                if (++regValue == 0) {
                    this.registerP.setValue(address + 2);
                }
                if (indirect) {
                    m.setValue(regValue);
                    break;
                }
                this.register.setValue(regValue);
                break;
            }
            case 160: {
                if (this.disassemble) {
                    this.instr = "AND";
                }
                if (!this.emulate) break;
                this.registerA.setValue(this.registerA.getValue() & regValue);
                break;
            }
            case 176: {
                if (this.disassemble) {
                    this.instr = "DSZ";
                }
                if (!this.emulate) break;
                if (--regValue == 0) {
                    this.registerP.setValue(address + 2);
                }
                if (indirect) {
                    m.setValue(regValue);
                    break;
                }
                this.register.setValue(regValue);
                break;
            }
            case 192: {
                if (this.disassemble) {
                    this.instr = "JSM";
                }
                if (!this.emulate) break;
                this.pushStack(this.registerP.getValue());
                this.registerP.setValue(memory_address);
                break;
            }
            case 208: {
                if (this.disassemble) {
                    this.instr = "JMP";
                }
                if (!this.emulate) break;
                this.registerP.setValue(memory_address);
                break;
            }
            default: {
                return this.instr;
            }
        }
        if (this.disassemble) {
            this.instr = String.valueOf(this.instr) + " " + this.register.name + indStr;
        }
        return this.instr;
    }

    public String compExecuteDmaGroup(int opcode, int address) {
        switch (opcode & 0x38) {
            case 24: {
                if (this.disassemble) {
                    this.instr = "DMA";
                }
                return this.instr;
            }
            case 8: {
                if (this.disassemble) {
                    this.instr = "EX";
                }
                if (!this.emulate) break;
                this.decode(this.register.getValue(), address);
                break;
            }
            case 40: {
                if (this.disassemble) {
                    this.instr = "CM";
                }
                if (!this.emulate) break;
                this.register.setValue(~this.register.getValue());
                break;
            }
            case 56: {
                if (this.disassemble) {
                    this.instr = "TC";
                }
                if (!this.emulate) break;
                this.register.setValue(~this.register.getValue() + 1);
            }
        }
        if (this.disassemble) {
            this.instr = String.valueOf(this.instr) + this.register.name;
        }
        return this.instr;
    }

    public String inputOutputGroup(int opcode, int address) {
        boolean clear;
        String testbit_HC = null;
        int selectCode = opcode & 0x1F;
        boolean bl = clear = (opcode & 0x200) != 0;
        if (this.disassemble) {
            testbit_HC = clear ? ",C" : "";
        }
        switch (opcode & 0x1E0) {
            case 480: {
                if (!clear) {
                    if (this.disassemble) {
                        this.instr = "STF";
                    }
                    if (this.emulate) {
                        this.ioInstruction.setFlag(selectCode);
                    }
                } else {
                    if (this.disassemble) {
                        this.instr = "CLF";
                    }
                    if (this.emulate) {
                        this.ioInstruction.clearFlag(selectCode);
                    }
                }
                if (this.disassemble) {
                    this.instr = String.valueOf(this.instr) + " " + Integer.toString(selectCode);
                }
                return this.instr;
            }
            case 448: {
                if (this.disassemble) {
                    this.instr = "SFC";
                }
                if (!this.emulate || this.ioInstruction.getFlag(selectCode)) break;
                this.registerP.setValue(address + 2);
                break;
            }
            case 320: {
                if (this.disassemble) {
                    this.instr = "SFS";
                }
                if (!this.emulate || !this.ioInstruction.getFlag(selectCode)) break;
                this.registerP.setValue(address + 2);
                break;
            }
            case 352: {
                if (this.disassemble) {
                    this.instr = "CLC";
                }
                if (!this.emulate) break;
                this.ioInstruction.clearControl(selectCode);
                break;
            }
            case 384: {
                if (this.disassemble) {
                    this.instr = "STC";
                }
                if (!this.emulate) break;
                this.ioInstruction.setControl(selectCode);
                break;
            }
            case 96: {
                if (this.disassemble) {
                    this.instr = "OT" + this.register.name;
                }
                if (!this.emulate) break;
                this.register.setValue(this.ioInstruction.output(selectCode, this.register.getValue()));
                break;
            }
            case 160: {
                if (this.disassemble) {
                    this.instr = "LI" + this.register.name;
                }
                if (!this.emulate) break;
                this.register.setValue(this.ioInstruction.input(selectCode, this.register.getValue()));
                break;
            }
            case 32: {
                if (this.disassemble) {
                    this.instr = "MI" + this.register.name;
                }
                if (!this.emulate) break;
                this.register.setValue(this.ioInstruction.merge(selectCode, this.register.getValue()));
                break;
            }
            default: {
                return this.instr;
            }
        }
        if (this.disassemble) {
            this.instr = String.valueOf(this.instr) + " " + Integer.toString(selectCode) + testbit_HC;
        }
        if (this.emulate && clear) {
            this.ioInstruction.clearFlag(selectCode);
        }
        return this.instr;
    }

    public String macGroup(int opcode) {
        switch (opcode) {
            case 61698: {
                this.FPop = false;
                if (this.disassemble) {
                    this.instr = "RET";
                }
                if (!this.emulate) break;
                this.registerP.setValue(this.popStack());
                this.registerP.setIncrement(true);
                break;
            }
            case 61442: {
                this.FPop = false;
                if (this.disassemble) {
                    this.instr = "MOV";
                }
                if (!this.emulate) break;
                this.registerA.setValue(this.registerE.getValue());
                this.registerE.setValue(0);
                break;
            }
            case 61440: {
                this.FPop = false;
                if (this.disassemble) {
                    this.instr = "CLR";
                }
                if (!this.emulate) break;
                int address = this.registerA.getValue();
                int i = 0;
                while (i <= 3) {
                    this.memory[address + i].setValue(0);
                    ++i;
                }
                break;
            }
            case 61444: {
                this.FPop = false;
                if (this.disassemble) {
                    this.instr = "XFR";
                }
                if (!this.emulate) break;
                int addressA = this.registerA.getValue();
                int addressB = this.registerB.getValue();
                int i = 0;
                while (i <= 3) {
                    this.memory[addressB].setValue(this.memory[addressA].getValue());
                    ++addressA;
                    ++addressB;
                    ++i;
                }
                this.registerA.setValue(addressA - 1);
                this.registerB.setValue(addressB - 1);
                break;
            }
            case 63768: {
                if (this.disassemble) {
                    this.instr = "MRX";
                }
                if (!this.emulate) break;
                this.registerA.setValue(this.mrx(996));
                break;
            }
            case 63800: {
                if (this.disassemble) {
                    this.instr = "MRY";
                }
                if (!this.emulate) break;
                this.registerA.setValue(this.mrx(1004));
                break;
            }
            case 62208: {
                if (this.disassemble) {
                    this.instr = "MLS";
                }
                if (!this.emulate) break;
                this.registerA.setValue(this.dls(1004, 0));
                break;
            }
            case 61704: {
                if (this.disassemble) {
                    this.instr = "DRS";
                }
                if (!this.emulate) break;
                this.registerA.setValue(this.drs(996, 0));
                break;
            }
            case 64256: {
                if (this.disassemble) {
                    this.instr = "DLS";
                }
                if (!this.emulate) break;
                this.registerA.setValue(this.dls(996, this.registerA.getValue()));
                break;
            }
            case 61808: {
                if (this.disassemble) {
                    this.instr = "FXA";
                }
                if (!this.emulate) break;
                int carry = this.registerE.getValue() & 1;
                this.registerE.setValue(this.fadd(carry));
                break;
            }
            case 62256: {
                if (this.disassemble) {
                    this.instr = "FMP";
                }
                if (!this.emulate) break;
                int B = this.registerB.getValue();
                int carry_sum = 0;
                int carry = this.registerE.getValue() & 1;
                int m = B & 0xF;
                while (m >= 1) {
                    carry_sum += this.fadd(carry);
                    carry = 0;
                    --m;
                }
                this.registerA.setValue(carry_sum);
                this.registerE.setValue(0);
                this.registerB.setValue(B | 0xF);
                break;
            }
            case 61712: {
                if (this.disassemble) {
                    this.instr = "FDV";
                }
                if (!this.emulate) break;
                int B = this.registerB.getValue();
                int carry = this.registerE.getValue() & 1;
                while (this.fadd(carry) == 0) {
                    ++B;
                    carry = 0;
                }
                this.registerB.setValue(B);
                this.registerE.setValue(0);
                break;
            }
            case 63744: {
                if (this.disassemble) {
                    this.instr = "CMX";
                }
                if (!this.emulate) break;
                this.cmpl(996);
                break;
            }
            case 61696: {
                if (this.disassemble) {
                    this.instr = "CMY";
                }
                if (!this.emulate) break;
                this.cmpl(1004);
                break;
            }
            case 61792: {
                if (this.disassemble) {
                    this.instr = "MDI";
                }
                if (!this.emulate) break;
                this.mdi(this.registerA.getValue(), true);
                break;
            }
            case 62248: {
                if (this.disassemble) {
                    this.instr = "NRM";
                }
                if (!this.emulate) break;
                int E = 1;
                int B = 0;
                while (B < 12) {
                    if ((this.memory[1005].getValue() & 0xF000) != 0) {
                        E = 0;
                        break;
                    }
                    this.dls(1004, 0);
                    ++B;
                }
                this.registerB.setValue(B);
                this.registerE.setValue(E);
            }
        }
        return this.instr;
    }

    private int mrx(int address) {
        int B = this.registerB.getValue() & 0xF;
        int A = this.registerA.getValue();
        int E = 0;
        while (B > 0) {
            E = this.drs(address, A);
            A = 0;
            --B;
        }
        this.registerB.setValue(this.registerB.getValue() & 0xFFF0);
        this.registerE.setValue(0);
        return E;
    }

    private int dls(int address, int A) {
        int E = A & 0xF;
        int i = 3;
        while (i >= 1) {
            A = this.memory[address + i].getValue() << 4 | E;
            E = A >> 16;
            this.memory[address + i].setValue(A);
            --i;
        }
        this.registerE.setValue(0);
        return E;
    }

    private int drs(int address, int A) {
        int E = A & 0xF;
        int i = 1;
        while (i <= 3) {
            A = E << 16 | this.memory[++address].getValue();
            E = A & 0xF;
            this.memory[address].setValue(A >> 4);
            ++i;
        }
        this.registerE.setValue(0);
        return E;
    }

    private void cmpl(int address) {
        int i = 1;
        while (i <= 3) {
            this.memory[address + i].setValue(39321 - this.memory[address + i].getValue());
            ++i;
        }
        this.mdi(address, false);
        this.registerE.setValue(0);
    }

    private void mdi(int address, boolean ovf) {
        int sum = 0;
        int i = 3;
        block0: while (i >= 1) {
            sum = this.memory[address + i].getValue();
            int one = 1;
            int ten = 10;
            int mask = 15;
            sum += one;
            int j = 1;
            while (j <= 4) {
                if ((sum & mask) < ten) {
                    this.memory[address + i].setValue(sum);
                    break block0;
                }
                sum += 6 * one;
                one <<= 4;
                ten <<= 4;
                mask <<= 4;
                ++j;
            }
            this.memory[address + i].setValue(0);
            --i;
        }
        if (i == 0 && ovf) {
            this.memory[address + 1].setValue(4096);
            this.registerE.setValue(1);
        } else {
            this.registerE.setValue(0);
        }
    }

    private int fadd(int carry) {
        int i = 3;
        while (i >= 1) {
            int one = 16;
            int ten = 10;
            int mask = 15;
            int sum = 0;
            int d1 = this.memory[996 + i].getValue();
            int d2 = this.memory[1004 + i].getValue();
            int j = 0;
            while (j < 4) {
                int dsum = (d1 & mask) + (d2 & mask) + carry;
                if (dsum >= ten) {
                    dsum -= ten;
                    carry = one;
                } else {
                    carry = 0;
                }
                sum |= dsum;
                one <<= 4;
                ten <<= 4;
                mask <<= 4;
                ++j;
            }
            this.memory[1004 + i].setValue(sum);
            if (carry != 0) {
                carry = 1;
            }
            --i;
        }
        return carry;
    }

    public String showRegister(int address) {
        StringBuffer out = new StringBuffer("\t");
        int i = 0;
        while (i <= 3) {
            out.append(String.valueOf(this.intToHexString(this.memory[address + i].getValue(), 4)) + " ");
            ++i;
        }
        return out.toString();
    }

    public void decode(int opcode, int address) {
        String instr = null;
        String fpReg = null;
        StringBuffer line = null;
        this.FPop = false;
        this.register = (opcode & 0x800) == 0 ? this.registerA : this.registerB;
        if (this.dumpRegisters | this.disassemble | this.dumpFPregisters) {
            instr = "???";
            line = new StringBuffer(" ");
        }
        if (this.dumpRegisters && line != null) {
            line.append(this.intToOctalString(this.registerA.getValue(), 7));
            line.append(" ");
            line.append(this.intToOctalString(this.registerB.getValue(), 7));
            line.append(" ");
            line.append(this.intToHexString(this.registerE.getValue(), 1));
            line.append(" ");
            line.append(this.intToHexString(this.ioRegister.getValue(), 4));
            line.append("\t");
            line.append(this.ioRegister.MLS ? "1" : ".");
            line.append(this.ioRegister.MCR ? "1" : ".");
            line.append(this.ioRegister.SIH ? "1" : ".");
            line.append(this.ioRegister.SSF ? "1" : ".");
            line.append(this.ioRegister.KLS ? "1" : ".");
            line.append(this.ioRegister.DEN ? "1" : ".");
            line.append(this.ioRegister.PEN ? "1" : ".");
            line.append(this.ioRegister.MFL ? "1" : ".");
            line.append(this.ioRegister.CEO ? "1" : ".");
            line.append(this.ioRegister.STP ? "1" : ".");
            line.append("\t");
        }
        if ((opcode & 0x7000) != 28672) {
            instr = this.memoryReferenceGroup(opcode, address);
        } else if ((opcode & 0x8000) != 0) {
            if ((opcode & 0x400) != 0) {
                instr = this.inputOutputGroup(opcode, address);
            } else {
                this.FPop = true;
                if (this.dumpFPregisters) {
                    fpReg = String.valueOf(this.showRegister(996)) + this.showRegister(1004);
                }
                instr = this.macGroup(opcode);
            }
        } else {
            instr = (opcode & 7) == 7 ? this.registerReferenceGroup(opcode, address) : ((opcode & 8) == 0 ? this.shiftRotateGroup(opcode) : ((opcode & 7) == 6 ? this.compExecuteDmaGroup(opcode, address) : this.alterSkipGroup(opcode, address)));
        }
        if (this.disassemble && line != null) {
            line.append(this.intToOctalString(address, 5));
            line.append("\t");
            line.append(this.intToOctalString(opcode, 6));
            line.append("\t");
            line.append(instr);
        }
        if (this.dumpFPregisters && this.FPop && line != null) {
            line.append("\t");
            line.append(fpReg);
        }
        if (this.dumpRegisters | this.disassemble | this.dumpFPregisters && line != null) {
            line.append("\n");
            this.console.append(line.toString());
        }
    }

    private DataInputStream openConfigFile(String fileName) {
        DataInputStream cfgFile = null;
        String filePath = null;
        String jarPath = System.getProperty("java.class.path");
        int pos = jarPath.lastIndexOf(47);
        if (pos < 0) {
            pos = jarPath.lastIndexOf(92);
        }
        try {
            cfgFile = new DataInputStream(new BufferedInputStream(new FileInputStream(fileName)));
            System.out.println("Custom configuration file " + fileName + " loaded.");
        }
        catch (FileNotFoundException e) {
            try {
                filePath = String.valueOf(jarPath.substring(0, pos + 1)) + fileName;
                cfgFile = new DataInputStream(new BufferedInputStream(new FileInputStream(filePath)));
                System.out.println("Standard configuration file " + filePath + " loaded.");
            }
            catch (FileNotFoundException e1) {
                filePath = "/config/" + fileName;
                if (this.getClass().getResourceAsStream(filePath) == null) {
                    System.out.println("Configuration file " + fileName + " not found.");
                    System.out.println("HP9800 Emulator terminated.");
                    System.exit(1);
                }
                cfgFile = new DataInputStream(new BufferedInputStream(this.getClass().getResourceAsStream(filePath)));
                System.out.println("Default configuration file " + jarPath + filePath + " loaded.");
            }
        }
        return cfgFile;
    }

    private void loadConfig(String machineName) {
        DataInputStream cfgFile = null;
        String mode = "Bin";
        this.model = machineName;
        this.version = "";
        try {
            String line;
            cfgFile = this.openConfigFile(String.valueOf(machineName) + ".cfg");
            while ((line = cfgFile.readLine()) != null && line.length() != 0) {
                if (line.charAt(0) == ';') continue;
                StringTokenizer tokenline = new StringTokenizer(line, " \t");
                while (tokenline.hasMoreTokens()) {
                    try {
                        int address;
                        String blockName;
                        String blockType = tokenline.nextToken();
                        if (blockType.equals("Model")) {
                            this.model = tokenline.nextToken();
                            this.version = tokenline.nextToken();
                            continue;
                        }
                        if (blockType.equals("DEV")) {
                            HP11305A hp11305a;
                            blockName = tokenline.nextToken();
                            address = tokenline.hasMoreTokens() ? Integer.parseInt(tokenline.nextToken()) : 1;
                            if (blockName.equals("HP9860A")) {
                                HP9860A hp9860a = new HP9860A(this.ioRegister);
                                continue;
                            }
                            if (blockName.equals("HP9861A")) {
                                HP9861A hp9861a = new HP9861A(this.ioRegister, address);
                                continue;
                            }
                            if (blockName.equals("HP9862A")) {
                                HP9862A hp9862a = new HP9862A(this.ioRegister);
                                continue;
                            }
                            if (blockName.equals("HP9865A")) {
                                HP9865A hp9865a = new HP9865A(this.ioRegister, address);
                                continue;
                            }
                            if (blockName.equals("HP9866A")) {
                                HP9866A hp9866a = new HP9866A(this.ioRegister, address);
                                continue;
                            }
                            if (blockName.equals("HP9880A")) {
                                hp11305a = new HP11305A(this.ioRegister, this.memory, address, 1);
                                continue;
                            }
                            if (blockName.equals("HP9880B")) {
                                hp11305a = new HP11305A(this.ioRegister, this.memory, address, 2);
                                continue;
                            }
                            if (!blockName.equals("HP11202A")) continue;
                            if (tokenline.hasMoreTokens()) {
                                mode = tokenline.nextToken();
                            }
                            HP11202HostFileIO hostFileIO = new HP11202HostFileIO(this.ioRegister, address, mode);
                            continue;
                        }
                        address = Integer.parseInt(tokenline.nextToken(), 8);
                        if (blockType.startsWith("Break")) {
                            if (this.memory[address] == null) continue;
                            this.memory[address].breakPoint = true;
                            continue;
                        }
                        if (blockType.startsWith("Watch")) {
                            if (this.memory[address] == null) continue;
                            this.memory[address].watchPoint = true;
                            if (!tokenline.hasMoreTokens()) continue;
                            this.memory[address].watchValue = Integer.parseInt(tokenline.nextToken(), 8);
                            this.memory[address].watchCondition = tokenline.nextToken().charAt(0);
                            continue;
                        }
                        int length = Integer.parseInt(tokenline.nextToken(), 8);
                        blockName = tokenline.nextToken();
                        String slot = tokenline.hasMoreTokens() ? tokenline.nextToken() : "";
                        MemoryBlock memoryBlock = new MemoryBlock(this.model, blockType, address, length, blockName, slot);
                        this.memoryBlocks.put(slot, memoryBlock);
                        if (memoryBlock.initialize(this.memory) == 0) continue;
                        System.exit(1);
                    }
                    catch (NumberFormatException e) {
                        System.err.println(e.toString());
                    }
                }
            }
            cfgFile.close();
        }
        catch (IOException e) {
            System.err.println(e.toString());
            System.exit(1);
        }
    }

    public void setROM(String slot, String romName) {
        MemoryBlock memoryBlock = (MemoryBlock)this.memoryBlocks.get(slot);
        String prevName = memoryBlock.getName();
        memoryBlock.setName(romName);
        if (memoryBlock.initialize(this.memory) != 0) {
            memoryBlock.setName(prevName);
            memoryBlock.initialize(this.memory);
        }
    }

    private void loadKeyConfig(String machineName) {
        String keyName;
        int keyCode;
        StringTokenizer tokenline;
        String line;
        DataInputStream cfgFile = null;
        Hashtable<String, String> keyNames = new Hashtable<String, String>();
        try {
            cfgFile = this.openConfigFile("keynames.cfg");
            while ((line = cfgFile.readLine()) != null) {
                if (!line.equals("") && line.charAt(0) == ';' || !(tokenline = new StringTokenizer(line, " \t")).hasMoreTokens()) continue;
                try {
                    keyCode = Integer.parseInt(tokenline.nextToken());
                    keyName = tokenline.nextToken();
                    keyNames.put(Integer.toString(keyCode), keyName);
                }
                catch (NumberFormatException e) {
                    System.err.println(e.toString());
                }
            }
            cfgFile.close();
        }
        catch (IOException e) {
            System.err.println(e.toString());
            System.exit(1);
        }
        try {
            cfgFile = this.openConfigFile(String.valueOf(machineName) + "-keyb.cfg");
            while ((line = cfgFile.readLine()) != null) {
                if (!line.equals("") && line.charAt(0) == ';' || !(tokenline = new StringTokenizer(line, " \t")).hasMoreTokens()) continue;
                try {
                    String modifier;
                    keyCode = Integer.parseInt(tokenline.nextToken(), 8);
                    int scanCode = Integer.parseInt(tokenline.nextToken());
                    if (tokenline.hasMoreTokens()) {
                        modifier = tokenline.nextToken().toUpperCase();
                        if (modifier.charAt(0) == ';') {
                            modifier = "";
                        }
                    } else {
                        modifier = "";
                    }
                    this.keyCodes.put(String.valueOf(Integer.toString(scanCode)) + modifier, Integer.toOctalString(keyCode));
                    String keyString = Integer.toString(scanCode);
                    keyName = (String)keyNames.get(keyString);
                    if (keyName == null) {
                        keyName = String.valueOf((char)scanCode);
                    }
                    keyString = modifier != "" ? String.valueOf(modifier) + "+" + keyName : keyName;
                    this.keyStrings.put(Integer.toString(keyCode), keyString);
                }
                catch (NumberFormatException e) {
                    System.err.println(e.toString());
                }
            }
            cfgFile.close();
        }
        catch (IOException e) {
            System.err.println(e.toString());
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int address = 0;
        long t = 0L;
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (true) {
            IOregister iOregister = this.ioRegister;
            synchronized (iOregister) {
                if (this.ioRegister.reset) {
                    this.ioRegister.reset = false;
                    address = 0;
                    this.registerP.setValue(address);
                    this.registerA.setValue(0);
                    this.registerB.setValue(0);
                }
            }
            if (this.ioRegister.serviceRequested()) {
                this.ioRegister.serviceRequestAcknowledge();
                this.registerP.setValue(address - 1);
                address = 2;
            }
            if (this.memory[address].breakPoint) {
                this.console.append("> Breakpoint\n");
                this.console.breakpoint();
            }
            int opcode = this.memory[address].getValue();
            if (Memory.trace) {
                this.emulate = false;
                this.disassemble = true;
                this.dumpRegisters = true;
                this.dumpFPregisters = true;
                this.decode(opcode, address);
                this.emulate = true;
                this.disassemble = false;
                this.dumpRegisters = false;
                this.dumpFPregisters = false;
                while (this.timerValue == 0) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
                try {
                    Thread.sleep(this.timerValue);
                }
                catch (InterruptedException interruptedException) {}
            } else {
                Thread.yield();
            }
            if (this.measure) {
                t = System.nanoTime();
            }
            this.registerP.setIncrement(true);
            this.decode(opcode, address);
            address = this.registerP.increment();
            if (this.measure && (t = System.nanoTime() - t) < 1000000L) {
                if (t < this.minExecTime) {
                    this.minExecTime = t;
                }
                if (t > this.maxExecTime) {
                    this.maxExecTime = t;
                }
                this.sumExecTime += t;
                ++this.numOps;
            }
            if (Memory.trace && this.FPop) {
                this.console.append("\t\t\t\t\t\t\t\t");
                this.console.append(this.showRegister(996));
                this.console.append(this.showRegister(1004));
                this.console.append("\n");
            }
            this.ioRegister.instructionCounter();
        }
    }
}

