/*
 * Decompiled with CFR 0.152.
 */
package emu98;

import emu98.Emulator;

public class Memory {
    static final int MASK = 65535;
    public static Emulator emu;
    public static boolean trace;
    public boolean isRW;
    public boolean breakPoint;
    public boolean watchPoint;
    private int address;
    int value;
    int watchValue;
    char watchCondition;

    static {
        trace = false;
    }

    public Memory(boolean rwMemory, int address, int initValue) {
        this.isRW = rwMemory;
        this.address = address;
        this.value = initValue;
        this.watchPoint = false;
        this.breakPoint = false;
        this.watchCondition = (char)32;
    }

    void doWatchPoint() {
        if (this.watchPoint) {
            switch (this.watchCondition) {
                case ' ': {
                    break;
                }
                case '>': {
                    if (this.value > this.watchValue) break;
                    return;
                }
                case '<': {
                    if (this.value < this.watchValue) break;
                    return;
                }
                case '=': {
                    if (this.value == this.watchValue) break;
                    return;
                }
                default: {
                    return;
                }
            }
            Memory.emu.console.append("> Watchpoint at " + emu.intToOctalString(this.address, 7) + " Value=" + emu.intToOctalString(this.value, 7) + "\n");
            Memory.emu.console.breakpoint();
        }
    }

    public int setValue(int value) {
        if (this.isRW) {
            this.value = value & 0xFFFF;
        }
        this.doWatchPoint();
        return this.value;
    }

    public int getValue() {
        this.doWatchPoint();
        return this.value;
    }
}

