/*
 * Decompiled with CFR 0.152.
 */
package emu98;

import emu98.Memory;
import io.ImageMedia;
import java.awt.Image;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.Vector;

public class MemoryBlock {
    private String machineName;
    private String blockName;
    private String blockSlot;
    private String blockType;
    private String title;
    private int blockStart;
    private int blockEnd;
    private int blockSize = 0;
    private boolean isRW;
    private Image moduleImage = null;
    private Image templateImage = null;
    private Image instructionsImage = null;
    private Vector instructionsVector = null;
    private int instrIndex = 0;

    public MemoryBlock(String machine, String type, int address, int length, String name, String slot) {
        this.machineName = machine;
        this.blockStart = address;
        this.blockEnd = address + length - 1;
        this.blockName = name;
        this.blockType = type;
        this.blockSlot = slot;
        this.isRW = type.equals("RWM");
    }

    private String makeFileName(String suffix) {
        return "media/" + this.machineName + "/" + this.blockName + suffix;
    }

    public void setName(String name) {
        this.blockName = name;
        this.instructionsImage = null;
        this.templateImage = null;
        this.moduleImage = null;
        this.instructionsVector = null;
    }

    public String getName() {
        return this.blockName;
    }

    public Image getModule() {
        if (this.moduleImage == null) {
            this.moduleImage = new ImageMedia(this.makeFileName("_Module_" + this.blockSlot + ".jpg")).getImage();
        }
        return this.moduleImage;
    }

    public Image getUniModule() {
        if (this.moduleImage == null) {
            this.moduleImage = new ImageMedia(this.makeFileName("_Module.jpg")).getImage();
        }
        return this.moduleImage;
    }

    public Image getTemplate() {
        if (this.templateImage == null) {
            this.templateImage = new ImageMedia(this.makeFileName("_Template_" + this.blockSlot + ".jpg")).getImage();
        }
        return this.templateImage;
    }

    public Image getInstructions() {
        if (this.instructionsVector.size() == 0) {
            return null;
        }
        this.instrIndex = 0;
        return this.nextInstructions();
    }

    public Image nextInstructions() {
        if (this.instructionsVector.size() == 0) {
            return null;
        }
        String fileName = "media/" + this.machineName + "/" + (String)this.instructionsVector.elementAt(this.instrIndex);
        this.instructionsImage = new ImageMedia(fileName).getImage();
        if (++this.instrIndex >= this.instructionsVector.size()) {
            this.instrIndex = 0;
        }
        return this.instructionsImage;
    }

    public int getAddress() {
        return this.blockStart;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int initialize(Memory[] memory) {
        String line;
        DataInputStream cfgFile = null;
        DataInputStream dumpFile = null;
        System.out.print(String.valueOf(this.blockName) + " " + this.blockType + " at " + Integer.toOctalString(this.blockStart) + "-" + Integer.toOctalString(this.blockEnd) + ", " + this.blockSlot + " ");
        if (this.isRW) {
            int address = this.blockStart;
            while (address <= this.blockEnd) {
                memory[address] = new Memory(this.isRW, address, 0);
                ++address;
            }
            System.out.println("initialized.");
            return 0;
        }
        this.instructionsVector = new Vector();
        try {
            InputStream cfgStream = this.getClass().getResourceAsStream("/" + this.makeFileName(".cfg"));
            if (cfgStream != null) {
                cfgFile = new DataInputStream(cfgStream);
                while ((line = cfgFile.readLine()) != null && line.length() != 0) {
                    if (line.charAt(0) == ';') continue;
                    StringTokenizer tokenline = new StringTokenizer(line, " \t");
                    block12: while (tokenline.hasMoreTokens()) {
                        try {
                            int addr;
                            String keyWord = tokenline.nextToken();
                            if (keyWord.equals("Model")) {
                                while (tokenline.hasMoreTokens()) {
                                    String keyValue = tokenline.nextToken();
                                    if (keyValue.equals(this.machineName)) continue block12;
                                }
                                System.out.println("Illegal ROM Block for this model!");
                                return 1;
                            }
                            if (keyWord.equals("Title")) {
                                this.title = tokenline.nextToken();
                                System.out.print("(" + this.title + ") ");
                                continue;
                            }
                            if (keyWord.equals("Size")) {
                                this.blockSize = Integer.parseInt(tokenline.nextToken(), 8);
                                if (this.blockStart + this.blockSize - 1 <= this.blockEnd) continue;
                                System.out.println("Illegal ROM size for this address range!");
                                return 1;
                            }
                            if (keyWord.equals("MinAddress")) {
                                addr = Integer.parseInt(tokenline.nextToken(), 8);
                                if (addr <= this.blockStart) continue;
                                System.out.println("Illegal ROM Block for this address range!");
                                return 1;
                            }
                            if (keyWord.equals("MaxAddress")) {
                                addr = Integer.parseInt(tokenline.nextToken(), 8);
                                if (addr >= this.blockEnd) continue;
                                System.out.println("Illegal ROM Block for this address range!");
                                return 1;
                            }
                            if (keyWord.equals("Instructions")) {
                                this.instructionsVector.addElement(tokenline.nextToken());
                                continue;
                            }
                            if (!keyWord.equals("Slots")) continue;
                            while (tokenline.hasMoreTokens()) {
                                if (this.blockSlot.equals(tokenline.nextToken())) continue block12;
                            }
                            System.out.println("Illegal ROM for this slot!");
                            return 1;
                        }
                        catch (NumberFormatException e) {
                            System.err.println(e.toString());
                            return 1;
                        }
                    }
                }
                cfgFile.close();
            }
        }
        catch (IOException e) {
            System.err.println(e.toString());
            System.exit(1);
        }
        try {
            dumpFile = new DataInputStream(this.getClass().getResourceAsStream("/" + this.makeFileName("_ROM.dmp")));
        }
        catch (NullPointerException e) {
            System.out.println("ROM dump not found!");
            return 1;
        }
        try {
            int address = this.blockStart;
            while (address <= this.blockEnd) {
                if (this.blockSize > 0 && address >= this.blockStart + this.blockSize) break;
                line = dumpFile.readLine();
                if (line == null) {
                    System.err.println("ROM dump file is too short.");
                    return 1;
                }
                try {
                    int opcode = Integer.parseInt(line, 8);
                    memory[address] = new Memory(this.isRW, address, opcode);
                }
                catch (NumberFormatException e) {
                    System.err.println(e.toString());
                    System.exit(1);
                }
                ++address;
            }
            dumpFile.close();
            System.out.println("loaded.");
        }
        catch (IOException e) {
            System.err.println(e.toString());
            System.exit(1);
        }
        return 0;
    }
}

