/*
 * Decompiled with CFR 0.152.
 */
package emu98;

import emu98.Emulator;
import io.ImageMedia;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ROMselector
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JScrollPane romScrollPane = null;
    private JPanel romPanel = null;
    private JButton romButton = null;
    private Frame owner;
    private Emulator emu;
    private String romSlot = "";

    public ROMselector(Frame owner, Emulator emu) {
        super(owner);
        this.owner = owner;
        this.emu = emu;
        this.initialize();
    }

    private void initialize() {
        this.setTitle("HP9800 ROM Blocks");
        this.setSize(new Dimension(230, 370));
        this.setLocation(new Point(0, 0));
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getRomScrollPane(), "Center");
        }
        return this.jContentPane;
    }

    private JScrollPane getRomScrollPane() {
        if (this.romScrollPane == null) {
            this.romScrollPane = new JScrollPane();
            this.romScrollPane.setPreferredSize(new Dimension(240, 270));
            this.romScrollPane.setVerticalScrollBarPolicy(22);
            this.romScrollPane.setViewportView(this.getRomPanel());
        }
        return this.romScrollPane;
    }

    public JPanel getRomPanel() {
        if (this.romPanel == null) {
            this.romPanel = new JPanel();
            this.romPanel.setLayout(new BoxLayout(this.getRomPanel(), 1));
            this.romPanel.setBackground(Color.black);
            this.romPanel.setLocation(new Point(0, 0));
        }
        return this.romPanel;
    }

    public void addRomButton(String imageName, String actionCommand) {
        this.romButton = new JButton();
        this.romButton.setIcon(new ImageIcon(new ImageMedia(imageName).getImage()));
        this.romButton.setPreferredSize(new Dimension(200, 58));
        this.romButton.setBackground(Color.black);
        this.romPanel.add((Component)this.romButton, null);
        this.romButton.setActionCommand(actionCommand);
        this.romButton.addActionListener(this);
    }

    public void setRomSlot(String romSlot) {
        this.romSlot = romSlot;
    }

    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        this.emu.setROM(this.romSlot, cmd);
        this.setVisible(false);
        this.owner.repaint();
    }
}

