/*
 * Decompiled with CFR 0.152.
 */
package io;

import io.HP11202Interface;
import io.HostIO;
import io.IOregister;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class HP11202HostFileIO
extends HostIO {
    public static final long serialVersionUID = 1L;
    HP11202Interface hp11202Interface;
    RandomAccessFile inFile = null;
    RandomAccessFile outFile = null;
    int inByte = 0;
    boolean reading = false;
    boolean fileSelector = true;
    String fileMode;
    int base;

    public HP11202HostFileIO(IOregister ioReg, int selectCode, String mode) {
        super("HP11202A File-I/O");
        this.hp11202Interface = new HP11202Interface(selectCode, ioReg);
        this.hp11202Interface.setFrame(this);
        ioReg.bus.devices.add(this.hp11202Interface);
        this.fileMode = mode;
        try {
            this.base = Integer.parseInt(mode);
        }
        catch (NumberFormatException e) {
            this.base = 8;
        }
        System.out.println("HP11202A File-I/O at select code 1:" + selectCode + " loaded.");
    }

    void timerCallback() {
        this.fileSelector = true;
    }

    RandomAccessFile openFile(boolean out) {
        if (!this.fileSelector) {
            return null;
        }
        FileDialog fileDialog = new FileDialog((Frame)this, "Open HP11202A " + (out ? "Output" : "Input") + " File");
        fileDialog.setBackground(Color.WHITE);
        fileDialog.setVisible(true);
        RandomAccessFile ioFile = null;
        String fileName = fileDialog.getFile();
        String dirName = fileDialog.getDirectory();
        if (fileName == null) {
            this.fileSelector = false;
            this.hp11202Interface.devThread.interrupt();
            return null;
        }
        fileName = String.valueOf(dirName) + fileName;
        try {
            ioFile = new RandomAccessFile(fileName, "rw");
        }
        catch (FileNotFoundException e) {
            return null;
        }
        return ioFile;
    }

    RandomAccessFile closeFile(RandomAccessFile ioFile) {
        if (ioFile != null) {
            try {
                ioFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean output(int value) {
        if (this.outFile == null) {
            this.outFile = this.openFile(true);
            if (this.outFile == null) {
                return false;
            }
        }
        try {
            if (this.fileMode.equals("Bin")) {
                this.outFile.writeByte(value);
            } else {
                this.outFile.writeBytes(String.valueOf(Integer.toString(value, this.base)) + "\r\n");
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int input() {
        if (this.inFile == null) {
            this.inFile = this.openFile(false);
            if (this.inFile == null) {
                return -1;
            }
        }
        try {
            if (this.fileMode.equals("Bin")) {
                return this.inFile.readByte();
            }
            return Integer.parseInt(this.inFile.readLine(), this.base);
        }
        catch (EOFException e) {
            this.inFile = this.closeFile(this.inFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return -1;
    }
}

