/*
 * Decompiled with CFR 0.152.
 */
package io;

import io.HostIO;
import io.IOinterface;
import io.IOregister;

public class HP11202Interface
extends IOinterface {
    public HostIO dispWindow;
    int status = 256;
    int inByte = 0;
    boolean reading = false;
    boolean debug = false;
    static final int INPUT_MODE = 2048;

    public HP11202Interface(int selectCode, IOregister ioReg) {
        super(selectCode, ioReg, "HP11202A");
    }

    public void setFrame(HostIO wind) {
        this.dispWindow = wind;
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                continue;
            }
            this.dispWindow.timerCallback();
            this.status = 256;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean output() {
        IOregister iOregister = this.ioReg;
        synchronized (iOregister) {
            if (this.ioReg.CEO && (this.ioReg.getValue() & 0x800) == 0) {
                this.status = 0;
                if (this.dispWindow.output(this.ioReg.getData())) {
                    this.status = 256;
                    if (this.debug) {
                        this.ioReg.console.append("HP11202A out: " + Integer.toHexString(this.ioReg.getValue()) + "\n");
                    }
                }
            }
            return this.ioReg.CEO;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean input() {
        IOregister iOregister = this.ioReg;
        synchronized (iOregister) {
            if (this.ioReg.CEO && (this.ioReg.getValue() & 0x800) != 0) {
                this.ioReg.bus.value = this.status;
                this.inByte = this.dispWindow.input();
                if (this.inByte != -1) {
                    this.ioReg.bus.value |= this.inByte;
                    if (this.debug) {
                        this.ioReg.console.append("HP11202A in: " + Integer.toHexString(this.inByte) + "\n");
                    }
                }
            } else {
                this.ioReg.bus.value = this.status | this.inByte;
            }
            return this.ioReg.CEO;
        }
    }
}

