/*
 * Decompiled with CFR 0.152.
 */
package io.HP9810A;

import io.DisplayInterface;
import io.HP9800Mainframe;
import io.IOinterface;
import io.IOregister;

public class HP9810DisplayInterface
extends IOinterface
implements DisplayInterface {
    HP9800Mainframe mainframe;
    int[][] displayBuffer;
    int keyLEDs = 0;
    boolean equal;

    public HP9810DisplayInterface(HP9800Mainframe mainframe, IOregister ioReg) {
        super(0, ioReg);
        this.mainframe = mainframe;
        this.displayBuffer = new int[3][16];
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 15) {
                this.displayBuffer[i][j] = 0;
                ++j;
            }
            ++i;
        }
        this.equal = false;
        System.out.println("HP9810 Display at select code 8:0 loaded.");
        System.out.println("HP9810 KeyLEDs at select code 16:0 loaded.");
    }

    public int[][] getDisplayBuffer() {
        return this.displayBuffer;
    }

    public int getKeyLEDs() {
        return this.keyLEDs;
    }

    public void blank() {
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 15) {
                this.displayBuffer[i][j] = 0;
                this.mainframe.display(i, j);
                ++j;
            }
            ++i;
        }
    }

    public boolean output(int printValue) {
        if (this.ioReg.PEN) {
            this.mainframe.print(printValue |= this.ioReg.getValue());
            this.ioReg.PEN = false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean output() {
        IOregister iOregister = this.ioReg;
        synchronized (iOregister) {
            block14: {
                if (!this.ioReg.KLS) break block14;
                int segments = this.ioReg.getValue() >> 8;
                if (segments != this.keyLEDs) {
                    this.keyLEDs = segments;
                    this.mainframe.displayLEDs(this.keyLEDs);
                }
                return false;
            }
            if (this.ioReg.DEN) {
                int segments;
                int pos = this.ioReg.getValue() & 0xF;
                int reg = (this.ioReg.getValue() & 0x30) >> 4;
                if (reg == 3) {
                    reg = 0;
                }
                boolean bl = this.equal = this.displayBuffer[reg][pos] == (segments = (this.ioReg.getValue() & 0x7F80) >> 7);
                if (!this.equal) {
                    this.displayBuffer[reg][pos] = segments;
                    this.mainframe.display(reg, pos);
                }
                if (reg == 1 && pos == 0) {
                    this.ioReg.dispSRQ = false;
                }
                if (pos == 14) {
                    try {
                        if (reg == 0 && !this.ioReg.dispSRQ) {
                            this.ioReg.wait(this.ioReg.time_12ms);
                        } else {
                            Thread.yield();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            return false;
        }
    }
}

