/*
 * Decompiled with CFR 0.152.
 */
package io.HP9820A;

import io.DisplayInterface;
import io.HP9800Mainframe;
import io.IOinterface;
import io.IOregister;

public class HP9820DisplayInterface
extends IOinterface
implements DisplayInterface {
    HP9800Mainframe mainframe;
    int[][] displayBuffer;
    boolean equal;

    public HP9820DisplayInterface(HP9800Mainframe mainframe, IOregister ioReg) {
        super(0, ioReg);
        this.mainframe = mainframe;
        this.displayBuffer = new int[5][16];
        int i = 0;
        while (i < 5) {
            int j = 0;
            while (j < 16) {
                this.displayBuffer[i][j] = 0;
                ++j;
            }
            ++i;
        }
        System.out.println("HP9820 Display at select code 8:0 loaded.");
    }

    public int[][] getDisplayBuffer() {
        return this.displayBuffer;
    }

    public int getKeyLEDs() {
        return 0;
    }

    public void blank() {
        int i = 0;
        while (i < 5) {
            int j = 0;
            while (j < 16) {
                this.displayBuffer[i][j] = 0;
                ++j;
            }
            ++i;
        }
        int l = this.mainframe.getInsets().left;
        int t = this.mainframe.getInsets().top;
        this.mainframe.repaint(l + HP9800Mainframe.DISPLAY_X + HP9800Mainframe.LED_X, t + HP9800Mainframe.DISPLAY_Y + HP9800Mainframe.LED_Y, 320, 20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean output(int printValue) {
        IOregister iOregister = this.ioReg;
        synchronized (iOregister) {
            if (this.ioReg.PEN) {
                this.mainframe.print(printValue |= this.ioReg.getValue());
                this.ioReg.PEN = false;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean output() {
        IOregister iOregister = this.ioReg;
        synchronized (iOregister) {
            block13: {
                if (!this.ioReg.KLS) break block13;
                return false;
            }
            if (this.ioReg.DEN) {
                int dots;
                int chr = (this.ioReg.getValue() & 0x3000) >> 12;
                int col = (this.ioReg.getValue() & 0xF80) >> 7;
                if (col >= 16) {
                    col -= 6;
                }
                boolean bl = this.equal = this.displayBuffer[col %= 5][chr = chr * 4 + col / 5] == (dots = this.ioReg.getValue() & 0x7F);
                if (!this.equal) {
                    this.displayBuffer[col][chr] = dots;
                    this.mainframe.display(col, chr);
                }
                if (chr == 0 && col == 0) {
                    this.ioReg.dispSRQ = false;
                }
                if (col == 4) {
                    try {
                        if (chr == 15 && !this.ioReg.dispSRQ) {
                            this.ioReg.wait(this.ioReg.time_32ms);
                        } else {
                            Thread.yield();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            return false;
        }
    }
}

