/*
 * Decompiled with CFR 0.152.
 */
package io;

import io.HP11201Interface;
import io.IOregister;
import io.SoundMedia;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;

public class HP9861A
extends Frame
implements KeyListener {
    private static final long serialVersionUID = 1L;
    HP11201Interface hp11201Interface;
    IOregister ioReg;
    SoundMedia fanSound;
    SoundMedia typeSound;
    SoundMedia spaceSound;
    SoundMedia crSound;
    SoundMedia lfSound;
    Vector printBuffer;
    StringBuffer lineBuffer;
    int numLines;
    int pos;
    int page;
    int ribbon;
    int timerValue;
    boolean[] tab;
    boolean highSpeed = false;
    boolean debug = false;
    static final int WIDTH = 162;
    static final int LINE_END = 2048;
    static final int NOP = 0;
    static final int TAB_SET = 1;
    static final int BLACK_RBN = 7;
    static final int RED_RBN = 6;
    static final int BSP = 8;
    static final int TAB = 9;
    static final int TAB_CLR_ALL = 11;
    static final int TAB_CLR = 12;

    public HP9861A(IOregister ioRegister, int selectCode) {
        super("HP9861A");
        this.addKeyListener(this);
        this.addWindowListener(new windowListener());
        this.addMouseListener(new mouseListener());
        this.typeSound = new SoundMedia("media/HP9861A/HP9861_TYPE.wav");
        this.spaceSound = new SoundMedia("media/HP9861A/HP9861_SPC.wav");
        this.crSound = new SoundMedia("media/HP9861A/HP9861_CR.wav");
        this.lfSound = new SoundMedia("media/HP9861A/HP9861_LF.wav");
        this.ioReg = ioRegister;
        this.hp11201Interface = new HP11201Interface(selectCode, this.ioReg);
        this.hp11201Interface.setFrame(this);
        this.ioReg.bus.devices.add(this.hp11201Interface);
        this.setSize(1010, 250);
        this.setLocation(0, 0);
        this.page = 0;
        this.ribbon = 7;
        this.setBackground(Color.WHITE);
        Font font = new Font("Monospaced", 0, 12);
        this.setFont(font);
        this.tab = new boolean[162];
        int i = 0;
        while (i < 162) {
            this.tab[i] = false;
            ++i;
        }
        this.pos = 0;
        this.initializeBuffer();
        this.setVisible(true);
        System.out.println("HP9861A Printer at select code 1:" + selectCode + " loaded.");
    }

    public void keyPressed(KeyEvent event) {
        int keyCode = event.getKeyCode();
        int h = this.getHeight() - 6;
        int windowLines = (h - this.getInsets().top) / 12;
        int numPages = this.numLines / windowLines;
        switch (keyCode) {
            case 34: {
                ++this.page;
                if (this.page <= numPages) break;
                this.page = numPages;
                break;
            }
            case 33: {
                if (--this.page >= 0) break;
                this.page = 0;
                break;
            }
            case 35: {
                this.page = 0;
                break;
            }
            case 36: {
                this.page = numPages;
                break;
            }
            case 127: {
                this.initializeBuffer();
                this.page = 0;
                this.setSize(1010, 250);
                break;
            }
            case 155: {
                int i = 0;
                while (i < this.numLines) {
                    System.out.print(this.printBuffer.elementAt(i));
                    ++i;
                }
                return;
            }
            case 83: {
                this.highSpeed = !this.highSpeed;
                this.setTitle("HP9861A" + (this.highSpeed ? " High Speed" : ""));
                break;
            }
            default: {
                return;
            }
        }
        this.repaint();
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyTyped(KeyEvent event) {
    }

    private void typeLine(Graphics g, String line, int x, int y) {
        int xmin = x;
        int i = 0;
        while (i < line.length()) {
            char c = line.charAt(i);
            switch (c) {
                case '\u0007': {
                    g.setColor(Color.BLACK);
                    break;
                }
                case '\u0006': {
                    g.setColor(Color.RED);
                    break;
                }
                case '\b': {
                    if ((x -= g.getFontMetrics().charWidth(' ')) >= xmin) break;
                    x = xmin;
                    break;
                }
                case '\r': {
                    x = xmin;
                    break;
                }
                default: {
                    g.drawString(Character.toString(c), x, y);
                    x += g.getFontMetrics().charWidth(c);
                }
            }
            ++i;
        }
    }

    public void paint(Graphics g) {
        int minLine;
        int x = this.getInsets().left + 4;
        int y = this.getHeight() - 6;
        int windowLines = (y - this.getInsets().top) / 12;
        int maxLine = this.numLines - this.page * windowLines;
        if (maxLine < 0) {
            maxLine = 0;
        }
        if ((minLine = maxLine - windowLines) < 0) {
            minLine = 0;
        }
        this.typeLine(g, this.lineBuffer.toString(), x, y);
        int i = maxLine - 1;
        while (i >= minLine) {
            this.typeLine(g, this.printBuffer.elementAt(i).toString(), x, y -= 12);
            --i;
        }
    }

    public void initializeBuffer() {
        this.pos = 0;
        this.numLines = 0;
        this.lineBuffer = new StringBuffer();
        this.printBuffer = new Vector();
        this.lineBuffer.append((char)this.ribbon);
    }

    public int output(int status, int value) {
        if (this.debug) {
            System.out.println(Integer.toHexString(value));
        }
        this.timerValue = 30;
        status = 256;
        switch (value) {
            case 0: {
                this.pos = 0;
                return status;
            }
            case 1: {
                this.tab[this.pos] = true;
                break;
            }
            case 6: 
            case 7: {
                this.lineBuffer.append((char)value);
                this.ribbon = value;
                break;
            }
            case 8: {
                this.lineBuffer.append((char)value);
                if (!this.highSpeed) {
                    this.spaceSound.start();
                }
                if (this.pos > 0) {
                    --this.pos;
                }
                this.timerValue = 70;
                break;
            }
            case 9: {
                int i = 1;
                if (!this.highSpeed) {
                    this.spaceSound.start();
                }
                ++this.pos;
                while (this.pos < 162) {
                    this.lineBuffer.append(' ');
                    ++i;
                    if (this.tab[this.pos]) break;
                    ++this.pos;
                }
                this.timerValue *= i;
                break;
            }
            case 12: {
                this.tab[this.pos] = false;
                break;
            }
            case 11: {
                int i = 0;
                while (i <= this.pos) {
                    this.tab[i] = false;
                    ++i;
                }
            }
            case 13: {
                if (!this.highSpeed) {
                    this.crSound.start();
                }
                this.timerValue = 100 + 600 * this.pos / 162;
                this.lineBuffer.append((char)value);
                this.pos = 0;
                if (value != 11) break;
                value = 13;
            }
            case 10: {
                if (!this.highSpeed) {
                    this.lfSound.start();
                }
                ++this.numLines;
                this.printBuffer.addElement(this.lineBuffer);
                this.lineBuffer = new StringBuffer();
                this.lineBuffer.append((char)this.ribbon);
                int i = 0;
                while (i < this.pos) {
                    this.lineBuffer.append(' ');
                    ++i;
                }
                this.repaint();
                this.timerValue = 120;
                break;
            }
            default: {
                this.lineBuffer.append((char)value);
                if (value == 32) {
                    if (!this.highSpeed) {
                        this.spaceSound.start();
                    }
                    this.timerValue = 60;
                } else {
                    if (!this.highSpeed) {
                        this.typeSound.start();
                    }
                    this.timerValue = 70;
                }
                this.typeLine(this.getGraphics(), this.lineBuffer.toString(), this.getInsets().left + 4, this.getHeight() - 6);
                ++this.pos;
            }
        }
        try {
            Thread.sleep(this.highSpeed ? 0 : this.timerValue);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (value == 13 && !this.highSpeed) {
            this.crSound.stop();
        }
        if (this.pos >= 162) {
            this.pos = 161;
            status |= 0x800;
        }
        return status;
    }

    class windowListener
    extends WindowAdapter {
        windowListener() {
        }

        public void windowClosing(WindowEvent event) {
            HP9861A.this.setVisible(false);
            HP9861A.this.dispose();
            HP9861A.this.ioReg.bus.devices.remove(HP9861A.this.hp11201Interface);
            System.out.println("HP9861A unloaded.");
        }
    }

    class mouseListener
    extends MouseAdapter {
        mouseListener() {
        }

        public void mousePressed(MouseEvent event) {
            int x = event.getX() - HP9861A.this.getInsets().left;
            int y = event.getY() - HP9861A.this.getInsets().top;
        }

        public void mouseReleased(MouseEvent event) {
        }
    }
}

