/*
 * Decompiled with CFR 0.152.
 */
package io;

import io.HP9862Interface;
import io.IOregister;
import io.SoundMedia;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;

public class HP9862A
extends Frame
implements KeyListener {
    private static final long serialVersionUID = 1L;
    static final int SYNC = 256;
    static final int CODE = 512;
    static final int PEN = 1024;
    static final int MANEUVER = 2048;
    static final int POWER = 512;
    static final int PEN_IN = 2048;
    static final int DEFAULT_SIZE = 500;
    HP9862Interface hp9862Interface;
    IOregister ioReg;
    Image hp9862aImage;
    SoundMedia plotSound;
    SoundMedia penDownSound;
    SoundMedia penUpSound;
    Vector points;
    int numPoints;
    int x0;
    int y0;
    int plotSize = 500;
    boolean repainting;
    int[] outByte;
    int byteCount;
    int xPos;
    int yPos;
    int x;
    int y;
    int color = 0;
    int penColor = 1;
    boolean bcdMode = false;

    public HP9862A(IOregister ioRegister) {
        super("HP9862A");
        this.addKeyListener(this);
        this.addWindowListener(new windowListener());
        this.addMouseListener(new mouseListener());
        this.addComponentListener(new ComponentRepaintAdapter());
        this.ioReg = ioRegister;
        this.hp9862Interface = new HP9862Interface(14, this.ioReg);
        this.hp9862Interface.setFrame(this);
        this.ioReg.bus.devices.add(this.hp9862Interface);
        this.plotSound = new SoundMedia("media/HP9862A/HP9862_PLOT.wav");
        this.penDownSound = new SoundMedia("media/HP9862A/HP9862_PEN_DOWN.wav");
        this.penUpSound = new SoundMedia("media/HP9862A/HP9862_PEN_UP.wav");
        this.setSize(530, 520);
        this.setBackground(Color.WHITE);
        this.setForeground(Color.BLACK);
        this.outByte = new int[4];
        this.byteCount = 0;
        this.initializeBuffer();
        this.setVisible(true);
        System.out.println("HP9862A Plotter at select code 1:14 loaded.");
    }

    public void keyPressed(KeyEvent event) {
        int keyCode = event.getKeyCode();
        switch (keyCode) {
            case 35: {
                break;
            }
            case 36: {
                break;
            }
            case 127: {
                this.initializeBuffer();
                this.setSize(530, 520);
                break;
            }
            case 155: {
                return;
            }
            case 38: {
                break;
            }
            case 40: {
                break;
            }
            case 37: {
                break;
            }
            case 39: {
                break;
            }
            case 83: {
                this.hp9862Interface.highSpeed = !this.hp9862Interface.highSpeed;
                this.setTitle("HP9862A" + (this.hp9862Interface.highSpeed ? " High Speed" : ""));
                break;
            }
            default: {
                return;
            }
        }
        this.repaint();
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyTyped(KeyEvent event) {
    }

    public void paint(Graphics g) {
        this.repainting = true;
        int xSave = this.xPos;
        int ySave = this.yPos;
        int colorSave = this.color;
        this.x0 = this.getInsets().left;
        this.y0 = this.getHeight() - 10;
        this.plotSize = this.y0 - this.getInsets().top;
        this.xPos = 0;
        this.yPos = 0;
        this.color = 0;
        int x = this.getInsets().left;
        int y = this.getInsets().top;
        boolean backgroundImage = g.drawImage(this.hp9862aImage, x, y, this.getWidth(), this.getHeight(), this);
        g.setColor(Color.WHITE);
        g.fillRect(x, y, this.getWidth() - x, this.getHeight() - y);
        int i = 0;
        while (i < this.numPoints) {
            PlotterPoint point = (PlotterPoint)this.points.elementAt(i);
            this.plot(point.x, point.y, point.color);
            ++i;
        }
        this.xPos = xSave;
        this.yPos = ySave;
        this.color = colorSave;
        this.repainting = false;
    }

    public void plot(int x, int y, int color) {
        if (color != 0) {
            Graphics g = this.getGraphics();
            switch (color) {
                case 2: {
                    g.setColor(Color.GREEN);
                    break;
                }
                case 3: {
                    g.setColor(Color.RED);
                    break;
                }
                case 4: {
                    g.setColor(Color.BLUE);
                    break;
                }
                case 5: {
                    g.setColor(Color.CYAN);
                    break;
                }
                case 6: {
                    g.setColor(Color.MAGENTA);
                    break;
                }
                case 7: {
                    g.setColor(Color.YELLOW);
                    break;
                }
                case 8: {
                    g.setColor(Color.ORANGE);
                    break;
                }
                case 9: {
                    g.setColor(Color.PINK);
                    break;
                }
                default: {
                    g.setColor(Color.BLACK);
                }
            }
            g.drawLine(this.x0 + this.xPos * this.plotSize / 10000, this.y0 - this.yPos * this.plotSize / 10000, this.x0 + x * this.plotSize / 10000, this.y0 - y * this.plotSize / 10000);
        }
        this.xPos = x;
        this.yPos = y;
    }

    public void initializeBuffer() {
        this.numPoints = 0;
        this.points = new Vector();
    }

    public int output(int status, int value) {
        if ((status & 0x800) != 0) {
            if ((status & 0x400) != 0) {
                if (this.color == 0 && !this.hp9862Interface.highSpeed) {
                    this.penDownSound.start();
                }
                this.color = this.penColor;
            } else {
                if (this.color != 0 && !this.hp9862Interface.highSpeed) {
                    this.penUpSound.start();
                }
                this.color = 0;
            }
            PlotterPoint point = new PlotterPoint(this.xPos, this.yPos, this.color);
            this.points.addElement(point);
            ++this.numPoints;
            this.plot(this.xPos, this.yPos, this.color);
            status = 512;
        } else {
            if ((status & 0x100) == 0) {
                this.byteCount = 0;
                boolean bl = this.bcdMode = (status & 0x200) == 0;
            }
            if (this.bcdMode) {
                value = 10 * (value >> 4) + (value & 0xF);
            }
            this.outByte[this.byteCount] = value;
            if (++this.byteCount == 4) {
                this.byteCount = 0;
                if (this.bcdMode) {
                    this.x = this.outByte[0] * 100 + this.outByte[1];
                    this.y = this.outByte[2] * 100 + this.outByte[3];
                } else {
                    this.x = (this.outByte[0] << 8) + this.outByte[1];
                    this.y = (this.outByte[2] << 8) + this.outByte[3];
                }
                if ((status & 0x200) != 0) {
                    this.x = this.xPos + (short)this.x;
                    this.y = this.yPos + (short)this.y;
                    if (this.x < 0) {
                        this.x = 0;
                    }
                    if (this.y < 0) {
                        this.y = 0;
                    }
                }
                if (this.x == 9999 && this.color == 0) {
                    if (this.y < 16) {
                        this.penColor = this.y;
                    }
                } else {
                    if (!(this.x == this.xPos && this.y == this.yPos || this.hp9862Interface.highSpeed)) {
                        this.plotSound.start();
                    }
                    PlotterPoint point = new PlotterPoint(this.x, this.y, this.color);
                    this.points.addElement(point);
                    ++this.numPoints;
                    this.plot(this.x, this.y, this.color);
                }
                status = 512;
            } else {
                status = 768;
            }
        }
        if (this.color != 0) {
            status |= 0x800;
        }
        return status;
    }

    class ComponentRepaintAdapter
    extends ComponentAdapter {
        ComponentRepaintAdapter() {
        }

        public void componentResized(ComponentEvent event) {
            event.getComponent().repaint();
        }
    }

    class windowListener
    extends WindowAdapter {
        windowListener() {
        }

        public void windowClosing(WindowEvent event) {
            HP9862A.this.setVisible(false);
            HP9862A.this.dispose();
            HP9862A.this.ioReg.bus.devices.remove(HP9862A.this.hp9862Interface);
            System.out.println("HP9862A unloaded.");
        }
    }

    class mouseListener
    extends MouseAdapter {
        mouseListener() {
        }

        public void mousePressed(MouseEvent event) {
            int x = event.getX() - HP9862A.this.getInsets().left;
            int y = event.getY() - HP9862A.this.getInsets().top;
        }

        public void mouseReleased(MouseEvent event) {
        }
    }

    class PlotterPoint {
        int x;
        int y;
        int color;

        PlotterPoint(int x, int y, int color) {
            this.x = x;
            this.y = y;
            this.color = color;
        }
    }
}

