/*
 * Decompiled with CFR 0.152.
 */
package io;

import io.HP9865Interface;
import io.IOregister;
import io.ImageMedia;
import io.SoundMedia;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.StringTokenizer;

public class HP9865A
extends Frame
implements KeyListener {
    private static final long serialVersionUID = 1L;
    static final int CONTROL = 2048;
    static final int READ = 0;
    static final int WRITE = 1024;
    static final int FORWARD = 0;
    static final int REVERSE = 512;
    static final int SLOW = 0;
    static final int FAST = 256;
    static final int STOP = 1280;
    static final int CONTINUE = 1792;
    static final int CASSETTE_OUT = 2048;
    static final int CLEAR_LEADER = 1024;
    static final int WRITE_PROTECT = 512;
    static final int POWER_ON = 256;
    static final int IDLE_TIMER = 500;
    static final int SLOW_TIMER = 3;
    static final int FAST_TIMER = 1;
    HP9865Interface hp9865Interface;
    IOregister ioReg;
    Image hp9865aImage;
    SoundMedia doorOpenSound = new SoundMedia("media/HP9865A/HP9865_DOOR_OPEN.wav");
    SoundMedia doorCloseSound = new SoundMedia("media/HP9865A/HP9865_DOOR_CLOSE.wav");
    SoundMedia motorStartSound = new SoundMedia("media/HP9865A/HP9865_MOTOR_START.wav");
    SoundMedia motorStopSound = new SoundMedia("media/HP9865A/HP9865_MOTOR_STOP.wav");
    SoundMedia motorSound;
    SoundMedia motorSlowSound = new SoundMedia("media/HP9865A/HP9865_MOTOR_SLOW.wav");
    SoundMedia motorFastSound = new SoundMedia("media/HP9865A/HP9865_MOTOR_FAST.wav");
    SoundMedia motorRewindSound = new SoundMedia("media/HP9865A/HP9865_MOTOR_REWIND.wav");
    RandomAccessFile tapeFile;
    int tapeCommand = 1280;
    int prevCommand = 1280;
    int driveStatus = 2816;
    boolean runFlag = false;
    boolean rewindFlag = false;
    boolean inByteReady = false;
    boolean outByteReady = false;
    boolean debug = false;
    Frame statusFrame;
    String statusString = "";
    int xStatus = 210;
    int yStatus = 160;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HP9865A(IOregister ioRegister, int selectCode) {
        super("HP9865A");
        this.ioReg = ioRegister;
        this.hp9865Interface = new HP9865Interface(selectCode, this.ioReg);
        this.hp9865Interface.setFrame(this);
        this.ioReg.bus.devices.add(this.hp9865Interface);
        this.statusFrame = this;
        if (selectCode == 10) {
            System.out.println("HP9800 Tape Drive at select code 1:" + selectCode + " loaded.");
        } else {
            this.addKeyListener(this);
            this.addWindowListener(new windowListener());
            this.addMouseListener(new mouseListener());
            this.hp9865aImage = new ImageMedia("media/HP9865A/HP9865A.jpg").getImage();
            this.setResizable(false);
            this.setLocation(280, 0);
            this.setBackground(Color.BLACK);
            this.setForeground(Color.WHITE);
            this.setVisible(true);
            Image image = this.hp9865aImage;
            synchronized (image) {
                try {
                    this.hp9865aImage.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.setSize(this.hp9865aImage.getWidth(this) + this.getInsets().left + this.getInsets().right, this.hp9865aImage.getHeight(this) + this.getInsets().top + this.getInsets().bottom);
            System.out.println("HP9865A Tape Drive at select code 1:" + selectCode + " loaded.");
        }
    }

    public boolean openTapeFile() {
        this.closeTapeFile();
        this.doorOpenSound.start();
        this.hp9865aImage = new ImageMedia("media/HP9865A/HP9865A_Open.jpg").getImage();
        this.repaint();
        FileDialog fileDialog = new FileDialog((Frame)this, "Load Cassette");
        fileDialog.setBackground(Color.WHITE);
        fileDialog.setVisible(true);
        String fileName = fileDialog.getFile();
        String dirName = fileDialog.getDirectory();
        if (fileName != null) {
            RandomAccessFile outFile;
            fileName = String.valueOf(dirName) + fileName;
            String mode = "rw";
            this.driveStatus = 256;
            while (true) {
                try {
                    this.tapeFile = new RandomAccessFile(fileName, mode);
                }
                catch (FileNotFoundException e) {
                    if (mode.equals("r")) {
                        System.err.println(e.toString());
                        return false;
                    }
                    mode = "r";
                    this.driveStatus |= 0x200;
                    continue;
                }
                break;
            }
            if (fileName.endsWith(".old")) {
                String outFileName = String.valueOf(fileName) + ".tape";
                try {
                    outFile = new RandomAccessFile(outFileName, "rw");
                }
                catch (FileNotFoundException e) {
                    System.err.println(e.toString());
                    return false;
                }
                try {
                    outFile.writeShort(0);
                    outFile.writeShort(0);
                    outFile.writeShort(0);
                    outFile.writeShort(0);
                    outFile.writeShort(0);
                    outFile.writeShort(0);
                    outFile.writeShort(0);
                    outFile.writeShort(0);
                }
                catch (IOException e) {
                    // empty catch block
                }
                try {
                    try {
                        while (true) {
                            short value = this.tapeFile.readShort();
                            outFile.writeShort(value);
                        }
                    }
                    catch (EOFException e) {
                        this.tapeFile.close();
                        outFile.close();
                        return false;
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (fileName.endsWith(".asc")) {
                String outFileName = String.valueOf(fileName) + ".tape";
                try {
                    outFile = new RandomAccessFile(outFileName, "rw");
                }
                catch (FileNotFoundException e) {
                    System.err.println(e.toString());
                    return false;
                }
                try {
                    outFile.writeShort(0);
                    outFile.writeShort(0);
                    outFile.writeShort(0);
                    outFile.writeShort(0);
                    outFile.writeShort(0);
                    outFile.writeShort(0);
                    outFile.writeShort(0);
                    outFile.writeShort(0);
                }
                catch (IOException e) {
                    // empty catch block
                }
                try {
                    String line;
                    int absFileSize = 0;
                    int fileSize = 0;
                    do {
                        int value;
                        StringTokenizer tokenline;
                        outFile.writeShort(316);
                        int checkSum = 0;
                        int i = 1;
                        while (i <= 7) {
                            line = this.tapeFile.readLine();
                            tokenline = new StringTokenizer(line, " \t");
                            value = 0;
                            if (line != null) {
                                value = Integer.parseInt(tokenline.nextToken());
                            }
                            checkSum += value;
                            outFile.writeShort(value & 0xFF);
                            outFile.writeShort(value >> 8);
                            switch (i) {
                                case 1: {
                                    System.out.println(value);
                                    break;
                                }
                                case 2: {
                                    fileSize = value;
                                }
                                case 4: {
                                    absFileSize = value;
                                }
                            }
                            ++i;
                        }
                        i = 1;
                        while (i <= 10) {
                            outFile.writeShort(0);
                            ++i;
                        }
                        outFile.writeShort(checkSum & 0xFF);
                        outFile.writeShort(checkSum >> 8);
                        checkSum = 0;
                        i = 0;
                        while ((line = this.tapeFile.readLine()) != null && i < fileSize) {
                            tokenline = new StringTokenizer(line, " \t");
                            if (tokenline.hasMoreTokens()) {
                                value = Integer.parseInt(tokenline.nextToken());
                                checkSum += value;
                                outFile.writeShort(value & 0xFF);
                                outFile.writeShort(value >> 8);
                            }
                            ++i;
                        }
                        outFile.writeShort(checkSum & 0xFF);
                        outFile.writeShort(checkSum >> 8);
                        while (i <= absFileSize) {
                            outFile.writeShort(0);
                            outFile.writeShort(0);
                            ++i;
                        }
                    } while (line != null && line.equals(""));
                    outFile.writeShort(316);
                }
                catch (EOFException tokenline) {
                    // empty catch block
                }
                this.tapeFile.close();
                outFile.close();
                try {
                    this.tapeFile = new RandomAccessFile(outFileName, mode);
                }
                catch (FileNotFoundException e) {
                    if (mode.equals("r")) {
                        System.err.println(e.toString());
                        return false;
                    }
                    try {
                        mode = "r";
                        this.driveStatus |= 0x200;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            this.doorCloseSound.start();
            this.hp9865aImage = new ImageMedia("media/HP9865A/HP9865A+Cassette.jpg").getImage();
            this.repaint();
            this.hp9865Interface.status = this.driveStatus;
            return true;
        }
        this.doorCloseSound.start();
        this.closeTapeFile();
        return false;
    }

    public boolean closeTapeFile() {
        if (this.tapeFile != null) {
            try {
                this.tapeFile.close();
                this.tapeFile = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.stopTape();
        this.driveStatus = 2816;
        this.hp9865Interface.status = 2816;
        this.hp9865aImage = new ImageMedia("media/HP9865A/HP9865A.jpg").getImage();
        this.repaint();
        return false;
    }

    public void keyPressed(KeyEvent event) {
        int keyCode = event.getKeyCode();
        switch (keyCode) {
            case 10: {
                this.openTapeFile();
                break;
            }
            case 19: {
                this.closeTapeFile();
            }
            default: {
                return;
            }
        }
        this.repaint();
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyTyped(KeyEvent event) {
    }

    public void paint(Graphics g) {
        int x = this.getInsets().left;
        int y = this.getInsets().top;
        boolean backgroundImage = g.drawImage(this.hp9865aImage, x, y, this.hp9865aImage.getWidth(this), this.hp9865aImage.getHeight(this), this);
    }

    void drawStatus() {
        if (this.tapeCommand == this.prevCommand) {
            return;
        }
        Graphics g = this.statusFrame.getGraphics();
        Font font = new Font("Monospaced", 1, 20);
        g.setFont(font);
        g.setColor(new Color(67, 66, 55));
        g.drawString(this.statusString, this.xStatus, this.yStatus);
        if (this.tapeCommand == 1280) {
            return;
        }
        if ((this.tapeCommand & 0x800) != 0) {
            g.setColor(Color.YELLOW);
        } else if ((this.tapeCommand & 0x400) != 0) {
            g.setColor(Color.RED);
        } else {
            g.setColor(Color.GREEN);
        }
        this.statusString = (this.tapeCommand & 0x100) != 0 ? ((this.tapeCommand & 0x200) != 0 ? "<<" : ">>") : ((this.tapeCommand & 0x200) != 0 ? "<" : ">");
        g.drawString(this.statusString, this.xStatus, this.yStatus);
    }

    public void setStatusFrame(Frame frame, int x, int y) {
        this.statusFrame = frame;
        this.xStatus = x;
        this.yStatus = y;
    }

    public int executeCommand() {
        if (!this.runFlag) {
            return this.driveStatus;
        }
        if (this.tapeFile == null) {
            this.driveStatus = 2816;
            return this.driveStatus;
        }
        if ((this.tapeCommand & 0x400) != 0 ? !this.outByteReady : this.inByteReady && !this.rewindFlag) {
            return this.driveStatus;
        }
        try {
            long pos = this.tapeFile.getFilePointer();
            if ((this.tapeCommand & 0x200) != 0) {
                if ((pos -= 2L) < 0L) {
                    if (this.debug) {
                        this.ioReg.console.append("HP9865A Begin of tape\n");
                    }
                    if ((this.tapeCommand & 0x800) != 0) {
                        this.hp9865Interface.requestInterrupt();
                    }
                    this.stopTape();
                    this.driveStatus |= 0x400;
                    return this.driveStatus;
                }
                this.tapeFile.seek(pos);
            }
            if ((this.tapeCommand & 0x400) != 0) {
                int ioByte = this.hp9865Interface.tapeValue;
                if ((this.tapeCommand & 0x800) != 0) {
                    ioByte |= 0x100;
                }
                this.tapeFile.writeShort(ioByte);
                this.outByteReady = false;
                this.ioReg.CEO = false;
                if (this.debug) {
                    this.ioReg.console.append("HP9865A write " + pos + ": " + Integer.toHexString(ioByte) + "\n");
                }
            } else {
                short ioByte = this.tapeFile.readShort();
                if (this.debug) {
                    this.ioReg.console.append("HP9865A  read " + pos + ": " + Integer.toHexString(ioByte) + "\n");
                }
                if ((this.tapeCommand & 0x800) != 0 && (ioByte & 0x100) == 0) {
                    this.inByteReady = false;
                } else {
                    this.hp9865Interface.tapeValue = ioByte & 0xFF;
                    this.inByteReady = true;
                    if ((this.tapeCommand & 0x800) != 0 && (ioByte & 0x100) != 0) {
                        this.hp9865Interface.requestInterrupt();
                    }
                }
            }
            if ((this.tapeCommand & 0x200) != 0) {
                this.tapeFile.seek(pos);
            }
            return this.driveStatus;
        }
        catch (EOFException e) {
            if (this.debug) {
                this.ioReg.console.append("HP9865A End of tape\n");
            }
            if ((this.tapeCommand & 0x800) != 0) {
                this.hp9865Interface.requestInterrupt();
            }
            this.ioReg.CEO = false;
            this.driveStatus |= 0x400;
            return this.driveStatus;
        }
        catch (IOException e) {
            System.err.println(e.toString());
            this.closeTapeFile();
            this.driveStatus = 2816;
            return this.driveStatus;
        }
    }

    public void stopTape() {
        if (this.motorSound != null) {
            this.motorSound.stop();
            this.motorSound = null;
            this.motorStopSound.start();
        }
        if (this.debug) {
            this.ioReg.console.append("HP9865A Stop\n");
        }
        this.hp9865Interface.timerValue = 500;
        this.hp9865Interface.tapeValue = 0;
        this.prevCommand = this.tapeCommand;
        this.tapeCommand = 1280;
        this.outByteReady = false;
        this.inByteReady = false;
        this.rewindFlag = false;
        this.runFlag = false;
        this.drawStatus();
    }

    public void output(int status) {
        if (this.debug) {
            this.ioReg.console.append("HP9865A Commmand: " + Integer.toHexString(status >> 8) + "\n");
        }
        this.rewindFlag = false;
        this.driveStatus &= 0xFFFFFBFF;
        switch (status & 0xFFFFF7FF) {
            case 1280: {
                this.stopTape();
                break;
            }
            case 1792: {
                break;
            }
            default: {
                this.prevCommand = this.tapeCommand;
                this.tapeCommand = status;
                if (!this.runFlag) {
                    this.motorStartSound.start();
                    this.runFlag = true;
                }
                if ((this.tapeCommand & 0x400) != 0 && (this.prevCommand & 0x400) == 0) {
                    this.inByteReady = false;
                    this.outByteReady = false;
                }
                if ((this.tapeCommand & 0x100) != 0) {
                    this.hp9865Interface.timerValue = 1;
                    if ((this.tapeCommand & 0x200) != 0) {
                        this.rewindFlag = true;
                        if (this.motorSound != this.motorRewindSound) {
                            if (this.motorSound != null) {
                                this.motorSound.stop();
                            }
                            this.motorSound = this.motorRewindSound;
                            this.motorSound.loop();
                        }
                    } else if (this.motorSound != this.motorFastSound) {
                        if (this.motorSound != null) {
                            this.motorSound.stop();
                        }
                        this.motorSound = this.motorFastSound;
                        this.motorSound.loop();
                    }
                } else {
                    this.hp9865Interface.timerValue = 3;
                    if (this.motorSound != this.motorSlowSound) {
                        if (this.motorSound != null) {
                            this.motorSound.stop();
                        }
                        this.motorSound = this.motorSlowSound;
                        this.motorSound.loop();
                    }
                }
                if ((this.driveStatus & 0x800) != 0) {
                    this.stopTape();
                    break;
                }
                this.drawStatus();
            }
        }
    }

    class windowListener
    extends WindowAdapter {
        windowListener() {
        }

        public void windowClosing(WindowEvent event) {
            HP9865A.this.setVisible(false);
            HP9865A.this.dispose();
            HP9865A.this.ioReg.bus.devices.remove(HP9865A.this.hp9865Interface);
            System.out.println("HP9865A unloaded.");
        }
    }

    class mouseListener
    extends MouseAdapter {
        mouseListener() {
        }

        public void mousePressed(MouseEvent event) {
            int x = event.getX() - HP9865A.this.getInsets().left;
            int y = event.getY() - HP9865A.this.getInsets().top;
            if (x >= 380 && x <= 410 && y >= 250 && y <= 300) {
                HP9865A.this.openTapeFile();
            }
            if (x >= 100 && x <= 350 && y >= 70 && y <= 280) {
                HP9865A.this.closeTapeFile();
            }
            if (x >= 390 && x <= 405 && y >= 80 && y <= 95) {
                HP9865A.this.output(768);
            }
        }

        public void mouseReleased(MouseEvent event) {
        }
    }
}

