unit FlortFileWin;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls;

type
  TFlortFile = class(TForm)
    GripImg: TImage;
    procedure FormPaint(Sender: TObject);
    procedure GripImgMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure GripImgMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure GripImgMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormResize(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private 錾 }
    MBarFlag:boolean;
    MBarX,MBarY:integer;
  public
    { Public 錾 }
    procedure LoadSkin;
    function isDocking(x,y:integer):boolean;
  end;

var
  FlortFile: TFlortFile;

implementation

uses MainWin,
     _MDXWinINI,_GridScroll,_GridScroll_Rap,_CSkin,_PicTools,_Images;

{$R *.dfm}

procedure TFlortFile.FormPaint(Sender: TObject);
begin
  with FlortFile do begin
    DrawFlameCanvas(Canvas,Width,Height,CSkin.ColEtcFrameBright,CSkin.ColEtcFrameMask);
  end;
end;

procedure TFlortFile.LoadSkin;
begin
  FlortFile.Color:=CSkin.dwEtcBG;

  MakeBlankImg(GripImg,pf24bit);
  with GripImg do begin
    Images.DrawSizeGrip(Picture.Bitmap,0,0,CSkin.ColEtcBG,CSkin.ColEtcFrameGrip);
  end;
  GripImg.Update;
end;

function TFlortFile.isDocking(x,y:integer):boolean;
begin
  Result:=False;
  if MainINI.CompactWindowFlortDockMain=True then begin
    if abs(y-(Main.Top+Main.Height))<16 then begin
      if abs(x-Main.Left)<16 then begin
        Result:=True;
      end;
    end;
  end;
end;

procedure TFlortFile.GripImgMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if Application.Title='MDXClose' then exit;
  MBarFlag:=True;
  MBarX:=X;
  MBarY:=Y;
end;

procedure TFlortFile.GripImgMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
var
  wx,wy:integer;
begin
  if Application.Title='MDXClose' then exit;
  if MBarFlag=True then begin
    wx:=FlortFile.Width+(X-MBarX);
    wy:=FlortFile.Height+(Y-MBarY);
    if isDocking(FlortFile.Left,FlortFile.Top)=True then begin
      if abs(wx-Main.Width)<16 then wx:=Main.Width;
    end;
    FlortFile.Width:=wx;
    FlortFile.Height:=wy;
  end;
end;

procedure TFlortFile.GripImgMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if Application.Title='MDXClose' then exit;
  MBarFlag:=False;
end;

procedure TFlortFile.FormResize(Sender: TObject);
begin
  if Main.isCompactWindow=False then exit;

  GripImg.Top:=FlortFile.Height-GripSize-2;
  GripImg.Left:=FlortFile.Width-GripSize-2;

  with Main.FileGrid do begin
    Left:=2;
    Top:=16;
    Width:=FlortFile.Width-GS_PartsSize-4;
    Height:=FlortFile.Height-Top-GripSize-4;
    DefaultColWidth:=Width;
  end;
  GS_Main.ResetPosition;

  with MainINI.CompactWindowFlortPos do begin
    Left:=FlortFile.Left;
    Top:=FlortFile.Top;
    Width:=FlortFile.Width;
    Height:=FlortFile.Height;
  end;
end;

procedure TFlortFile.FormMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if Application.Title='MDXClose' then exit;

  if Button=mbLeft then begin
    MBarFlag:=True;
    MBarX:=X;
    MBarY:=Y;
  end;
end;

procedure TFlortFile.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var
  wx,wy:integer;
begin
  if Application.Title='MDXClose' then exit;
  if MBarFlag=True then begin
    wx:=FlortFile.Left+(X-MBarX);
    wy:=FlortFile.Top+(Y-MBarY);
    if isDocking(wx,wy)=True then begin
      wx:=Main.Left;
      wy:=Main.Top+Main.Height;
    end;
    FlortFile.Left:=wx;
    FlortFile.Top:=wy;

    with MainINI.CompactWindowFlortPos do begin
      Left:=FlortFile.Left;
      Top:=FlortFile.Top;
    end;
  end;
end;

procedure TFlortFile.FormMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  pos:TPoint;
begin
  if Application.Title='MDXClose' then exit;
  MBarFlag:=False;

  if Button=mbRight then begin
    GetCursorPos(pos);
    Main.PopupMenu.Popup(pos.X,pos.Y);
  end;
end;

procedure TFlortFile.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  Main.FormKeyDown(Sender,Key,Shift);
end;

procedure TFlortFile.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  Main.FormKeyUp(Sender,Key,Shift);
end;

end.
