unit KDDWin;

{$WARN UNIT_PLATFORM OFF}
{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  Windows, SysUtils, Forms, Dialogs, Classes, Controls, StdCtrls, Buttons, ComCtrls,
  ExtCtrls,Graphics,_Pictools;

const TextSizeX=16;
const TextSizeY=TextSizeX*2;
const MarkingMax=64;
const TextMax=36;

type
  TCustomBM=record              
    Width:integer;
    Bits:array[0..TextSizeY] of PByteArray;
  end;

type
  TKDDClockInfo=record
    BaseX:integer;
    StartClock,WorkClock,EndClock:word;
  end;

type
  TKDDHeader=record
    Title,Filename:string;
    BGColor:TRGBPack;
  end;

type
  TKDDData01_TextWrite=record
    Centering:boolean;
    TextColor:TRGBPack;
    TextCount:array[0..2] of integer;
    Text:array[0..2] of string;
  end;

type
  TKDDData02_TextMark=record
    EndClock:word;
    Centering:boolean;
    MarkColor:TRGBPack;
    MarkCount:array[0..2] of integer;
    Mark:array[0..2] of array of TKDDClockInfo;
  end;

type
  TKDDData03_LoadGraphic=record
    Filename:string;
  end;

type
  TKDDData04_StartFadeout=record
  end;

type
  TKDDData06_SetUnMarkedTextColor=record
    Color:TRGBPack;
  end;

type
  TKDDData=record
    Offset:integer;
    Enabled:boolean;
    Clock:word;
    Cmd:byte;
    Count:byte;
    Data:array of byte;
    Data01_TextWrite:TKDDData01_TextWrite;
    Data02_TextMark:TKDDData02_TextMark;
    Data03_LoadGraphic:TKDDData03_LoadGraphic;
    Data04_StartFadeout:TKDDData04_StartFadeout;
    Data06_SetUnMarkedTextColor:TKDDData06_SetUnMarkedTextColor;
  end;

type
  TKDDFile=record
    Header:TKDDHeader;
    DataExists:array[0..65536] of boolean;
    DataCnt:integer;
    Data:array of TKDDData;
  end;

type
  TKDDNow=record
    Enabled:boolean;
    EndFlag:boolean;
    MeasureClock:word;
    LastClock:word;
    BGImg:TBitmap;
    ClockInfo:TKDDClockInfo;
    AlignX,AlignY:array[0..2] of integer;
    TextColor:TRGBPack;
    TextCount:array[0..2] of integer;
    Text:array[0..2] of string;
    TextChanged,TextColorChanged:boolean;
    BM:array[0..2] of TCustomBM; // 8bitGrayScale
    MarkBaseClock:word;
    MarkColor:TRGBPack;
    MarkCount:array[0..2] of integer;
    Mark:array[0..2] of array of TKDDClockInfo;
    MarkedX:array[0..2] of integer;
  end;

type
  TMarking=record
    Enabled:boolean;
    Line:integer;
    x,y,Size:integer;
    LeaveClock:integer;
  end;

type
  TKDD = class(TForm)
    BevelFlame: TBevel;
    PrvImg: TImage;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private 錾 }
    MMoveFlag:boolean;
    MMoveX,MMoveY:integer;
    Antialias:boolean;
    KDDFile:TKDDFile;
    KDDNow:TKDDNow;
    Filename:string;
    Marking:array[0..MarkingMax+1] of TMarking;
    txtbm:TBitmap;
    TitlePosiBM,TitleNegaBM:TBitmap;
    function fsReadX68kWord(var fs:TFileStream):word;
    function fsReadX68kString(var fs:TFileStream;Terminate:byte):string;
    function fsReadX68kByte(var fs:TFileStream):byte;
    procedure MakeCustomBM(var cbm:TCustomBM;const _Width:integer);
    procedure FreeCustomBM(var cbm:TCustomBM);
    procedure CustomBMTextWrite(var cbm:TCustomBM;const Text:string);
    procedure CustomBMtoImage(var Srccbm:TCustomBM;var DstImg:TImage;const dx,dy:integer;var TextColor,BGColor:TRGBPack);
    procedure LoadKDDHeader(var fs:TFileStream;var KDDHeader:TKDDHeader);
    procedure LoadKDDData(var fs:TFileStream;var KDDData:TKDDData);
    procedure LoadKDDData01_TextWrite(const DataCount:integer;const Data:array of byte;var Data01_TextWrite:TKDDData01_TextWrite);
    procedure LoadKDDData02_TextMark(const DataCount:integer;const Data:array of byte;var Data02_TextMark:TKDDData02_TextMark);
    procedure LoadKDDData03_LoadGraphic(const DataCount:integer;const Data:array of byte;var Data03_LoadGraphic:TKDDData03_LoadGraphic);
    procedure LoadKDDData04_StartFadeout(const DataCount:integer;const Data:array of byte;var Data04_StartFadeout:TKDDData04_StartFadeout);
    procedure LoadKDDData06_SetUnMarkedTextColor(const DataCount:integer;const Data:array of byte;var Data06_SetUnMarkedTextColor:TKDDData06_SetUnMarkedTextColor);
    procedure Process(TaskClock:word);
    procedure ProcessData01(var Data01_TextWrite:TKDDData01_TextWrite);
    procedure ProcessData02(var Data02_TextMark:TKDDData02_TextMark);
    procedure ProcessData03(var Data03_LoadGraphic:TKDDData03_LoadGraphic);
    procedure ProcessData04(var Data04_StartFadeout:TKDDData04_StartFadeout);
    procedure ProcessData06(var Data06_SetUnMarkedTextColor:TKDDData06_SetUnMarkedTextColor);
    procedure ProcessNowKDD;
    procedure ProcessDrawBG;
    procedure ProcessClearMarking;
    procedure ProcessSetMarking(_LastClock:word;_LineCnt:integer;const Mark:TKDDClockInfo);
    procedure ProcessMarking;
    procedure ProcessRedraw;
  public
    { Public 錾 }
    KDDID:byte;
    procedure CustomBMCopy(var Srccbm,Dstcbm:TCustomBM);
    procedure FreeKDDNowFile;
    function LoadKDDFile(const _Filename:string):boolean;
    procedure RefrectSetting;
    procedure Start;
    procedure Interrupt(_KDDID:byte;NowClock:word;DrawFlag:boolean);
    function GetEndFlag:boolean;
    procedure SetEndFlag(_EndFlag:boolean);
  end;

var
  KDD: TKDD;

implementation

uses MainWin,
     _m_Tools, _MDXWinINI, _SndDrv_const,_SndDrv;

{$R *.dfm}

procedure TKDD.FormCreate(Sender: TObject);
begin
  PrvImg.Top:=2;
  PrvImg.Left:=2;
  PrvImg.Width:=640;
  PrvImg.Height:=64+6*TextSizeY;

  KDD.ClientWidth:=PrvImg.Width+4;
  KDD.ClientHeight:=PrvImg.Height+4;

  BevelFlame.Align:=alClient;

  with MainINI do begin
    with KDDPos do begin
      Width:=KDD.Width;
      Height:=KDD.Height;
      AdjustWindowSize(Screen.Width,Screen.Height,KDDPos);
      KDD.Left:=Left;
      KDD.Top:=Top;
    end;
  end;

  MakeBlankImg(PrvImg,pf24bit);

  TitlePosiBM:=TBitmap.Create;
  LoadBitmapFromQDA('MDXWin.qda','KDD_Title_Posi.bmp',TitlePosiBM);
  TitleNegaBM:=TBitmap.Create;
  LoadBitmapFromQDA('MDXWin.qda','KDD_Title_Nega.bmp',TitleNegaBM);

  MakeBlankBM(txtbm,TextSizeX*(TextMax+2)*2,TextSizeY*2,pf8bit);

  Antialias:=True;

  KDDID:=$00;
end;

procedure TKDD.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  FreeKDDNowFile;

  PrvImg.Free;
  txtbm.Free;

  TitlePosiBM.Free;
  TitleNegaBM.Free;

  FreeCustomBM(KDDNow.BM[0]);
  FreeCustomBM(KDDNow.BM[1]);
  FreeCustomBM(KDDNow.BM[2]);
end;

procedure TKDD.RefrectSetting;
begin
  Antialias:=MainINI.KDDAntialias;

  with txtbm.Canvas do begin
    Brush.Style:=bsSolid;
    Brush.Color:=$000000;
    Pen.Style:=psSolid;
    Pen.Color:=$ffffff;
    with Font do begin
      Charset:=SHIFTJIS_CHARSET;
      Name:=MainINI.KDDTextFont;
      Color:=$ffffff;
      if Antialias=True then begin
        Height:=-TextSizeY*2;
        end else begin
        Height:=-TextSizeY*1;
      end;
      Pitch:=fpFixed;
      Style:=[];
    end;
  end;
end;

function TKDD.fsReadX68kWord(var fs:TFileStream):word;
var
  b:byte;
begin
  fs.Read(b,1);
  Result:=b shl 8;
  fs.Read(b,1);
  inc(Result,b);
end;

function TKDD.fsReadX68kString(var fs:TFileStream;Terminate:byte):string;
var
  b:byte;
begin
  Result:='';
  if fs.Position<fs.Size then begin
    fs.Read(b,1);
    while (b<>Terminate) do begin
      Result:=Result+char(b);
      fs.Read(b,1);
    end;
  end;
end;

function TKDD.fsReadX68kByte(var fs:TFileStream):byte;
var
  b:byte;
begin
  fs.Read(b,1);
  Result:=b;
end;

procedure TKDD.MakeCustomBM(var cbm:TCustomBM;const _Width:integer);
var
  y:integer;
begin
  with cbm do begin
    Width:=_Width;
    for y:=0 to TextSizeY-1 do begin
      GlobalFree(HGLOBAL(Bits[y]));
      Bits[y]:=Ptr(GlobalAlloc(GMEM_FIXED,Width+1));
    end;
  end;
end;

procedure TKDD.FreeCustomBM(var cbm:TCustomBM);
var
  y:integer;
begin
  with cbm do begin
    Width:=0;
    for y:=0 to TextSizeY-1 do begin
      GlobalFree(HGLOBAL(Bits[y]));
      Bits[y]:=nil;
    end;
  end;
end;

procedure TKDD.CustomBMTextWrite(var cbm:TCustomBM;const Text:string);
  procedure AntialiasCopy;
  var
    x,y:integer;
    pSrc0,PSrc1,pDst:PByteArray;
    Offset:integer;
  begin
    for y:=0 to TextSizeY-1 do begin
      pSrc0:=txtbm.ScanLine[y*2+0];
      pSrc1:=txtbm.ScanLine[y*2+1];
      pDst:=cbm.Bits[y];
      for x:=0 to cbm.Width-1 do begin
        Offset:=x*2;
        pDst[x]:=byte((word(pSrc0[Offset+0])+word(pSrc0[Offset+1])+word(pSrc1[Offset+0])+word(pSrc1[Offset+1])) div 4);
      end;
    end;
  end;
  procedure NormalCopy;
  var
    x,y:integer;
    pSrc,pDst:PByteArray;
  begin
    for y:=0 to TextSizeY-1 do begin
      pSrc:=txtbm.ScanLine[y];
      pDst:=cbm.Bits[y];
      for x:=0 to cbm.Width-1 do begin
        pDst[x]:=pSrc[x];
      end;
    end;
  end;
begin
  txtbm.Canvas.TextOut(0,0,Text);

  if Antialias=True then begin
    AntialiasCopy;
    end else begin
    NormalCopy;
  end;
end;

procedure TKDD.CustomBMCopy(var Srccbm,Dstcbm:TCustomBM);
var
  SizeY:integer;
  x,y:integer;
  pSrc,pDst:PByteArray;
begin
  if Srccbm.Width<=Dstcbm.Width then begin
    SizeY:=Srccbm.Width;
    end else begin
    SizeY:=Dstcbm.Width;
  end;

  for y:=0 to TextSizeY-1 do begin
    pSrc:=Srccbm.Bits[y];
    pDst:=Dstcbm.Bits[y];
    for x:=0 to SizeY-1 do begin
      pDst[x]:=pSrc[x];
    end;
  end;
end;

procedure TKDD.CustomBMtoImage(var Srccbm:TCustomBM;var DstImg:TImage;const dx,dy:integer;var TextColor,BGColor:TRGBPack);
var
  x,y:integer;
  pSrc,pDst:PByteArray;
  DstOffset:integer;
  TextBright,BGBright:byte;
  tr,tg,tb,br,bg,bb:byte;
begin
  with TextColor do begin
    tr:=r;
    tg:=g;
    tb:=b;
  end;
  with BGColor do begin
    br:=r;
    bg:=g;
    bb:=b;
  end;

  for y:=0 to TextSizeY-1 do begin
    pSrc:=Srccbm.Bits[y];
    pDst:=DstImg.Picture.Bitmap.ScanLine[dy+y];
    if Antialias=True then begin
      for x:=0 to Srccbm.Width-1 do begin
        TextBright:=pSrc[x];
        if TextBright<>$00 then begin
          BGBright:=$ff-TextBright;
          DstOffset:=(dx+x)*3;
          pDst[DstOffset+0]:=byte(word(TextBright)*tb shr 8)+byte(word(BGBright)*bb shr 8);
          pDst[DstOffset+1]:=byte(word(TextBright)*tg shr 8)+byte(word(BGBright)*bg shr 8);
          pDst[DstOffset+2]:=byte(word(TextBright)*tr shr 8)+byte(word(BGBright)*br shr 8);
        end;
      end;
      end else begin
      for x:=0 to Srccbm.Width-1 do begin
        TextBright:=pSrc[x];
        if TextBright>=$80 then begin
          DstOffset:=(dx+x)*3;
          pDst[DstOffset+0]:=tb;
          pDst[DstOffset+1]:=tg;
          pDst[DstOffset+2]:=tr;
        end;
      end;
    end;
  end;
end;

procedure TKDD.FreeKDDNowFile;
var
  cnt:integer;
begin
  ProcessClearMarking;

  with KDDNow do begin
    Enabled:=False;
    EndFlag:=False;
    MeasureClock:=0;
    LastClock:=0;
    BGImg.Free;
    with ClockInfo do begin
      StartClock:=0;
      WorkClock:=0;
      EndClock:=0;
    end;

    SetRGBPack(TextColor,$000000);
    TextChanged:=True;
    for cnt:=0 to 2 do begin
      AlignX[cnt]:=0;
      AlignY[cnt]:=0;
      TextCount[cnt]:=0;
      Text[cnt]:='';
    end;
    TextColorChanged:=False;

    MarkBaseClock:=0;
    SetRGBPack(MarkColor,$000000);
    for cnt:=0 to 2 do begin
      FreeCustomBM(BM[cnt]);
      MarkCount[cnt]:=0;
      SetLength(Mark[cnt],0);
      MarkedX[cnt]:=0;
    end;
  end;

  with KDDFile do begin
    for cnt:=0 to 65535 do begin
      KDDFile.DataExists[cnt]:=False;
    end;

    DataCnt:=0;
    SetLength(Data,0);
  end;
end;

function TKDD.LoadKDDFile(const _Filename:string):boolean;
var
  fs:TFileStream;
  dataendflag:boolean;
  InfoCnt:integer;
  procedure InfoDraw(msg:string);
  begin
    inc(InfoCnt);
    with KDD.Canvas do begin
      TextOut(8,InfoCnt*(TextHeight('0123456789')+2),msg);
    end;
  end;
begin
  InfoCnt:=0;

  if KDDID=$ff then begin
    KDDID:=$00;
    end else begin
    inc(KDDID);
  end;

  KDD.Color:=$000000;
  with KDD.Canvas do begin
    Brush.Style:=bsSolid;
    Brush.Color:=$000000;
    Pen.Style:=psSolid;
    Pen.Color:=$ffffff;
    FillRect(Rect(0,0,KDD.ClientWidth,KDD.ClientHeight));
  end;

  InfoDraw('Free Memory.');
  InfoDraw('');

  FreeKDDNowFile;

  Filename:=_Filename;

  if FileExists(Filename)=False then begin
    KDDNow.Enabled:=False;
    Result:=False;
    KDD.Visible:=False;
    exit;
    end else begin
    KDD.Visible:=True;
  end;

  InfoDraw('LoadFile:['+thExtractFilename(Filename)+']');

  fs:=TFileStream.Create(Filename,fmOpenRead);

  LoadKDDHeader(fs,KDDFile.Header);

  InfoDraw('Title:['+KDDFile.Header.Title+']');
  InfoDraw('BGColor:$'+IntToHex(KDDFile.Header.BGColor.rgb,6));
  InfoDraw('');

  KDDFile.DataCnt:=0;

  dataendflag:=False;
  while ((fs.Position<fs.Size) and (dataendflag=False)) do begin
    InfoDraw('Create...'+IntToStr(fs.Position)+'/'+IntToStr(fs.Size));
    dec(InfoCnt);

    SetLength(KDDFile.Data,KDDFile.DataCnt+1);
    LoadKDDData(fs,KDDFile.Data[KDDFile.DataCnt]);
    KDDFile.DataExists[KDDFile.Data[KDDFile.DataCnt].Clock]:=True;
    with KDDFile.Data[KDDFile.DataCnt] do begin
      if Clock=$ffff then begin
        dataendflag:=True;
        end else begin
        dataendflag:=False;
        if KDDNow.MeasureClock<(Clock+Count) then begin
          KDDNow.MeasureClock:=Clock+Count;
        end;
      end;
    end;
    inc(KDDFile.DataCnt);
  end;

  fs.Free;

  InfoDraw('');
  InfoDraw('Loaded...');

  KDDNow.Enabled:=True;
  Result:=True;
end;

procedure TKDD.LoadKDDHeader(var fs:TFileStream;var KDDHeader:TKDDHeader);
begin
  KDDHeader.Title:=fsReadX68kString(fs,$1a);
  KDDHeader.Filename:=fsReadX68kString(fs,$00);
  SetRGBPack(KDDHeader.BGColor,RGBItoRGB(fsReadX68kWord(fs)));
end;

procedure TKDD.LoadKDDData(var fs:TFileStream;var KDDData:TKDDData);
var
  cnt:integer;
begin
  with KDDData do begin
    Enabled:=True;
    Offset:=fs.Position;
    Clock:=fsReadX68kWord(fs);
    Cmd:=fsReadX68kByte(fs);
    Count:=fsReadX68kByte(fs);

    if Clock=$ffff then begin
      Cmd:=$ff;
      Count:=$00;
      SetLength(Data,0);
      end else begin
      SetLength(Data,Count+1);
      fs.Read(Data[0],Count);
      for cnt:=0 to Count-1 do begin
        Data[cnt]:=not Data[cnt];
      end;

      case cmd of
        $01: LoadKDDData01_TextWrite(Count,Data,Data01_TextWrite);
        $02: LoadKDDData02_TextMark(Count,Data,Data02_TextMark);
        $03: LoadKDDData03_LoadGraphic(Count,Data,Data03_LoadGraphic);
        $04: LoadKDDData04_StartFadeout(Count,Data,Data04_StartFadeout);
        $06: LoadKDDData06_SetUnMarkedTextColor(Count,Data,Data06_SetUnMarkedTextColor);
      end;
    end;
  end;
end;

procedure TKDD.LoadKDDData01_TextWrite(const DataCount:integer;const Data:array of byte;var Data01_TextWrite:TKDDData01_TextWrite);
var
  linecnt,pos,cnt:integer;
  function GetWordFromData:word;
  begin
    Result:=(word(Data[pos+0]) shl 8)+Data[pos+1];
    inc(pos,2);
  end;
  function GetByteFromData:byte;
  begin
    Result:=Data[pos];
    inc(pos);
  end;
begin
  pos:=0;

  with Data01_TextWrite do begin
    SetRGBPack(TextColor,RGBItoRGB(GetWordFromData));
    TextCount[0]:=GetByteFromData;
    TextCount[1]:=GetByteFromData;
    TextCount[2]:=GetByteFromData;

    case GetByteFromData of
      $00: Centering:=False;
      $01: Centering:=True;
    end;

    for linecnt:=0 to 2 do begin
      Text[linecnt]:=StringOfChar(' ',TextCount[linecnt]);
      for cnt:=0 to TextCount[linecnt]-1 do begin
        Text[linecnt][cnt+1]:=char(GetByteFromData);
      end;
      Text[linecnt]:=copy(Text[linecnt],1,TextMax);
    end;
  end;
end;

procedure TKDD.LoadKDDData02_TextMark(const DataCount:integer;const Data:array of byte;var Data02_TextMark:TKDDData02_TextMark);
var
  WorkLength:array[0..$10] of word;
  linecnt,pos,cnt:integer;
  ClockPos:word;
  function GetWordFromData:word;
  begin
    Result:=(word(Data[pos+0]) shl 8)+Data[pos+1];
    inc(pos,2);
  end;
  function GetByteFromData:byte;
  begin
    Result:=Data[pos];
    inc(pos);
  end;
begin
  WorkLength[$00]:=0;
  WorkLength[$01]:=12;
  WorkLength[$02]:=24;
  WorkLength[$03]:=24+12;
  WorkLength[$04]:=48;
  WorkLength[$05]:=48+12;
  WorkLength[$06]:=48+24;
  WorkLength[$07]:=48+24+12;
  WorkLength[$08]:=96;
  WorkLength[$09]:=96+12;
  WorkLength[$0a]:=96+24;
  WorkLength[$0b]:=96+24+12;
  WorkLength[$0c]:=96+48;
  WorkLength[$0d]:=96+48+12;
  WorkLength[$0e]:=96+48+24;
  WorkLength[$0f]:=96+48+24+12;
  WorkLength[$10]:=192;

  pos:=0;

  with Data02_TextMark do begin
    SetRGBPack(MarkColor,RGBItoRGB(GetWordFromData));
    MarkCount[0]:=GetByteFromData;
    MarkCount[1]:=GetByteFromData;
    MarkCount[2]:=GetByteFromData;

    case GetByteFromData of
      $00: Centering:=False;
      $01: Centering:=True;
    end;

    ClockPos:=0;

    for linecnt:=0 to 2 do begin
      SetLength(Mark[linecnt],MarkCount[linecnt]+1);
      for cnt:=0 to MarkCount[linecnt]-1 do begin
        with Mark[linecnt,cnt] do begin
          BaseX:=cnt*TextSizeX;
          StartClock:=ClockPos;
          WorkClock:=WorkLength[GetByteFromData];
          inc(ClockPos,WorkClock);
          EndClock:=ClockPos;
        end;
      end;
      if MarkCount[linecnt]>=TextMax then begin
        MarkCount[linecnt]:=TextMax-1;
        SetLength(Mark[linecnt],MarkCount[linecnt]+1);
      end;
    end;
    EndClock:=ClockPos;
  end;
end;

procedure TKDD.LoadKDDData03_LoadGraphic(const DataCount:integer;const Data:array of byte;var Data03_LoadGraphic:TKDDData03_LoadGraphic);
var
  cnt:integer;
begin
  with Data03_LoadGraphic do begin
    Filename:='';
    for cnt:=0 to DataCount-1 do begin
      if Data[cnt]=$00 then exit;
      Filename:=Filename+char(Data[cnt]);
    end;
  end;
end;

procedure TKDD.LoadKDDData04_StartFadeout(const DataCount:integer;const Data:array of byte;var Data04_StartFadeout:TKDDData04_StartFadeout);
begin
  exit;
end;

procedure TKDD.LoadKDDData06_SetUnMarkedTextColor(const DataCount:integer;const Data:array of byte;var Data06_SetUnMarkedTextColor:TKDDData06_SetUnMarkedTextColor);
begin
  with Data06_SetUnMarkedTextColor do begin
    SetRGBPack(Color,RGBItoRGB((word(Data[0]) shl 8)+Data[1]));
  end;
end;

procedure TKDD.Start;
var
  cnt:integer;
begin
  if KDDNow.Enabled=False then exit;

  KDD.Color:=KDDFile.Header.BGColor.rgb;
  KDD.Caption:=KDDFile.Header.Title;

  KDDNow.Enabled:=True;
  KDDNow.LastClock:=0;
  KDDNow.TextChanged:=True;

  for cnt:=0 to KDDFile.DataCnt-1 do begin
    KDDFile.Data[cnt].Enabled:=True;
  end;

  for cnt:=0 to 2 do begin
    KDDNow.MarkedX[cnt]:=0;
  end;

  ProcessClearMarking;
end;

procedure TKDD.Interrupt(_KDDID:byte;NowClock:word;DrawFlag:boolean);
begin
  if _KDDID<>KDDID then exit;

  with KDDNow do begin
    if Enabled=False then exit;

    if LastClock=0 then Process(0);

    while (LastClock<NowClock) do begin
      inc(LastClock);
      Process(LastClock);
      ProcessNowKDD;
    end;
  end;

  if DrawFlag=True then ProcessRedraw;

  if KDDNow.MeasureClock<KDDNow.LastClock then SetEndFlag(True);
end;

procedure TKDD.Process(TaskClock:word);
var
  cnt:integer;
begin
  if KDDFile.DataExists[TaskClock]=False then exit;

  for cnt:=0 to KDDFile.DataCnt-1 do begin
    with KDDFile.Data[cnt] do begin
      if (Clock=TaskClock) and (Enabled=True) then begin
        Enabled:=False;
        case cmd of
          $01: ProcessData01(Data01_TextWrite);
          $02: ProcessData02(Data02_TextMark);
          $03: ProcessData03(Data03_LoadGraphic);
          $04: ProcessData04(Data04_StartFadeout);
          $06: ProcessData06(Data06_SetUnMarkedTextColor);
        end;
      end;
    end;
  end;
end;

procedure TKDD.ProcessData01(var Data01_TextWrite:TKDDData01_TextWrite);
var
  linecnt:integer;
begin
  KDDNow.TextChanged:=True;

  with KDDNow.ClockInfo do begin
    StartClock:=0;
    WorkClock:=0;
    EndClock:=0;
  end;

  with KDDNow do begin
    AlignX[0]:=32-16;
    AlignY[0]:=64+0*TextSizeY;
    AlignX[1]:=32;
    AlignY[1]:=64+2*TextSizeY;
    AlignX[2]:=32+16;
    AlignY[2]:=64+4*TextSizeY;
  end;

  with Data01_TextWrite do begin
    KDDNow.TextColor:=TextColor;
    for linecnt:=0 to 2 do begin
      KDDNow.TextCount[linecnt]:=TextCount[linecnt];
      KDDNow.Text[linecnt]:=Text[linecnt];
      if KDDNow.Text[linecnt]<>'' then begin
        MakeCustomBM(KDDNow.BM[linecnt],TextSizeX*KDDNow.TextCount[linecnt]);
        CustomBMTextWrite(KDDNow.BM[linecnt],Text[linecnt]);
      end;
    end;
  end;

  with KDDNow do begin
    MarkBaseClock:=0;
    SetRGBPack(MarkColor,$000000);
    for linecnt:=0 to 2 do begin
      MarkCount[linecnt]:=0;
      SetLength(Mark[linecnt],0);
    end;

    for linecnt:=0 to 2 do begin
      MarkedX[linecnt]:=0;
    end;
  end;
end;

procedure TKDD.ProcessData02(var Data02_TextMark:TKDDData02_TextMark);
var
  linecnt,cnt:integer;
begin
  with KDDNow.ClockInfo do begin
    BaseX:=0;
    StartClock:=KDDNow.LastClock;
    EndClock:=StartClock+Data02_TextMark.EndClock;
    WorkClock:=EndClock-StartClock;
  end;

  with Data02_TextMark do begin
    KDDNow.MarkBaseClock:=KDDNow.LastClock;
    KDDNow.MarkColor:=MarkColor;
    for linecnt:=0 to 2 do begin
      KDDNow.MarkCount[linecnt]:=MarkCount[linecnt];
      SetLength(KDDNow.Mark[linecnt],KDDNow.MarkCount[linecnt]+1);
      for cnt:=0 to KDDNow.MarkCount[linecnt]-1 do begin
        KDDNow.Mark[linecnt,cnt]:=Mark[linecnt,cnt];
      end;
    end;
  end;
end;

procedure TKDD.ProcessData03(var Data03_LoadGraphic:TKDDData03_LoadGraphic);
begin
end;

procedure TKDD.ProcessData04(var Data04_StartFadeout:TKDDData04_StartFadeout);
begin
  if (sdEnd=False) and (sdFadeout=False) then begin
    sdStartFadeout;
  end;
end;

procedure TKDD.ProcessData06(var Data06_SetUnMarkedTextColor:TKDDData06_SetUnMarkedTextColor);
begin
  with Data06_SetUnMarkedTextColor do begin
    KDDNow.TextColorChanged:=True;
    KDDNow.TextColor:=Color;
  end;
end;

procedure TKDD.ProcessNowKDD;
var
  linecnt,cnt:integer;
  lastclk:word;
begin
  with KDDNow do begin
    if TextChanged=True then begin
      TextChanged:=False;
      ProcessClearMarking;
      ProcessDrawBG;
      for linecnt:=0 to 2 do begin
        if Text[linecnt]<>'' then begin
          CustomBMtoImage(BM[linecnt],PrvImg,AlignX[linecnt],AlignY[linecnt],TextColor,KDDFile.Header.BGColor);
        end;
      end;
    end;
    if TextColorChanged=True then begin
      TextColorChanged:=False;
      for linecnt:=0 to 2 do begin
        if Text[linecnt]<>'' then begin
          CustomBMtoImage(BM[linecnt],PrvImg,AlignX[linecnt],AlignY[linecnt],TextColor,KDDFile.Header.BGColor);
        end;
      end;
    end;
  end;

  with KDDNow do begin
    lastclk:=LastClock-MarkBaseClock;
    for linecnt:=0 to 2 do begin
      if MarkCount[linecnt]<>0 then begin
        for cnt:=0 to MarkCount[linecnt]-1 do begin
          with Mark[linecnt,cnt] do begin
            if WorkClock=0 then begin
              if StartClock=lastclk then begin
                ProcessSetMarking(lastclk,linecnt,Mark[linecnt,cnt]);
              end;
              end else begin
              if (StartClock<=lastclk) and (lastclk<EndClock) then begin
                ProcessSetMarking(lastclk,linecnt,Mark[linecnt,cnt]);
              end;
            end;
          end;
        end;
      end;
    end;
  end;

  ProcessMarking;
end;

procedure TKDD.ProcessDrawBG;
begin
  with PrvImg.Canvas do begin
    Brush.Color:=KDDFile.Header.BGColor.rgb;
    Brush.Style:=bsSolid;
    FillRect(Rect(0,0,PrvImg.Width,PrvImg.Height));

    BitBlt(Handle,PrvImg.Width-TitleNegaBM.Width,0,TitleNegaBM.Width,TitleNegaBM.Height,TitleNegaBM.Canvas.Handle,0,0,SRCAND);
    BitBlt(Handle,PrvImg.Width-TitlePosiBM.Width,0,TitlePosiBM.Width,TitlePosiBM.Height,TitlePosiBM.Canvas.Handle,0,0,SRCPAINT);
  end;
end;

procedure TKDD.ProcessClearMarking;
var
  cnt:integer;
begin
  for cnt:=0 to MarkingMax-1 do begin
    Marking[cnt].Enabled:=False;
  end;
end;

procedure TKDD.ProcessSetMarking(_LastClock:word;_LineCnt:integer;const Mark:TKDDClockInfo);
var
  SetLine,SetX:integer;
  cnt:integer;
  SeekMarking:integer;
begin
  SetLine:=_LineCnt;

  if Mark.WorkClock=0 then begin
    SetX:=Mark.BaseX;
    end else begin
    SetX:=Mark.BaseX+((_LastClock-Mark.StartClock)*TextSizeX div Mark.WorkClock);
  end;

  SeekMarking:=-1;
  for cnt:=0 to MarkingMax-1 do begin
    with Marking[cnt] do begin
      if Enabled=True then begin
        if (Line=SetLine) and (x=SetX) then begin
          exit;
        end;
        end else begin
        SeekMarking:=cnt;
      end;
    end;
  end;

  if SeekMarking=-1 then exit;

  with Marking[SeekMarking] do begin
    Enabled:=True;
    Line:=SetLine;
    x:=SetX;
    y:=0;
    if Mark.WorkClock=0 then begin
      Size:=TextSizeX;
      end else begin
      Size:=(TextSizeX div Mark.WorkClock)+1;
    end;
    LeaveClock:=Mark.WorkClock;
  end;
end;

procedure TKDD.ProcessMarking;
var
  cnt,ax:integer;
  MarkBright,BGBright:byte;
  pSrc,pDst:PByteArray;
  DstOffset:integer;
  alx:integer;
  mr,mg,mb,br,bg,bb:byte;
begin
  with KDDNow.MarkColor do begin
    mr:=r;
    mg:=g;
    mb:=b;
  end;
  with KDDFile.Header.BGColor do begin
    br:=r;
    bg:=g;
    bb:=b;
  end;

  for cnt:=0 to MarkingMax-1 do begin
    with Marking[cnt] do begin
      if Enabled=True then begin
        with KDDNow.BM[Line] do begin
          alx:=KDDNow.AlignX[Line];
          pSrc:=Bits[y];
          pDst:=PrvImg.Picture.Bitmap.ScanLine[KDDNow.AlignY[Line]+y];
          if Antialias=True then begin
            for ax:=x to (x+Size)-1 do begin
              if Width>ax then begin
                MarkBright:=pSrc[ax];
                if MarkBright<>$00 then begin
                  pSrc[ax]:=$00;
                  BGBright:=$ff-MarkBright;
                  DstOffset:=(alx+ax)*3;
                  pDst[DstOffset+0]:=byte(word(MarkBright)*mb shr 8)+byte(word(BGBright)*bb shr 8);
                  pDst[DstOffset+1]:=byte(word(MarkBright)*mg shr 8)+byte(word(BGBright)*bg shr 8);
                  pDst[DstOffset+2]:=byte(word(MarkBright)*mr shr 8)+byte(word(BGBright)*br shr 8);
                end;
              end;
            end;
            end else begin
            for ax:=x to (x+Size)-1 do begin
              if Width>ax then begin
                MarkBright:=pSrc[ax];
                if MarkBright>=$80 then begin
                  pSrc[ax]:=$00;
                  DstOffset:=(KDDNow.AlignX[Line]+ax)*3;
                  pDst[DstOffset+0]:=mb;
                  pDst[DstOffset+1]:=mg;
                  pDst[DstOffset+2]:=mr;
                end;
              end;
            end;
          end;
        end;
        inc(y);
        if y>=TextSizeY then Enabled:=False;
      end;
    end;
  end;
end;

procedure TKDD.ProcessRedraw;
begin
  with PrvImg do begin
    BitBlt(KDD.Canvas.Handle,Left,Top,Width,Height,Canvas.Handle,0,0,SRCCOPY);
  end;
end;

procedure TKDD.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (Key=VK_F4) and (Shift=[ssAlt]) then begin
    Key:=0;
    KDD.Visible:=False;
    exit;
  end;

  if Key=VK_ESCAPE then begin
    Key:=0;
    KDD.Visible:=False;
    exit;
  end;

  Main.FormKeyDown(Sender,Key,Shift);
end;

procedure TKDD.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  Main.FormKeyUp(Sender,Key,Shift);
end;

procedure TKDD.FormMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  MMoveFlag:=True;
  MMoveX:=X;
  MMoveY:=Y;
end;

procedure TKDD.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  if MMoveFlag=True then begin
    KDD.Left:=KDD.Left+(X-MMoveX);
    KDD.Top:=KDD.Top+(Y-MMoveY);
    end else begin
    MMoveX:=X;
    MMoveY:=Y;
  end;
end;

procedure TKDD.FormMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  MMoveFlag:=False;
end;

function TKDD.GetEndFlag:boolean;
begin
  Result:=KDDNow.EndFlag;
end;

procedure TKDD.SetEndFlag(_EndFlag:boolean);
begin
  KDDNow.EndFlag:=_EndFlag;
end;

end.
