unit MXDRVConfigWin;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons;

type
  TMXDRVConfig = class(TForm)
    GroupBox2: TGroupBox;
    Label1: TLabel;
    Label16: TLabel;
    Label54: TLabel;
    SetMarcuryVolume: TEdit;
    SetADPCMSRCMode: TComboBox;
    GroupBox10: TGroupBox;
    Label49: TLabel;
    Label50: TLabel;
    Label51: TLabel;
    Label52: TLabel;
    SetMXDRVgEnabled: TCheckBox;
    SetMXDRVgusePCM8: TCheckBox;
    SetMXDRVgMDXBufMax: TEdit;
    SetMXDRVgPDXBufMax: TEdit;
    Label2: TLabel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Label22: TLabel;
    PDXPathBtn: TBitBtn;
    SetPDXPath: TEdit;
    procedure SetCreate;
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure PDXPathBtnClick(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  MXDRVConfig: TMXDRVConfig;

implementation

{$R *.dfm}

uses _MDXWinINI,FolderDlgWin;

procedure TMXDRVConfig.SetCreate;
begin
  MDXWinINIFilesave(ExtractFileDir(Application.ExeName)+'\MDXWin.ini');

  with MXDRVmINI do begin
    SetPDXPath.Text:=PDXFilePath;
    SetMarcuryVolume.Text:=IntToStr(MarcuryVolume);
    SetADPCMSRCMode.ItemIndex:=ADPCMSRCMode;
  end;

  with MXDRVgINI do begin
    SetMXDRVgEnabled.Checked:=Enabled;
    SetMXDRVgusePCM8.Checked:=usePCM8;
    SetMXDRVgMDXBufMax.Text:=inttostr(MDXBufMax);
    SetMXDRVgPDXBufMax.Text:=inttostr(PDXBufMax);
  end;
end;

procedure TMXDRVConfig.BitBtn2Click(Sender: TObject);
begin
  ModalResult:=mrCancel;
end;

procedure TMXDRVConfig.BitBtn1Click(Sender: TObject);
var
  v:integer;
begin
  v:=StrToIntDef(SetMarcuryVolume.Text,1024);
  if (v<0) or (8192<v) then begin
    MessageDlg('Marcury-Unit̃{[oCAXl̐ݒ肪ُłBiOȏWPXQȉj',mtWarning,[mbOK],0);
    exit;
  end;

  v:=StrToIntDef(SetMXDRVgMDXBufMax.Text,-1);
  if v=-1 then begin
    MessageDlg('MXDRVgMDXobt@TCY̐ݒ肪ُłB',mtWarning,[mbOK],0);
    exit;
  end;

  v:=StrToIntDef(SetMXDRVgPDXBufMax.Text,-1);
  if v=-1 then begin
    MessageDlg('MXDRVgPDXobt@TCY̐ݒ肪ُłB',mtWarning,[mbOK],0);
    exit;
  end;

  with MXDRVmINI do begin
    PDXFilePath:=SetPDXPath.Text;
    MarcuryVolume:=StrToIntDef(SetMarcuryVolume.Text,1024);
    ADPCMSRCMode:=SetADPCMSRCMode.ItemIndex;
  end;

  with MXDRVgINI do begin
    Enabled:=SetMXDRVgEnabled.Checked;
    usePCM8:=SetMXDRVgusePCM8.Checked;
    MDXBufMax:=StrToIntDef(SetMXDRVgMDXBufMax.Text,512*1024);
    PDXBufMax:=StrToIntDef(SetMXDRVgPDXBufMax.Text,2048*1024);
  end;

  ModalResult:=mrOk;
end;

procedure TMXDRVConfig.PDXPathBtnClick(Sender: TObject);
begin
  Application.CreateForm(TFolderDlg, FolderDlg);
  FolderDlg.Caption:='PDXt@CtH_';
  FolderDlg.OpenDlg(SetPDXPath.Text);
  if FolderDlg.ShowModal=mrOk then SetPDXPath.Text:=FolderDlg.DirectoryLst.Directory;
  ModalResult:=mrNone;
end;

end.
