unit NetFindWin;

{$WARN UNIT_PLATFORM OFF}
{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  Windows, SysUtils, Forms, Dialogs, Classes, Controls, StdCtrls, Buttons, ComCtrls,
  ExtCtrls, Grids, Graphics, Menus;

type
  TFindData=record
    Path,Filename,Title:string;
  end;

type
  TNetFind = class(TForm)
    FindPanel: TPanel;
    SeekFileEdt: TEdit;
    SeekTitle1Edt: TEdit;
    PrgBar: TProgressBar;
    SeekGrid: TStringGrid;
    SeekTitle2Edt: TEdit;
    SeekTimer: TTimer;
    InfoLbl: TStaticText;
    FindFileLbl: TStaticText;
    FindTitle1Lbl: TStaticText;
    FindTitle2Lbl: TStaticText;
    StopShape: TShape;
    StopLbl: TLabel;
    CloseLbl: TLabel;
    CloseShape: TShape;
    GripImg: TImage;
    SizeChangeTimer: TTimer;
    SeekGridImg: TImage;
    FindMenuLbl: TLabel;
    FindMenuShape: TShape;
    FindMenu: TPopupMenu;
    FM_PlayStop: TMenuItem;
    N2: TMenuItem;
    FM_AutoFindNone: TMenuItem;
    FM_AutoFind1sec: TMenuItem;
    FM_AutoFind2sec: TMenuItem;
    FM_AutoFind3sec: TMenuItem;
    FM_AutoFind4sec: TMenuItem;
    FM_AutoFind5sec: TMenuItem;
    FM_EnableHomeEndKey: TMenuItem;
    SeekStartTimer: TTimer;
    procedure FormCreate(Sender: TObject);
    procedure SeekEdtChange(Sender: TObject);
    procedure SeekTimerTimer(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure SeekGridDblClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SeekEdtKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure SeekGridKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure InfoLblMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure InfoLblMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure InfoLblMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FindPanelMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FindPanelMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FindPanelMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure StopLblClick(Sender: TObject);
    procedure CloseLblClick(Sender: TObject);
    procedure SeekGridMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure SeekGridMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure SeekGridMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure GripImgMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure GripImgMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure GripImgMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure SizeChangeTimerTimer(Sender: TObject);
    procedure SeekGridMouseWheelDown(Sender: TObject; Shift: TShiftState;
      MousePos: TPoint; var Handled: Boolean);
    procedure SeekGridMouseWheelUp(Sender: TObject; Shift: TShiftState;
      MousePos: TPoint; var Handled: Boolean);
    procedure FormDestroy(Sender: TObject);
    procedure FindMenuLblClick(Sender: TObject);
    procedure FM_ItemClick(Sender: TObject);
    procedure FM_EnableHomeEndKeyClick(Sender: TObject);
    procedure FM_AutoFindNoneClick(Sender: TObject);
    procedure FM_AutoFind1secClick(Sender: TObject);
    procedure FM_AutoFind2secClick(Sender: TObject);
    procedure FM_AutoFind3secClick(Sender: TObject);
    procedure FM_AutoFind4secClick(Sender: TObject);
    procedure FM_AutoFind5secClick(Sender: TObject);
    procedure SeekStartTimerTimer(Sender: TObject);
  private
    { Private 錾 }
    FindDataCount:integer;
    FindData:array of TFindData;
    MBarFlag:boolean;
    MBarX,MBarY:integer;
    DlgDrag:boolean;
    Dlgmx:integer;
    Dlgmy:integer;
    SeekFilename,SeekTitle1,SeekTitle2:string;
    SeekCount:integer;
    HitCount:integer;
    StopBtnEnabled:boolean;
    SeekChangeHold:boolean;
    SeekTick:dword;
    procedure ClearGrid;
    procedure SeekStart;
    procedure LoadSeekList;
    procedure SetStopBtnEnabled(mode:boolean);
    procedure SetShapeLblColor(var Lbl:TLabel;var Shape:TShape;const mode:boolean);
    procedure SetGridRowCount(cnt:integer);
  public
    { Public 錾 }
    procedure LoadSkin;
    procedure InitialStart;
  end;

var
  NetFind: TNetFind;

implementation

uses MainWin,
     _MDXWinINI,_MainFileCtl,_GridTool,_m_Tools,_fsTools, _PicTools, _filebuf, _SndDrv,_GridScroll,_GridScroll_Rap,_CSkin,_Images;

{$R *.dfm}

procedure SetShapeLblColor(var Lbl:TLabel;var Shape:TShape;const mode:boolean);
begin
  if mode=True then begin
    Lbl.Font.Color:=CSkin.dwEtcBright;
    Shape.Pen.Color:=CSkin.dwEtcBright;
    end else begin
    Lbl.Font.Color:=CSkin.dwEtcMask;
    Shape.Pen.Color:=CSkin.dwEtcMask;
  end;
end;

procedure TNetFind.LoadSkin;
  procedure SetLabel(var Lb:TStaticText);
  begin
    Lb.Color:=CSkin.dwEtcBG;
    Lb.Font.Color:=CSkin.dwEtcBright;
  end;
  procedure SetEdit(var Edt:TEdit);
  begin
    Edt.Color:=CSkin.dwEtcBG;
    Edt.Font.Color:=CSkin.dwEtcText;
  end;
begin
  MakeBlankImg(GripImg,pf24bit);
  with GripImg do begin
    Images.DrawSizeGrip(Picture.Bitmap,0,0,CSkin.ColEtcBG,CSkin.ColEtcFrameGrip);
  end;
  GripImg.Refresh;

  NetFind.SetStopBtnEnabled(False);

  SetShapeLblColor(FindMenuLbl,FindMenuShape,True);
  SetShapeLblColor(CloseLbl,CloseShape,True);

  FindPanel.Color:=CSkin.dwEtcBG;

  SetLabel(FindFileLbl);
  SetLabel(FindTitle1Lbl);
  SetLabel(FindTitle2Lbl);
  SetLabel(InfoLbl);
  SetEdit(SeekFileEdt);
  SetEdit(SeekTitle1Edt);
  SetEdit(SeekTitle2Edt);

  with SeekGrid do begin
    FixedColor:=CSkin.dwEtcGridFixedBG;
    Color:=CSkin.dwEtcGridBG;
    Font.Color:=CSkin.dwEtcGridText;
  end;
  SeekGrid.Refresh;
end;

procedure TNetFind.FormCreate(Sender: TObject);
begin
  AdjustWindowSize(Screen.Width,Screen.Height,MainINI.NetFindPos);
  with MainINI.NetFindPos do begin
    NetFind.Left:=Left;
    NetFind.Top:=Top;
    NetFind.Width:=Width;
    NetFind.Height:=Height;
  end;

  SeekChangeHold:=True;
  with MainINI do begin
    SeekFileEdt.Text:=NetFindFile;
    SeekTitle1Edt.Text:=NetFindTitle1;
    SeekTitle2Edt.Text:=NetFindTitle2;
  end;
  SeekChangeHold:=False;

  GS_NetFind:=TGridScroll.Create;
  GS_NetFind.LinkComponent(SeekGrid,SeekGridImg);

  with SeekGrid do begin
    Cells[0,0]:='Index';
    Cells[1,0]:='Path';
    Cells[2,0]:='Filename';
    Cells[3,0]:='Title';
    DefaultRowHeight:=Canvas.TextHeight('0123456789')+4;
  end;
  SeekTimer.Enabled:=False;

  FindDataCount:=-1;

  with NetFind.Constraints do begin
    MinHeight:=SeekGrid.Top+64;
    MaxHeight:=Screen.Height;
    MinWidth:=640;
    MaxWidth:=Screen.Width;
  end;

  InfoLbl.Caption:='MDXOnline EBhE';
  NetFind.Visible:=True;

  LoadSkin;

  MBarFlag:=False;

  FormResize(Sender);
  SizeChangeTimerTimer(Sender);
end;

procedure TNetFind.FormDestroy(Sender: TObject);
begin
  GS_NetFind.Free;
  GS_NetFind:=nil;
end;

procedure TNetFind.FormResize(Sender: TObject);
begin
  InfoLbl.Top:=NetFind.ClientHeight-InfoLbl.Height-4;
  GripImg.Top:=FindPanel.Height-4-GripImg.Height;
  GripImg.Left:=FindPanel.Width-4-GripImg.Width;
  SizeChangeTimer.Enabled:=True;
end;

procedure TNetFind.InitialStart;
begin
  SeekStart;
end;

procedure TNetFind.SizeChangeTimerTimer(Sender: TObject);
begin
  SizeChangeTimer.Enabled:=False;

  InfoLbl.Width:=FindPanel.Width-4-InfoLbl.Left-GripImg.Width;
  PrgBar.Width:=NetFind.ClientWidth-24;

  with SeekGrid do begin
    Width:=NetFind.ClientWidth-GS_PartsSize-24;
    Height:=NetFind.ClientHeight-SeekGrid.Top-8-InfoLbl.Height;
    ColWidths[0]:=46;
    ColWidths[1]:=180*(Width-46) div 554;
    ColWidths[2]:=140*(Width-46) div 554;
    ColWidths[3]:=256*(Width-46) div 554;
  end;

  GS_NetFind.ResetPosition;
end;

procedure TNetFind.SetStopBtnEnabled(mode:boolean);
begin
  StopBtnEnabled:=mode;
  SetShapeLblColor(StopLbl,StopShape,mode);
end;

procedure TNetFind.SetShapeLblColor(var Lbl:TLabel;var Shape:TShape;const mode:boolean);
begin
  if mode=True then begin
    Lbl.Font.Color:=CSkin.dwEtcBright;
    Shape.Pen.Color:=CSkin.dwEtcBright;
    end else begin
    Lbl.Font.Color:=CSkin.dwEtcMask;
    Shape.Pen.Color:=CSkin.dwEtcMask;
  end;
end;

procedure TNetFind.ClearGrid;
var
  x,y:integer;
begin
  with SeekGrid do begin
    for y:=1 to RowCount-0 do begin
      for x:=0 to ColCount-1 do begin
        Cells[x,y]:='';
      end;
    end;
    SetGridRowCount(2);
    Cells[0,1]:='';
    Cells[1,1]:='';
    Cells[2,1]:='';
    Cells[3,1]:='';
  end;
  SeekCount:=0;
  HitCount:=0;
end;

procedure TNetFind.SeekStartTimerTimer(Sender: TObject);
begin
  SeekStartTimer.Enabled:=False;
  SeekStart;
end;

procedure TNetFind.SeekStart;
begin
  if MainINI.NetFind_PlayStop=True then sdStop;

  SeekFilename:=AnsiLowerCase(strCnvAnk2to1byte(strGetCompact(strCnvX68kPlusSJIS(strClearESC(SeekFileEdt.Text)))));
  SeekTitle1:=AnsiLowerCase(strCnvAnk2to1byte(strGetCompact(strCnvX68kPlusSJIS(strClearESC(SeekTitle1Edt.Text)))));
  SeekTitle2:=AnsiLowerCase(strCnvAnk2to1byte(strGetCompact(strCnvX68kPlusSJIS(strClearESC(SeekTitle2Edt.Text)))));

  InfoLbl.Caption:='EBhEĂ܂c';
  ClearGrid;

  SeekTimer.Enabled:=True;
  SetStopBtnEnabled(True);

  InfoLbl.Caption:='Jn܂B';
  SeekTick:=GetTickCount;
end;

procedure TNetFind.SeekEdtChange(Sender: TObject);
begin
  if SeekChangeHold=False then begin
    with MainINI do begin
      NetFindFile:=SeekFileEdt.Text;
      NetFindTitle1:=SeekTitle1Edt.Text;
      NetFindTitle2:=SeekTitle2Edt.Text;
    end;
    if StopBtnEnabled=True then StopLblClick(Sender);
    if MainINI.NetFind_AutoFind<>0 then begin
      SeekStartTimer.Interval:=MainINI.NetFind_AutoFind*1000;
      SeekStartTimer.Enabled:=True;
    end;
  end;
end;

procedure TNetFind.SeekTimerTimer(Sender: TObject);
var
  HitFlag:boolean;
  cnt:integer;
  _Title:string;
begin
  SeekTimer.Enabled:=False;

  if Main.Network.NetworkEnable=False then begin
    InfoLbl.Caption:='MDXOnlineɐڑł܂łB';
    SetStopBtnEnabled(False);
    exit;
  end;

  LoadSeekList;

  if FindDataCount=-1 then begin
    InfoLbl.Caption:='Xg̓ǂݍ݂Ɏs܂B';
    SetStopBtnEnabled(False);
    exit;
  end;

  if (SeekFilename='') and (SeekTitle1='') and (SeekTitle2='') then begin
    InfoLbl.Caption:='I܂B';
    SetStopBtnEnabled(False);
    exit;
  end;

  PrgBar.Max:=FindDataCount;
  PrgBar.Position:=SeekCount;

  for cnt:=0 to 256-1 do begin
    if SeekCount<FindDataCount then begin
      with FindData[SeekCount] do begin
        HitFlag:=True;
        if SeekFilename<>'' then begin
          if AnsiPos(SeekFilename,AnsiLowerCase(Filename))=0 then HitFlag:=False;
        end;
        _Title:=AnsiLowerCase(Title);
        if SeekTitle1<>'' then begin
          if AnsiPos(SeekTitle1,_Title)=0 then HitFlag:=False;
        end;
        if SeekTitle2<>'' then begin
          if AnsiPos(SeekTitle2,_Title)=0 then HitFlag:=False;
        end;
        if HitFlag=True then begin
          inc(HitCount);
          with SeekGrid do begin
            if RowCount<=(HitCount+1) then begin
              SetGridRowCount(HitCount+200+1);
            end;
            Cells[0,HitCount]:=IntToStr(SeekCount);
            Cells[1,HitCount]:=Path;
            Cells[2,HitCount]:=Filename;
            Cells[3,HitCount]:=Title;
          end;
        end;
      end;
    end;
    inc(SeekCount);
  end;

  if SeekCount<FindDataCount then begin
    if (SeekTick+100)<GetTickCount then begin
      SeekTick:=GetTickCount;
      InfoLbl.Caption:='Ă܂c '+Format('(%2.2fper)',[SeekCount/FindDataCount*100]);
    end;
    SeekTimer.Enabled:=True;
    end else begin
    InfoLbl.Caption:='I܂B'+Format('Files:%d Hit:%d',[FindDataCount,HitCount]);
    SetStopBtnEnabled(False);
    if HitCount=0 then begin
      SetGridRowCount(2);
      end else begin
      SetGridRowCount(HitCount+1);
    end;
  end;
end;

procedure TNetFind.LoadSeekList;
var
  CatalogSeekFilename:string;
  procedure LoadFromCatalogIndex;
  var
    idxcnt:integer;
    _path:string;
    Datafs:TFileStream;
    DataSize:dword;
    Segment:dword;
  begin
    FindDataCount:=0;
    PrgBar.Position:=0;
    PrgBar.Max:=Main.Network.NetworkCatalog.CatalogIndexCount;
    SeekTick:=GetTickCount;

    Main.Network.NetworkCatalog.GetTitlePackStart(Datafs);

    for idxcnt:=0 to Main.Network.NetworkCatalog.CatalogIndexCount-1 do begin
      if (SeekTick+100)<GetTickCount then begin
        SeekTick:=GetTickCount;
        InfoLbl.Caption:='Xg쐬Ă܂c '+Format('%d/%ddirs (%2.2fper) %dfiles',[idxcnt,Main.Network.NetworkCatalog.CatalogIndexCount,idxcnt/Main.Network.NetworkCatalog.CatalogIndexCount*100,FindDataCount]);
        PrgBar.Position:=idxcnt;
      end;

      Segment:=Main.Network.NetworkCatalog.CatalogIndex[idxcnt].Segment;
      if Segment<>0 then begin
        Datafs.Position:=Segment;
        DataSize:=GetStreamDWord(Datafs);
        _path:=GetStreamMString(Datafs);
        while (Datafs.Position-Segment)<DataSize do begin
          if (FindDataCount mod 4096)=0 then begin
            SetLength(FindData,FindDataCount+4096+1);
          end;
          with FindData[FindDataCount] do begin
            Path:=_path;
            Filename:=GetStreamMString(Datafs);
            Title:=GetStreamMString(Datafs);
            Title:=strCnvAnk2to1byte(strGetCompact(strCnvX68kPlusSJIS(strClearESC(Title))));
          end;
          inc(FindDataCount);
        end;
      end;
    end;

    Main.Network.NetworkCatalog.GetTitlePackEnd(Datafs);
  end;
  procedure SaveToCatalogSeek(Filename:string);
  var
    wfb:TWriteFileBuf;
    cnt:integer;
  begin
    wfb:=TWriteFileBuf.Create;
    wfb.Init(Filename);
    wfb.SetDWord(FindDataCount);
    PrgBar.Position:=0;
    PrgBar.Max:=FindDataCount;
    SeekTick:=GetTickCount;

    for cnt:=0 to FindDataCount-1 do begin
      if (SeekTick+100)<GetTickCount then begin
        SeekTick:=GetTickCount;
        InfoLbl.Caption:='XgۑĂ܂c '+Format('%d/%dfiles (%2.2fper)',[cnt,FindDataCount,cnt/FindDataCount*100]);
        PrgBar.Position:=cnt;
      end;
      with FindData[cnt] do begin
        wfb.SetVMString(Path);
        wfb.SetVMString(Filename);
        wfb.SetVMString(Title);
      end;
    end;
    wfb.SaveFile;
    wfb.Free;
  end;
  procedure LoadFromCatalogSeek(Filename:string);
  var
    rfb:TReadFileBuf;
    cnt:integer;
  begin
    rfb:=TReadFileBuf.Create;
    rfb.Init(Filename);
    rfb.LoadFile;
    FindDataCount:=rfb.GetDWord;
    PrgBar.Position:=0;
    PrgBar.Max:=FindDataCount;
    SetLength(FindData,FindDataCount+1);
    SeekTick:=GetTickCount;

    for cnt:=0 to FindDataCount-1 do begin
      if (SeekTick+100)<GetTickCount then begin
        SeekTick:=GetTickCount;
        InfoLbl.Caption:='Xgǂݍł܂c '+Format('%d/%dfiles (%2.2fper)',[cnt,FindDataCount,cnt/FindDataCount*100]);
        PrgBar.Position:=cnt;
      end;
      with FindData[cnt] do begin
        rfb.GetVMString(Path);
        rfb.GetVMString(Filename);
        rfb.GetVMString(Title);
      end;
    end;
    rfb.Free;
  end;
begin
  if Main.Network.NetworkEnable=False then exit;
  if FindDataCount<>-1 then exit;

  SetStopBtnEnabled(False);

  CatalogSeekFilename:=Main.Network.CFG.CatalogSeek;

  if FileExists(CatalogSeekFilename)=False then begin
    LoadFromCatalogIndex;
    SaveToCatalogSeek(CatalogSeekFilename);
    end else begin
    LoadFromCatalogSeek(CatalogSeekFilename);
  end;

  PrgBar.Position:=0;
  SetStopBtnEnabled(True);
end;

procedure TNetFind.SeekGridDblClick(Sender: TObject);
var
  idx:integer;
begin
  idx:=Grid_GetIndex(SeekGrid);
  if idx<=0 then exit;
  if Length(FindData)=0 then exit;

  with SeekGrid do begin
    MainFileCtl.ExecutePlayFile('#:\'+Cells[1,idx]+Cells[2,idx],True);
  end;
end;

procedure TNetFind.SeekGridKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key=VK_F11 then Key:=VK_ESCAPE;

  case Key of
    VK_ESCAPE: begin
      Key:=0;
      if StopBtnEnabled=False then begin
        NetFind.Close;
        end else begin
        StopLblClick(Sender);
      end;
    end;
    VK_RETURN: begin
      Key:=0;
      SeekGridDblClick(Sender);
    end;
  end;

  case Key of
    VK_PRIOR: Grid_MouseWheelWithCursor(SeekGrid,-1,Shift);
    VK_NEXT:  Grid_MouseWheelWithCursor(SeekGrid,1,Shift);
    VK_UP:    Grid_MoveIndex(SeekGrid,Grid_GetIndex(SeekGrid)-1);
    VK_DOWN:  Grid_MoveIndex(SeekGrid,Grid_GetIndex(SeekGrid)+1);
    VK_END:   Grid_MoveIndex(SeekGrid,SeekGrid.RowCount-1);
    VK_HOME:  Grid_MoveIndex(SeekGrid,0);
  end;

  if (Key=VK_ESCAPE) or (Key=VK_RETURN) or (Key=VK_PRIOR) or (Key=VK_NEXT) or (Key=VK_UP) or (Key=VK_DOWN) or (Key=VK_END) or (Key=VK_HOME) then begin
    Key:=0;
    Shift:=[];
    exit;
  end;
end;

procedure TNetFind.SeekEdtKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
  procedure SendGrid;
  begin
    SeekGridKeyDown(Sender,Key,Shift);
    Key:=0;
  end;
begin
  if (Key=VK_ESCAPE) or (Key=VK_PRIOR) or (Key=VK_NEXT) or (Key=VK_UP) or (Key=VK_DOWN) then begin
    SendGrid;
  end;

  if Key=VK_RETURN then begin
    if MainINI.NetFind_AutoFind=0 then begin
      SeekStart;
      end else begin
      SendGrid;
    end;
  end;

  if MainINI.NetFind_EnableHomeEndKey=False then begin
    if (Key=VK_HOME) or (Key=VK_END) then begin
      SendGrid;
    end;
  end;
end;

procedure TNetFind.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if StopBtnEnabled=True then StopLblClick(Sender);
  SeekTimer.Enabled:=False;
  ClearGrid;

end;

procedure TNetFind.InfoLblMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  MBarFlag:=True;
  MBarY:=Y;
end;

procedure TNetFind.InfoLblMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  if MBarFlag=True then begin
    NetFind.Height:=NetFind.Height+(Y-MBarY);
  end;
end;

procedure TNetFind.InfoLblMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  MBarFlag:=False;
end;

procedure TNetFind.FindPanelMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  DlgDrag:=True;
  Dlgmx:=x;
  Dlgmy:=y;
end;

procedure TNetFind.FindPanelMouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
begin
  if DlgDrag=True then begin
    with NetFind do begin
      Left:=Left+(X-Dlgmx);
      Top:=Top+(Y-Dlgmy);
    end;
  end;
end;

procedure TNetFind.FindPanelMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  DlgDrag:=False;
end;

procedure TNetFind.StopLblClick(Sender: TObject);
begin
  if StopBtnEnabled=False then exit;

  SeekTimer.Enabled:=False;
  SetStopBtnEnabled(False);
  InfoLbl.Caption:='𒆎~܂B';

  if HitCount=0 then begin
    SetGridRowCount(2);
    end else begin
    SetGridRowCount(HitCount+1);
  end;
end;

procedure TNetFind.CloseLblClick(Sender: TObject);
begin
  NetFind.Close;
end;

procedure TNetFind.SeekGridMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  col,row:integer;
begin
  SeekGrid.MouseToCell(x,y,col,row);

  if (col<1) or (row<1) then begin
    DlgDrag:=True;
    Dlgmx:=x;
    Dlgmy:=y;
  end;
end;

procedure TNetFind.SeekGridMouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
var
  col,row:integer;
begin
  if DlgDrag=True then begin
    with NetFind do begin
      Left:=Left+(X-Dlgmx);
      Top:=Top+(Y-Dlgmy);
    end;
    end else begin
    SeekGrid.MouseToCell(x,y,col,row);
    if (col>=1) and (row>=1) then begin
      InfoLbl.Caption:=Format('[%2d,%2d] %s',[col,row,SeekGrid.Cells[col,row]]);
    end;
  end;
end;

procedure TNetFind.SeekGridMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  DlgDrag:=False;
end;

procedure TNetFind.GripImgMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  MBarFlag:=True;
  MBarX:=X;
  MBarY:=Y;
end;

procedure TNetFind.GripImgMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  if MBarFlag=True then begin
    NetFind.Width:=NetFind.Width+(X-MBarX);
    NetFind.Height:=NetFind.Height+(Y-MBarY);
  end;
end;

procedure TNetFind.GripImgMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  MBarFlag:=False;
end;

procedure TNetFind.SeekGridMouseWheelDown(Sender: TObject;
  Shift: TShiftState; MousePos: TPoint; var Handled: Boolean);
begin
  Handled:=True;
  Grid_MouseWheelViewOnly(SeekGrid,1,Shift);
end;

procedure TNetFind.SeekGridMouseWheelUp(Sender: TObject;
  Shift: TShiftState; MousePos: TPoint; var Handled: Boolean);
begin
  Handled:=True;
  Grid_MouseWheelViewOnly(SeekGrid,-1,Shift);
end;

procedure TNetFind.SetGridRowCount(cnt:integer);
begin
  SeekGrid.RowCount:=cnt;
  GS_NetFind.ResetPosition;
  SizeChangeTimer.Enabled:=True;
end;

procedure TNetFind.FindMenuLblClick(Sender: TObject);
var
  pos:TPoint;
begin
  with MainINI do begin
    FM_PlayStop.Checked:=NetFind_PlayStop;
    FM_AutoFindNone.Checked:=(NetFind_AutoFind=0);
    FM_AutoFind1sec.Checked:=(NetFind_AutoFind=1);
    FM_AutoFind2sec.Checked:=(NetFind_AutoFind=2);
    FM_AutoFind3sec.Checked:=(NetFind_AutoFind=3);
    FM_AutoFind4sec.Checked:=(NetFind_AutoFind=4);
    FM_AutoFind5sec.Checked:=(NetFind_AutoFind=5);
    FM_EnableHomeEndKey.Checked:=NetFind_EnableHomeEndKey;
  end;

  GetCursorPos(pos);
  FindMenu.Popup(pos.X,pos.Y);
end;

procedure TNetFind.FM_ItemClick(Sender: TObject);
begin
  MainINI.NetFind_PlayStop:=not MainINI.NetFind_PlayStop;
end;

procedure TNetFind.FM_EnableHomeEndKeyClick(Sender: TObject);
begin
  MainINI.NetFind_EnableHomeEndKey:=not MainINI.NetFind_EnableHomeEndKey;
end;

procedure TNetFind.FM_AutoFindNoneClick(Sender: TObject);
begin
  MainINI.NetFind_AutoFind:=0;
end;

procedure TNetFind.FM_AutoFind1secClick(Sender: TObject);
begin
  MainINI.NetFind_AutoFind:=1;
end;

procedure TNetFind.FM_AutoFind2secClick(Sender: TObject);
begin
  MainINI.NetFind_AutoFind:=2;
end;

procedure TNetFind.FM_AutoFind3secClick(Sender: TObject);
begin
  MainINI.NetFind_AutoFind:=3;
end;

procedure TNetFind.FM_AutoFind4secClick(Sender: TObject);
begin
  MainINI.NetFind_AutoFind:=4;
end;

procedure TNetFind.FM_AutoFind5secClick(Sender: TObject);
begin
  MainINI.NetFind_AutoFind:=5;
end;

end.
