unit NetRankWin;

{$WARN UNIT_PLATFORM OFF}
{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  Windows, SysUtils, Forms, Dialogs, Classes, Controls, StdCtrls, Buttons, ComCtrls,
  ExtCtrls, Grids, Graphics;

type
  TinRankData=record
    url:string;
    count:integer;
  end;

  TRankData=record
    Loaded:boolean;
    UpdateData:string;
    Files,Paths:array of TinRankData;
    FilesCount,PathsCount:integer;
  end;

const RankMode_Files=0;
const RankMode_Paths=1;

type
  TNetRank = class(TForm)
    RankPanel: TPanel;
    SeekGrid: TStringGrid;
    InfoLbl: TStaticText;
    RefreshShape: TShape;
    RefreshLbl: TLabel;
    CloseLbl: TLabel;
    CloseShape: TShape;
    GripImg: TImage;
    SizeChangeTimer: TTimer;
    FileListShape: TShape;
    FileListLbl: TLabel;
    PathListShape: TShape;
    PathListLbl: TLabel;
    LastUpdateLbl: TStaticText;
    RefreshRankTimer: TTimer;
    MaxCountLst: TComboBox;
    SeekGridImg: TImage;
    procedure FormCreate(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure SeekGridDblClick(Sender: TObject);
    procedure SeekEdtKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure SeekGridKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure InfoLblMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure InfoLblMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure InfoLblMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure RankPanelMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure RankPanelMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure RankPanelMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure CloseLblClick(Sender: TObject);
    procedure SeekGridMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure SeekGridMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure SeekGridMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure GripImgMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure GripImgMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure GripImgMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure SizeChangeTimerTimer(Sender: TObject);
    procedure FileListLblClick(Sender: TObject);
    procedure PathListLblClick(Sender: TObject);
    procedure RefreshLblClick(Sender: TObject);
    procedure RefreshRankTimerTimer(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure MaxCountLstChange(Sender: TObject);
    procedure SeekGridMouseWheelDown(Sender: TObject; Shift: TShiftState;
      MousePos: TPoint; var Handled: Boolean);
    procedure SeekGridMouseWheelUp(Sender: TObject; Shift: TShiftState;
      MousePos: TPoint; var Handled: Boolean);
    procedure FormDestroy(Sender: TObject);
  private
    { Private 錾 }
    RankData:TRankData;
    MBarFlag:boolean;
    MBarX,MBarY:integer;
    DlgDrag:boolean;
    Dlgmx:integer;
    Dlgmy:integer;
    RankMode:integer;
    MaxCountChangeHold:boolean;
    procedure RefreshRank;
    procedure RefreshGrid;
    procedure RefreshTitle;
    procedure LoadRank;
    procedure ClearGrid;
    procedure SetShapeLblColor(var Lbl:TLabel;var Shape:TShape;const mode:boolean);
    procedure ExtractURL(const url:string;var path,filename:string);
    procedure SetGridRowCount(cnt:integer);
  public
    { Public 錾 }
    procedure LoadSkin;
    procedure Init;
  end;

var
  NetRank: TNetRank;

implementation

uses MainWin,
     _MDXWinINI,_MainFileCtl,_GridTool,_m_Tools,  _PicTools,_filebuf, _GridScroll,_GridScroll_Rap,_CSkin,_Images;

{$R *.dfm}

procedure SetShapeLblColor(var Lbl:TLabel;var Shape:TShape;const mode:boolean);
begin
  if mode=True then begin
    Lbl.Font.Color:=CSkin.dwEtcBright;
    Shape.Pen.Color:=CSkin.dwEtcBright;
    end else begin
    Lbl.Font.Color:=CSkin.dwEtcMask;
    Shape.Pen.Color:=CSkin.dwEtcMask;
  end;
end;

procedure TNetRank.LoadSkin;
  procedure SetLabel(var Lb:TStaticText);
  begin
    Lb.Color:=CSkin.dwEtcBG;
    Lb.Font.Color:=CSkin.dwEtcBright;
  end;
  procedure SetEdit(var Edt:TEdit);
  begin
    Edt.Color:=CSkin.dwEtcBG;
    Edt.Font.Color:=CSkin.dwEtcText;
  end;
  procedure SetCLst(var CLst:TComboBox);
  begin
    CLst.Color:=CSkin.dwEtcBG;
    CLst.Font.Color:=CSkin.dwEtcBright;
  end;
begin
  MakeBlankImg(GripImg,pf24bit);
  with GripImg do begin
    Images.DrawSizeGrip(Picture.Bitmap,0,0,CSkin.ColEtcBG,CSkin.ColEtcFrameGrip);
  end;
  GripImg.Refresh;

  SetShapeLblColor(CloseLbl,CloseShape,True);
  SetShapeLblColor(RefreshLbl,RefreshShape,True);

  RankPanel.Color:=CSkin.dwEtcBG;
  SetCLst(MaxCountLst);
  SetLabel(InfoLbl);
  SetLabel(LastUpdateLbl);

  with SeekGrid do begin
    FixedColor:=CSkin.dwEtcGridFixedBG;
    Color:=CSkin.dwEtcGridBG;
    Font.Color:=CSkin.dwEtcGridText;
  end;
  SeekGrid.Refresh;
end;

procedure TNetRank.FormCreate(Sender: TObject);
var
  cnt:integer;
begin
  AdjustWindowSize(Screen.Width,Screen.Height,MainINI.NetRankPos);
  with MainINI.NetRankPos do begin
    NetRank.Left:=Left;
    NetRank.Top:=Top;
    NetRank.Width:=Width;
    NetRank.Height:=Height;
  end;

  GS_NetRank:=TGridScroll.Create;
  GS_NetRank.LinkComponent(SeekGrid,SeekGridImg);

  with SeekGrid do begin
    Cells[0,0]:='Hit';
    Cells[1,0]:='Path';
    Cells[2,0]:='Filename';
    Cells[3,0]:='Title';
    DefaultRowHeight:=Canvas.TextHeight('0123456789')+4;
  end;

  with NetRank.Constraints do begin
    MinHeight:=SeekGrid.Top+64;
    MaxHeight:=Screen.Height;
    MinWidth:=640;
    MaxWidth:=Screen.Width;
  end;

  InfoLbl.Caption:='MDXOnline LOEBhE';
  NetRank.Visible:=True;

  with MaxCountLst do begin
    MaxCountChangeHold:=True;
    Clear;
    Items.Add('S');
    for cnt:=1 to 20 do begin
      Items.Add(IntToStr(cnt*100)+'܂');
    end;
    with MainINI do begin
      if Items.Count<(NetRankMaxCountIndex+1) then NetRankMaxCountIndex:=Items.Count-1;
      ItemIndex:=NetRankMaxCountIndex;
    end;
    MaxCountChangeHold:=False;
  end;

  LoadSkin;

  FormResize(Sender);
  SizeChangeTimerTimer(Sender);

  RankMode:=RankMode_Files;
  with MainINI do begin
    if NetRankRankMode=RankMode_Files then RankMode:=RankMode_Files;
    if NetRankRankMode=RankMode_Paths then RankMode:=RankMode_Paths;
  end;

  if FileExists(Main.Network.CFG.RankingPath)=True then DeleteFile(Main.Network.CFG.RankingPath);

  RankData.Loaded:=False;
end;

procedure TNetRank.FormDestroy(Sender: TObject);
begin
  GS_NetRank.Free;
  GS_NetRank:=nil;
end;

procedure TNetRank.Init;
begin
  RefreshRankTimer.Enabled:=True;
end;

procedure TNetRank.FormResize(Sender: TObject);
begin
  InfoLbl.Top:=NetRank.ClientHeight-InfoLbl.Height-4;
  GripImg.Top:=RankPanel.Height-4-GripImg.Height;
  GripImg.Left:=RankPanel.Width-4-GripImg.Width;
  SizeChangeTimer.Enabled:=True;
end;

procedure TNetRank.SizeChangeTimerTimer(Sender: TObject);
begin
  SizeChangeTimer.Enabled:=False;

  SeekGrid.Height:=NetRank.ClientHeight-SeekGrid.Top-8-InfoLbl.Height;

  InfoLbl.Width:=RankPanel.Width-4-InfoLbl.Left-GripImg.Width;

  with SeekGrid do begin
    Width:=NetRank.ClientWidth-GS_PartsSize-24;
    case RankMode of
      RankMode_Files: begin
        ColWidths[0]:=38;
        ColWidths[1]:=186*(Width-38) div 564;
        ColWidths[2]:=100*(Width-38) div 564;
        ColWidths[3]:=300*(Width-38) div 564;
      end;
      RankMode_Paths: begin
        ColWidths[0]:=38;
        ColWidths[1]:=286*(Width-38) div 564;
        ColWidths[2]:=0*(Width-38) div 564;
        ColWidths[3]:=300*(Width-38) div 564;
      end;
    end;
  end;

  GS_NetRank.ResetPosition;
end;

procedure TNetRank.SetShapeLblColor(var Lbl:TLabel;var Shape:TShape;const mode:boolean);
begin
  if mode=True then begin
    Lbl.Font.Color:=CSkin.dwEtcBright;
    Shape.Pen.Color:=CSkin.dwEtcBright;
    end else begin
    Lbl.Font.Color:=CSkin.dwEtcMask;
    Shape.Pen.Color:=CSkin.dwEtcMask;
  end;
end;

procedure TNetRank.RefreshRankTimerTimer(Sender: TObject);
begin
  RefreshRankTimer.Enabled:=False;
  RefreshRank;
  RefreshGrid;
  RefreshTitle;
end;

procedure TNetRank.RefreshRank;
var
  res:boolean;
begin
  case RankMode of
    RankMode_Files: begin
      SetShapeLblColor(FileListLbl,FileListShape,True);
      SetShapeLblColor(PathListLbl,PathListShape,False);
    end;
    RankMode_Paths: begin
      SetShapeLblColor(FileListLbl,FileListShape,False);
      SetShapeLblColor(PathListLbl,PathListShape,True);
    end;
  end;

  InfoLbl.Caption:='LOEBhEĂ܂c';

  if RankData.Loaded=False then begin
    if FileExists(Main.Network.CFG.RankingPath)=False then begin
      if Main.Network.NetworkEnable=False then exit;
      res:=Main.Network.GetHTTPDataFileSZip(Main.Network.CFG.RankingURL,Main.Network.CFG.RankingPath,'lbg[NLOf[^_E[hĂ܂c');
      if res=False then begin
        ShowMessage('LOf[^̓ǂݍ݂Ɏs܂B');
        NetRank.Close;
        exit;
      end;
    end;
    LoadRank;
    RankData.Loaded:=True;
    LastUpdateLbl.Caption:='ŏIXV:'+RankData.UpdateData;
  end;

  InfoLbl.Caption:='';
end;

procedure TNetRank.ClearGrid;
var
  x,y:integer;
begin
  with SeekGrid do begin
    for y:=1 to RowCount-1 do begin
      for x:=0 to ColCount-1 do begin
        Cells[x,y]:='';
      end;
    end;
    SetGridRowCount(2);
    Cells[0,1]:='';
    Cells[1,1]:='';
    Cells[2,1]:='';
    Cells[3,1]:='';
  end;
end;

procedure TNetRank.RefreshGrid;
var
  MaxCount:integer;
  cnt:integer;
  path,filename:string;
  BackMaxCount:integer;
begin
  SizeChangeTimerTimer(nil);

  ClearGrid;

  case RankMode of
    RankMode_Files: begin
      with RankData,SeekGrid do begin
        MaxCountChangeHold:=True;
        BackMaxCount:=MaxCountLst.ItemIndex;
        MaxCountLst.Items[0]:='S('+IntToStr(FilesCount)+')';
        MaxCountLst.ItemIndex:=BackMaxCount;
        MaxCountChangeHold:=False;

        if FilesCount=0 then exit;
        if MaxCountLst.ItemIndex=0 then begin
          MaxCount:=FilesCount;
          end else begin
          MaxCount:=MaxCountLst.ItemIndex*100;
          if MaxCount>FilesCount then MaxCount:=FilesCount;
        end;
        SetGridRowCount(MaxCount+1);
        for cnt:=0 to MaxCount-1 do begin
          with Files[cnt] do begin
            Cells[0,cnt+1]:=format('%5d',[Count]);
            ExtractURL(url,path,filename);
            Cells[1,cnt+1]:=path;
            Cells[2,cnt+1]:=filename;
            Cells[3,cnt+1]:='';
          end;
        end;
      end;
    end;
    RankMode_Paths: begin
      with RankData,SeekGrid do begin
        MaxCountChangeHold:=True;
        BackMaxCount:=MaxCountLst.ItemIndex;
        MaxCountLst.Items[0]:='S('+IntToStr(PathsCount)+')';
        MaxCountLst.ItemIndex:=BackMaxCount;
        MaxCountChangeHold:=False;

        if PathsCount=0 then exit;
        if MaxCountLst.ItemIndex=0 then begin
          MaxCount:=PathsCount;
          end else begin
          MaxCount:=MaxCountLst.ItemIndex*100;
          if MaxCount>PathsCount then MaxCount:=PathsCount;
        end;
        SetGridRowCount(MaxCount+1);
        for cnt:=0 to MaxCount-1 do begin
          with Paths[cnt] do begin
            Cells[0,cnt+1]:=format('%5d',[Count]);
            Cells[1,cnt+1]:=url;
            Cells[2,cnt+1]:='';
            Cells[3,cnt+1]:='';
          end;
        end;
      end;
    end;
  end;
end;

procedure TNetRank.RefreshTitle;
var
  cnt,Count:integer;
  Title:string;
  path,filename:string;
  Datafs:TFileStream;
  procedure RefreshInfoLbl(cnt,max:integer);
  begin
    InfoLbl.Caption:='ȃ^Cgǂݍł܂c '+format('[%d/%d]',[cnt,max]);
  end;
begin
  RefreshInfoLbl(0,0);

  Main.Network.NetworkCatalog.GetTitlePackStart(Datafs);

  Count:=SeekGrid.RowCount-1;

  case RankMode of
    RankMode_Files: begin
      with RankData,SeekGrid do begin
        if FilesCount=0 then exit;
        for cnt:=0 to Count-1 do begin
          if cnt<FilesCount then begin
            if (cnt mod 512)=0 then RefreshInfoLbl(cnt,Count);
            ExtractURL(Files[cnt].url,path,filename);
            Title:=Main.Network.NetworkCatalog.GetTitlePackSeek(Datafs,path,filename,True);
            if Title='' then begin
              Cells[3,cnt+1]:='no title';
              end else begin
              Cells[3,cnt+1]:=Title;
            end;
          end;
        end;
      end;
    end;
    RankMode_Paths: begin
      with RankData,SeekGrid do begin
        if PathsCount=0 then exit;
        for cnt:=0 to Count-1 do begin
          if cnt<PathsCount then begin
            if (cnt mod 512)=0 then RefreshInfoLbl(cnt,Count);
            Title:=Main.Network.NetworkCatalog.GetTitlePackSeek(Datafs,Paths[cnt].url,'',True);
            if Title='' then begin
              Cells[3,cnt+1]:='no title';
              end else begin
              Cells[3,cnt+1]:=Title;
            end;
          end;
        end;
      end;
    end;
  end;

  Main.Network.NetworkCatalog.GetTitlePackEnd(Datafs);

  InfoLbl.Caption:='';
end;

procedure TNetRank.ExtractURL(const url:string;var path,filename:string);
var
  cnt:integer;
  p:integer;
begin
  p:=-1;
  for cnt:=1 to Length(url) do begin
    if url[cnt]='\' then p:=cnt;
  end;
  if p=-1 then begin
    path:='';
    filename:='';
    end else begin
    path:=copy(url,1,p);
    filename:=copy(url,p+1,255);
  end;
end;

procedure TNetRank.LoadRank;
var
  rfb:TReadFileBuf;
  cnt:integer;
  res:string;
begin
  RankData.FilesCount:=0;
  RankData.PathsCount:=0;
  RankData.UpdateData:='';

  rfb:=TReadFileBuf.Create;
  rfb.Init(Main.Network.CFG.RankingPath);
  rfb.LoadFile;

  rfb.GetVMString(res);
  if res<>'MDXOnlineRankingList' then begin
    ShowMessage('t@CĂ܂BčXVĂB');
    exit;
  end;

  rfb.GetVMString(RankData.UpdateData);

  rfb.GetVInteger(RankData.PathsCount);
  SetLength(RankData.Paths,RankData.PathsCount);
  for cnt:=0 to RankData.PathsCount-1 do begin
    with RankData.Paths[cnt] do begin
      Count:=rfb.GetDWord;
      rfb.GetVMString(url);
    end;
  end;

  rfb.GetVInteger(RankData.FilesCount);
  SetLength(RankData.Files,RankData.FilesCount);
  for cnt:=0 to RankData.FilesCount-1 do begin
    with RankData.Files[cnt] do begin
      Count:=rfb.GetDWord;
      rfb.GetVMString(url);
    end;
  end;

  rfb.Free;
end;

procedure TNetRank.SeekGridDblClick(Sender: TObject);
var
  idx:integer;
begin
  idx:=Grid_GetIndex(SeekGrid);
  if idx<=0 then exit;
  if SeekGrid.RowCount=0 then exit;

  with SeekGrid do begin
    case RankMode of
      RankMode_Files: MainFileCtl.ExecutePlayFile('#:\'+Cells[1,idx]+Cells[2,idx],True);
      RankMode_Paths: MainFileCtl.ExecutePlayFile('#:\'+Cells[1,idx],False);
    end;
  end;
end;

procedure TNetRank.SeekGridKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key=VK_F11 then Key:=VK_ESCAPE;

  case Key of
    VK_ESCAPE: begin
      Key:=0;
      NetRank.Close;
    end;
    VK_RETURN: begin
      Key:=0;
      SeekGridDblClick(Sender);
    end;
  end;

  case Key of
    VK_END:   Grid_MoveIndex(SeekGrid,SeekGrid.RowCount-1);
    VK_HOME:  Grid_MoveIndex(SeekGrid,0);
    VK_PRIOR: Grid_MouseWheelWithCursor(SeekGrid,-1,Shift);
    VK_NEXT:  Grid_MouseWheelWithCursor(SeekGrid,1,Shift);
  end;

  if (Key=VK_END) or (Key=VK_HOME) or (Key=VK_PRIOR) or (Key=VK_NEXT) then begin
    Key:=0;
    Shift:=[];
    exit;
  end;
end;

procedure TNetRank.SeekEdtKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (Key=VK_ESCAPE) or (Key=VK_F11) or (Key=VK_RETURN) or (Key=VK_PRIOR) or (Key=VK_NEXT) or (Key=VK_UP) or (Key=VK_DOWN) or (Key=VK_HOME) or (Key=VK_END) then begin
    SeekGridKeyDown(Sender,Key,Shift);
    Key:=0;
  end;
end;

procedure TNetRank.InfoLblMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  MBarFlag:=True;
  MBarY:=Y;
end;

procedure TNetRank.InfoLblMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  if MBarFlag=True then begin
    NetRank.Height:=NetRank.Height+(Y-MBarY);
  end;
end;

procedure TNetRank.InfoLblMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  MBarFlag:=False;
end;

procedure TNetRank.RankPanelMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  DlgDrag:=True;
  Dlgmx:=x;
  Dlgmy:=y;
end;

procedure TNetRank.RankPanelMouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
begin
  if DlgDrag=True then begin
    with NetRank do begin
      Left:=Left+(X-Dlgmx);
      Top:=Top+(Y-Dlgmy);
    end;
  end;
end;

procedure TNetRank.RankPanelMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  DlgDrag:=False;
end;

procedure TNetRank.CloseLblClick(Sender: TObject);
begin
  NetRank.Close;
end;

procedure TNetRank.SeekGridMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  col,row:integer;
begin
  SeekGrid.MouseToCell(x,y,col,row);

  if (col<1) or (row<1) then begin
    DlgDrag:=True;
    Dlgmx:=x;
    Dlgmy:=y;
  end;
end;

procedure TNetRank.SeekGridMouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
var
  col,row:integer;
begin
  if DlgDrag=True then begin
    with NetRank do begin
      Left:=Left+(X-Dlgmx);
      Top:=Top+(Y-Dlgmy);
    end;
    end else begin
    SeekGrid.MouseToCell(x,y,col,row);
    if (col>=1) and (row>=1) then begin
      InfoLbl.Caption:=Format('[%2d,%2d] %s',[col,row,SeekGrid.Cells[col,row]]);
    end;
  end;
end;

procedure TNetRank.SeekGridMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  DlgDrag:=False;
end;

procedure TNetRank.GripImgMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  MBarFlag:=True;
  MBarX:=X;
  MBarY:=Y;
end;

procedure TNetRank.GripImgMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  if MBarFlag=True then begin
    NetRank.Width:=NetRank.Width+(X-MBarX);
    NetRank.Height:=NetRank.Height+(Y-MBarY);
  end;
end;

procedure TNetRank.GripImgMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  MBarFlag:=False;
end;

procedure TNetRank.FileListLblClick(Sender: TObject);
begin
  RankMode:=RankMode_Files;
  MainINI.NetRankRankMode:=RankMode;
  RefreshRankTimer.Enabled:=True;
end;

procedure TNetRank.PathListLblClick(Sender: TObject);
begin
  RankMode:=RankMode_Paths;
  MainINI.NetRankRankMode:=RankMode;
  RefreshRankTimer.Enabled:=True;
end;

procedure TNetRank.RefreshLblClick(Sender: TObject);
begin
  RankData.Loaded:=False;
  if FileExists(Main.Network.CFG.RankingPath)=True then DeleteFile(Main.Network.CFG.RankingPath);
  RefreshRankTimer.Enabled:=True;
end;

procedure TNetRank.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  RefreshRankTimer.Enabled:=False;
  ClearGrid;
end;

procedure TNetRank.MaxCountLstChange(Sender: TObject);
begin
  if MaxCountChangeHold=False then begin
    MainINI.NetRankMaxCountIndex:=MaxCountLst.ItemIndex;
    RefreshRankTimer.Enabled:=True;
  end;
end;

procedure TNetRank.SeekGridMouseWheelDown(Sender: TObject;
  Shift: TShiftState; MousePos: TPoint; var Handled: Boolean);
begin
  Handled:=True;
  Grid_MouseWheelViewOnly(SeekGrid,1,Shift);
end;

procedure TNetRank.SeekGridMouseWheelUp(Sender: TObject;
  Shift: TShiftState; MousePos: TPoint; var Handled: Boolean);
begin
  Handled:=True;
  Grid_MouseWheelViewOnly(SeekGrid,-1,Shift);
end;

procedure TNetRank.SetGridRowCount(cnt:integer);
begin
  SeekGrid.RowCount:=cnt;
  GS_NetRank.ResetPosition;
  SizeChangeTimer.Enabled:=True;
end;

end.
