unit SetupWin;

interface

{$WARN UNIT_PLATFORM OFF}
{$WARN SYMBOL_PLATFORM OFF}

uses
  Windows, SysUtils, Forms, Dialogs, Classes, Controls, StdCtrls, Buttons, ComCtrls,
  Registry, CheckLst, ShellAPI;

type
  TSetup = class(TForm)
    Label20: TLabel;
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Label25: TLabel;
    FontDlg: TFontDialog;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet3: TTabSheet;
    Label28: TLabel;
    Label32: TLabel;
    CurrentPathBtn: TBitBtn;
    SetCurrentPath: TEdit;
    CatalogPathBtn: TBitBtn;
    SetCatalogPath: TEdit;
    GroupBox1: TGroupBox;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    SetP2_233: TButton;
    SetPM_200: TButton;
    SetP_166: TButton;
    TabSheet2: TTabSheet;
    RegLst: TCheckListBox;
    RegFastChk: TCheckBox;
    Label6: TLabel;
    RegSetBtn: TBitBtn;
    AllRegSetBtn: TBitBtn;
    TabSheet4: TTabSheet;
    Label41: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    YM2608PathBtn: TBitBtn;
    SetYM2608Path: TEdit;
    SetFMPPMDPathLst: TListBox;
    FMPPathAddBtn: TBitBtn;
    FMPPathDelBtn: TBitBtn;
    FMPPathUpBtn: TButton;
    FMPPathDownBtn: TButton;
    SetWaveLocalPath: TEdit;
    WaveLocalPathBtn: TBitBtn;
    Label7: TLabel;
    WaveLocalEqualMDXFolderChk: TCheckBox;
    SimpleBar: TStatusBar;
    Label11: TLabel;
    SetCeleron_350: TButton;
    SetDropActiveWindow: TCheckBox;
    Label17: TLabel;
    DefPathBtn: TBitBtn;
    SetDefPath: TEdit;
    Label18: TLabel;
    TabSheet5: TTabSheet;
    SetLoopMax: TEdit;
    Label38: TLabel;
    GroupBox3: TGroupBox;
    Label5: TLabel;
    SetDSoundSafeTime: TComboBox;
    GroupBox5: TGroupBox;
    SetDLLProgressLoad: TCheckBox;
    SetFMCalc55k: TCheckBox;
    SetInterpolation: TCheckBox;
    SetLoadInitADPCM: TCheckBox;
    SetPPSUse: TCheckBox;
    SetRhythmWithSSGEffect: TCheckBox;
    SetADPCMPPZ8Emulate: TCheckBox;
    SetPMD86PCMMode: TCheckBox;
    SetVolFM: TTrackBar;
    SetVolSSG: TTrackBar;
    SetVolRhythm: TTrackBar;
    SetVolADPCM: TTrackBar;
    SetVolPPZ: TTrackBar;
    Label19: TLabel;
    Label21: TLabel;
    Label23: TLabel;
    Label24: TLabel;
    Label26: TLabel;
    VisVolFM: TLabel;
    VisVolSSG: TLabel;
    VisVolRhythm: TLabel;
    VisVolADPCM: TLabel;
    VisVolPPZ: TLabel;
    Label29: TLabel;
    TabSheet6: TTabSheet;
    Label31: TLabel;
    SetWaveNetworkPath: TEdit;
    WaveNetworkPathBtn: TBitBtn;
    Label33: TLabel;
    Label35: TLabel;
    TabSheet7: TTabSheet;
    Set_SPC_MixMode: TComboBox;
    Label36: TLabel;
    Set_SPC_IntMode: TComboBox;
    Label37: TLabel;
    GroupBox6: TGroupBox;
    Set_SPC_DSPOpt_LowpassFilter: TCheckBox;
    Set_SPC_DSPOpt_OldADPCMDecompress: TCheckBox;
    Set_SPC_DSPOpt_SurroundSound: TCheckBox;
    Set_SPC_DSPOpt_ReverseStereo: TCheckBox;
    Set_SPC_DSPPitch: TComboBox;
    Label39: TLabel;
    Label40: TLabel;
    Set_SPC_DefaultSongLenSec: TEdit;
    Label42: TLabel;
    Set_SPC_DefaultFadeoutLenSec: TEdit;
    Label43: TLabel;
    Label44: TLabel;
    Set_SPC_EnabledID666Length: TCheckBox;
    Set_SPC_EnabledWinAMPDSP: TCheckBox;
    GroupBox7: TGroupBox;
    Label30: TLabel;
    SetUseKDD: TCheckBox;
    SetKDDAntialias: TCheckBox;
    SetKDDTextFont: TEdit;
    SetKDDTextFontBtn: TButton;
    GroupBox8: TGroupBox;
    Label45: TLabel;
    SetTitleUseESC: TCheckBox;
    SetTitleUseAnk2to1byte: TCheckBox;
    SetTitleFontName: TEdit;
    SetTitleFontNameBtn: TButton;
    SetMainPriorityLevel: TComboBox;
    Label10: TLabel;
    Label34: TLabel;
    GroupBox9: TGroupBox;
    SetNetRemoteEnabled: TCheckBox;
    SetNetRemotePort: TEdit;
    Label46: TLabel;
    SetNetRemoteLocalOnly: TCheckBox;
    Label47: TLabel;
    SetNetRemoteLoginPassword: TEdit;
    Label48: TLabel;
    Label12: TLabel;
    Label27: TLabel;
    FontChangeBtn: TButton;
    SetSplashScreen: TCheckBox;
    Label8: TLabel;
    Label9: TLabel;
    Label53: TLabel;
    SetMDXOnlineBufferSize: TComboBox;
    Label55: TLabel;
    Label56: TLabel;
    Label57: TLabel;
    Label58: TLabel;
    HelpBtn: TBitBtn;
    Label1: TLabel;
    Label16: TLabel;
    Label22: TLabel;
    Label49: TLabel;
    Label59: TLabel;
    Label60: TLabel;
    procedure SetCeleron_350Click(Sender: TObject);
    procedure SetP2_233Click(Sender: TObject);
    procedure SetPM_200Click(Sender: TObject);
    procedure SetP_166Click(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure CurrentPathBtnClick(Sender: TObject);
    procedure CatalogPathBtnClick(Sender: TObject);
    procedure FontChangeBtnClick(Sender: TObject);
    procedure YM2608PathBtnClick(Sender: TObject);
    procedure NumCheckKeyPress(Sender: TObject; var Key: Char);
    procedure FMPPathAddBtnClick(Sender: TObject);
    procedure SetFMPPMDPathLstClick(Sender: TObject);
    procedure FMPPathDelBtnClick(Sender: TObject);
    procedure FMPPathUpBtnClick(Sender: TObject);
    procedure FMPPathDownBtnClick(Sender: TObject);
    procedure RegLstClick(Sender: TObject);
    procedure RegSetBtnClick(Sender: TObject);
    procedure AllRegSetBtnClick(Sender: TObject);
    procedure WaveLocalPathBtnClick(Sender: TObject);
    procedure WaveNetworkPathBtnClick(Sender: TObject);
    procedure DefPathBtnClick(Sender: TObject);
    procedure SetVolChange(Sender: TObject);
    procedure SetKDDTextFontBtnClick(Sender: TObject);
    procedure SetKDDTextFontKeyPress(Sender: TObject; var Key: Char);
    procedure SetTitleFontNameKeyPress(Sender: TObject; var Key: Char);
    procedure SetTitleFontNameBtnClick(Sender: TObject);
    procedure HelpBtnClick(Sender: TObject);
  private
    procedure SetupCancel;
    procedure SetupSave;
    procedure RefrectFMPPMDBtn;
    function  isRegisted(ext:string):boolean;
    procedure RegRefresh;
  public
    procedure SetCreate;
  end;

var
  Setup: TSetup;

implementation

uses MainWin, FolderDlgWin,
     _MainFileCtl,_const, _SndDrv_const,_MDXWinINI;

{$R *.DFM}

procedure TSetup.SetCreate;
var
  cnt:integer;
begin
  MDXWinINIFilesave(ExtractFileDir(Application.ExeName)+'\MDXWin.ini');

  PageControl1.ActivePageIndex:=MainINI.SetupLastPage;

  with MainINI do begin
    SetMainPriorityLevel.ItemIndex:=MainPriorityLevel;
    SetMDXOnlineBufferSize.Text:=inttostr(MDXOnlineBufferSize);

    SetLoopMax.Text:=IntToStr(LoopMax);
    SetCurrentPath.Text:=CurrentFilePath;
    SetSplashScreen.Checked:=SplashScreen;
    SetDropActiveWindow.Checked:=DropActiveWindow;

    SetDSoundSafeTime.ItemIndex:=(DSoundSafeTime div 100)-1;
    SetCatalogPath.Text:=CatalogFilePath;
    SetWaveLocalPath.Text:=WaveLocalPath;
    WaveLocalEqualMDXFolderChk.Checked:=WaveLocalEqualMDXFolder;
    SetWaveNetworkPath.Text:=WaveNetworkPath;
    SetDefPath.Text:=DefPath;

    SetUseKDD.Checked:=UseKDD;
    SetKDDAntialias.Checked:=KDDAntialias;
    SetKDDTextFont.Text:=KDDTextFont;
    SetTitleFontName.Text:=TitleFontName;
    SetTitleUseESC.Checked:=TitleUseESC;
    SetTitleUseAnk2to1byte.Checked:=TitleUseAnk2to1byte;

    SetNetRemoteEnabled.Checked:=NetRemoteEnabled;
    SetNetRemotePort.Text:=inttostr(NetRemotePort);
    SetNetRemoteLoginPassword.Text:=NetRemoteLoginPassword;
    SetNetRemoteLocalOnly.Checked:=NetRemoteLocalOnly;
  end;

  with FMPMDINI do begin
    SetYM2608Path.Text:=PCMYM2608Path;
    with SetFMPPMDPathLst do begin
      Clear;
      for cnt:=0 to PCMFMPPMDPathCount-1 do
        if PCMFMPPMDPath[cnt]<>'' then Items.Add(PCMFMPPMDPath[cnt]);
    end;
    RefrectFMPPMDBtn;
    SetDLLProgressLoad.Checked:=DLLProgressLoad;
    SetFMCalc55k.Checked:=FMCalc55k;
    SetInterpolation.Checked:=Interpolation;
    SetLoadInitADPCM.Checked:=LoadInitADPCM;
    SetPPSUse.Checked:=PPSUse;
    SetRhythmWithSSGEffect.Checked:=RhythmWithSSGEffect;
    SetADPCMPPZ8Emulate.Checked:=ADPCMPPZ8Emulate;
    SetPMD86PCMMode.Checked:=PMD86PCMMode;
    SetVolFM.Position:=255-VolFM;
    SetVolSSG.Position:=255-VolSSG;
    SetVolRhythm.Position:=255-VolRhythm;
    SetVolADPCM.Position:=255-VolADPCM;
    SetVolPPZ.Position:=255-VolPPZ;
  end;

  with SPCINI do begin
    Set_SPC_EnabledWinAMPDSP.Checked:=EnabledWinAMPDSP;
    Set_SPC_MixMode.ItemIndex:=MixMode;
    Set_SPC_IntMode.ItemIndex:=IntMode;
    Set_SPC_DSPOpt_LowpassFilter.Checked:=DSPOpt_LowpassFilter;
    Set_SPC_DSPOpt_OldADPCMDecompress.Checked:=DSPOpt_OldADPCMDecompress;
    Set_SPC_DSPOpt_SurroundSound.Checked:=DSPOpt_SurroundSound;
    Set_SPC_DSPOpt_ReverseStereo.Checked:=DSPOpt_ReverseStereo;
    Set_SPC_DSPPitch.ItemIndex:=DSPPitch;
    Set_SPC_EnabledID666Length.Checked:=EnabledID666Length;
    Set_SPC_DefaultSongLenSec.Text:=IntToStr(DefaultSongLenSec);
    Set_SPC_DefaultFadeoutLenSec.Text:=IntToStr(DefaultFadeoutLenSec);
  end;

  SetVolChange(nil);
  RefrectFMPPMDBtn;
  RegRefresh;
end;

procedure TSetup.SetupCancel;
begin
  if MessageDlg('ύXۑɏIėǂłH',mtWarning,[mbYes,mbNo],0)=mrNo then exit;

  MDXWinINIFileload(ExtractFileDir(Application.ExeName)+'\MDXWin.ini');
  MainINI.SetupLastPage:=PageControl1.ActivePageIndex;
  ModalResult:=mrCancel;
end;

procedure TSetup.SetupSave;
var
  v,cnt:integer;
  RequestReset:boolean;
begin
  v:=StrToIntDef(SetLoopMax.Text,1);
  if (v<1) or (99<v) then begin
    MessageDlg('[v񐔂̐ݒ肪ُłBiPȏXXȉj',mtWarning,[mbOK],0);
    exit;
  end;

  v:=StrToIntDef(SetDSoundSafeTime.Text,500);
  v:=(v div 100)*100;
  if (v<100) or (1000<v) then begin
    MessageDlg('DirectX̔xԂ̐ݒ肪ُłBiPOOȏPOOOȉj',mtWarning,[mbOK],0);
    exit;
  end;

  if SetNetRemoteEnabled.Checked=True then begin
    v:=StrToIntDef(SetNetRemotePort.Text,-1);
    if v<=0 then begin
      MessageDlg('NetRemoteT[o|[g̐ݒ肪ُłB1ȏ̐͂ĉB',mtWarning,[mbOK],0);
      exit;
    end;

    if SetNetRemoteLoginPassword.Text='' then begin
      MessageDlg('NetRemoteOCpX[hݒ肳Ă܂B',mtWarning,[mbOK],0);
      exit;
    end;
  end;

  RequestReset:=False;

  with MainINI do begin
    if DSoundSafeTime<>StrToIntDef(SetDSoundSafeTime.Text,500) then RequestReset:=True;
  end;

  if RequestReset=True then begin
    MessageDlg('ȂĐOMDXWinċNĂB',mtWarning,[mbOK],0);
  end;

  with MainINI do begin
    MainPriorityLevel:=SetMainPriorityLevel.ItemIndex;
    MDXOnlineBufferSize:=strtointdef(SetMDXOnlineBufferSize.Text,8192);

    CurrentFilePath:=SetCurrentPath.Text;
    LoopMax:=StrToIntDef(SetLoopMax.Text,1);
    SplashScreen:=SetSplashScreen.Checked;
    DropActiveWindow:=SetDropActiveWindow.Checked;
    DSoundSafeTime:=StrToIntDef(SetDSoundSafeTime.Text,500);
    CatalogFilePath:=SetCatalogPath.Text;
    WaveLocalPath:=SetWaveLocalPath.Text;
    WaveLocalEqualMDXFolder:=WaveLocalEqualMDXFolderChk.Checked;
    WaveNetworkPath:=SetWaveNetworkPath.Text;
    DefPath:=SetDefPath.Text;

    UseKDD:=SetUseKDD.Checked;
    KDDAntialias:=SetKDDAntialias.Checked;
    KDDTextFont:=SetKDDTextFont.Text;
    TitleFontName:=SetTitleFontName.Text;
    TitleUseESC:=SetTitleUseESC.Checked;
    TitleUseAnk2to1byte:=SetTitleUseAnk2to1byte.Checked;

    NetRemoteEnabled:=SetNetRemoteEnabled.Checked;
    NetRemotePort:=StrToInt(SetNetRemotePort.Text);
    NetRemoteLoginPassword:=SetNetRemoteLoginPassword.Text;
    NetRemoteLocalOnly:=SetNetRemoteLocalOnly.Checked;
  end;

  with FMPMDINI do begin
    PCMYM2608Path:=SetYM2608Path.Text;
    with SetFMPPMDPathLst do begin
      for cnt:=0 to PCMFMPPMDPathCount-1 do
        PCMFMPPMDPath[cnt]:='';
      for cnt:=0 to Items.Count-1 do
        PCMFMPPMDPath[cnt]:=Items[cnt];
    end;
    DLLProgressLoad:=SetDLLProgressLoad.Checked;
    FMCalc55k:=SetFMCalc55k.Checked;
    Interpolation:=SetInterpolation.Checked;
    LoadInitADPCM:=SetLoadInitADPCM.Checked;
    PPSUse:=SetPPSUse.Checked;
    RhythmWithSSGEffect:=SetRhythmWithSSGEffect.Checked;
    ADPCMPPZ8Emulate:=SetADPCMPPZ8Emulate.Checked;
    PMD86PCMMode:=SetPMD86PCMMode.Checked;
    VolFM:=255-SetVolFM.Position;
    VolSSG:=255-SetVolSSG.Position;
    VolRhythm:=255-SetVolRhythm.Position;
    VolADPCM:=255-SetVolADPCM.Position;
    VolPPZ:=255-SetVolPPZ.Position;
  end;

  with SPCINI do begin
    EnabledWinAMPDSP:=Set_SPC_EnabledWinAMPDSP.Checked;
    MixMode:=Set_SPC_MixMode.ItemIndex;
    IntMode:=Set_SPC_IntMode.ItemIndex;
    DSPOpt_LowpassFilter:=Set_SPC_DSPOpt_LowpassFilter.Checked;
    DSPOpt_OldADPCMDecompress:=Set_SPC_DSPOpt_OldADPCMDecompress.Checked;
    DSPOpt_SurroundSound:=Set_SPC_DSPOpt_SurroundSound.Checked;
    DSPOpt_ReverseStereo:=Set_SPC_DSPOpt_ReverseStereo.Checked;
    DSPPitch:=Set_SPC_DSPPitch.ItemIndex;
    EnabledID666Length:=Set_SPC_EnabledID666Length.Checked;
    DefaultSongLenSec:=StrToIntDef(Set_SPC_DefaultSongLenSec.Text,90);
    DefaultFadeoutLenSec:=StrToIntDef(Set_SPC_DefaultFadeoutLenSec.Text,5);
  end;

  Main.Catalog.Init(MainINI.CatalogFilePath);
  Main.ChangeLoopMax(0);

  MainINI.SetupLastPage:=PageControl1.ActivePageIndex;

  ModalResult:=mrOk;
end;

procedure TSetup.SetCeleron_350Click(Sender: TObject);
begin
  with MainINI do begin
    DSoundSafeTime:=100;
    WADSPEnabled:=True;
    DSoundRate:=PCMRate_48kHz;
    UseKDD:=True;
    KDDAntialias:=True;
  end;
  with VisINI do begin
    UseEffect:=True;
    GradEnabled:=True;
    AnalyzeFrame:=30;
    AnalyzeFFT:=1;
  end;
  SetCreate;
  ShowMessage('vZbgݒKp܂BOtBbN֘A̐ݒʂQƂĉB'+chr(13)+'MDXWinċNォLɂȂ܂B');
  ModalResult:=0;
end;

procedure TSetup.SetP2_233Click(Sender: TObject);
begin
  with MainINI do begin
    DSoundSafeTime:=100;
    WADSPEnabled:=False;
    DSoundRate:=PCMRate_44kHz;
    UseKDD:=True;
    KDDAntialias:=False;
  end;
  with VisINI do begin
    UseEffect:=True;
    GradEnabled:=True;
    AnalyzeFrame:=20;
    AnalyzeFFT:=2;
  end;
  SetCreate;
  ShowMessage('vZbgݒKp܂BOtBbN֘A̐ݒʂQƂĉB'+chr(13)+'MDXWinċNォLɂȂ܂B');
  ModalResult:=0;
end;

procedure TSetup.SetPM_200Click(Sender: TObject);
begin
  with MainINI do begin
    DSoundSafeTime:=500;
    WADSPEnabled:=False;
    DSoundRate:=PCMRate_44kHz;
    UseKDD:=False;
    KDDAntialias:=False;
  end;
  with VisINI do begin
    UseEffect:=True;
    GradEnabled:=True;
    AnalyzeFrame:=20;
    AnalyzeFFT:=4;
  end;
  SetCreate;
  ShowMessage('vZbgݒKp܂BOtBbN֘A̐ݒʂQƂĉB'+chr(13)+'MDXWinċNォLɂȂ܂B');
  ModalResult:=0;
end;

procedure TSetup.SetP_166Click(Sender: TObject);
begin
  with MainINI do begin
    DSoundSafeTime:=500;
    WADSPEnabled:=False;
    DSoundRate:=PCMRate_44kHz;
    UseKDD:=False;
    KDDAntialias:=False;
  end;
  with VisINI do begin
    UseEffect:=False;
    GradEnabled:=False;
    AnalyzeFrame:=10;
    AnalyzeFFT:=8;
  end;
  SetCreate;
  ShowMessage('vZbgݒKp܂BOtBbN֘A̐ݒʂQƂĉB'+chr(13)+'MDXWinċNォLɂȂ܂B');
  ModalResult:=0;
end;

procedure TSetup.OKBtnClick(Sender: TObject);
begin
  SetupSave;
end;

procedure TSetup.CancelBtnClick(Sender: TObject);
begin
  SetupCancel;
end;

procedure TSetup.CurrentPathBtnClick(Sender: TObject);
begin
  Application.CreateForm(TFolderDlg, FolderDlg);
  FolderDlg.Caption:='ȃf[^t@CtH_';
  FolderDlg.OpenDlg(SetCurrentPath.Text);
  if FolderDlg.ShowModal=mrOk then SetCurrentPath.Text:=FolderDlg.DirectoryLst.Directory;
  ModalResult:=0;
end;

procedure TSetup.CatalogPathBtnClick(Sender: TObject);
begin
  Application.CreateForm(TFolderDlg, FolderDlg);
  FolderDlg.Caption:='Catalogt@CtH_';
  FolderDlg.OpenDlg(SetCatalogPath.Text);
  if FolderDlg.ShowModal=mrOk then SetCatalogPath.Text:=FolderDlg.DirectoryLst.Directory;
  ModalResult:=0;
end;

procedure TSetup.YM2608PathBtnClick(Sender: TObject);
begin
  Application.CreateForm(TFolderDlg, FolderDlg);
  FolderDlg.Caption:='YM2608YpPCMt@CtH_';
  FolderDlg.OpenDlg(SetYM2608Path.Text);
  if FolderDlg.ShowModal=mrOk then SetYM2608Path.Text:=FolderDlg.DirectoryLst.Directory;
  ModalResult:=0;
end;

procedure TSetup.WaveLocalPathBtnClick(Sender: TObject);
begin
  Application.CreateForm(TFolderDlg, FolderDlg);
  FolderDlg.Caption:='HDD/FDDĐƂWavet@CtH_';
  FolderDlg.OpenDlg(SetWaveLocalPath.Text);
  if FolderDlg.ShowModal=mrOk then SetWaveLocalPath.Text:=FolderDlg.DirectoryLst.Directory;
  ModalResult:=0;
end;

procedure TSetup.WaveNetworkPathBtnClick(Sender: TObject);
begin
  Application.CreateForm(TFolderDlg, FolderDlg);
  FolderDlg.Caption:='MDXOnlineĐƂWavet@CtH_';
  FolderDlg.OpenDlg(SetWaveNetworkPath.Text);
  if FolderDlg.ShowModal=mrOk then SetWaveNetworkPath.Text:=FolderDlg.DirectoryLst.Directory;
  ModalResult:=0;
end;

procedure TSetup.DefPathBtnClick(Sender: TObject);
begin
  Application.CreateForm(TFolderDlg, FolderDlg);
  FolderDlg.Caption:='ȃf[^tH_';
  FolderDlg.OpenDlg(SetDefPath.Text);
  if FolderDlg.ShowModal=mrOk then SetDefPath.Text:=FolderDlg.DirectoryLst.Directory;
  ModalResult:=0;
end;

procedure TSetup.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  MDXWinINIFilesave(ExtractFileDir(Application.ExeName)+'\MDXWin.ini');

  Main.FileGrid.Canvas.Font:=Main.FileGrid.Font;
  MainFileCtl.FileGridRefresh;
  Main.Visible:=True;
  Setup.Release;
end;

procedure TSetup.FontChangeBtnClick(Sender: TObject);
begin
  with FontDlg do begin
    Font.Name:=ListFontINI.Name;
    Font.Size:=ListFontINI.Size;
    MaxFontSize:=0;
    MinFontSize:=0;
    if Execute=True then begin
      ListFontINI.Name:=Font.Name;
      ListFontINI.Size:=Font.Size;
    end;
  end;
end;

procedure TSetup.NumCheckKeyPress(Sender: TObject; var Key: Char);
begin
  if (Key='-') then exit;
  if ('!'<=Key) and (Key<='/') then Key:=char(0);
  if (':'<=Key) and (Key<='~') then Key:=char(0);
end;

procedure TSetup.FMPPathAddBtnClick(Sender: TObject);
var
  cnt:integer;
begin
  if SetFMPPMDPathLst.Items.Count=PCMFMPPMDPathCount then begin
    MessageDlg('PCMtH_X^bNtłB'+chr(13)+'ǂꂩ폜Ăēo^ĂB',mtWarning,[mbOK],0);
    ModalResult:=0;
    exit;
  end;

  Application.CreateForm(TFolderDlg, FolderDlg);
  FolderDlg.Caption:='FMPyPMDpPCMt@CtH_';
  if SetFMPPMDPathLst.ItemIndex<>-1 then
    FolderDlg.OpenDlg(SetFMPPMDPathLst.Items[SetFMPPMDPathLst.ItemIndex])
    else
    FolderDlg.OpenDlg(copy(StartPath,1,length(StartPath)-1));
  if FolderDlg.ShowModal=mrOk then begin
    if SetFMPPMDPathLst.Items.Count<>0 then begin // d`FbN
      with SetFMPPMDPathLst do begin
        for cnt:=0 to Items.Count-1 do begin
          if lowercase(Items[cnt])=lowercase(FolderDlg.DirectoryLst.Directory) then begin
            MessageDlg('tH_ɓo^Ă܂B'+chr(13)+'o^ǉ̓LZ܂B',mtWarning,[mbOK],0);
            ModalResult:=0;
            ItemIndex:=cnt;
            RefrectFMPPMDBtn;
            exit;
          end;
        end;
      end;
    end;
    SetFMPPMDPathLst.Items.Add(FolderDlg.DirectoryLst.Directory);
    SetFMPPMDPathLst.ItemIndex:=SetFMPPMDPathLst.Items.Count-1;
  end;
  RefrectFMPPMDBtn;
  ModalResult:=0;
end;

procedure TSetup.RefrectFMPPMDBtn;
var
  Enabled:boolean;
begin
  if SetFMPPMDPathLst.ItemIndex<>-1 then
    Enabled:=True
    else
    Enabled:=False;
  FMPPathDelBtn.Enabled:=Enabled;

  if (SetFMPPMDPathLst.Items.Count>=2) and (SetFMPPMDPathLst.ItemIndex<>-1) then begin
    if SetFMPPMDPathLst.ItemIndex<>0 then
      Enabled:=True
      else
      Enabled:=False;
    FMPPathUpBtn.Enabled:=Enabled;
    if SetFMPPMDPathLst.ItemIndex<>(SetFMPPMDPathLst.Items.Count-1) then
      Enabled:=True
      else
      Enabled:=False;
    FMPPathDownBtn.Enabled:=Enabled;
    end else begin
    FMPPathUpBtn.Enabled:=False;
    FMPPathDownBtn.Enabled:=False;
  end;
end;

procedure TSetup.SetFMPPMDPathLstClick(Sender: TObject);
begin
  RefrectFMPPMDBtn;
end;

procedure TSetup.FMPPathDelBtnClick(Sender: TObject);
begin
  with SetFMPPMDPathLst do begin
    if MessageDlg('FMPyPMDpPCMt@CtH_...'+chr(13)+Items[ItemIndex]+chr(13)+'폜Ă낵łH',mtWarning,[mbOK,mbCancel],0)=mrOK then begin
      SetFMPPMDPathLst.Items.Delete(ItemIndex);
    end;
  end;
  ModalResult:=0;
end;

procedure TSetup.FMPPathUpBtnClick(Sender: TObject);
var
  tmp:string;
begin
  with SetFMPPMDPathLst do begin
    tmp:=Items[ItemIndex];
    Items[ItemIndex]:=Items[ItemIndex-1];
    Items[ItemIndex-1]:=tmp;
    ItemIndex:=ItemIndex-1;
    RefrectFMPPMDBtn;
  end;
end;

procedure TSetup.FMPPathDownBtnClick(Sender: TObject);
var
  tmp:string;
begin
  with SetFMPPMDPathLst do begin
    tmp:=Items[ItemIndex];
    Items[ItemIndex]:=Items[ItemIndex+1];
    Items[ItemIndex+1]:=tmp;
    ItemIndex:=ItemIndex+1;
    RefrectFMPPMDBtn;
  end;
end;

function TSetup.isRegisted(ext:string):boolean;
var
  reg:TRegistry;
begin
  Reg:=TRegistry.Create;
  Reg.RootKey:=HKEY_CLASSES_ROOT;
  Result:=False;
  if Reg.OpenKey('\'+ext, False)=True then begin
    if Reg.ReadString('')='MDXWin' then Result:=True;
    Reg.CloseKey;
  end;
  Reg.Free;
end;

procedure TSetup.RegRefresh;
var
  cnt:integer;
  ext:string;
begin
  RegSetBtn.Enabled:=False;
  for cnt:=0 to RegLst.Items.Count-1 do begin
    ext:=Trim(Copy(RegLst.Items[cnt],1,4));
    RegLst.Checked[cnt]:=isRegisted(ext);
  end;
end;

procedure TSetup.RegLstClick(Sender: TObject);
begin
  RegSetBtn.Enabled:=True;
end;

procedure TSetup.RegSetBtnClick(Sender: TObject);
var
  reg:TRegistry;
  cnt:integer;
  ext:string;
  FilePath:string;
begin
  Reg:=TRegistry.Create;
  Reg.RootKey:=HKEY_CLASSES_ROOT;

  for cnt:=0 to RegLst.Items.Count-1 do begin
    ext:=Trim(Copy(RegLst.Items[cnt],1,4));
    if RegLst.Checked[cnt]=False then begin // ֘At̍폜
      if isRegisted(ext)=True then begin // MDXWinɊ֘AtĂƂ̂ݍ폜
        if Reg.OpenKey('\', False)=True then begin
          Reg.DeleteKey(ext);
          Reg.CloseKey;
        end;
      end;
      end else begin // VK֘AtMDXWinɍXV
      if Reg.OpenKey('\'+ext, True)=True then begin
        Reg.WriteString('','MDXWin');
        Reg.CloseKey;
      end;
    end;
  end;

  // MDXWin֘AXgN`쐬
  FilePath:=ExtractFilePath(Application.ExeName);
  if Reg.OpenKey('\MDXWin\DefaultIcon', True)=True then begin // ACR
    Reg.WriteString('',FilePath+'\MDXWin.exe,0');
    Reg.CloseKey;
  end;
  if Reg.OpenKey('\MDXWin\shell\open\command', True)=True then begin // Nt@C
    if RegFastChk.Checked=True then // N
      Reg.WriteString('','"'+FilePath+'MDXWin_FastLoader.exe" "%1"')
      else // ܂ƂȋN@i΁j
      Reg.WriteString('','"'+FilePath+'MDXWin.exe" "%1"');
    Reg.CloseKey;
  end;
  Reg.Free;
  RegRefresh;
  ShowMessage('֘AtI܂B');
  ModalResult:=0;
end;

procedure TSetup.AllRegSetBtnClick(Sender: TObject);
var
  cnt:integer;
begin
  if MessageDlg('SĂ̑Ή`Ɋ֘AÂĂ낵łH',mtWarning,[mbOK,mbCancel],0)=mrOK then begin
    for cnt:=0 to RegLst.Items.Count-1 do begin
      RegLst.Checked[cnt]:=True;
    end;
    RegSetBtnClick(Sender);
  end;
  ModalResult:=0;
end;

procedure TSetup.SetVolChange(Sender: TObject);
begin
  VisVolFM.Caption:=IntToStr(SetVolFM.Position-255);
  VisVolSSG.Caption:=IntToStr(SetVolSSG.Position-255);
  VisVolRhythm.Caption:=IntToStr(SetVolRhythm.Position-255);
  VisVolADPCM.Caption:=IntToStr(SetVolADPCM.Position-255);
  VisVolPPZ.Caption:=IntToStr(SetVolPPZ.Position-255);
end;

procedure TSetup.SetKDDTextFontKeyPress(Sender: TObject; var Key: Char);
begin
  SetKDDTextFontBtnClick(Sender);
end;

procedure TSetup.SetKDDTextFontBtnClick(Sender: TObject);
begin
  with FontDlg do begin
    Font.Name:=SetKDDTextFont.Text;
    Font.Size:=16;
    MaxFontSize:=Font.Size;
    MinFontSize:=Font.Size;
    if Execute=True then begin
      SetKDDTextFont.Text:=Font.Name;
    end;
  end;
end;

procedure TSetup.SetTitleFontNameKeyPress(Sender: TObject; var Key: Char);
begin
  SetTitleFontNameBtnClick(Sender);
end;

procedure TSetup.SetTitleFontNameBtnClick(Sender: TObject);
begin
  with FontDlg do begin
    Font.Name:=SetTitleFontName.Text;
    Font.Size:=16;
    MaxFontSize:=Font.Size;
    MinFontSize:=Font.Size;
    if Execute=True then begin
      SetTitleFontName.Text:=Font.Name;
    end;
  end;
end;

procedure TSetup.HelpBtnClick(Sender: TObject);
begin
  if FileExists(StartPath+'MDXWin.html')=False then begin
    ShowMessage('ICHTMLwvt@C܂łB');
    end else begin
    ShellExecute(0,'',PChar(StartPath+'MDXWin.html'),nil, nil,SW_SHOW);
  end;
end;

end.
