unit SplashWin;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls;

type
  TSplash = class(TForm)
  private
    { Private 錾 }
    SplashBM:TBitmap;
    SplashCount:integer;
    procedure WMMove(var Msg:TWMMove); message WM_MOVE;
    procedure EraseBackGround(var Msg:TWMEraseBkgnd); message WM_ERASEBKGND;
  public
    { Public 錾 }
    procedure Init(px,py:integer);
    procedure TextOut(txt:string);
    procedure FreeMemory;
  end;

var
  Splash: TSplash;

implementation

uses _PicTools,_Images;

{$R *.dfm}

procedure TSplash.EraseBackGround(var Msg:TWMEraseBkgnd);
begin
  if SplashBM<>nil then begin
    BitBlt(Splash.Canvas.Handle,0,0,SplashBM.Width,SplashBM.Height,SplashBM.Canvas.Handle,0,0,SRCCOPY);
    end else begin
//    DefWindowProc(Handle, WM_ICONERASEBKGND, Msg.DC, 0);
  end;

  Msg.Result := 1;
end;

procedure TSplash.WMMove(var Msg:TWMMove);
begin
  inherited;
  Invalidate;
end;

procedure TSplash.Init(px,py:integer);
begin
  Splash.SplashBM:=nil;

  Splash.Left:=px;
  Splash.Top:=py;
  Splash.Show;

  SplashCount:=0;
  SplashBM:=TBitmap.Create;
  MakeBlankBM(SplashBM,320,240,pf1bit);
  with SplashBM.Canvas do begin
    Pen.Color:=$ffffff;
    Brush.Color:=$ffffff;
    FrameRect(rect(0,0,320,240));
  end;
end;

procedure TSplash.TextOut(txt:string);
begin
  if txt<>'' then Images.WriteX68kString(SplashBM.Canvas,2,16*SplashCount+6,txt,False);
  inc(SplashCount);
  BitBlt(Splash.Canvas.Handle,0,0,SplashBM.Width,SplashBM.Height,SplashBM.Canvas.Handle,0,0,SRCCOPY);
end;

procedure TSplash.FreeMemory;
begin
  SplashBM.Free;
  SplashBM:=nil;
  Splash.Release;
end;

initialization

end.


