unit ID3EditDlg;

{$WARN UNIT_PLATFORM OFF}
{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  Windows, SysUtils, Forms, Dialogs, Classes, Controls, StdCtrls, Buttons, ComCtrls,
  _ID3_const;

type
  TID3Edit = class(TForm)
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label17: TLabel;
    TitleLenLbl: TLabel;
    ArtistLenLbl: TLabel;
    AlbumLenLbl: TLabel;
    CommentLenLbl: TLabel;
    ID3TitleEdt: TEdit;
    ID3ArtistEdt: TEdit;
    ID3AlbumEdt: TEdit;
    ID3CommentEdt: TEdit;
    ID3GenreLst: TComboBox;
    ID3YearLst: TComboBox;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure ID3EdtChange(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
    procedure SetCreate;
    procedure SetID3(ID3:TID3);
    procedure GetID3(var ID3:TID3);
  end;

var
  ID3Edit: TID3Edit;

implementation

{$R *.dfm}

procedure TID3Edit.FormCreate(Sender: TObject);
var
  year:integer;
begin
  ID3YearLst.Clear;
  for year:=1980 to 2010 do begin
    ID3YearLst.Items.Add(IntToStr(year));
  end;
end;

procedure TID3Edit.SetCreate;
begin
  ID3TitleEdt.Text:='';
  ID3ArtistEdt.Text:='';
  ID3AlbumEdt.Text:='';
  ID3CommentEdt.Text:='';
  ID3GenreLst.ItemIndex:=0;
  ID3YearLst.ItemIndex:=0;
end;

procedure TID3Edit.SetID3(ID3:TID3);
begin
  ID3TitleEdt.Text:=copy(ID3.Title,1,30);
  ID3ArtistEdt.Text:=copy(ID3.Artist,1,30);
  ID3AlbumEdt.Text:=copy(ID3.Album,1,30);
  ID3CommentEdt.Text:=copy(ID3.Comment,1,30);
  ID3GenreLst.ItemIndex:=ID3.Genre;
  ID3YearLst.Text:=copy(ID3.Year,1,4);

  ID3EdtChange(nil);
end;

procedure TID3Edit.GetID3(var ID3:TID3);
begin
  ID3.Title:=copy(ID3TitleEdt.Text,1,30);
  ID3.Artist:=copy(ID3ArtistEdt.Text,1,30);
  ID3.Album:=copy(ID3AlbumEdt.Text,1,30);
  ID3.Comment:=copy(ID3CommentEdt.Text,1,30);
  ID3.Genre:=ID3GenreLst.ItemIndex;
  ID3.Year:=copy(ID3YearLst.Text,1,4);
end;

procedure TID3Edit.ID3EdtChange(Sender: TObject);
begin
  TitleLenLbl.Caption:=IntToStr(Length(ID3TitleEdt.Text))+'/30';
  ArtistLenLbl.Caption:=IntToStr(Length(ID3ArtistEdt.Text))+'/30';
  AlbumLenLbl.Caption:=IntToStr(Length(ID3AlbumEdt.Text))+'/30';
  CommentLenLbl.Caption:=IntToStr(Length(ID3CommentEdt.Text))+'/30';
end;

end.
