unit SetMPPDlg;

{$WARN UNIT_PLATFORM OFF}
{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  Windows, SysUtils, Forms, Dialogs, Classes, Controls, StdCtrls, Buttons, ComCtrls,
  ExtCtrls, _wavesout_const;

type
  TSetMPP = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Label5: TLabel;
    TotalVolumeEdt: TEdit;
    Label7: TLabel;
    LoopMaxEdt: TEdit;
    EnableDSPChk: TCheckBox;
    InitBtn: TButton;
    UseFadeoutChk: TCheckBox;
    Label11: TLabel;
    PCMRateLst: TComboBox;
    FormatPage: TPageControl;
    FormatWaveTab: TTabSheet;
    FormatMP3Tab: TTabSheet;
    FormatOggTab: TTabSheet;
    Label4: TLabel;
    Label6: TLabel;
    Label8: TLabel;
    GogoDLLVerLbl: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    MP3OptCPUExtendChk: TCheckBox;
    MP3OptProcessorsLst: TComboBox;
    MP3OptEncordTypeLst: TComboBox;
    MP3OptLPFChk: TCheckBox;
    MP3OptPsyAnalizeChk: TCheckBox;
    MP3OptBitRateLst: TComboBox;
    MP3OptThreadLevelLst: TComboBox;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    MP3OptVBREnabledChk: TCheckBox;
    MP3OptVBRBitrateEnabledChk: TCheckBox;
    MP3OptVBRQualityLst: TComboBox;
    MP3OptVBRBitrateLowLst: TComboBox;
    MP3OptVBRBitrateHighLst: TComboBox;
    FormatWaveRadio: TRadioButton;
    FormatMP3Radio: TRadioButton;
    FormatOggRadio: TRadioButton;
    Label12: TLabel;
    Label13: TLabel;
    OggManageModeQualityRadio: TRadioButton;
    OggManageModeABRRadio: TRadioButton;
    OggManageModeCBRRadio: TRadioButton;
    OggQualityBar: TTrackBar;
    OggQualityLbl: TLabel;
    OggABRMinLst: TComboBox;
    Label16: TLabel;
    OggABRNormLst: TComboBox;
    Label15: TLabel;
    OggABRMaxLst: TComboBox;
    Label17: TLabel;
    OggCBRNormLst: TComboBox;
    Label18: TLabel;
    OggDownmixChk: TCheckBox;
    OggIgnoreID3Chk: TCheckBox;
    Shape1: TShape;
    OggAddOptionEdt: TEdit;
    Label19: TLabel;
    OggCommandLinePreviewEdt: TStaticText;
    Label20: TLabel;
    Label21: TLabel;
    Label14: TLabel;
    Label22: TLabel;
    StartBlankTimeEdt: TEdit;
    EndBlankTimeEdt: TEdit;
    Label23: TLabel;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    RadioButton3: TRadioButton;
    Edit1: TEdit;
    Label24: TLabel;
    procedure OKBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure MP3OptVBREnabledChkClick(Sender: TObject);
    procedure InitBtnClick(Sender: TObject);
    procedure FormatWaveRadioClick(Sender: TObject);
    procedure FormatMP3RadioClick(Sender: TObject);
    procedure FormatOggRadioClick(Sender: TObject);
    procedure OggQualityBarChange(Sender: TObject);
    procedure OggManageModeRadioClick(Sender: TObject);
    procedure OggLstSelect(Sender: TObject);
    procedure OggChkClick(Sender: TObject);
    procedure OggAddOptionEdtChange(Sender: TObject);
  private
    { Private 錾 }
    procedure LoadMPPSetting(var MPPSetting:TMPPSetting);
    procedure SaveMPPSetting(var MPPSetting:TMPPSetting);
    procedure OggManageRefresh;
    procedure OggCommandLinePreviewRefresh;
  public
    { Public 錾 }
    GogoTeaEnabled:boolean;
    MPPSetting:TMPPSetting;
    procedure SetCreate(_GogoTeaEnabled:boolean;GogoTeaVer:string;_MPPSetting:TMPPSetting);
  end;

var
  SetMPP: TSetMPP;

implementation

uses _ID3_const,_const;

{$R *.dfm}

procedure TSetMPP.SetCreate(_GogoTeaEnabled:boolean;GogoTeaVer:string;_MPPSetting:TMPPSetting);
var
  cnt:integer;
begin
  GogoTeaEnabled:=_GogoTeaEnabled;

  GogoDLLVerLbl.Caption:=GogoTeaVer;

  MP3OptBitRateLst.Clear;
  for cnt:=0 to MP3BitRateCount-1 do begin
    MP3OptBitRateLst.Items.Add(GetMP3BitRateStr(cnt));
  end;

  MP3OptVBRBitrateLowLst.Clear;
  MP3OptVBRBitrateHighLst.Clear;
  for cnt:=0 to MP3BitRateCount-1 do begin
    MP3OptVBRBitrateLowLst.Items.Add(GetMP3VBRBitRateStr(cnt));
    MP3OptVBRBitrateHighLst.Items.Add(GetMP3VBRBitRateStr(cnt));
  end;

  OggABRMinLst.Clear;
  OggABRNormLst.Clear;
  OggABRMaxLst.Clear;
  OggCBRNormLst.Clear;
  for cnt:=45 to 500 do begin
    OggABRMinLst.Items.Add(inttostr(cnt));
    OggABRNormLst.Items.Add(inttostr(cnt));
    OggABRMaxLst.Items.Add(inttostr(cnt));
    OggCBRNormLst.Items.Add(inttostr(cnt));
  end;

  MPPSetting:=_MPPSetting;
  LoadMPPSetting(MPPSetting);
end;

procedure TSetMPP.LoadMPPSetting(var MPPSetting:TMPPSetting);
  procedure SetList(var lst:TComboBox;i:integer);
  var
    s:string;
    cnt:integer;
  begin
    if lst.Items.Count=0 then exit;
    s:=inttostr(i);
    for cnt:=0 to lst.Items.Count-1 do begin
      if lst.Items[cnt]=s then begin
        lst.ItemIndex:=cnt;
        exit;
      end;
    end;
    lst.ItemIndex:=0;
  end;
begin
  with MPPSetting do begin
    TotalVolumeEdt.Text:=IntToStr(TotalVolume);
    LoopMaxEdt.Text:=IntToStr(LoopMax);
    UseFadeoutChk.Checked:=UseFadeout;
    EnableDSPChk.Checked:=EnableDSP;
    StartBlankTimeEdt.Text:=IntToStr(StartBlankTime);
    EndBlankTimeEdt.Text:=IntToStr(EndBlankTime);

    case PCMRate of
      PCMRate_22kHz: PCMRateLst.ItemIndex:=0;
      PCMRate_44kHz: PCMRateLst.ItemIndex:=1;
      PCMRate_48kHz: PCMRateLst.ItemIndex:=2;
      PCMRate_96kHz: PCMRateLst.ItemIndex:=3;
      else           PCMRateLst.ItemIndex:=1;
    end;

    case FileFormat of
      FileFormat_Wave: FormatWaveRadio.Checked:=True;
      FileFormat_MP3:  FormatMP3Radio.Checked:=True;
      FileFormat_Ogg:  FormatOggRadio.Checked:=True;
      else             FormatWaveRadio.Checked:=True;
    end;

    MP3OptBitRateLst.ItemIndex:=MP3BitRate;
    MP3OptCPUExtendChk.Checked:=MP3CPUExtendEnabled;
    MP3OptProcessorsLst.ItemIndex:=MP3Processors;
    MP3OptEncordTypeLst.ItemIndex:=MP3EncordType;
    MP3OptThreadLevelLst.ItemIndex:=MP3ThreadLevel;
    MP3OptLPFChk.Checked:=MP3LPFEnabled;
    MP3OptPsyAnalizeChk.Checked:=MP3PsyAnalizeEnabled;

    MP3OptVBREnabledChk.Checked:=MP3VBREnabled;
    MP3OptVBRQualityLst.ItemIndex:=MP3VBRQuality;
    MP3OptVBRBitrateEnabledChk.Checked:=MP3VBRBitrateEnabled;
    MP3OptVBRBitrateLowLst.ItemIndex:=MP3VBRBitrateLow;
    MP3OptVBRBitrateHighLst.ItemIndex:=MP3VBRBitrateHigh;

    case OggManageMode of
      OggManage_Quality: OggManageModeQualityRadio.Checked:=True;
      OggManage_ABR:     OggManageModeABRRadio.Checked:=True;
      OggManage_CBR:     OggManageModeCBRRadio.Checked:=True;
      else               OggManageModeQualityRadio.Checked:=True;
    end;

    OggQualityBar.Position:=OggQuality;
    SetList(OggABRMinLst,OggABRMin);
    SetList(OggABRNormLst,OggABRNorm);
    SetList(OggABRMaxLst,OggABRMax);
    SetList(OggCBRNormLst,OggCBRNorm);
    OggDownmixChk.Checked:=OggDownmix;
    OggIgnoreID3Chk.Checked:=OggIgnoreID3;
    OggAddOptionEdt.Text:=OggAddOption;
  end;

  MP3OptVBREnabledChkClick(nil);

  OggManageRefresh;
  OggCommandLinePreviewRefresh;
end;

procedure TSetMPP.SaveMPPSetting(var MPPSetting:TMPPSetting);
begin
  with MPPSetting do begin
    TotalVolume:=StrToIntDef(TotalVolumeEdt.Text,1024);
    if ((TotalVolume<0) or (16384<TotalVolume)) then TotalVolume:=1024;
    LoopMax:=StrToIntDef(LoopMaxEdt.Text,2);
    if ((LoopMax<=0) or (100<=LoopMax)) then LoopMax:=2;
    UseFadeout:=UseFadeoutChk.Checked;
    EnableDSP:=EnableDSPChk.Checked;
    StartBlankTime:=StrToIntDef(StartBlankTimeEdt.Text,0);
    EndBlankTime:=StrToIntDef(EndBlankTimeEdt.Text,0);

    case PCMRateLst.ItemIndex of
      0:   PCMRate:=PCMRate_22kHz;
      1:   PCMRate:=PCMRate_44kHz;
      2:   PCMRate:=PCMRate_48kHz;
      3:   PCMRate:=PCMRate_96kHz;
      else PCMRate:=PCMRate_44kHz;
    end;

    FileFormat:=FileFormat_Wave;
    if FormatWaveRadio.Checked=True then FileFormat:=FileFormat_Wave;
    if FormatMP3Radio.Checked=True then FileFormat:=FileFormat_MP3;
    if FormatOggRadio.Checked=True then FileFormat:=FileFormat_Ogg;

    MP3BitRate:=MP3OptBitRateLst.ItemIndex;
    MP3CPUExtendEnabled:=MP3OptCPUExtendChk.Checked;
    MP3Processors:=MP3OptProcessorsLst.ItemIndex;
    MP3EncordType:=MP3OptEncordTypeLst.ItemIndex;
    MP3ThreadLevel:=MP3OptThreadLevelLst.ItemIndex;
    MP3LPFEnabled:=MP3OptLPFChk.Checked;
    MP3PsyAnalizeEnabled:=MP3OptPsyAnalizeChk.Checked;

    MP3VBREnabled:=MP3OptVBREnabledChk.Checked;
    MP3VBRQuality:=MP3OptVBRQualityLst.ItemIndex;
    MP3VBRBitrateEnabled:=MP3OptVBRBitrateEnabledChk.Checked;
    MP3VBRBitrateLow:=MP3OptVBRBitrateLowLst.ItemIndex;
    MP3VBRBitrateHigh:=MP3OptVBRBitrateHighLst.ItemIndex;

    OggManageMode:=OggManage_Quality;
    if OggManageModeQualityRadio.Checked=True then OggManageMode:=OggManage_Quality;
    if OggManageModeABRRadio.Checked=True then OggManageMode:=OggManage_ABR;
    if OggManageModeCBRRadio.Checked=True then OggManageMode:=OggManage_CBR;

    OggQuality:=OggQualityBar.Position;
    OggABRMin:=strtointdef(OggABRMinLst.Text,128);
    OggABRNorm:=strtointdef(OggABRNormLst.Text,128);
    OggABRMax:=strtointdef(OggABRMaxLst.Text,128);
    OggCBRNorm:=strtointdef(OggCBRNormLst.Text,128);
    OggDownmix:=OggDownmixChk.Checked;
    OggIgnoreID3:=OggIgnoreID3Chk.Checked;
    OggAddOption:=OggAddOptionEdt.Text;
  end;
end;

procedure TSetMPP.OKBtnClick(Sender: TObject);
begin
  if (FormatMP3Radio.Checked=True) and (PCMRateLst.ItemIndex=3) then begin
    ShowMessage('96kHzMP3ῗł܂B');
    exit;
  end;
  SaveMPPSetting(MPPSetting);
  ModalResult:=mrOk;
end;

procedure TSetMPP.CancelBtnClick(Sender: TObject);
begin
  ModalResult:=mrCancel;
end;

procedure TSetMPP.MP3OptVBREnabledChkClick(Sender: TObject);
var
  e:boolean;
begin
  e:=MP3OptVBREnabledChk.Checked;
  MP3OptVBRBitrateEnabledChk.Enabled:=e;
  MP3OptVBRQualityLst.Enabled:=e;
  MP3OptVBRBitrateLowLst.Enabled:=e;
  MP3OptVBRBitrateHighLst.Enabled:=e;
end;

procedure TSetMPP.InitBtnClick(Sender: TObject);
begin
  if MessageDlg('ݒĂ낵łH',mtWarning,[mbOk,mbCancel],0)=mrOk then begin
    ClearMPPSetting(MPPSetting);
    LoadMPPSetting(MPPSetting);
  end;
end;

procedure TSetMPP.FormatWaveRadioClick(Sender: TObject);
begin
  FormatPage.ActivePage:=FormatWaveTab;
end;

procedure TSetMPP.FormatMP3RadioClick(Sender: TObject);
begin
  if GogoTeaEnabled=False then begin
    MessageDlg(GogoTeaDLLVerErrorMsg,mtWarning,[mbOk],0);
    FormatWaveRadioClick(Sender);
    end else begin
    FormatPage.ActivePage:=FormatMP3Tab;
  end;
end;

procedure TSetMPP.FormatOggRadioClick(Sender: TObject);
begin
  FormatPage.ActivePage:=FormatOggTab;
end;

procedure TSetMPP.OggQualityBarChange(Sender: TObject);
begin
  OggQualityLbl.Caption:=format('%1.2f',[OggQualityBar.Position/100]);
  OggCommandLinePreviewRefresh;
end;

procedure TSetMPP.OggManageRefresh;
begin
  OggQualityBar.Enabled:=False;
  OggABRMinLst.Enabled:=False;
  OggABRNormLst.Enabled:=False;
  OggABRMaxLst.Enabled:=False;
  OggCBRNormLst.Enabled:=False;
  if OggManageModeQualityRadio.Checked=True then begin
    OggQualityBar.Enabled:=True;
  end;
  if OggManageModeABRRadio.Checked=True then begin
    OggABRMinLst.Enabled:=True;
    OggABRNormLst.Enabled:=True;
    OggABRMaxLst.Enabled:=True;
  end;
  if OggManageModeCBRRadio.Checked=True then begin
    OggCBRNormLst.Enabled:=True;
  end;
end;

procedure TSetMPP.OggManageModeRadioClick(Sender: TObject);
begin
  OggManageRefresh;
  OggCommandLinePreviewRefresh;
end;

procedure TSetMPP.OggLstSelect(Sender: TObject);
begin
  OggCommandLinePreviewRefresh;
end;

procedure TSetMPP.OggChkClick(Sender: TObject);
begin
  OggCommandLinePreviewRefresh;
end;

procedure TSetMPP.OggAddOptionEdtChange(Sender: TObject);
begin
  OggCommandLinePreviewRefresh;
end;

procedure TSetMPP.OggCommandLinePreviewRefresh;
var
  ID3:TID3;
  tmpMPP:TMPPSetting;
begin
  ClearID3(ID3);
  ID3.Title:='ID3TitleEtc';
  SaveMPPSetting(tmpMPP);
  OggCommandLinePreviewEdt.Caption:='oggenc.exe '+GetOggCommandLine(tmpMPP,'PureTitle',ID3,False,'filename.wav');
end;

end.
