//
// Componentware for Delphi - TrayIcon Component Release 1.16
//   Copyright(C) 1996-1998 Yukio Tsujihara
//
// Module      : gCACRR|[lg
// Last Update : 10/27/98
// Author      : Yukio Tsujihara
//
// Revision    : Taro Kato
// Last Update : 01/25/2001

unit TrayIcon;

interface

uses
  Messages, ShellApi, Windows,
  Classes, Controls, Graphics, ExtCtrls, Forms, Menus, SysUtils ;

const
  NotifyIconErrMessage = '^XNgCɃACRo^ł܂B';
  WM_NotifyIconMessage = WM_User + 200;

type
  // ENotifyIconErrorO̒`
  ENotifyIconError = class(Exception);

  // TTrayIconMode񋓌^̒`
  TTrayIconMode = (tiAddIcon, tiModifyIcon, tiDeleteIcon);

  // TAnimateMode񋓌^̒`
  TAnimateMode = (amAutomatic, amManual);

  // TrayIconAj[VXbhNX̋^`
  TTrayIconAnimate = class;

  TTrayIcon = class(TComponent)
  private
    FAnimated: Boolean;
    FAnimateIcons: TImageList;
    FAnimateMode: TAnimateMode;
    FAnimateRate: Integer;
    FAutoPopup: Boolean;
    FEnabled: Boolean;
    FIcon: TIcon;
    FLBPopupMenu: TPopupMenu;
    FRBPopupMenu: TPopupMenu;
    FTipHelp: String;
    FVisible: Boolean;
    FOnClick: TNotifyEvent;
    FOnDblClick: TNotifyEvent;
    FOnMouseMove: TMouseMoveEvent;
    FOnMouseDown, FOnMouseUp: TMouseEvent;

    AnimateThread: TTrayIconAnimate;
    IconID: UINT;
    IconRegisted: Boolean;
    NIconData: PNotifyIconDataA;
    SingleClickExec: Boolean;

    FReadStateNext: Boolean;
    function GetIconHandle: THandle;
  protected
    procedure IconChange(Sender: TObject);

    procedure SetAnimateIcons(Value: TImageList);
    procedure SetAnimateRate(Value: Integer);
    procedure SetEnabled(Value: Boolean);
    procedure SetIcon(Value: TIcon);
    procedure SetLBPopupMenu(Value: TPopupMenu);
    procedure SetRBPopupMenu(Value: TPopupMenu);
    procedure SetTipHelp(Value: String);
    procedure SetTrayIcon(Value: TTrayIconMode);
    procedure SetVisible(Value: Boolean);
    procedure ReadState(Reader: TReader); override;
    procedure Notification(AComponent: TComponent; Operation: TOperation);
      override;
  public
    constructor Create(AOwner: TComponent); override;
    procedure Loaded; override;
    destructor Destroy; override;
    procedure AnimeteModeChange;
    procedure AnimatePlay(AAnimateMode: TAnimateMode);
    procedure AnimateStep;
    procedure AnimateStop;

    property Animated: Boolean read FAnimated;
    property AnimateMode: TAnimateMode read FAnimateMode;
  published
    property AnimateIcons: TImageList read FAnimateIcons write SetAnimateIcons;
    property AnimateRate: Integer read FAnimateRate write SetAnimateRate
      default 500;
    property AutoPopup: Boolean read FAutoPopup write FAutoPopup default True;
    property Enabled: Boolean read FEnabled write SetEnabled default True;
    property Icon: TIcon read FIcon write SetIcon;
    property LBPopupMenu: TPopupMenu read FLBPopupMenu write SetLBPopupmenu;
    property RBPopupMenu: TPopupMenu read FRBPopupMenu write SetRBPopupmenu;
    property TipHelp: String read FTipHelp write SetTipHelp;
    property Visible: Boolean read FVisible write SetVisible default False;

    property OnClick: TNotifyEvent read FOnClick write FOnClick;
    property OnDblClick: TNotifyEvent read FOnDblClick write FOnDblClick;
    property OnMouseDown: TMouseEvent read FOnMouseDown write FOnMouseDown;
    property OnMouseMove: TMouseMoveEvent read FOnMouseMove write FOnMouseMove;
    property OnMouseUp: TMouseEvent read FOnMouseUp write FOnMouseUp;
  end;

  // VONbNXbhNX̒`
  TSingleClick = class(TThread)
  protected
    procedure Execute; override;
  public
    constructor Create;
  end;

  // TrayIconAj[VXbhNX̒`
  TTrayIconAnimate = class(TThread)
  private
    AnimateFrame: Integer;
    Icon: TIcon;
    Owner: TTrayIcon;
  protected
    procedure Execute; override;
  public
    constructor Create(AOwner: TTrayIcon);
    destructor Destroy; override;
  end;

  // Shell_NotifyIconp\EBhENX̒`
  TCallbackWindow = Class(TWinControl)
  private
    FOwner: TTrayIcon;

    procedure CallbackWndProc(var Msg: TMessage); Message WM_NotifyIconMessage;
    procedure OnClick(Sender: TObject);
  end;

procedure Register;

implementation

var
  CallbackWindow: TCallbackWindow;
  IconIDList: TStringList;

constructor TTrayIcon.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);

  // ACRo^̃`FbN
  if IconIDList.Count > 99 then
  begin
    IconID := 0;
    raise ENotifyIconError.Create(NotifyIconErrMessage);
  end;
  if IconIDList.Count > 0 then
    IconID := StrToInt(IconIDList[IconIDList.Count - 1]) + 1
  else
    IconID := 1;
  IconIDList.AddObject(IntToStr(IconID), Self);

  // vpeB̃ftHgl̐ݒ
  AnimateThread := nil;
  FAnimated := False;
  FAnimateMode := amAutomatic;
  FAnimateRate := 500;
  FAutoPopup := True;
  FEnabled := True;
  FTipHelp := 'TipHelp';
  FVisible := False;
  // IconvpeBpACRf[^̈m
  FIcon := TIcon.Create;
  IconRegisted := False;
  // VONbNptȌ
  SingleClickExec := False;

  // fUCłȂꍇ̏
  if not (csDesigning in ComponentState) then
  begin
    // ACROnChangeCxgݒ
    FIcon.OnChange := IconChange;

    // Shell_NotifyIconp\R[obNEBhEĂȂꍇ
    if CallbackWindow = nil then
    begin
      CallbackWindow := TCallbackWindow.Create(Owner);
      CallbackWindow.Parent := TWinControl(Owner);
    end;

    // Shell_NotifyIconpf[^̈mۂƏ
    New(NIconData);
    with NIconData^ do
    begin
      cbSize := Sizeof(TNotifyIconDataA);
      uCallBackMessage := WM_NotifyIconMessage;
      uID := IconID;
    end;
  end;
end;

procedure TTrayIcon.Loaded;
begin
  FReadStateNext := False; 
  // fUCłȂꍇAACR̓o^
  if not (csDesigning in ComponentState) then
    SetTrayIcon(tiAddIcon);

  inherited Loaded;
end;

destructor TTrayIcon.Destroy;
begin
  // ACRo^I[oɂOȊOAj
  if IconID <> 0 then
  begin
    // fUCłȂꍇAj
    if not (csDesigning in ComponentState) then
    begin
      // Aj[VXbh̔j
      if AnimateThread <> nil then
      begin
        AnimateThread.Terminate;
        if AnimateThread.Suspended then
          AnimateThread.Resume;
        AnimateThread.Free;
        FAnimated := False;
      end;

      // gCɃACR\ĂꍇAACR̔j
      if IconRegisted then
        SetTrayIcon(tiDeleteIcon);

      // Shell_NotifyIconpf[^̈j
      Dispose(NIconData);
    end;

    IconIDList.Delete(IconIDList.IndexOf(IntToStr(IconID)));
    FIcon.Free;
  end;

  inherited Destroy;
end;

procedure TTrayIcon.AnimeteModeChange;
begin
  if FAnimated then
  begin
    // 蓮֐؂ւꍇ
    if FAnimateMode = amAutomatic then
    begin
      FAnimateMode := amManual;
    end
    // 蓮֐؂ւꍇ
    else
    begin
      FAnimateMode := amAutomatic;
      AnimateThread.Resume;
    end;
  end;
end;

procedure TTrayIcon.AnimatePlay(AAnimateMode: TAnimateMode);
begin
  // Aj[VłȂAAj[VACRݒ肳Ăꍇ
  if (not FAnimated) and (FAnimateIcons <> nil) then
  begin
    // Aj[VACRɂPȏ̃ACRo^ĂꍇA
    // Aj[VJn
    if FAnimateIcons.Count > 0 then
    begin
      // Aj[VXbh̏ꍇ
      if AnimateThread = nil then
      begin
        // Aj[VXbh̐
        AnimateThread := TTrayIconAnimate.Create(Self);
      end;
      // Aj[V֘A̕ϐ
      FAnimated := True;
      FAnimateMode := AAnimateMode;
      // Aj[VXbh̍ĊJ
      AnimateThread.Resume;
    end;
  end;
end;

procedure TTrayIcon.AnimateStep;
begin
  // Aj[VŎ蓮Aj[V̏ꍇ
  if FAnimated and (FAnimateMode = amManual) then
    AnimateThread.Resume;
end;

procedure TTrayIcon.AnimateStop;
begin
  // Aj[VJnĂꍇAAj[V~
  if FAnimated then
  begin
    // Aj[VXbh̒~
    FAnimated := False;
    if FAnimateMode = amManual then
      AnimateThread.Resume;
    // Aj[VXbhSɒ~܂Ń[v
    while not AnimateThread.Suspended do;

    // Aj[VACRƂ̃ACRɕύX
    IconChange(FIcon);  // 2001/01/25 Self->FIcon
  end;
end;

procedure TTrayIcon.IconChange(Sender: TObject);
begin
  // gCɃACR\ĂꍇAACR̕ύX
  if IconRegisted and (not (FAnimated and (FAnimateMode = amAutomatic))) then
    SetTrayIcon(tiModifyIcon);
end;

procedure TTrayIcon.Notification(AComponent: TComponent; Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);

  // tH[̑̃R|[lg폜ꂽꍇ
  if (Operation = opRemove) then
  begin
    // 폜ꂽR|[lgTPopupMenuŁA
    // LBPopupMenuARBPopupMenuɐݒ肳ĂꍇAݒ𖳌ɕύX
    if AComponent is TPopupMenu then
    begin
      if AComponent = FLBPopupMenu then
        FLBPopupMenu := nil
      else if AComponent = FRBPopupMenu then
        FRBPopupMenu := nil;
    end
    // 폜ꂽR|[lgTImageListŁA
    // AnimateIconsɐݒ肳ꂽꍇAݒ𖳌ɕύX
    else if (AComponent is TImageList) and (AComponent = FAnimateIcons) then
      FAnimateIcons := nil;
  end;
end;

procedure TTrayIcon.ReadState(Reader: TReader);
begin
  if not FReadStateNext then
  begin
    FReadStateNext := True;
    TipHelp := '';
  end;
  inherited;
end;

procedure TTrayIcon.SetAnimateIcons(Value: TImageList);
begin
  if (Value <> FAnimateIcons) and (not FAnimated) then
    FAnimateIcons := Value;
  if FAnimateIcons <> nil then
    Value.FreeNotification(Self);
end;

procedure TTrayIcon.SetAnimateRate(Value: Integer);
begin
  if Value <> FAnimateRate then
  begin
    if Value < 100 then
      Value := 100;
    FAnimateRate := Value;
  end;
end;

procedure TTrayIcon.SetEnabled(Value: Boolean);
begin
  if Value <> FEnabled then
  begin
    FEnabled := Value;
    if not Value then
      SingleClickExec := False;
  end;
end;

procedure TTrayIcon.SetIcon(Value: TIcon);
begin
  if Value <> FIcon then
  begin
    // ACRݒ肳ꂽꍇ
    if Value <> nil then
      FIcon.Assign(Value)
    // ACRNA(폜)ꂽꍇ
    else
    begin
      FIcon.ReleaseHandle;
      FIcon.Handle := 0;
{=====================================
2000.01.25 OwnerForm.Icon, Appliction.Icon ő։\Ȃߔ\͂Ȃ
      // ACR\ɂ邽߁AVisiblevpeBFalseɐݒ
      Visible := False;
======================================}
    end;
  end;
end;

procedure TTrayIcon.SetLBPopupMenu(Value: TPopupMenu);
begin
  if Value <> FLBPopupMenu then
    FLBPopupMenu := Value;
  if FLBPopupMenu <> nil then
    Value.FreeNotification(Self);
end;

procedure TTrayIcon.SetRBPopupMenu(Value: TPopupMenu);
begin
  if Value <> FRBPopupMenu then
    FRBPopupMenu := Value;
  if FRBPopupMenu <> nil then
    Value.FreeNotification(Self);
end;

procedure TTrayIcon.SetTipHelp(Value: String);
begin
  if FTipHelp <> Copy(Value, 1, 62) then
  begin
    FTipHelp := Copy(Value, 1, 62);

    // fUCłȂꍇA`bvwv̕ύX
    if not (csDesigning in ComponentState) then
      IconChange(Self);
  end;
end;

procedure TTrayIcon.SetTrayIcon(Value: TTrayIconMode);
begin
  // Shell_NotifyIconpf[^̈ɃvpeB̒lݒ
  with NIconData^ do
  begin
    // Aj[VłȂA蓮Aj[V̏ꍇA
    // IconvpeB̃ACRݒ
    if not FAnimated then
      hIcon := GetIconHandle
    else
      hIcon := AnimateThread.Icon.Handle;
    StrCopy(szTip, PChar(FTipHelp));
    if FtipHelp <> '' then
      uFlags := NIF_MESSAGE or NIF_ICON or NIF_TIP
    else
      uFlags := NIF_MESSAGE or NIF_ICON;
  end;

  case Value of
    tiAddIcon:
    begin
      // VisiblevpeBTruȅꍇAACR̓o^
      if FVisible then
      begin
        // Shell_NotifyIconpEBhEnh()ݒ
        NIconData^.Wnd := CallbackWindow.Handle;
        if not Shell_NotifyIcon(NIM_ADD, NIconData) then
          raise ENotifyIconError.Create(NotifyIconErrMessage);
        IconRegisted := True;
      end;
    end;
    tiModifyIcon:
    begin
      if not Shell_NotifyIcon(NIM_MODIFY, NIconData) then
        raise ENotifyIconError.Create(NotifyIconErrMessage);
    end;
    tiDeleteIcon:
    begin
      Shell_NotifyIcon(NIM_DELETE, NIconData);
      IconRegisted := False;
    end;
  end;
end;

function TTrayIcon.GetIconHandle: THandle;
begin
  Result := FIcon.Handle;
  if Result = 0 then
  begin
    if Owner is TForm then
      Result := TForm(Owner).Icon.Handle;
    if Result = 0 then
      Result := Application.Icon.Handle;
  end;
end;

procedure TTrayIcon.SetVisible(Value: Boolean);
begin
  if Value <> FVisible then
  begin
    // 2001/01/25 IconvpeBȂ OwnerForm  Application 𗘗p
    if GetIconHandle <> 0 then
      FVisible := Value
    else
      FVisible := False;

    // fUCłȂAR|[lg[hłȂꍇA\E\̐ؑւ
    if not (csDesigning in ComponentState)
      and not (csLoading in ComponentState) then
    begin
      // \\֐ؑւꍇ
      if FVisible then
        SetTrayIcon(tiAddIcon)
      // \\֐ؑւꍇ
      else if IconRegisted then
        SetTrayIcon(tiDeleteIcon);
    end;
  end;
end;

constructor TSingleClick.Create;
begin
  inherited Create(False);

  // Execute\bhIATSingleClickXbhNX̎jݒ
  FreeOnterminate := True;
end;

procedure TSingleClick.Execute;
begin
  // VONbN̔莞ԒAXbh̒~
  Sleep(GetDoubleClickTime + 50);
end;

constructor TTrayIconAnimate.Create(AOwner: TTrayIcon);
begin
  inherited Create(True);

  // XbhLTrayIconR|[lg̐ݒ
  Owner := AOwner;
  // Aj[Vt[̏
  AnimateFrame := 0;
  // Aj[VACRpACRf[^̈m
  Icon := TIcon.Create;
end;

destructor TTrayIconAnimate.Destroy;
begin
  // Aj[VACRpACRf[^̈̉
  Icon.Free;

  inherited Destroy;
end;

procedure TTrayIconAnimate.Execute;
begin
  while not Terminated do
  begin
    if Owner.FAnimated then
    begin
      // AnimateIcons̓eύXAɕ\ACRȂȂꍇ
      // ŏ̃ACRɖ߂
      if AnimateFrame > (Owner.FAnimateIcons.Count - 1) then
        AnimateFrame := 0;

      // ACR̕ύX
      Owner.FAnimateIcons.GetIcon(AnimateFrame, Icon);
      // gCɃACR\ĂꍇAACR̔f
      if Owner.IconRegisted then
      begin
        with Owner.NIconData^ do
        begin
          hIcon := Icon.Handle;
          StrCopy(szTip, PChar(Owner.FTipHelp));
          if Owner.FTipHelp <> '' then
            uFlags := NIF_MESSAGE or NIF_ICON or NIF_TIP
          else
            uFlags := NIF_MESSAGE or NIF_ICON;
        end;
        Shell_NotifyIcon(NIM_MODIFY, Owner.NIconData);
      end;

      // ɕ\ACR̃t[ݒ
      if AnimateFrame < (Owner.FAnimateIcons.Count - 1) then
        Inc(AnimateFrame)
      else
        AnimateFrame := 0;

      // Aj[V[h̏ꍇAw肳ꂽ~bXbh~
      if Owner.AnimateMode = amAutomatic then
        Sleep(Owner.FAnimateRate)
      else
        Suspend;
    end
    else
    begin
      AnimateFrame := 0;
      Suspend;
    end;
  end;
end;

procedure TCallbackWindow.CallbackWndProc(var Msg: TMessage);
var
  cursorpos: TPoint;
  objindex: Integer;
begin
  // TTrayIconIuWFNg̃CfbNXʒu̐ݒ
  objindex := IconIDList.IndexOf(IntToStr(Msg.wParam));
  if objindex >= 0 then
  begin
    FOwner := TTrayIcon(IconIDList.Objects[objindex]);
    // EnabledvpeBFalsȅꍇAɃvV[W甲o
    if not FOwner.FEnabled then
      Exit;
  end
  else
    Exit;

  // }EXJ[\݈̌ʒu擾
  GetCursorPos(cursorpos);

  // }EX̃bZ[Wɂ菈
  case Msg.lParam of
    // ACR̒ʉߎ
    WM_MOUSEMOVE:
    begin
      if Assigned(FOwner.OnMouseMove) then
        FOwner.OnMouseMove(FOwner, [], cursorpos.X, cursorpos.Y);
    end;
    // {^̃_E
    WM_LBUTTONDOWN:
    begin
      // {^Ƀ|bvAbvj[蓖ĂāAAutoPopupTruȅꍇ
      if Assigned(FOwner.LBPopupMenu) and FOwner.AutoPopup then
      begin
        if FOwner.Owner is TForm then
        begin
          SetForegroundWindow(TForm(FOwner.Owner).Handle);
          Application.ProcessMessages;
        end;
        FOwner.LBPopupMenu.Popup(cursorpos.X, cursorpos.Y);
      end
      else if Assigned(FOwner.OnMouseDown) then
        FOwner.OnMouseDown(FOwner, mbLeft, [ssLeft], cursorpos.X, cursorpos.Y);
    end;
    // {^̃Abv
    WM_LBUTTONUP:
    begin
      if Assigned(FOwner.OnMouseUp) then
        FOwner.OnMouseUp(FOwner, mbLeft, [ssLeft], cursorpos.X, cursorpos.Y)
      else if Assigned(FOwner.OnClick) then
      begin
        if not FOwner.SingleClickExec then
        begin
          FOwner.SingleClickExec := True;
          with TSingleClick.Create do
            OnTerminate := OnClick;
        end
        else
        begin
          FOwner.SingleClickExec := False;
        end;
      end
      else
        FOwner.SingleClickExec := False;
    end;
    // {^̃_uNbN
    WM_LBUTTONDBLCLK:
    begin
      FOwner.SingleClickExec := True;
      if Assigned(FOwner.OnDblClick) then
        FOwner.OnDblClick(FOwner);
    end;
    // {^̃_E
    WM_MBUTTONDOWN:
    begin
      if Assigned(FOwner.OnMouseDown) then
        FOwner.OnMouseDown(FOwner, mbMiddle, [ssMiddle],
          cursorpos.X, cursorpos.Y);
    end;
    // {^̃Abv
    WM_MBUTTONUP:
    begin
      if Assigned(FOwner.OnMouseUp) then
        FOwner.OnMouseUp(FOwner, mbMiddle, [ssMiddle],
          cursorpos.X, cursorpos.Y);
    end;
    // E{^̃_E
    WM_RBUTTONDOWN:
    begin
      // E{^Ƀ|bvAbvj[蓖ĂāAAutoPopupTruȅꍇ
      if Assigned(FOwner.RBPopupMenu) and FOwner.AutoPopup then
      begin
        if FOwner.Owner is TForm then
        begin
          SetForegroundWindow(TForm(FOwner.Owner).Handle);
          Application.ProcessMessages;
        end;
        FOwner.RBPopupMenu.Popup(cursorpos.X, cursorpos.Y);
      end
      else if Assigned(FOwner.OnMouseDown) then
        FOwner.OnMouseDown(FOwner, mbRight, [ssRight],
          cursorpos.X, cursorpos.Y);
    end;
    // E{^̃Abv
    WM_RBUTTONUP:
    begin
      if Assigned(FOwner.OnMouseUp) then
        FOwner.OnMouseUp(FOwner, mbRight, [ssRight],
          cursorpos.X, cursorpos.Y);
    end;
  end;
end;

procedure TCallbackWindow.OnClick(Sender: TObject);
begin
  if Assigned(FOwner.OnClick) and FOwner.SingleClickExec then
    FOwner.OnClick(FOwner);
  FOwner.SingleClickExec := False;
end;

procedure Register;
begin
  RegisterComponents('Win32', [TTrayIcon]);
end;

initialization
  // Shell_NotifyIconp\EBhENX̏
  CallbackWindow := nil;

  // Shell_NotifyIconpIcon IDXg̐
  IconIDList := TStringList.Create;
  IconIDList.Sorted := False;

finalization
  // Shell_NotifyIconpIcon IDXg̉
  IconIDList.Free;

end.

