unit _Compact;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls,ExtCtrls,_PicTools;

{$WARN UNIT_PLATFORM OFF}
{$WARN SYMBOL_PLATFORM OFF}

type
  TCompact = class
  private
    { Private 錾 }
    Img:TImage;
    TimeTick:dword;
    CmpBtnPos,TitlePos,TimePos:TWindowPos;
    procedure DrawButton(cnt:integer;Enabled:boolean);
    procedure ImgRefresh(var pos:TWindowPos);
    procedure ImgMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure ImgMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure ImgMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
  public
    { Public 錾 }
    constructor Create;
    destructor Destroy; override;
    procedure Init(var _Img:TImage);
    procedure FreeMemory;
    procedure DrawTitle;
    procedure SetTime(Tick:integer);
    procedure DrawTime;
    procedure DrawAll;
  end;

var
  Compact:TCompact;

implementation

uses MainWin,
     _MDXWin_const, _m_Tools, _MDXWinINI,_Images,_KeyDef_const,_KeyDef,_CSkin;

constructor TCompact.Create;
begin
  inherited Create;

  Img:=nil;
  TimeTick:=0;

  with CmpBtnPos do begin
    Left:=4;
    Top:=4;
    Width:=CmpBtnWidth;
    Height:=CmpBtnHeight;
  end;

  with TitlePos do begin
    Left:=128;
    Top:=3;
    Width:=28*16;
    Height:=18;
  end;

  with TimePos do begin
    Left:=590;
    Top:=5;
    Width:=8*5;
    Height:=16;
  end;

end;

destructor TCompact.Destroy;
begin
  Img:=nil;
  TimeTick:=0;

  inherited Destroy;
end;

procedure TCompact.Init(var _Img:TImage);
begin
  Img:=_Img;
  MakeBlankImg(Img,pf24bit);

  Img.OnMouseDown:=ImgMouseDown;
  Img.OnMouseMove:=ImgMouseMove;
  Img.OnMouseUp:=ImgMouseUp;

  TimeTick:=0;
end;

procedure TCompact.FreeMemory;
begin
  Img.OnMouseDown:=nil;
  Img.OnMouseMove:=nil;
  Img.OnMouseUp:=nil;

  Img:=nil;
end;

procedure TCompact.DrawButton(cnt:integer;Enabled:boolean);
var
  btnx:integer;
  dx,dy:integer;
  x,y:integer;
  pImg,pBG,pSrc:PRGB;
begin
  btnx:=CmpBtnOneWidth*cnt;
  dx:=CmpBtnPos.Left+btnx;
  dy:=CmpBtnPos.Top;

  for y:=0 to CmpBtnHeight-1 do begin
    pImg:=Img.Picture.Bitmap.ScanLine[dy+y];
    inc(pImg,dx);
    pBG:=@Images.CompactBGPtr[dy+y][dx];
    if Enabled=True then begin
      pSrc:=@Images.CompactButtonBMEx.PosiPtr[y][btnx];
      end else begin
      pSrc:=@Images.CompactButtonBMEx.NegaPtr[y][btnx];
    end;
    for x:=0 to CmpBtnOneWidth-1 do begin
      if (pSrc^.b=$00) and (pSrc^.g=$ff) and (pSrc^.r=$00) then begin
        pImg^:=pBG^;
        end else begin
        pImg^:=pSrc^;
      end;
      inc(pImg);
      inc(pBG);
      inc(pSrc);
    end;
  end;
  ImgRefresh(CmpBtnPos);
end;

procedure TCompact.DrawTitle;
begin
  with TitlePos do begin
    BitBlt(Img.Canvas.Handle,Left,Top,Width,Height,Images.CompactBGBM.Canvas.Handle,Left,Top,SRCCOPY);
  end;
  Images.WriteMoeString(Img.Picture.Bitmap,TitlePos.Left,TitlePos.Top,TitlePos.Width,Main.MusicTitle.Text,CSkin.dwCompactTitle,False,Main.MusicTitle.ESCMode,MainINI.TitleFontName);
  ImgRefresh(TitlePos);
end;

procedure TCompact.SetTime(Tick:integer);
begin
  if Tick<0 then Tick:=0;
  TimeTick:=dword(Tick);
end;

procedure TCompact.DrawTime;
begin
  with TimePos do begin
    BitBlt(Img.Canvas.Handle,Left,Top,Width,Height,Images.CompactBGBM.Canvas.Handle,Left,Top,SRCCOPY);
  end;
  Images.WriteX68kStringTransparent(Img.Picture.Bitmap,TimePos.Left,TimePos.Top,CSkin.ColCompactTime,Images.TimeToText(TimeTick div 500));
  ImgRefresh(TimePos);
end;

procedure TCompact.DrawAll;
var
  cnt:integer;
  pos:TWindowPos;
begin
  with pos do begin
    Left:=0;
    Top:=0;
    Width:=Img.Width;
    Height:=Img.Height;
  end;

  with pos do begin
    BitBlt(Img.Canvas.Handle,Left,Top,Width,Height,Images.CompactBGBM.Canvas.Handle,Left,Top,SRCCOPY);
  end;
  DrawFlameBitmap(Img.Picture.Bitmap,CSkin.ColCompactFrameBright,CSkin.ColCompactFrameMask);

  for cnt:=0 to CmpBtnCount-1 do
    DrawButton(cnt,True);

  DrawTitle;
  DrawTime;

  ImgRefresh(pos);
end;

procedure TCompact.ImgRefresh(var pos:TWindowPos);
begin
  if Img.Visible=False then exit;
  with pos do begin
    BitBlt(Main.Canvas.Handle,Img.Left+Left,Img.Top+Top,Width,Height,Img.Canvas.Handle,Left,Top,SRCCOPY);
  end;
end;

procedure TCompact.ImgMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  PushCnt:integer;
begin
  PushCnt:=(x-CmpBtnPos.Left) div CmpBtnOneWidth;
  if PushCnt<0 then PushCnt:=-1;
  if PushCnt>=CmpBtnCount then PushCnt:=-1;

  if PushCnt<>-1 then begin
    if Button=mbLeft then begin
      ImgMouseMove(Sender,[ssLeft],x,y);
    end;
    if Button=mbRight then begin
      KeyDef.ExecuteCommand(DCT_ShowPlayModeMenu);
    end;
  end;

  if PushCnt=-1 then begin
    if Button=mbLeft then begin
      KeyDef.ExecuteCommand(DCT_ShowTitle);
    end;
    if Button=mbRight then begin
      KeyDef.ExecuteCommand(DCT_ShowMainMenu);
    end;
  end;
end;

procedure TCompact.ImgMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var
  PushCnt,cnt:integer;
begin
  PushCnt:=(x-CmpBtnPos.Left) div CmpBtnOneWidth;
  if PushCnt<0 then PushCnt:=-1;
  if PushCnt>=CmpBtnCount then PushCnt:=-1;

  if Shift=[ssLeft] then begin
    for cnt:=0 to CmpBtnCount-1 do begin
      if cnt=PushCnt then
        DrawButton(cnt,False)
        else
        DrawButton(cnt,True);
    end;
  end;
end;

procedure TCompact.ImgMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  PushCnt,cnt:integer;
begin
  PushCnt:=(x-CmpBtnPos.Left) div CmpBtnOneWidth;
  if PushCnt<0 then PushCnt:=-1;
  if PushCnt>=CmpBtnCount then PushCnt:=-1;

  if Button=mbLeft then begin
    for cnt:=0 to CmpBtnCount-1 do
      DrawButton(cnt,True);

    case PushCnt of
      0: KeyDef.ExecuteCommand(DCT_NextPlayBack);
      1: KeyDef.ExecuteCommand(DCT_sdPlay);
      2: KeyDef.ExecuteCommand(DCT_sdPause);
      3: KeyDef.ExecuteCommand(DCT_sdStop);
      4: KeyDef.ExecuteCommand(DCT_NextPlayNext);
    end;
  end;
end;

end.
