unit _CurrentFiles;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Grids;

{$WARN UNIT_PLATFORM OFF}
{$WARN SYMBOL_PLATFORM OFF}

const ir_None=0;
const ir_Drive=1;
const ir_Dir=2;
const ir_File=3;

type
  TFilesItem=record
    Attr:byte;
    Name,Value:string;
  end;

type
  TFiles=record
    ItemCount:integer;
    Item:array of TFilesItem;
  end;

type
  TCurrentFiles=class
  private
    { Private 錾 }
    TargetGrid:TStringGrid;
    PlayIndex:integer;
    Files:TFiles;
  public
    { Public 錾 }
    procedure MemInit(var g:TStringGrid);
    procedure MemFree;
    function MouseToCell(x,y:integer):integer;
    procedure MouseWheel(vector:integer;Shift:TShiftState);
    procedure RollKey(vector:integer;Shift:TShiftState);
    procedure FindName(Name:string;Cursor,Play:boolean);
    procedure GridCellRefresh(idx:integer);

    procedure SetPlayIndex(i:integer);
    function GetPlayIndex:integer;
    procedure SetCursorIndex(i:integer);
    function GetCursorIndex:integer;
    procedure SetItemsCount(i:integer);
    function GetItemsCount:integer;

    procedure SetItem(idx:integer;var item:TFilesItem);
    procedure GetItem(idx:integer;var item:TFilesItem);
    function GetItemAttr(idx:integer):byte;
    function GetItemName(idx:integer):string;
    function GetItemViewStr(idx:integer;CurrentPath:string):string;
  end;

var
  CurrentFiles:TCurrentFiles;

implementation

uses _GridTool;

procedure TCurrentFiles.MemInit(var g:TStringGrid);
begin
  TargetGrid:=g;
  PlayIndex:=-1;
  Files.ItemCount:=0;
  SetLength(Files.Item,Files.ItemCount);
end;

procedure TCurrentFiles.MemFree;
begin
  TargetGrid:=nil;
  PlayIndex:=-1;
  Files.ItemCount:=0;
  SetLength(Files.Item,Files.ItemCount);
end;

function TCurrentFiles.MouseToCell(x,y:integer):integer;
var
  c,r:integer;
begin
  TargetGrid.MouseToCell(x,y,c,r);
  Result:=r;
end;

procedure TCurrentFiles.MouseWheel(vector:integer;Shift:TShiftState);
begin
  Grid_MouseWheelViewOnly(TargetGrid,vector,Shift);
end;

procedure TCurrentFiles.RollKey(vector:integer;Shift:TShiftState);
begin
  Grid_MouseWheelWithCursor(TargetGrid,vector,Shift);
end;

procedure TCurrentFiles.FindName(Name:string;Cursor,Play:boolean);
var
  Cnt:integer;
begin
  Name:=AnsiLowerCase(Name);
  for Cnt:=0 to Files.ItemCount-1 do begin
    if AnsiLowerCase(Files.Item[Cnt].Name)=Name then begin
      if Cursor=True then SetCursorIndex(Cnt);
      if Play=True then SetPlayIndex(Cnt);
      break;
    end;
  end;
end;

procedure TCurrentFiles.GridCellRefresh(idx:integer);
begin
  if (0<=idx) and (idx<Files.ItemCount) then begin
    TargetGrid.Cells[0,idx]:=TargetGrid.Cells[0,idx]+' ';
  end;
end;

procedure TCurrentFiles.SetPlayIndex(i:integer);
begin
  GridCellRefresh(PlayIndex);
  if (0<=i) and (i<Files.ItemCount) then begin
    PlayIndex:=i;
    GridCellRefresh(PlayIndex);
  end;
end;

function TCurrentFiles.GetPlayIndex:integer;
begin
  Result:=PlayIndex;
end;

procedure TCurrentFiles.SetCursorIndex(i:integer);
begin
  if (0<=i) and (i<Files.ItemCount) then begin
    if GetCursorIndex<>i then begin
      Grid_MoveIndex(TargetGrid,i);
    end;
  end;
end;

function TCurrentFiles.GetCursorIndex:integer;
begin
  Result:=Grid_GetIndex(TargetGrid);
end;

procedure TCurrentFiles.SetItemsCount(i:integer);
var
  cnt:integer;
begin
  if i<0 then i:=0;

  PlayIndex:=-1;

  TargetGrid.RowCount:=i;
  Files.ItemCount:=i;
  SetLength(Files.Item,Files.ItemCount);

  for cnt:=0 to Files.ItemCount-1 do begin
    Files.Item[cnt].Attr:=ir_None;
    TargetGrid.Cells[0,cnt]:='';
  end;
end;

function TCurrentFiles.GetItemsCount:integer;
begin
  Result:=Files.ItemCount;
end;

procedure TCurrentFiles.SetItem(idx:integer;var item:TFilesItem);
begin
  if (0<=idx) and (idx<Files.ItemCount) then begin
    Files.Item[idx]:=item;
    GridCellRefresh(idx);
  end;
end;

procedure TCurrentFiles.GetItem(idx:integer;var item:TFilesItem);
begin
  if (0<=idx) and (idx<Files.ItemCount) then begin
    item:=Files.Item[idx];
    end else begin
    item.Attr:=ir_None;
  end;
end;

function TCurrentFiles.GetItemAttr(idx:integer):byte;
begin
  if (0<=idx) and (idx<Files.ItemCount) then begin
    Result:=Files.Item[idx].Attr;
    end else begin
    Result:=ir_None;
  end;
end;

function TCurrentFiles.GetItemName(idx:integer):string;
begin
  if (0<=idx) and (idx<Files.ItemCount) then begin
    Result:=Files.Item[idx].Name;
    end else begin
    Result:='';
  end;
end;

function TCurrentFiles.GetItemViewStr(idx:integer;CurrentPath:string):string;
var
  Filename:string;
begin
  if (0<=idx) and (idx<Files.ItemCount) then begin
    end else begin
    Result:='';
    exit;
  end;

  with Files.Item[idx] do begin
    case Attr of
      ir_None: Result:='';
      ir_Drive: Result:=' - '+Name+' Drive - '+Value;
      ir_Dir: begin
        Result:=' < Directory > '+Name;
        if Name='..' then begin
          Result:=Result+' '+CurrentPath;
        end;
      end;
      ir_File: begin
        if Value='' then begin
          Result:=Name;
          end else begin
          Filename:=Name;
          if Length(Filename)>24 then begin
            Filename:=copy(Filename,1,21)+'...';
          end;
          Result:=Filename+StringOfChar(' ',14-Length(Filename))+' '+trim(Value);
        end;
      end;
      else Result:='';
    end;
  end;
end;

end.
