unit _DynamicBuffer;

interface

uses
  Windows, SysUtils, Variants, Classes;

type
  TDynamicBuffer=class
  private
    { Private 錾 }
  public
    count,pos:integer;
    buf:array of byte;
    constructor Create;
    destructor Destroy; override;
    procedure Clear;
    procedure LeadCut(cutlen:integer);
    procedure SetByte(b:byte);
    procedure SetWord(w:word);
    procedure SetDWord(dw:dword);
    procedure SetInteger(i:integer);
    procedure SetString(msg:string);
    function GetByte:byte;
    function GetWord:word;
    function GetDWord:dword;
    function GetInteger:integer;
    function GetString:string;
  end;

implementation

constructor TDynamicBuffer.Create;
begin
  count:=0;
  pos:=0;
  SetLength(buf,0);
end;

destructor TDynamicBuffer.Destroy;
begin
  count:=0;
  pos:=0;
  SetLength(buf,0);
end;

procedure TDynamicBuffer.Clear;
begin
  count:=0;
  pos:=0;
  SetLength(buf,0);
end;

procedure TDynamicBuffer.LeadCut(cutlen:integer);
begin
  if count<=cutlen then begin
    Clear;
    end else begin
    MoveMemory(@buf[0],@buf[cutlen],count-cutlen);
    dec(count,cutlen);
    if pos<=cutlen then begin
      pos:=0;
      end else begin
      dec(pos,cutlen);
    end;
  end;
end;

procedure TDynamicBuffer.SetByte(b:byte);
begin
  SetLength(buf,pos+1);
  buf[pos]:=b;
  inc(pos,1);
  count:=pos;
end;

procedure TDynamicBuffer.SetWord(w:word);
begin
  SetLength(buf,pos+2);
  buf[pos+0]:=byte(w div $100 and $ff);
  buf[pos+1]:=byte(w div $1 and $ff);
  inc(pos,2);
  count:=pos;
end;

procedure TDynamicBuffer.SetDWord(dw:dword);
begin
  SetLength(buf,pos+4);
  buf[pos+0]:=byte(dw div $1000000 and $ff);
  buf[pos+1]:=byte(dw div $10000 and $ff);
  buf[pos+2]:=byte(dw div $100 and $ff);
  buf[pos+3]:=byte(dw div $1 and $ff);
  inc(pos,4);
  count:=pos;
end;

procedure TDynamicBuffer.SetInteger(i:integer);
begin
  SetLength(buf,pos+4);
  buf[pos+0]:=byte(dword(i) div $1000000 and $ff);
  buf[pos+1]:=byte(dword(i) div $10000 and $ff);
  buf[pos+2]:=byte(dword(i) div $100 and $ff);
  buf[pos+3]:=byte(dword(i) div $1 and $ff);
  inc(pos,4);
  count:=pos;
end;

procedure TDynamicBuffer.SetString(msg:string);
var
  cnt:integer;
begin
  SetByte(Length(msg));
  for cnt:=0 to Length(msg)-1 do begin
    SetByte(byte(msg[cnt+1]));
  end;
end;

function TDynamicBuffer.GetByte:byte;
begin
  Result:=buf[pos];
  inc(pos,1);
end;

function TDynamicBuffer.GetWord:word;
begin
  Result:=word(buf[pos+0])*$100;
  Result:=Result+(word(buf[pos+1])*$1);
  inc(pos,2);
end;

function TDynamicBuffer.GetDWord:dword;
begin
  Result:=dword(buf[pos+0])*$1000000;
  Result:=Result+(dword(buf[pos+1])*$10000);
  Result:=Result+(dword(buf[pos+2])*$100);
  Result:=Result+(dword(buf[pos+3])*$1);
  inc(pos,4);
end;

function TDynamicBuffer.GetInteger:integer;
var
  dw:dword;
begin
  dw:=dword(buf[pos+0])*$1000000;
  dw:=dw+(dword(buf[pos+1])*$10000);
  dw:=dw+(dword(buf[pos+2])*$100);
  dw:=dw+(dword(buf[pos+3])*$1);
  inc(pos,4);
  Result:=integer(dw);
end;

function TDynamicBuffer.GetString:string;
var
  cnt,len:integer;
begin
  Result:='';

  len:=GetByte;
  for cnt:=0 to len-1 do begin
    Result:=Result+char(GetByte);
  end;
end;

end.
