unit _Func;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, _PicTools;

{$WARN UNIT_PLATFORM OFF}
{$WARN SYMBOL_PLATFORM OFF}

const ItemCount=12;

const TextWidth=8;
const TextHeight=16;

const FuncNo_F1=0;
const FuncNo_F2=1;
const FuncNo_F3=2;
const FuncNo_F4=3;
const FuncNo_F5=4;
const FuncNo_F6=5;
const FuncNo_F7=6;
const FuncNo_F8=7;
const FuncNo_F9=8;
const FuncNo_F10=9;
const FuncNo_F11=10;
const FuncNo_F12=11;

type
  TItem=record
    DCT:integer;
    Enabled:boolean;
    Text:string;
    pos:TWindowPos;
  end;

type
  TFunc = class
  private
    { Private 錾 }
    InfoPos,LoopPos,GripPos:TWindowPos;
    RegImg:TImage;
    RegBM:TBitmap;
    RegX:integer;
    MBarFlag:boolean;
    MBarY:integer;
    procedure DrawItem(No:integer);
    procedure FillAlpha(pos:TWindowPos;rgb:TRGB;Alpha:integer);
  public
    { Public 錾 }
    Width,Height:integer;
    Item:array[0..ItemCount] of TItem;
    constructor Create;
    destructor Destroy; override;
    procedure FreeMemory;
    procedure Regist(var Img:TImage);
    procedure Draw;
    procedure AllRedraw(LoopCount:integer);
    procedure SetItem(No:integer;_DCT:integer;_Enabled:boolean;_Text:string;_Left,_Width:integer);
    procedure SetItemEnabled(No:integer;_Enabled:boolean);
    procedure SetItemText(No:integer;_Text:string);
    procedure SetInfo(InfoText:string;LoopCount:integer);
    procedure onMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure onMouseMove(Sender: TObject; Shift: TShiftState; X,Y: Integer);
    procedure onMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
  end;

var
  Func:TFunc;

implementation

uses MainWin,_CSkin,_KeyDef,_Images;

constructor TFunc.Create;
begin
  inherited Create;

  Width:=FuncWidth;
  Height:=FuncHeight;

  InfoPos.Left:=TextWidth;
  InfoPos.Top:=22;
  InfoPos.Width:=Width-InfoPos.Left-24;
  InfoPos.Height:=TextHeight;

  LoopPos.Width:=(Length('AUTO ? Loop.')*TextWidth)+TextWidth;
  LoopPos.Left:=Width-LoopPos.Width-24;
  LoopPos.Top:=InfoPos.Top;
  LoopPos.Height:=TextHeight;

  GripPos.Left:=Width-GripSize;
  GripPos.Width:=GripSize;
  GripPos.Top:=Height-GripSize;
  GripPos.Height:=GripSize;

  MBarFlag:=False;
  MBarY:=0;

  RegBM:=nil;
  RegX:=0;
end;

destructor TFunc.Destroy;
begin
  inherited Destroy;
end;

procedure TFunc.FreeMemory;
begin
  Width:=0;
  Height:=0;

  MBarFlag:=False;
  MBarY:=0;

  RegImg.OnMouseDown:=nil;
  RegImg.OnMouseMove:=nil;
  RegImg.OnMouseUp:=nil;
  RegImg:=nil;
  RegBM:=nil;
  RegX:=0;
end;

procedure TFunc.Regist(var Img:TImage);
begin
  MakeBlankImg(Img,pf24bit);

  RegImg:=Img;
  RegImg.OnMouseDown:=onMouseDown;
  RegImg.OnMouseMove:=onMouseMove;
  RegImg.OnMouseUp:=onMouseUp;

  RegBM:=RegImg.Picture.Bitmap;
  RegX:=RegImg.Left;
end;

procedure TFunc.Draw;
  procedure DrawGrip;
  var
    x,y:integer;
    pBM,pBGBM:PRGB;
    pGrip:PGray;
  begin
    for y:=0 to GripSize-1 do begin
      pBM:=Images.FuncBM.ScanLine[GripPos.Top+y];
      inc(pBM,GripPos.Left);
      pBGBM:=Images.FuncBGBM.ScanLine[GripPos.Top+y];
      inc(pBGBM,GripPos.Left);
      pGrip:=@Images.GripArray[y][0];
      for x:=0 to GripSize-1 do begin
        pBM^:=RGBModulate(pBGBM^,CSkin.ColFrameGrip,pGrip^);
        inc(pBM);
        inc(pBGBM);
        inc(pGrip);
      end;
    end;
  end;
begin
  with RegBM.Canvas do begin
    Pen.Color:=CSkin.dwMask;
    MoveTo(0,0);
    LineTo(Width,0);
  end;
  DrawGrip;
  BitBlt(RegBM.Canvas.Handle,0,1,Width-RegX,Height,Images.FuncBM.Canvas.Handle,RegX,0,SRCCOPY);
  RegBM.Canvas.Pixels[0,0]:=RegBM.Canvas.Pixels[0,0];
end;

procedure TFunc.AllRedraw(LoopCount:integer);
var
  No:integer;
begin
  for No:=0 to 12-1 do begin
    DrawItem(No);
  end;
  SetInfo('',LoopCount);
  Draw;
end;

procedure TFunc.SetItem(No:integer;_DCT:integer;_Enabled:boolean;_Text:string;_Left,_Width:integer);
begin
  if No<0 then exit;
  if No>12 then exit;

  with Item[No] do begin
    Enabled:=_Enabled;
    DCT:=_DCT;
    Text:=_Text;
    pos.Left:=_Left*TextWidth;
    pos.Top:=4;
    pos.Width:=_Width*TextWidth+TextWidth;
    pos.Height:=TextHeight;
  end;

  DrawItem(No);
end;

procedure TFunc.SetItemEnabled(No:integer;_Enabled:boolean);
begin
  if No<0 then exit;
  if No>12 then exit;

  with Item[No] do begin
    Enabled:=_Enabled;
  end;

  DrawItem(No);
end;

procedure TFunc.SetItemText(No:integer;_Text:string);
begin
  if No<0 then exit;
  if No>12 then exit;

  with Item[No] do begin
    Text:=_Text;
  end;

  DrawItem(No);
end;

procedure TFunc.FillAlpha(pos:TWindowPos;rgb:TRGB;Alpha:integer);
begin
  with pos do begin
    BitBlt(Images.FuncBM.Canvas.Handle,Left,Top,Width,Height,Images.FuncBGBM.Canvas.Handle,Left,Top,SRCCOPY);
  end;
  FillAlphaBMPos(Images.FuncBM,pos,rgb,Alpha);
end;

procedure TFunc.DrawItem(No:integer);
var
  rgb:TRGB;
  x:integer;
begin
  if Item[No].pos.Width=0 then exit;
  if Item[No].pos.Height=0 then exit;

  with Item[No] do begin
    if Enabled=True then begin
      FillAlpha(pos,CSkin.ColFuncEnabledBG,CSkin.FuncBGEnabledAlpha);
      rgb:=CSkin.ColFuncEnabledText;
      end else begin
      FillAlpha(pos,CSkin.ColFuncDisabledBG,CSkin.FuncBGDisabledAlpha);
      rgb:=CSkin.ColFuncDisabledText;
    end;
    if Text<>'' then begin
      x:=pos.Left+(pos.Width-(Length(Text)*TextWidth)) div 2;
      Images.WriteX68kStringTransparent(Images.FuncBM,x,pos.Top,rgb,Text);
    end;
  end;
end;

procedure TFunc.SetInfo(InfoText:string;LoopCount:integer);
begin
  if InfoText='' then begin
    FillAlpha(InfoPos,CSkin.ColFuncTextBG,$00);
    FillAlpha(LoopPos,CSkin.ColFuncLoopBG,CSkin.FuncLoopAlpha);
    Images.WriteX68kStringTransparent(Images.FuncBM,LoopPos.Left+TextWidth,LoopPos.Top,CSkin.ColFuncLoop,'AUTO '+inttostr(LoopCount)+' Loop.');
    end else begin
    FillAlpha(InfoPos,CSkin.ColFuncTextBG,CSkin.FuncTextAlpha);
    Images.WriteX68kStringTransparent(Images.FuncBM,InfoPos.Left,InfoPos.Top,CSkin.ColFuncText,InfoText);
  end;
end;

procedure TFunc.onMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  cnt:integer;
begin
  if Application.Title='MDXClose' then exit;

  for cnt:=0 to ItemCount-1 do begin
    if CheckWindowInside(Item[cnt].pos,x,y)=True then begin
      KeyDef.ExecuteCommand(Item[cnt].DCT);
      exit;
    end;
  end;

  if CheckWindowInside(LoopPos,x,y)=True then begin
    if Button=mbLeft then Main.ChangeLoopMax(-1);
    if Button=mbRight then Main.ChangeLoopMax(1);
    exit;
  end;

  if (CheckWindowInside(GripPos,x,y)=True) or ((Height-3)<=y) then begin
    MBarFlag:=True;
    MBarY:=Y;
    exit;
  end;
end;

procedure TFunc.onMouseMove(Sender: TObject; Shift: TShiftState; X,Y: Integer);
begin
  if Application.Title='MDXClose' then exit;

  if MBarFlag=False then begin
    if CheckWindowInside(GripPos,x,y)=True then begin
      RegImg.Cursor:=crSizeNWSE;
      end else begin
      if (Height-3)<=y then begin
        RegImg.Cursor:=crSizeNS;
        end else begin
        RegImg.Cursor:=crDefault;
      end;
    end;
    exit;
  end;

  if MBarFlag=True then begin
    Main.Height:=Main.Height+(Y-MBarY);
    exit;
  end;
end;

procedure TFunc.onMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if Application.Title='MDXClose' then exit;
  MBarFlag:=False;
end;

end.
