unit _GridTool;

interface

uses
  Windows, Classes,Grids,Messages;

{$WARN UNIT_PLATFORM OFF}
{$WARN SYMBOL_PLATFORM OFF}

function Grid_GetNowItem(var Grid:TStringGrid):string;
function Grid_GetItem(var Grid:TStringGrid;idx:integer):string;
procedure Grid_SetItem(var Grid:TStringGrid;idx:integer;msg:string);
function Grid_GetIndex(var Grid:TStringGrid):integer;
procedure Grid_MoveIndex(var Grid:TStringGrid;Idx:integer);
procedure Grid_InsideScroll(var Grid:TStringGrid);
procedure Grid_MouseWheelWithCursor(var Grid:TStringGrid;vector:integer;Shift:TShiftState);
procedure Grid_MouseWheelViewOnly(var Grid:TStringGrid;vector:integer;Shift:TShiftState);

implementation

function Grid_GetNowItem(var Grid:TStringGrid):string;
begin
  if Grid.RowCount=0 then begin
    Result:='';
    exit;
  end;

  Result:=Grid.Cells[0,Grid.Selection.Top];
end;

function Grid_GetItem(var Grid:TStringGrid;idx:integer):string;
begin
  if Grid.RowCount=0 then begin
    Result:='';
    exit;
  end;

  Result:=Grid.Cells[0,idx];
end;

procedure Grid_SetItem(var Grid:TStringGrid;idx:integer;msg:string);
begin
  if Grid.RowCount=0 then exit;
  Grid.Cells[0,idx]:=msg;
end;

function Grid_GetIndex(var Grid:TStringGrid):integer;
begin
  if Grid.RowCount=0 then begin
    Result:=0;
    exit;
  end;

  Result:=Grid.Selection.Top;
end;

procedure Grid_MoveIndex(var Grid:TStringGrid;Idx:integer);
var
  select:TGridRect;
begin
  if Grid.RowCount=0 then exit;

  if Idx<Grid.FixedRows then Idx:=Grid.FixedRows;
  if Grid.RowCount<=Idx then Idx:=Grid.RowCount-1;

  if Grid.Selection.Top=Idx then exit;

  Select.Left:=Grid.FixedCols;
  Select.Top:=Idx;
  Select.Right:=Grid.FixedCols+Grid.ColCount;
  Select.Bottom:=Idx;
  Grid.Selection:=Select;
  Grid_InsideScroll(Grid);
end;

procedure Grid_InsideScroll(var Grid:TStringGrid);
var
  min,max:integer;
  idx:integer;
begin
  if Grid.RowCount=0 then exit;

  min:=Grid.TopRow;
  max:=min+Grid.VisibleRowCount;
  idx:=Grid_GetIndex(Grid);

  if (min<=idx) and (idx<max) then exit;

  if idx<min then begin
    if idx>=0 then Grid.TopRow:=idx;
  end;

  if idx>=max then begin
    Grid.TopRow:=idx-Grid.VisibleRowCount+1;
  end;
end;

procedure Grid_MouseWheelWithCursor(var Grid:TStringGrid;vector:integer;Shift:TShiftState);
var
  delta:integer;
  idx:integer;
begin
  if Grid.RowCount=0 then exit;

  delta:=Grid.VisibleRowCount div 4;
  if delta=0 then delta:=1;

  if (ssShift in Shift) then delta:=delta*2;
  if (ssAlt in Shift) then delta:=delta*2;
  if (ssCtrl in Shift) then delta:=delta*2;

  idx:=Grid_GetIndex(Grid)+(delta*vector);

  if idx>=(Grid.RowCount-1) then idx:=Grid.RowCount-1;
  if idx<Grid.FixedRows then idx:=Grid.FixedRows;

  Grid_MoveIndex(Grid,idx);
end;

procedure Grid_MouseWheelViewOnly(var Grid:TStringGrid;vector:integer;Shift:TShiftState);
var
  rowsize:integer;
  delta:integer;
  idx:integer;
begin
  if Grid.RowCount=0 then exit;

  rowsize:=Grid.VisibleRowCount;

  delta:=rowsize div 2;
  if delta=0 then delta:=1;

  if (ssShift in Shift) then delta:=delta*2;
  if (ssAlt in Shift) then delta:=delta*2;
  if (ssCtrl in Shift) then delta:=delta*2;

  idx:=Grid.TopRow+(delta*vector);

  if idx>=(Grid.RowCount-rowsize) then idx:=Grid.RowCount-rowsize;
  if idx<Grid.FixedRows then idx:=Grid.FixedRows;

  Grid.TopRow:=idx;
end;

end.
