// MDXWin Constructor

unit _ID3_const;

interface

uses
  SysUtils,Types;

type
  TID3=record
    Title,Artist,Album,Comment,Year:string;
    Genre:byte;
    ID:string;
  end;

procedure ClearID3(var ID3:TID3);
function ConvertTitleToID3(const Title:string):TID3;

implementation

uses _m_Tools;

procedure ClearID3(var ID3:TID3);
begin
  with ID3 do begin
    Title:='';
    Artist:='';
    Album:='';
    Comment:='';
    Year:='';
    Genre:=0;
    ID:='';
  end;
end;

function ConvertTitleToID3(const Title:string):TID3;
var
  tmp:string;
  offset:integer;
  function GetDivTitle:string;
  begin
    Result:='';
    while (length(Result)<=28) do begin
      if isAnkChar(byte(tmp[offset+0]))=True then begin
        Result:=Result+tmp[offset+0];
        inc(offset);
        end else begin
        Result:=Result+tmp[offset+0]+tmp[offset+1];
        inc(offset,2);
      end;
    end;
  end;
begin
  tmp:=Title+StringOfChar(' ',30*3);

  offset:=1;
  Result.Title:=GetDivTitle;
  Result.Artist:=GetDivTitle;
  Result.Album:=GetDivTitle;

  Result.Comment:='';
  Result.Year:='';
  Result.Genre:=0;
  Result.ID:='';
end;

end.
