unit _KeyDef;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,Clipbrd,_const,
  Dialogs, StdCtrls,INIFiles, ShellAPI,_KeyDef_const;

{$WARN UNIT_PLATFORM OFF}
{$WARN SYMBOL_PLATFORM OFF}

type
  TKeyDef = class
  private
    { Private 錾 }
    BaseINIFilename:string;
    procedure ExecuteDCT_MoveDefaultPath;
    procedure ExecuteDCT_ShowTitle;
    procedure ExecuteDCT_SetupMain;
    procedure ExecuteDCT_SetupDSPPlugin;
    procedure ExecuteDCT_SetupVisualEffect;
    procedure ExecuteDCT_OpenFileOutputWindow;
    procedure ExecuteDCT_OpenCatalogCompressWindow;
    procedure ExecuteDCT_EmulateTrayIcon_DoubleClick;
    procedure ExecuteDCT_EmulateTrayIcon_LeftButtonClick;
    procedure ExecuteDCT_EmulateTrayIcon_RightButtonClick;
    procedure ExecuteDCT_Network_OpenBBS;
    procedure ExecuteDCT_Network_OpenSkinUploadBBS;
    procedure ExecuteDCT_Network_OpenDataFindWindow;
    procedure ExecuteDCT_Network_OpenRankingWindow;
    procedure ExecuteDCT_Network_OpenVoteWindow;
    procedure ExecuteDCT_SoundMXDRV(i:integer);
  public
    { Public 錾 }
    Define:TDefine;
    constructor Create;
    destructor Destroy; override;
    procedure InitDefine(var Define:TDefine);
    procedure LoadDefine(var Define:TDefine;INIFilename:string);
    procedure SaveDefine(var Define:TDefine;INIFilename:string);
    function FindCommandIndexFromKey(_VK:word;_Shift:TShiftState):integer;overload;
    function FindCommandIndexFromKey(_VK:word;_Shift,_Ctrl,_Alt:boolean):integer;overload;
    procedure ExecuteCommandIndex(CommandIndex:integer);
    procedure ExecuteCommand(DCT:integer);
  end;

var
  KeyDef:TKeyDef;

implementation

uses MainWin,KeySetupWin,SetupWin,KDDWin,NetFindWin,NetRankWin,SKIDlgWin,
     NetVoteWin,VisSetupWin,WavesOutWin,CatalogCompressWin,CopyrightWin,MXDRVConfigWin,
     DX3DRap,
     _m_Tools,_MainFileCtl,_Images,_MDXWinINI,_CurrentFiles,_CSkin,_vis_const,_MDXWin_const,_Vis,
     _Func,_PCMOut,_PopupMenus,_SndDrv,_GridScroll,_GridScroll_Rap,_SndDrv_const;

constructor TKeyDef.Create;
begin
  inherited Create;

  BaseINIFilename:=ExtractFilePath(Application.ExeName)+'MDXWin.key';

  LoadDefine(Define,'');
end;

destructor TKeyDef.Destroy;
begin
  SaveDefine(Define,'');
  Define.CommandCount:=0;
  SetLength(Define.Command,Define.CommandCount);

  inherited Destroy;
end;

procedure TKeyDef.InitDefine(var Define:TDefine);
  procedure AddDCT(DCT:integer);
  begin
    with Define do begin
      SetLength(Command,CommandCount+1);
      DC_SetDefault(Command[CommandCount],DCT);
      inc(CommandCount);
    end;
  end;
begin
  Define.CommandCount:=0;
  SetLength(Define.Command,Define.CommandCount);

  AddDCT(DCT_nil);

  AddDCT(DCT_sdFadeout);
  AddDCT(DCT_sdFadeoutStop);
  AddDCT(DCT_sdPlay);
  AddDCT(DCT_sdStop);
  AddDCT(DCT_sdPause);
  AddDCT(DCT_sdSeekTop);

  AddDCT(DCT_KeyCustomize);
  AddDCT(DCT_DisableDisplay);
  AddDCT(DCT_ShowTitle);
  AddDCT(DCT_ToggleCompactMode);
  AddDCT(DCT_Minimized);
  AddDCT(DCT_ShowHelp);
  AddDCT(DCT_ShowFileMenu);
  AddDCT(DCT_ShowDriveMenu);
  AddDCT(DCT_ShowVisualMenu);
  AddDCT(DCT_ShowPlayModeMenu);
  AddDCT(DCT_OpenFileOutputWindow);
  AddDCT(DCT_OpenCatalogCompressWindow);
  AddDCT(DCT_ShowMainMenu);
  AddDCT(DCT_ShowPCMOutMenu);
  AddDCT(DCT_ReloadSKI);
  AddDCT(DCT_SelectSKI);

  AddDCT(DCT_VolumeUP);
  AddDCT(DCT_VolumeDown);
  AddDCT(DCT_TempoUP);
  AddDCT(DCT_TempoDown);
  AddDCT(DCT_LoopInc);
  AddDCT(DCT_LoopDec);

  AddDCT(DCT_PressF1);
  AddDCT(DCT_PressF2);
  AddDCT(DCT_PressF3);
  AddDCT(DCT_PressF4);
  AddDCT(DCT_PressF5);
  AddDCT(DCT_PressF6);
  AddDCT(DCT_PressF7);
  AddDCT(DCT_PressF8);
  AddDCT(DCT_PressF9);
  AddDCT(DCT_PressF10);
  AddDCT(DCT_PressF11);
  AddDCT(DCT_PressF12);

  AddDCT(DCT_Execute);
  AddDCT(DCT_MoveDirUpper);
  AddDCT(DCT_MainClose);
  AddDCT(DCT_ToWave);
  AddDCT(DCT_ToWaveAndNext);
  AddDCT(DCT_ToWaveAndAll);
  AddDCT(DCT_NextPlayNext);
  AddDCT(DCT_NextPlayBack);
  AddDCT(DCT_NextPlayMode);
  AddDCT(DCT_FilePageUP);
  AddDCT(DCT_FilePageDown);
  AddDCT(DCT_FilePageTop);
  AddDCT(DCT_FilePageEnd);
  AddDCT(DCT_MoveDefaultPath);
  AddDCT(DCT_SetFileDialog);
  AddDCT(DCT_SetFileClipboard);

  AddDCT(DCT_MuteShowMenu);
  AddDCT(DCT_MuteToggleAll);
  AddDCT(DCT_MuteSetAll);
  AddDCT(DCT_MuteResetAll);
  AddDCT(DCT_MuteCh01);
  AddDCT(DCT_MuteCh02);
  AddDCT(DCT_MuteCh03);
  AddDCT(DCT_MuteCh04);
  AddDCT(DCT_MuteCh05);
  AddDCT(DCT_MuteCh06);
  AddDCT(DCT_MuteCh07);
  AddDCT(DCT_MuteCh08);
  AddDCT(DCT_MuteCh09);
  AddDCT(DCT_MuteCh10);
  AddDCT(DCT_MuteCh11);
  AddDCT(DCT_MuteCh12);
  AddDCT(DCT_MuteCh13);
  AddDCT(DCT_MuteCh14);
  AddDCT(DCT_MuteCh15);
  AddDCT(DCT_MuteCh16);

  AddDCT(DCT_CopyPlayFilename);
  AddDCT(DCT_CopyPlayFilenameTitle);
  AddDCT(DCT_CopyPlayTitle);
  AddDCT(DCT_CopyPlayURL);
  AddDCT(DCT_CopyPlayURLTitle);
  AddDCT(DCT_CopyPlayHTMLURL);
  AddDCT(DCT_CopyPlayHTMLURLTitle);
  AddDCT(DCT_CopyPlayHTMLTitle);

  AddDCT(DCT_CopyCursorFilename);
  AddDCT(DCT_CopyCursorFilenameTitle);
  AddDCT(DCT_CopyCursorTitle);
  AddDCT(DCT_CopyCursorURL);
  AddDCT(DCT_CopyCursorURLTitle);
  AddDCT(DCT_CopyCursorHTMLURL);
  AddDCT(DCT_CopyCursorHTMLURLTitle);
  AddDCT(DCT_CopyCursorHTMLTitle);

  AddDCT(DCT_SoundRateDialog);
  AddDCT(DCT_SoundRate22050Hz);
  AddDCT(DCT_SoundRate44100Hz);
  AddDCT(DCT_SoundRate48000Hz);
  AddDCT(DCT_SoundRate96000Hz);
  AddDCT(DCT_SoundRate192000Hz);

  AddDCT(DCT_SoundWADP_Enabled);
  AddDCT(DCT_SoundWADP_Disabled);
  AddDCT(DCT_SoundWADP_RegInit);

  AddDCT(DCT_SoundMXDRV_SelectMoonlight);
  AddDCT(DCT_SoundMXDRV_SelectGORRY);
  AddDCT(DCT_SoundMXDRV_Config);

  AddDCT(DCT_SoundOutNull);
//  AddDCT(DCT_SoundOutNullSet);
  AddDCT(DCT_SoundOutWSS);
//  AddDCT(DCT_SoundOutWSSSet);
  AddDCT(DCT_SoundOutDS);
//  AddDCT(DCT_SoundOutDSSet);
  AddDCT(DCT_SoundOutASIO2);
  AddDCT(DCT_SoundOutASIO2Set);
  AddDCT(DCT_SoundOutWA);
  AddDCT(DCT_SoundOutWASet);
  AddDCT(DCT_SoundOutWAAbout);

  AddDCT(DCT_SoundSRC_Nearest);
  AddDCT(DCT_SoundSRC_Liner);
  AddDCT(DCT_SoundSRC_Spline);

  AddDCT(DCT_SetupMain);
  AddDCT(DCT_SetupDSPPlugin);
  AddDCT(DCT_SetupNetwork);
  AddDCT(DCT_SetupVisualEffect);
  AddDCT(DCT_SetupCompactShowFile);
  AddDCT(DCT_SetupCompactWithMain);

  AddDCT(DCT_mdxoInstall);
  AddDCT(DCT_mdxoUninstall);
  AddDCT(DCT_mdxoReference);

  AddDCT(DCT_SetVisMode_Keyboard);
  AddDCT(DCT_SetVisMode_Sonar);
  AddDCT(DCT_SetVisMode_MDXDis);
  AddDCT(DCT_SetVisMode_Wire);
  AddDCT(DCT_SetVisMode_Wave);
  AddDCT(DCT_SetVisMode_Fly);
  AddDCT(DCT_SetVisMode_Pool);
  AddDCT(DCT_SetVisMode_Box);
  AddDCT(DCT_SetVisMode_Rain);

  AddDCT(DCT_SetVisMode_FillCopy);
  AddDCT(DCT_SetVisMode_FillReduction);
  AddDCT(DCT_SetVisMode_FillShade);

  AddDCT(DCT_SetPlayMode_Single);
  AddDCT(DCT_SetPlayMode_ALL);
  AddDCT(DCT_SetPlayMode_ALLRepeat);
  AddDCT(DCT_SetPlayMode_Random);
  AddDCT(DCT_SetPlayMode_None);

  AddDCT(DCT_EmulateTrayIcon_DoubleClick);
  AddDCT(DCT_EmulateTrayIcon_LeftButtonClick);
  AddDCT(DCT_EmulateTrayIcon_RightButtonClick);

  AddDCT(DCT_Network_StartOnlineUpdate);
  AddDCT(DCT_Network_ToggleAutoOnlineUpdate);
  AddDCT(DCT_Network_SelectMirrorServer);
  AddDCT(DCT_Network_OpenBBS);
  AddDCT(DCT_Network_OpenSkinUploadBBS);
  AddDCT(DCT_Network_OpenDataFindWindow);
  AddDCT(DCT_Network_OpenRankingWindow);
  AddDCT(DCT_Network_OpenVoteWindow);
end;

procedure TKeyDef.LoadDefine(var Define:TDefine;INIFilename:string);
var
  INI:TMemINIFile;
  cnt:integer;
  res:integer;
begin
  if INIFilename='' then INIFilename:=BaseINIFilename;

  InitDefine(Define);

  INI:=TMemINIFile.Create(INIFilename);

  for cnt:=0 to Define.CommandCount-1 do begin
    with Define.Command[cnt] do begin
      res:=INI.ReadInteger('KeyDef0',Name,0);
      if res<>0 then begin
        VK:=word(res and $ffff);
        if (res and (1 shl 16))=0 then
          Shift:=False
          else
          Shift:=True;
        if (res and (1 shl 17))=0 then
          Ctrl:=False
          else
          Ctrl:=True;
        if (res and (1 shl 18))=0 then
          Alt:=False
          else
          Alt:=True;
      end;
    end;
  end;

  INI.Free;
end;

procedure TKeyDef.SaveDefine(var Define:TDefine;INIFilename:string);
var
  INI:TextFile;
  cnt:integer;
  res:integer;
  Section,LastSection:string;
  procedure WriteValue(Ident:string;Value:string);
  begin
    if LastSection<>Section then begin
      LastSection:=Section;
      Writeln(INI,'['+Section+']');
    end;
    Writeln(INI,Ident+'='+Value);
  end;
  procedure WriteString(Ident:string;Value:string);
  begin
    WriteValue(Ident,Value);
  end;
  procedure WriteInteger(Ident:string;Value:integer);
  begin
    WriteValue(Ident,inttostr(Value));
  end;
  procedure WriteBool(Ident:string;Value:boolean);
  begin
    if Value=True then begin
      WriteValue(Ident,'1');
      end else begin
      WriteValue(Ident,'0');
    end;
  end;
begin
  LastSection:='';

  if INIFilename='' then INIFilename:=BaseINIFilename;

  DeleteFile(INIFilename);
  AssignFile(INI,INIFilename);
  Rewrite(INI);

  Section:='KeyDef0';
  for cnt:=0 to Define.CommandCount-1 do begin
    with Define.Command[cnt] do begin
      res:=VK;
      if Shift=True then res:=res+(1 shl 16);
      if Ctrl=True then res:=res+(1 shl 17);
      if Alt=True then res:=res+(1 shl 18);
      WriteInteger(Name,res);
    end;
  end;

  CloseFile(INI);
end;

function TKeyDef.FindCommandIndexFromKey(_VK:word;_Shift:TShiftState):integer;
var
  Shift,Ctrl,Alt:boolean;
begin
  Shift:=ssShift in _Shift;
  Ctrl:=ssCtrl in _Shift;
  Alt:=ssAlt in _Shift;
  Result:=FindCommandIndexFromKey(_VK,Shift,Ctrl,Alt);
end;

function TKeyDef.FindCommandIndexFromKey(_VK:word;_Shift,_Ctrl,_Alt:boolean):integer;
var
  cnt:integer;
begin
  Result:=-1;
  if _VK=0 then exit;

  for cnt:=0 to Define.CommandCount-1 do begin
    with Define.Command[cnt] do begin
      if (VK=_VK) and (Shift=_Shift) and (Ctrl=_Ctrl) and (Alt=_Alt) then begin
        Result:=cnt;
        exit;
      end;
    end;
  end;
end;

procedure TKeyDef.ExecuteCommandIndex(CommandIndex:integer);
begin
  if CommandIndex<0 then exit;
  if Define.CommandCount<=CommandIndex then exit;

  ExecuteCommand(Define.Command[CommandIndex].DCT);
end;

procedure TKeyDef.ExecuteCommand(DCT:integer);
var
  Filename:string;
  e:boolean;
  procedure ExecuteSoundRateDialog;
  var
    FreqStr:string;
    v:integer;
  begin
    FreqStr:=inttostr(Main.NowDSoundRate);
    if InputQuery('gύX_CAO','ύXg͂ĉB',FreqStr)=True then begin
      v:=strtointdef(FreqStr,0);
      if v<2400 then begin
        ShowMessage('͂ꂽgُłB2400HzȏŎw肵ĉB');
        end else begin
        sdChangeRate(v,PCMOut_Already,'');
        Main.PCMOutMenuCallback;
      end;
    end;
  end;
  procedure ExecuteSoundRate(rate:integer);
  begin
    if (Main.NowUseDSound=PCMOut_WindowsSound) and (rate>55555) then begin
      ShowMessage('WindowsSoundSystem55kHz𒴂Đ͂ł܂B');
      exit;
    end;
    if (Main.NowUseDSound=PCMOut_DirectSound) and (rate>96000) then begin
      ShowMessage('96kHz𒴂ĐASIOhCogȊOɕ@͖悤ȋC܂c');
      exit;
    end;
    sdChangeRate(rate,PCMOut_Already,'');
    Main.PCMOutMenuCallback;
  end;
  procedure ExecuteSoundDevice(dev:integer);
  begin
    if (dev=PCMOut_WindowsSound) and (Main.NowDSoundRate>55555) then begin
      ShowMessage('WindowsSoundSystem55kHzȏ̍Đ͂ł܂B');
      exit;
    end;
    if (dev=PCMOut_DirectSound) and (Main.NowDSoundRate>96000) then begin
      ShowMessage('96kHz𒴂ĐASIOhCogȊOɕ@͖悤ȋC܂c');
      exit;
    end;
    if (dev=PCMOut_WinAMPOutput) and (MainINI.WAO_DLLName='') then begin
      ShowMessage('DLLIĂ܂B܂gpWinAMPPluginDLLw肵ĉB');
      exit;
    end;
    sdChangeRate(0,dev,'');
    Main.PCMOutMenuCallback;
  end;
  procedure ExecuteSoundDeviceSet(dev:integer);
  begin
    case dev of
      PCMOut_Null: begin end;
      PCMOut_WindowsSound: begin end;
      PCMOut_DirectSound: begin end;
      PCMOut_ASIO: begin
        sdStop;
        sdASIO_OpenSetting;
        sdChangeRate(0,PCMOut_ASIO,'');
        Main.PCMOutMenuCallback;
      end;
      PCMOut_WinAMPOutput: begin
        PCMOut.WAOUT_ShowConfig(MainINI.WAO_DLLName);
        Main.PCMOutMenuCallback;
      end;
    end;
  end;
  procedure ExecuteSetVisMode(vm:integer);
  begin
    if vm=VisualModeMDXDis then begin
      Main.InfomationVisible('BWA[h[MDXDis]͍폜܂B');
      exit;
    end;
    Main.SetVisMode(vm);
  end;
  procedure ExecuteSetPlayMode(pm:integer);
  begin
    MainINI.PlayMode:=pm;
    Main.PlayButtonsCallback;
  end;
begin
  if Application.Title='MDXClose' then exit;
  if Main.goEtcWindowFlag=True then exit;
  if Main.FilereadBusyFlag=True then exit;
  if Main.Visible=False then exit;

  case DCT of
    DCT_nil: begin end;
    DCT_sdFadeout: sdStartFadeout;
    DCT_sdFadeoutStop: sdRequestFadeoutStop;
    DCT_sdPlay: begin
      if sdGetPlay=True then begin
        sdTogglePause;
        end else begin
        Filename:=CurrentFiles.GetItemName(CurrentFiles.GetPlayIndex);
        if Filename<>'' then MainFileCtl.ExecutePlayFile(Filename,False);
      end;
    end;
    DCT_sdStop: sdStop;
    DCT_sdPause: sdTogglePause;
    DCT_sdSeekTop: if sdGetPlay=True then sdSeek(0);

    DCT_KeyCustomize: begin
      if KeySetup=nil then begin
        Application.CreateForm(TKeySetup, KeySetup);
      end;
      KeySetup.Init;
    end;
    DCT_DisableDisplay: begin
      e:=not sdGetQuietMode;
      sdSetQuietMode(e);
      Func.SetItemEnabled(FuncNo_F6,e);
      Func.Draw;
      Vis.ClearImage;
    end;
    DCT_ShowTitle: ExecuteDCT_ShowTitle;
    DCT_ToggleCompactMode: Main.TitleBarScroll;
    DCT_Minimized: Main.TrayIconDblClick(nil);
    DCT_ShowHelp: begin
      if FileExists(StartPath+'MDXWin.html')=False then begin
        ShowMessage('ICHTMLwvt@C܂łB');
        end else begin
        sdStop;
        ShellExecute(0,'',PChar(StartPath+'MDXWin.html'),nil, nil,SW_SHOW);
      end;
    end;
    DCT_ShowFileMenu: PopupMenus.FileMenu_Popup;
    DCT_ShowDriveMenu: Main.DriveMenu_Popup;
    DCT_ShowVisualMenu: PopupMenus.VisualMenu_Popup;
    DCT_ShowPlayModeMenu: PopupMenus.PlayModeMenu_Popup;
    DCT_OpenFileOutputWindow: ExecuteDCT_OpenFileOutputWindow;
    DCT_OpenCatalogCompressWindow: ExecuteDCT_OpenCatalogCompressWindow;
    DCT_ShowMainMenu: PopupMenus.MainMenu_Popup;
    DCT_ShowPCMOutMenu: PopupMenus.PCMOutMenu_Popup;
    DCT_ReloadSKI: Main.ReloadSkin('');
    DCT_SelectSKI: begin
      Application.CreateForm(TSKIDlg, SKIDlg);
      Main.SKIOpenDlg.FileName:=MainINI.SKIFilename;
      Main.SKIOpenDlg.InitialDir:=ExtractFilePath(Main.SKIOpenDlg.FileName);
      if Main.SKIOpenDlg.Execute=True then begin
        Main.ReloadSkin(Main.SKIOpenDlg.FileName);
      end;
      SKIDlg.Release;
    end;

    DCT_VolumeUP: begin
      sdSetTotalVolume(sdGetTotalVolume+128);
      Main.VolumeBarImgRefresh;
      Main.FormPaintVolumeTempo;
    end;
    DCT_VolumeDown: begin
      sdSetTotalVolume(sdGetTotalVolume-128);
      Main.VolumeBarImgRefresh;
      Main.FormPaintVolumeTempo;
    end;
    DCT_TempoUP: if sdGetTransTempo<>16 then Main.TempoBarImgRefresh(16);
    DCT_TempoDown: if sdGetTransTempo<>-16 then Main.TempoBarImgRefresh(-16);
    DCT_LoopInc: Main.ChangeLoopMax(1);
    DCT_LoopDec: Main.ChangeLoopMax(-1);

    DCT_PressF1: KeyDef.ExecuteCommand(DCT_ShowDriveMenu);
    DCT_PressF2: KeyDef.ExecuteCommand(DCT_sdPlay);
    DCT_PressF3: KeyDef.ExecuteCommand(DCT_sdStop);
    DCT_PressF4: KeyDef.ExecuteCommand(DCT_ShowPlayModeMenu);
    DCT_PressF5: KeyDef.ExecuteCommand(DCT_ShowPCMOutMenu);
    DCT_PressF6: KeyDef.ExecuteCommand(DCT_DisableDisplay);
    DCT_PressF7: KeyDef.ExecuteCommand(DCT_ShowVisualMenu);
    DCT_PressF8: KeyDef.ExecuteCommand(DCT_OpenFileOutputWindow);
    DCT_PressF9: KeyDef.ExecuteCommand(DCT_SetupMain);
    DCT_PressF10: KeyDef.ExecuteCommand(DCT_ShowMainMenu);
    DCT_PressF11: KeyDef.ExecuteCommand(DCT_SetupNetwork);
    DCT_PressF12: begin end;

    DCT_Execute: Main.FileGridDblClick(nil);
    DCT_MoveDirUpper: MainFileCtl.MoveDirToUpper;
    DCT_MainClose: Main.Close;
    DCT_ToWave: MainFileCtl.ToWavesOut(False,False);
    DCT_ToWaveAndNext: MainFileCtl.ToWavesOut(False,True);
    DCT_ToWaveAndAll: MainFileCtl.ToWavesOut(True,False);
    DCT_NextPlayNext: MainFileCtl.NextPlay(1);
    DCT_NextPlayBack: MainFileCtl.NextPlay(-1);
    DCT_NextPlayMode: MainFileCtl.NextPlay(0);
    DCT_FilePageUP: CurrentFiles.RollKey(-1,[]);
    DCT_FilePageDown: CurrentFiles.RollKey(1,[]);
    DCT_FilePageTop: CurrentFiles.SetCursorIndex(0);
    DCT_FilePageEnd: CurrentFiles.SetCursorIndex(CurrentFiles.GetItemsCount-1);
    DCT_MoveDefaultPath: ExecuteDCT_MoveDefaultPath;
    DCT_SetFileDialog: begin
      Main.goEtcWindowFlag:=True;
      MainFileCtl.MM_SetFilenameDialog('');
      Main.goEtcWindowFlag:=False;
    end;
    DCT_SetFileClipboard: begin
      Main.goEtcWindowFlag:=True;
      MainFileCtl.MM_SetFilenameDialog(ClipBoard.AsText);
      Main.goEtcWindowFlag:=False;
    end;

    DCT_MuteShowMenu: PopupMenus.MuteMenu_Popup;
    DCT_MuteToggleAll: sdToggleAllMute;
    DCT_MuteSetAll:    sdSetAllMute(True);
    DCT_MuteResetAll:  sdSetAllMute(False);
    DCT_MuteCh01: sdToggleMute(0);
    DCT_MuteCh02: sdToggleMute(1);
    DCT_MuteCh03: sdToggleMute(2);
    DCT_MuteCh04: sdToggleMute(3);
    DCT_MuteCh05: sdToggleMute(4);
    DCT_MuteCh06: sdToggleMute(5);
    DCT_MuteCh07: sdToggleMute(6);
    DCT_MuteCh08: sdToggleMute(7);
    DCT_MuteCh09: sdToggleMute(8);
    DCT_MuteCh10: sdToggleMute(9);
    DCT_MuteCh11: sdToggleMute(10);
    DCT_MuteCh12: sdToggleMute(11);
    DCT_MuteCh13: sdToggleMute(12);
    DCT_MuteCh14: sdToggleMute(13);
    DCT_MuteCh15: sdToggleMute(14);
    DCT_MuteCh16: sdToggleMute(15);

    DCT_CopyPlayFilename:      MainFileCtl.PlayToClipboard(True,False,False,False);
    DCT_CopyPlayFilenameTitle: MainFileCtl.PlayToClipboard(True,True,False,False);
    DCT_CopyPlayTitle:         MainFileCtl.PlayToClipboard(False,True,False,False);
    DCT_CopyPlayURL:           MainFileCtl.PlayToClipboard(True,False,True,False);
    DCT_CopyPlayURLTitle:      MainFileCtl.PlayToClipboard(True,True,True,False);
    DCT_CopyPlayHTMLURL:       MainFileCtl.PlayToClipboard(True,False,True,True);
    DCT_CopyPlayHTMLURLTitle:  MainFileCtl.PlayToClipboard(True,True,True,True);
    DCT_CopyPlayHTMLTitle:     MainFileCtl.PlayToClipboard(False,True,True,True);

    DCT_copyCursorFilename:      MainFileCtl.CursorToClipboard(True,False,False,False);
    DCT_copyCursorFilenameTitle: MainFileCtl.CursorToClipboard(True,True,False,False);
    DCT_copyCursorTitle:         MainFileCtl.CursorToClipboard(False,True,False,False);
    DCT_copyCursorURL:           MainFileCtl.CursorToClipboard(True,False,True,False);
    DCT_copyCursorURLTitle:      MainFileCtl.CursorToClipboard(True,True,True,False);
    DCT_copyCursorHTMLURL:       MainFileCtl.CursorToClipboard(True,False,True,True);
    DCT_copyCursorHTMLURLTitle:  MainFileCtl.CursorToClipboard(True,True,True,True);
    DCT_copyCursorHTMLTitle:     MainFileCtl.CursorToClipboard(False,True,True,True);

    DCT_SoundRateDialog:   ExecuteSoundRateDialog;
    DCT_SoundRate22050Hz:  ExecuteSoundRate(22050);
    DCT_SoundRate44100Hz:  ExecuteSoundRate(44100);
    DCT_SoundRate48000Hz:  ExecuteSoundRate(48000);
    DCT_SoundRate96000Hz:  ExecuteSoundRate(96000);
    DCT_SoundRate192000Hz: ExecuteSoundRate(192000);

    DCT_SoundWADP_Enabled: begin
      MainINI.WADSPEnabled:=True;
      sdCreateWADSPPlugin(Main.Handle);
    end;
    DCT_SoundWADP_Disabled: begin
      MainINI.WADSPEnabled:=False;
      sdFreeWADSPPlugin;
    end;
    DCT_SoundWADP_RegInit: begin
      MainINI.WADSPRegInit:=True;
      if MainINI.WADSPEnabled=True then sdCreateWADSPPlugin(Main.Handle);
    end;

    DCT_SoundMXDRV_SelectMoonlight: ExecuteDCT_SoundMXDRV(0);
    DCT_SoundMXDRV_SelectGORRY: ExecuteDCT_SoundMXDRV(1);
    DCT_SoundMXDRV_Config: ExecuteDCT_SoundMXDRV(2);

    DCT_SoundOutNull:     ExecuteSoundDevice(PCMOut_Null);
    DCT_SoundOutNullSet:  ExecuteSoundDeviceSet(PCMOut_Null);
    DCT_SoundOutWSS:      ExecuteSoundDevice(PCMOut_WindowsSound);
    DCT_SoundOutWSSSet:   ExecuteSoundDeviceSet(PCMOut_WindowsSound);
    DCT_SoundOutDS:       ExecuteSoundDevice(PCMOut_DirectSound);
    DCT_SoundOutDSSet:    ExecuteSoundDeviceSet(PCMOut_DirectSound);
    DCT_SoundOutASIO2:    ExecuteSoundDevice(PCMOut_ASIO);
    DCT_SoundOutASIO2Set: ExecuteSoundDeviceSet(PCMOut_ASIO);
    DCT_SoundOutWA:       ExecuteSoundDevice(PCMOut_WinAMPOutput);
    DCT_SoundOutWASet:    ExecuteSoundDeviceSet(PCMOut_WinAMPOutput);
    DCT_SoundOutWAAbout:  begin
      PCMOut.WAOUT_ShowAbout(MainINI.WAO_DLLName);
      Main.PCMOutMenuCallback;
    end;

    DCT_SoundSRC_Nearest: MainINI.UseSRCMode:=SRCMode_Nearest;
    DCT_SoundSRC_Liner: MainINI.UseSRCMode:=SRCMode_Liner;
    DCT_SoundSRC_Spline: MainINI.UseSRCMode:=SRCMode_Spline;

    DCT_SetupMain: ExecuteDCT_SetupMain;
    DCT_SetupDSPPlugin: ExecuteDCT_SetupDSPPlugin;
    DCT_SetupNetwork: PopupMenus.NetworkMenu_Popup;
    DCT_SetupVisualEffect: ExecuteDCT_SetupVisualEffect;
    DCT_SetupCompactShowFile: begin
      MainINI.CompactWindowFlortEnabled:=not MainINI.CompactWindowFlortEnabled;
      Main.SetCompactWindow;
    end;
    DCT_SetupCompactWithMain: begin
      MainINI.CompactWindowFlortDockMain:=not MainINI.CompactWindowFlortDockMain;
      Main.SetCompactWindow;
    end;

    DCT_mdxoInstall: MainFileCtl.mdxo_Registry(True);
    DCT_mdxoUninstall: MainFileCtl.mdxo_Registry(False);
    DCT_mdxoReference: MainFileCtl.mdxo_OpenReference;

    DCT_SetVisMode_Keyboard:  ExecuteSetVisMode(VisualModeKeyboard);
    DCT_SetVisMode_Sonar:  ExecuteSetVisMode(VisualModeSonar);
    DCT_SetVisMode_MDXDis:  ExecuteSetVisMode(VisualModeMDXDis);
    DCT_SetVisMode_Wire:  ExecuteSetVisMode(VisualModeWire);
    DCT_SetVisMode_Wave:  ExecuteSetVisMode(VisualModeWave);
    DCT_SetVisMode_Fly:  ExecuteSetVisMode(VisualModeFly);
    DCT_SetVisMode_Pool:  ExecuteSetVisMode(VisualModePool);
    DCT_SetVisMode_Box:  ExecuteSetVisMode(VisualModeBox);
    DCT_SetVisMode_Rain:  ExecuteSetVisMode(VisualModeRain);

    DCT_SetVisMode_FillCopy: Main.DDBlurMode:=DDBlurModeCopy;
    DCT_SetVisMode_FillReduction: Main.DDBlurMode:=DDBlurModeReduction;
    DCT_SetVisMode_FillShade: Main.InfomationVisible('VF[hu[͖łB');

    DCT_SetPlayMode_Single: ExecuteSetPlayMode(PlayMode_Single);
    DCT_SetPlayMode_ALL: ExecuteSetPlayMode(PlayMode_ALL);
    DCT_SetPlayMode_ALLRepeat: ExecuteSetPlayMode(PlayMode_ALLRepeat);
    DCT_SetPlayMode_Random: ExecuteSetPlayMode(PlayMode_Random);
    DCT_SetPlayMode_None: ExecuteSetPlayMode(PlayMode_None);

    DCT_EmulateTrayIcon_DoubleClick: ExecuteDCT_EmulateTrayIcon_DoubleClick;
    DCT_EmulateTrayIcon_LeftButtonClick: ExecuteDCT_EmulateTrayIcon_LeftButtonClick;
    DCT_EmulateTrayIcon_RightButtonClick: ExecuteDCT_EmulateTrayIcon_RightButtonClick;

    DCT_Network_StartOnlineUpdate: Main.Network.StartOnlineUpdate(False);
    DCT_Network_ToggleAutoOnlineUpdate: MainINI.MDXOnlineAutoUpdate:=not MainINI.MDXOnlineAutoUpdate;
    DCT_Network_SelectMirrorServer: begin
      Main.goEtcWindowFlag:=True;
      Main.HTTPSocket.SelectMirrorServer('ڑ~[T[oIĂB');
      Main.goEtcWindowFlag:=False;
    end;
    DCT_Network_OpenBBS: ExecuteDCT_Network_OpenBBS;
    DCT_Network_OpenSkinUploadBBS: ExecuteDCT_Network_OpenSkinUploadBBS;
    DCT_Network_OpenDataFindWindow: ExecuteDCT_Network_OpenDataFindWindow;
    DCT_Network_OpenRankingWindow: ExecuteDCT_Network_OpenRankingWindow;
    DCT_Network_OpenVoteWindow: ExecuteDCT_Network_OpenVoteWindow;
  end;
end;

procedure TKeyDef.ExecuteDCT_MoveDefaultPath;
var
  path:string;
begin
  path:=MainINI.DefPath;
  if path[length(path)]<>'\' then path:=path+'\';
  if DirectoryExists(path)=True then begin
    MainFileCtl.ExecutePlayFile(path,False);
    end else begin
    ShowMessage(path+' ݂܂B');
  end;
end;

procedure TKeyDef.ExecuteDCT_ShowTitle;
begin
  dx3dSetVisible(False);

  Main.goEtcWindowFlag:=True;
  sdLoadDLL_MXDRV;
  sdLoadDLL_FMP;
  sdLoadDLL_PMD;
  sdLoadDLL_SPC;
  Application.CreateForm(TCopyright, Copyright);
  Copyright.RefreshCopyright;
  Copyright.ShowModal;
  Copyright.Release;
  Main.goEtcWindowFlag:=False;

  dx3dSetVisible(True);
end;

procedure TKeyDef.ExecuteDCT_SetupMain;
begin
  sdStop;

  dx3dSetVisible(False);
  Vis.ClearImage;
  if Main.KDDLoaded=True then KDD.Visible:=False;
  if Main.NetFindLoaded=True then NetFind.Visible:=False;
  if Main.NetRankLoaded=True then NetRank.Visible:=False;
  if Main.NetVoteLoaded=True then NetVote.Visible:=False;

  sdSetDriverMode(DriverModeUnknown);

  Main.goEtcWindowFlag:=True;
  Application.CreateForm(TSetup, Setup);
  Setup.SetCreate;
  Setup.ShowModal;
  Setup.Release;
  Main.goEtcWindowFlag:=False;

  dx3dSetVisible(True);

  Main.ReflectionMainSetting;
end;

procedure TKeyDef.ExecuteDCT_SetupDSPPlugin;
begin
  if MainINI.WADSPEnabled=False then begin
    ShowMessage('WinAMP/DSPvOC[h悤ɐݒ肳Ă܂B'+CRLF+'SetupEBhENɓǂݍނ悤ɐݒ肵ĂB');
    exit;
  end;

  if WADSPPluginLoaded=True then begin
    WADSPPlugin.ShowConfig;
    end else begin
    ShowMessage('WinAMP/DSPvOCCXg[Ă܂B');
  end;
end;

procedure TKeyDef.ExecuteDCT_SetupVisualEffect;
begin
  dx3dSetVisible(False);

  Main.goEtcWindowFlag:=True;
  Application.CreateForm(TVisSetup, VisSetup);
  VisSetup.SetCreate;
  VisSetup.ShowModal;
  VisSetup.Release;
  Main.goEtcWindowFlag:=False;

  dx3dSetVisible(True);
end;

procedure TKeyDef.ExecuteDCT_OpenFileOutputWindow;
begin
  if Main.WavesFormLoaded=False then begin
    Main.WavesFormLoaded:=True;
    Application.CreateForm(TWavesOut, WavesOut);
    WavesOut.Visible:=True;
    end else begin
    if WavesOut.Visible=True then WavesOut.Visible:=False;
    WavesOut.Visible:=True;
  end;
end;

procedure TKeyDef.ExecuteDCT_OpenCatalogCompressWindow;
begin
  dx3dSetVisible(False);

  Main.goEtcWindowFlag:=True;
  Application.CreateForm(TCatalogCompress, CatalogCompress);
  CatalogCompress.Init(Main.Catalog.GetIndexFilename,Main.Catalog.GetDataFilename);
  CatalogCompress.ShowModal;
  CatalogCompress.Release;
  Main.Catalog.LoadIndex;
  Main.goEtcWindowFlag:=False;

  dx3dSetVisible(True);
end;

procedure TKeyDef.ExecuteDCT_EmulateTrayIcon_DoubleClick;
begin
  if Main.TrayIcon=nil then exit;

  if IsIconic(Application.Handle)=True then begin
    Application.Restore;
    ShowWindow(Application.Handle, SW_HIDE);
    SetForegroundWindow(Main.Handle);
    SetActiveWindow(Main.Handle);
    end else begin
    Application.Minimize;
    ShowWindow(Application.Handle, SW_HIDE);
  end;
end;

procedure TKeyDef.ExecuteDCT_EmulateTrayIcon_LeftButtonClick;
begin
  if Main.TrayIcon=nil then exit;

  if IsIconic(Application.Handle)=False then begin
    SetForegroundWindow(Main.Handle);
    SetActiveWindow(Main.Handle);
  end;
end;

procedure TKeyDef.ExecuteDCT_EmulateTrayIcon_RightButtonClick;
begin
  if Main.TrayIcon=nil then exit;

  KeyDef.ExecuteCommand(DCT_EmulateTrayIcon_LeftButtonClick);
  KeyDef.ExecuteCommand(DCT_ShowMainMenu);
end;

procedure TKeyDef.ExecuteDCT_Network_OpenBBS;
var
  Filename:string;
begin
  if Main.Network.NetworkEnable=True then begin
    Filename:=Main.Network.CFG.BBSURL;
    end else begin
    Filename:='';
  end;

  if Filename='' then begin
    ShowMessage('f̃AhX_E[hł܂łB');
    end else begin
    sdStop;
    ShellExecute(0,'',PChar(Filename),nil, nil,SW_SHOW);
  end;
end;

procedure TKeyDef.ExecuteDCT_Network_OpenSkinUploadBBS;
var
  Filename:string;
begin
  if Main.Network.NetworkEnable=True then begin
    Filename:=Main.Network.CFG.SkinUploadBBSURL;
    end else begin
    Filename:='';
  end;

  if Filename='' then begin
    ShowMessage('XLAbv[hf̃AhX_E[hł܂łB');
    end else begin
    sdStop;
    ShellExecute(0,'',PChar(Filename),nil, nil,SW_SHOW);
  end;
end;

procedure TKeyDef.ExecuteDCT_Network_OpenDataFindWindow;
begin
  if Main.NetFindLoaded=False then begin
    Main.NetFindLoaded:=True;
    Application.CreateForm(TNetFind, NetFind);
    NetFind.InitialStart;
    end else begin
    if NetFind.Visible=True then begin
      NetFind.Visible:=False;
      end else begin
      NetFind.InitialStart;
    end;
    NetFind.Visible:=True;
  end;
end;

procedure TKeyDef.ExecuteDCT_Network_OpenRankingWindow;
begin
  if Main.NetRankLoaded=False then begin
    Main.NetRankLoaded:=True;
    Application.CreateForm(TNetRank, NetRank);
    NetRank.Init;
    end else begin
    if NetRank.Visible=True then begin
      NetRank.Visible:=False;
      end else begin
      NetRank.Init;
    end;
    NetRank.Visible:=True;
  end;
end;

procedure TKeyDef.ExecuteDCT_Network_OpenVoteWindow;
begin
  if Main.NetVoteLoaded=False then begin
    Main.NetVoteLoaded:=True;
    Application.CreateForm(TNetVote, NetVote);
    NetVote.Init;
    end else begin
    if NetVote.Visible=True then begin
      NetVote.Visible:=False;
      end else begin
      NetVote.Init;
    end;
    NetVote.Visible:=True;
  end;
end;

procedure TKeyDef.ExecuteDCT_SoundMXDRV(i:integer);
begin
  sdSetDriverMode(DriverModeUnknown);
  if MXDRVLoadFlag=True then begin
    if MXDRVm<>nil then begin
      MXDRVm.FreeMemory;
      MXDRVm.Free;
      MXDRVm:=nil;
    end;
    if MXDRVg<>nil then begin
      MXDRVg.FreeMemory;
      MXDRVg.Free;
      MXDRVg:=nil;
    end;
    MXDRVLoadFlag:=False;
  end;

  case i of
    0: MXDRVgINI.Enabled:=False;
    1: MXDRVgINI.Enabled:=True;
    2: begin
      dx3dSetVisible(False);

      Main.goEtcWindowFlag:=True;
      Application.CreateForm(TMXDRVConfig, MXDRVConfig);
      MXDRVConfig.SetCreate;
      MXDRVConfig.ShowModal;
      MXDRVConfig.Release;
      MXDRVConfig:=nil;
      Main.goEtcWindowFlag:=False;

      dx3dSetVisible(True);
    end;
  end;
end;

end.

