unit _MDXDis;

interface

uses
  Windows,SysUtils;

type
  TMDXDisCmd=array[0..5] of byte;
  TMDXDisData=record
    Offset:integer;
    Cmd:array[0..5] of byte;
    len:integer;
    mes:string;
  end;

procedure MDXDisAnalyze(var MDXDisData:TMDXDisData);

implementation

procedure MDXDisAnalyze(var MDXDisData:TMDXDisData);
begin
  with MDXDisData do begin
    len:=0;
    mes:='';

    if Cmd[0]<=$7f then begin // Rest offing
      len:=0;
      mes:='Noteoff Clock='+IntToStr(Cmd[0]+1);
      exit;
    end;

    if ($80<=Cmd[0]) and (Cmd[0]<=$df) then begin // Set Noteon
      len:=1;
      mes:='Noteon Clock='+IntToStr(Cmd[1]);
      exit;
    end;

    case Cmd[0] of
      $ff: begin // Set Tempo
        len:=1;
        mes:='SetTempo Timer-B='+IntToStr(Cmd[1]);
      end;
      $fe: begin // Set OPM Register
        len:=2;
        mes:='y'+IntToStr(Cmd[1])+','+IntToStr(Cmd[2]);
      end;
      $fd: begin // Set VoiceNo.
        len:=1;
        mes:='SetVoice @'+IntToStr(Cmd[1]);
      end;
      $fc: begin // Set Panpot
        len:=1;
        mes:='SetPanpot '+IntToStr(Cmd[1]);
      end;
      $fb: begin // Set Volume
        len:=1;
        mes:='SetVolume '+IntToStr(Cmd[1]);
      end;
      $fa: begin // Downto Volume
        len:=0;
        mes:='DowntoVolume';
      end;
      $f9: begin // Upto Volume
        len:=0;
        mes:='UptoVolume';
      end;
      $f8: begin // Set Pronounce Percent
        len:=1;
        mes:='Q'+IntToStr(Cmd[1]);
      end;
      $f7: begin // Disable Keyoff
        len:=0;
        mes:='Disable Keyoff';
      end;
      $f6: begin // Start Repert
        len:=2;
        mes:='Start Repert Loop:'+IntToStr(Cmd[1]);
      end;
      $f5: begin // End Repert
        len:=2;
        mes:='End Repert Jumpto:-'+IntToStr(dword($FFFF)-dword(dword(Cmd[1])*$100+dword(Cmd[2]))-1);
      end;
      $f4: begin // Exit Repert
        len:=2;
        mes:='End Repert Jumpto:'+IntToStr(dword(Cmd[1])*$100+dword(Cmd[2])+4);
      end;
      $f3: begin // Set Detune
        len:=2;
        mes:='SetDetune '+IntToStr(SmallInt(dword(Cmd[1])*$100+Cmd[2]));
      end;
      $f2: begin // Set Portament
        len:=2;
        mes:='SetPortament '+IntToStr(SmallInt(dword(Cmd[1])*$100+Cmd[2]));
      end;
      $f1: begin // End of data
        len:=2;
        mes:='End of data Jumpto:-'+IntToStr(dword($FFFF)-(dword(Cmd[1])*$100+dword(Cmd[2]))-1);
      end;
      $f0: begin // Set Keyon Delay
        len:=1;
        mes:='SetKeyonDelay Clock:'+IntToStr(Cmd[1]);
      end;
      $ef: begin // Send Adjust Signal
        len:=1;
        mes:='SendAdjustSignal Ch:'+IntToStr(Cmd[1]);
      end;
      $ee: begin // Waiting Adjust Signal
        len:=0;
        mes:='WaitingAdjustSignal';
      end;
      $ed: begin // Set Noize Frequency // Supported Ch.H only
        len:=1;
        mes:='SetNoizeFreq '+IntToStr(Cmd[1]);
      end;
      $ec: begin // Set Tone LFO
        case Cmd[1] of
          $80: begin
            len:=1;
            mes:='ToneLFO OFF';
          end;
          $81: begin
            len:=1;
            mes:='ToneLFO ON';
          end;
          else begin
            len:=5;
            mes:='SetToneLFO '+format('$%2x,%2x%2x,%2x%2x',[Cmd[1],Cmd[2],Cmd[3],Cmd[4],Cmd[5]]);
          end;
        end;
      end;
      $eb: begin // Set Volume LFO
        case Cmd[1] of
          $80: begin
            len:=1;
            mes:='VolumeLFO OFF';
          end;
          $81: begin
            len:=1;
            mes:='VolumeLFO ON';
          end;
          else begin
            len:=5;
            mes:='SetVolumeLFO '+format('$%2x,%2x%2x,%2x%2x',[Cmd[1],Cmd[2],Cmd[3],Cmd[4],Cmd[5]]);
          end;
        end;
      end;
      $ea: begin // Set OPM LFO
        case Cmd[1] of
          $80: begin
            len:=1;
            mes:='OPMLFO OFF';
          end;
          $81: begin
            len:=1;
            mes:='OPMLFO ON';
          end;
          else begin
            len:=5;
            mes:='SetOPMLFO '+format('$%2x,%2x,%2x,%2x,%2x',[Cmd[1],Cmd[2],Cmd[3],Cmd[4],Cmd[5]]);
          end;
        end;
      end;
      $e9: begin // Set LFO Delay
        len:=1;
        mes:='SetLFODelay Clock:'+IntToStr(Cmd[1]);
      end;
      $e8: begin // Set Expanded PCM8 Mode
        len:=0;
        mes:='Expanded PCM8';
      end;
      $e7: begin // Start Fadeout
        case Cmd[1] of
          $00: begin
            len:=1;
            mes:='Fadeout DataError';
          end;
          $01: begin
            len:=2;
            mes:='StartFadeout '+IntToStr(Cmd[2]);
          end;
          else begin
            len:=5;
            mes:='$e7 unknown extend.';
          end;
        end;
      end;
      $e6: begin // Extend Command mxdrv16x system
        len:=5;
        mes:='$e6 unknown extend.';
      end;
      else begin
        if $e0<=Cmd[0] then begin
          len:=5;
          mes:='$'+IntToStr(Cmd[0])+' unknown extend.';
        end;
      end;
    end;
  end;
end;

end.

