unit _NetVote_const;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

{$WARN UNIT_PLATFORM OFF}
{$WARN SYMBOL_PLATFORM OFF}

type
  TVote=record
    Name,MailAddress,Comment:string;
    Date:TDateTime;
    Rating,Celebrity:byte;
    Genre:byte;
    Filename,Title:string;
  end;

type
  TVoteData=record
    Loaded:boolean;
    Votes:array of TVote;
    VotesCount:integer;
  end;

const VoteDataID='MDXOnlineVoteDataVer0.1';

function GetEncordVote(Vote:TVote):string;
function GetDecordVote(str:string;var Vote:TVote):boolean;
function LoadVoteData(Filename:string;var VoteData:TVoteData):boolean;
procedure SaveVoteData(Filename:string;var VoteData:TVoteData);
function AddVote(var VoteData:TVoteData;_Vote:TVote):boolean;

implementation

uses _filebuf;

function GetEncordVote(Vote:TVote):string;
var
  TempStr:string;
  cnt:integer;
  procedure SetByte(b:byte);
  begin
    TempStr:=TempStr+char(b);
  end;
  procedure SetMString(msg:string);
  var
    tmp:string;
  begin
    tmp:=copy(msg,1,255);
    SetByte(length(tmp));
    TempStr:=TempStr+tmp;
  end;
begin
  with Vote do begin
    SetMString(Name);
    SetMString(MailAddress);
    SetMString(Comment);
    SetByte(Rating);
    SetByte(Celebrity);
    SetByte(Genre);
    SetMString(Filename);
  end;

  Result:='';
  for cnt:=0 to length(TempStr)-1 do begin
    Result:=Result+inttohex(byte(TempStr[cnt+1]),2);
  end;
  Result:=lowercase(Result);
end;

function GetDecordVote(str:string;var Vote:TVote):boolean;
var
  TempStr,TempHex:string;
  TempByte:byte;
  offset:integer;
  cnt:integer;
  function GetByte:byte;
  begin
    if offset=length(TempStr) then begin
      Result:=$00;
      end else begin
      Result:=byte(TempStr[offset+1]);
      inc(offset);
    end;
  end;
  function GetMString:string;
  var
    cnt,Count:integer;
  begin
    Count:=GetByte;
    Result:='';
    for cnt:=0 to Count-1 do begin
      Result:=Result+char(GetByte);
    end;
  end;
begin
  if (length(str)=0) or ((length(str) mod 2)=1) then begin
    Result:=False;
    exit;
  end;

  TempStr:='';
  for cnt:=0 to (length(str) div 2)-1 do begin
    TempHex:=copy(str,cnt*2+1,2);
    if TempHex='00' then begin
      TempStr:=TempStr+char($00);
      end else begin
      TempByte:=strtointdef('$'+TempHex,$00);
      if TempByte=$00 then begin
        Result:=False;
        exit;
      end;
      TempStr:=TempStr+char(TempByte);
    end;
  end;

  offset:=0;
  with Vote do begin
    Name:=GetMString;
    MailAddress:=GetMString;
    Comment:=GetMString;
    Date:=now;
    Rating:=GetByte;
    Celebrity:=GetByte;
    Genre:=GetByte;
    Filename:=GetMString;
    Title:=GetMString;
  end;

  Result:=True;
end;

function LoadVoteData(Filename:string;var VoteData:TVoteData):boolean;
var
  rfb:TReadFileBuf;
  ID:string;
begin
  if FileExists(Filename)=False then begin
    with VoteData do begin
      Loaded:=True;
      VotesCount:=0;
      SetLength(Votes,VotesCount+1);
    end;
    Result:=True;
    exit;
  end;

  rfb:=TReadFileBuf.Create;
  rfb.Init(Filename);
  rfb.LoadFile;

  rfb.GetVMString(ID);
  if ID<>VoteDataID then begin
    rfb.Free;
    with VoteData do begin
      Loaded:=True;
      VotesCount:=0;
      SetLength(Votes,VotesCount+1);
    end;
    Result:=True;
    exit;
  end;

  with VoteData do begin
    Loaded:=True;
    VotesCount:=0;
    SetLength(Votes,VotesCount+1);

    while (rfb.GetPosition<rfb.GetCount) do begin
      SetLength(Votes,VotesCount+1);
      with Votes[VotesCount] do begin
        rfb.GetVMString(Name);
        rfb.GetVMString(MailAddress);
        rfb.GetVMString(Comment);
        rfb.GetVDateTime(Date);
        rfb.GetVByte(Rating);
        rfb.GetVByte(Celebrity);
        rfb.GetVByte(Genre);
        rfb.GetVMString(Filename);
      end;
      inc(VotesCount);
    end;
  end;

  rfb.Free;

  Result:=True;
end;

procedure SaveVoteData(Filename:string;var VoteData:TVoteData);
var
  wfb:TWriteFileBuf;
  cnt:integer;
begin
  if VoteData.Loaded=False then exit;
  if VoteData.VotesCount=0 then exit;

  wfb:=TWriteFileBuf.Create;
  wfb.Init(Filename);

  wfb.SetMString(VoteDataID);

  with VoteData do begin
    for cnt:=0 to VotesCount-1 do begin;
      with Votes[cnt] do begin
        wfb.SetVMString(Name);
        wfb.SetVMString(MailAddress);
        wfb.SetVMString(Comment);
        wfb.SetVDateTime(Date);
        wfb.SetVByte(Rating);
        wfb.SetVByte(Celebrity);
        wfb.SetVByte(Genre);
        wfb.SetVMString(Filename);
      end;
    end;
  end;

  wfb.SaveFile;
  wfb.Free;
end;

function AddVote(var VoteData:TVoteData;_Vote:TVote):boolean;
begin
  if VoteData.Loaded=False then begin
    Result:=False;
    exit;
  end;

  with VoteData do begin
    SetLength(Votes,VotesCount+1);
    Votes[VotesCount]:=_Vote;
    inc(VotesCount);
  end;

  Result:=True;
end;

end.
