unit _PopupMenus;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls,Menus;

{$WARN UNIT_PLATFORM OFF}
{$WARN SYMBOL_PLATFORM OFF}

type
  TPopupMenus = class
  private
    { Private 錾 }
    ParentForm:TForm;
    MuteMenu:TPopupMenu;
    FileMenu:TPopupMenu;
    VisualMenu:TPopupMenu;
    PlayModeMenu:TPopupMenu;
    MainMenu:TPopupMenu;
    NetworkMenu:TPopupMenu;
    PCMOutMenu:TPopupMenu;
    procedure MenuItem_ExecuteDCTTag(Sender: TObject);
    procedure PCMOutMenu_SelectDLL(Sender: TObject);
  public
    { Public 錾 }
    constructor Create(_ParentForm:TForm);
    destructor Destroy; override;
    procedure MuteMenu_Popup;
    procedure FileMenu_Popup;
    procedure VisualMenu_Popup;
    procedure PlayModeMenu_Popup;
    procedure MainMenu_Popup;
    procedure NetworkMenu_Popup;
    procedure PCMOutMenu_Popup;
  end;

var
  PopupMenus:TPopupMenus;

implementation

uses MainWin,
     _m_Tools,_const,_MDXWin_const,_MDXWinINI,_KeyDef_const,_KeyDef,
     _SndDrv,_Vis_const,_MXDRVm_const,_PCMOut;

constructor TPopupMenus.Create(_ParentForm:TForm);
begin
  inherited Create;

  ParentForm:=_ParentForm;

  MuteMenu:=nil;
  FileMenu:=nil;
  VisualMenu:=nil;
  PlayModeMenu:=nil;
  MainMenu:=nil;
  NetworkMenu:=nil;
  PCMOutMenu:=nil;
end;

destructor TPopupMenus.Destroy;
  procedure FreeAndNil(var PopupMenu:TPopupMenu);
  begin
    if PopupMenu<>nil then begin
      PopupMenu.Free;
      PopupMenu:=nil;
    end;
  end;
begin
  inherited Destroy;

  ParentForm:=nil;

  FreeAndNil(MuteMenu);
  FreeAndNil(FileMenu);
  FreeAndNil(VisualMenu);
  FreeAndNil(PlayModeMenu);
  FreeAndNil(MainMenu);
  FreeAndNil(NetworkMenu);
  FreeAndNil(PCMOutMenu);
end;

procedure TPopupMenus.MenuItem_ExecuteDCTTag(Sender: TObject);
begin
  KeyDef.ExecuteCommand(TMenuItem(Sender).Tag);
end;

procedure TPopupMenus.PCMOutMenu_SelectDLL(Sender: TObject);
begin
  sdChangeRate(0,PCMOut_WinAMPOutput,TMenuItem(Sender).Caption);
end;

procedure TPopupMenus.MuteMenu_Popup;
var
  pos:TPoint;
  cnt:integer;
  ChMode:string;
  ChTrack:integer;
  msg:string;
  procedure AddItem(_Caption:string;_DCT:integer;_Checked:boolean);
  var
    Item:TMenuItem;
  begin
    Item:=TMenuItem.Create(MuteMenu);
    Item.Enabled:=True;
    Item.Caption:=_Caption;
    Item.Tag:=_DCT;
    Item.Checked:=_Checked;
    if _DCT<>DCT_nil then begin
      Item.OnClick:=MenuItem_ExecuteDCTTag;
    end;
    MuteMenu.Items.Add(Item);
  end;
begin
  if MuteMenu<>nil then begin
    MuteMenu.Free;
    MuteMenu:=nil;
  end;
  MuteMenu:=TPopupMenu.Create(ParentForm);
  MuteMenu.AutoHotkeys:=maManual;

  AddItem('Să~[g (&E)',DCT_MuteSetAll,False);
  AddItem('Să~[g (&D)',DCT_MuteResetAll,False);
  AddItem('S`l] (&T)',DCT_MuteToggleAll,False);
  AddItem('-',DCT_nil,False);

  for cnt:=0 to 16-1 do begin
    ChMode:='';
    ChTrack:=0;
    sdGetChMode(cnt,ChMode,ChTrack);
    msg:='ch.'+inttostr(cnt)+' '+ChMode+'.'+inttostr(ChTrack)+' ';
    if cnt<8 then begin
      msg:=msg+'(&'+inttostr(cnt)+')';
      end else begin
      msg:=msg+'(&'+inttostr(cnt-8)+')';
    end;
    AddItem(msg,DCT_MuteCh01+cnt,not sdGetMute(cnt));
  end;

  GetCursorPos(pos);
  MuteMenu.Popup(pos.X,pos.Y);
end;

procedure TPopupMenus.FileMenu_Popup;
var
  pos:TPoint;
  ParentItem:TMenuItem;
  procedure AddItem(_Caption:string;_DCT:integer);
  var
    Item:TMenuItem;
  begin
    Item:=TMenuItem.Create(FileMenu);
    Item.Enabled:=True;
    Item.Caption:=_Caption;
    Item.Tag:=_DCT;
    if _DCT<>DCT_nil then begin
      Item.OnClick:=MenuItem_ExecuteDCTTag;
    end;
    FileMenu.Items.Add(Item);
  end;
  procedure AddItemParent(_Caption:string;_DCT:integer);
  var
    Item:TMenuItem;
  begin
    Item:=TMenuItem.Create(ParentItem);
    Item.Enabled:=True;
    Item.Caption:=_Caption;
    Item.Tag:=_DCT;
    if _DCT<>DCT_nil then begin
      Item.OnClick:=MenuItem_ExecuteDCTTag;
    end;
    ParentItem.Add(Item);
  end;
begin
  if FileMenu<>nil then begin
    FileMenu.Free;
    FileMenu:=nil;
  end;
  FileMenu:=TPopupMenu.Create(ParentForm);
  FileMenu.AutoHotkeys:=maManual;

  AddItem('hCuj[J (&D)',DCT_ShowDriveMenu);
  AddItem('Wave/MP3/OggϊXgɑ',DCT_ToWaveAndNext);
  AddItem('J[\ȉSẴt@C𑗂',DCT_ToWaveAndAll);
  AddItem('-',DCT_nil);

  AddItem('t@Cw肵čĐ/ړ (&O)',DCT_SetFileDialog);
  AddItem('Nbv{[hĐ/ړ (&O)',DCT_SetFileClipboard);
  AddItem('-',DCT_nil);

  ParentItem:=TMenuItem.Create(FileMenu);
  ParentItem.Caption:='Nbv{[hɍĐ́c (&P)';
  FileMenu.Items.Add(ParentItem);

  AddItemParent('t@CRs[ (&F)',DCT_CopyPlayFilename);
  AddItemParent('t@C{^CgRs[ (&A)',DCT_CopyPlayFilenameTitle);
  AddItemParent('^CgRs[ (&T)',DCT_CopyPlayTitle);
  AddItemParent('URLRs[ (&U)',DCT_CopyPlayURL);
  AddItemParent('URL{^CgRs[ (&U)',DCT_CopyPlayURLTitle);
  AddItemParent('HTML`URLRs[ (&H)',DCT_CopyPlayHTMLURL);
  AddItemParent('HTML`URL{^CgRs[ (&H)',DCT_CopyPlayHTMLURLTitle);
  AddItemParent('HTML`Ń^CgRs[ (&H)',DCT_CopyPlayHTMLTitle);

  ParentItem:=TMenuItem.Create(FileMenu);
  ParentItem.Caption:='Nbv{[hɃJ[\ʒúc (&C)';
  FileMenu.Items.Add(ParentItem);

  AddItemParent('t@CRs[ (&F)',DCT_CopyCursorFilename);
  AddItemParent('t@C{^CgRs[ (&A)',DCT_CopyCursorFilenameTitle);
  AddItemParent('^CgRs[ (&T)',DCT_CopyCursorTitle);
  AddItemParent('URLRs[ (&U)',DCT_CopyCursorURL);
  AddItemParent('URL{^CgRs[ (&U)',DCT_CopyCursorURLTitle);
  AddItemParent('HTML`URLRs[ (&H)',DCT_CopyCursorHTMLURL);
  AddItemParent('HTML`URL{^CgRs[ (&H)',DCT_CopyCursorHTMLURLTitle);
  AddItemParent('HTML`Ń^CgRs[ (&H)',DCT_CopyCursorHTMLTitle);

  ParentItem:=TMenuItem.Create(FileMenu);
  ParentItem.Caption:='mdxovgR (&U)';
  FileMenu.Items.Add(ParentItem);

  AddItemParent('CXg[ėLɂ (&I)',DCT_mdxoInstall);
  AddItemParent('ACXg[Ėɂ (&U)',DCT_mdxoUninstall);
  AddItemParent('mdxovgR̉y[WJ (&H)',DCT_mdxoReference);

  GetCursorPos(pos);
  FileMenu.Popup(pos.X,pos.Y);
end;

procedure TPopupMenus.VisualMenu_Popup;
var
  pos:TPoint;
  procedure AddItem(_Caption:string;_DCT:integer;_Checked:boolean);
  var
    Item:TMenuItem;
  begin
    Item:=TMenuItem.Create(VisualMenu);
    Item.Enabled:=True;
    Item.Checked:=_Checked;
    Item.Caption:=_Caption;
    Item.Tag:=_DCT;
    if _DCT<>DCT_nil then begin
      Item.OnClick:=MenuItem_ExecuteDCTTag;
    end;
    VisualMenu.Items.Add(Item);
  end;
begin
  if VisualMenu<>nil then begin
    VisualMenu.Free;
    VisualMenu:=nil;
  end;
  VisualMenu:=TPopupMenu.Create(ParentForm);
  VisualMenu.AutoHotkeys:=maManual;

  AddItem('GtFNgݒ (&S)',DCT_SetupVisualEffect,False);
  AddItem('-',DCT_nil,False);

  AddItem('L[{[h (&0)',DCT_SetVisMode_Keyboard,VisINI.VisualMode=VisualModeKeyboard);
  AddItem('\i[([_[) (&1)',DCT_SetVisMode_Sonar,VisINI.VisualMode=VisualModeSonar);
  AddItem('MDXDis (&2)',DCT_SetVisMode_MDXDis,VisINI.VisualMode=VisualModeMDXDis);
  AddItem('C[ (&3)',DCT_SetVisMode_Wire,VisINI.VisualMode=VisualModeWire);
  AddItem('EF[u (&4)',DCT_SetVisMode_Wave,VisINI.VisualMode=VisualModeWave);
  AddItem('tC (&5)',DCT_SetVisMode_Fly,VisINI.VisualMode=VisualModeFly);
  AddItem('v[ (&6)',DCT_SetVisMode_Pool,VisINI.VisualMode=VisualModePool);
  AddItem('{bNX (&7)',DCT_SetVisMode_Box,VisINI.VisualMode=VisualModeBox);
  AddItem('C (&8)',DCT_SetVisMode_Rain,VisINI.VisualMode=VisualModeRain);
  AddItem('-',DCT_nil,False);

  AddItem('tB->y[WRs[ (&P)',DCT_SetVisMode_FillCopy,VisINI.Effect3DDDBlurMode=DDBlurModeCopy);
  AddItem('tB->At@u[ (&A)',DCT_SetVisMode_FillReduction,VisINI.Effect3DDDBlurMode=DDBlurModeReduction);
  AddItem('tB->VF[hu[ (&S)',DCT_SetVisMode_FillShade,VisINI.Effect3DDDBlurMode=DDBlurModeShade);

  GetCursorPos(pos);
  VisualMenu.Popup(pos.X,pos.Y);
end;

procedure TPopupMenus.PlayModeMenu_Popup;
var
  pos:TPoint;
  procedure AddItem(_Caption:string;_DCT:integer;_Checked:boolean);
  var
    Item:TMenuItem;
  begin
    Item:=TMenuItem.Create(PlayModeMenu);
    Item.Enabled:=True;
    Item.Checked:=_Checked;
    Item.Caption:=_Caption;
    Item.Tag:=_DCT;
    if _DCT<>DCT_nil then begin
      Item.OnClick:=MenuItem_ExecuteDCTTag;
    end;
    PlayModeMenu.Items.Add(Item);
  end;
begin
  if PlayModeMenu<>nil then begin
    PlayModeMenu.Free;
    PlayModeMenu:=nil;
  end;
  PlayModeMenu:=TPopupMenu.Create(ParentForm);
  PlayModeMenu.AutoHotkeys:=maManual;

  AddItem('Pȃs[g (&0)',DCT_SetPlayMode_Single,MainINI.PlayMode=PlayMode_Single);
  AddItem('S (&1)',DCT_SetPlayMode_ALL,MainINI.PlayMode=PlayMode_ALL);
  AddItem('Sȃs[g (&2)',DCT_SetPlayMode_ALLRepeat,MainINI.PlayMode=PlayMode_ALLRepeat);
  AddItem('_ (&3)',DCT_SetPlayMode_Random,MainINI.PlayMode=PlayMode_Random);
  AddItem('s[gȂ (&4)',DCT_SetPlayMode_None,MainINI.PlayMode=PlayMode_None);

  GetCursorPos(pos);
  PlayModeMenu.Popup(pos.X,pos.Y);
end;

procedure TPopupMenus.MainMenu_Popup;
var
  pos:TPoint;
  ParentItem:TMenuItem;
  procedure AddItem(_Caption:string;_DCT:integer);
  var
    Item:TMenuItem;
  begin
    Item:=TMenuItem.Create(MainMenu);
    Item.Enabled:=True;
    Item.Caption:=_Caption;
    Item.Tag:=_DCT;
    if _DCT<>DCT_nil then begin
      Item.OnClick:=MenuItem_ExecuteDCTTag;
    end;
    MainMenu.Items.Add(Item);
  end;
  procedure AddItemParent(_Caption:string;_DCT:integer;_Checked:boolean);
  var
    Item:TMenuItem;
  begin
    Item:=TMenuItem.Create(ParentItem);
    Item.Enabled:=True;
    Item.Checked:=_Checked;
    Item.Caption:=_Caption;
    Item.Tag:=_DCT;
    if _DCT<>DCT_nil then begin
      Item.OnClick:=MenuItem_ExecuteDCTTag;
    end;
    ParentItem.Add(Item);
  end;
begin
  if MainMenu<>nil then begin
    MainMenu.Free;
    MainMenu:=nil;
  end;
  MainMenu:=TPopupMenu.Create(ParentForm);
  MainMenu.AutoHotkeys:=maManual;

  AddItem('ICwv (&H)',DCT_ShowHelp);
  AddItem('L[JX^}CY (&K)',DCT_KeyCustomize);
  AddItem('-',DCT_nil);

  AddItem('SʃZbgAbv (&S)',DCT_SetupMain);
  AddItem('DSPvOCݒ (&D)',DCT_SetupDSPPlugin);
  AddItem('lbg[Nݒ (&N)',DCT_SetupNetwork);
  AddItem('rWAGtFNgݒ (&V)',DCT_ShowVisualMenu);
  AddItem('-',DCT_nil);

  AddItem('vC[hj[ (&P)',DCT_ShowPlayModeMenu);
  AddItem('EF[ut@C쐬 (&W)',DCT_OpenFileOutputWindow);
  AddItem('J^Ot@C̍œK (&C)',DCT_OpenCatalogCompressWindow);
  AddItem('^Cg\ (&T)',DCT_ShowTitle);
  AddItem('-',DCT_nil);

  AddItem('XLt@CēǍ (&R)',DCT_ReloadSKI);
  AddItem('XLt@CI (&S)',DCT_SelectSKI);
  AddItem('-',DCT_nil);

  AddItem('RpNg[hؑ (&C)',DCT_ToggleCompactMode);

  ParentItem:=TMenuItem.Create(MainMenu);
  ParentItem.Caption:='RpNgݒ (&S)';
  MainMenu.Items.Add(ParentItem);

  AddItemParent('t@CXg\ (&F)',DCT_SetupCompactShowFile,MainINI.CompactWindowFlortEnabled);
  AddItemParent('CEBhEɋߕtƋz (&D)',DCT_SetupCompactWithMain,MainINI.CompactWindowFlortDockMain);
  AddItem('-',DCT_nil);

  AddItem('ŏiACRj؂ւ (&I)',DCT_Minimized);
  AddItem('-',DCT_nil);

  AddItem(' (&X)',DCT_MainClose);

  GetCursorPos(pos);
  MainMenu.Popup(pos.X,pos.Y);
end;

procedure TPopupMenus.NetworkMenu_Popup;
var
  pos:TPoint;
  procedure AddItem(_Caption:string;_DCT:integer);
  var
    Item:TMenuItem;
  begin
    Item:=TMenuItem.Create(NetworkMenu);
    Item.Enabled:=True;
    Item.Caption:=_Caption;
    Item.Tag:=_DCT;
    if _DCT<>DCT_nil then begin
      Item.OnClick:=MenuItem_ExecuteDCTTag;
    end;
    NetworkMenu.Items.Add(Item);
  end;
  procedure AddItemChecked(_Caption:string;_DCT:integer;_Checked:boolean);
  var
    Item:TMenuItem;
  begin
    Item:=TMenuItem.Create(NetworkMenu);
    Item.Enabled:=True;
    Item.Checked:=_Checked;
    Item.Caption:=_Caption;
    Item.Tag:=_DCT;
    if _DCT<>DCT_nil then begin
      Item.OnClick:=MenuItem_ExecuteDCTTag;
    end;
    NetworkMenu.Items.Add(Item);
  end;
begin
  if NetworkMenu<>nil then begin
    NetworkMenu.Free;
    NetworkMenu:=nil;
  end;
  NetworkMenu:=TPopupMenu.Create(ParentForm);
  NetworkMenu.AutoHotkeys:=maManual;

  AddItem('ICAbvf[g (&O)',DCT_Network_StartOnlineUpdate);
  AddItemChecked('ICAbvf[g̎XVʒm (&A)',DCT_Network_ToggleAutoOnlineUpdate,MainINI.MDXOnlineAutoUpdate);
  AddItem('~[T[oI (&M)',DCT_Network_SelectMirrorServer);
  AddItem('fJ (&B)',DCT_Network_OpenBBS);
  AddItem('XLAbv[hfJ (&B)',DCT_Network_OpenSkinUploadBBS);
  AddItem('-',DCT_nil);

  AddItem('f[^ (&F)',DCT_Network_OpenDataFindWindow);
  AddItem('LO (&R)',DCT_Network_OpenRankingWindow);
  AddItem('[ (&V)',DCT_Network_OpenVoteWindow);

  GetCursorPos(pos);
  NetworkMenu.Popup(pos.X,pos.Y);
end;

procedure TPopupMenus.PCMOutMenu_Popup;
var
  pos:TPoint;
  ParentItem:TMenuItem;
  i:integer;
  cnt:integer;
  NewItem:TMenuItem;
  procedure AddItem(_Caption:string;_DCT:integer;_Checked:boolean);
  var
    Item:TMenuItem;
  begin
    Item:=TMenuItem.Create(PCMOutMenu);
    Item.Enabled:=True;
    Item.Checked:=_Checked;
    Item.Caption:=_Caption;
    Item.Tag:=_DCT;
    if _DCT<>DCT_nil then begin
      Item.OnClick:=MenuItem_ExecuteDCTTag;
    end;
    PCMOutMenu.Items.Add(Item);
  end;
  procedure AddItemParent(_Caption:string;_DCT:integer;_Checked:boolean);
  var
    Item:TMenuItem;
  begin
    Item:=TMenuItem.Create(ParentItem);
    Item.Enabled:=True;
    Item.Checked:=_Checked;
    Item.Caption:=_Caption;
    Item.Tag:=_DCT;
    if _DCT<>DCT_nil then begin
      Item.OnClick:=MenuItem_ExecuteDCTTag;
    end;
    ParentItem.Add(Item);
  end;
begin
  if PCMOutMenu<>nil then begin
    PCMOutMenu.Free;
    PCMOutMenu:=nil;
  end;
  PCMOutMenu:=TPopupMenu.Create(ParentForm);
  PCMOutMenu.AutoHotkeys:=maManual;

  i:=Main.NowDSoundRate;
  AddItem('rate 22050Hz',DCT_SoundRate22050Hz,i=22050);
  AddItem('rate 44100Hz',DCT_SoundRate44100Hz,i=44100);
  AddItem('rate 48000Hz',DCT_SoundRate48000Hz,i=48000);
  AddItem('rate 96000Hz',DCT_SoundRate96000Hz,i=96000);
  AddItem('rate 192000Hz',DCT_SoundRate192000Hz,i=192000);
  AddItem('rate lw',DCT_SoundRateDialog,False);
  AddItem('-',DCT_nil,False);

  AddItem('EnhancervOCL',DCT_SoundWADP_Enabled,MainINI.WADSPEnabled=True);
  AddItem('EnhancervOC',DCT_SoundWADP_Disabled,MainINI.WADSPEnabled=False);
  AddItem('EnhancervOCݒ菉',DCT_SoundWADP_RegInit,False);
  AddItem('-',DCT_nil,False);

  AddItem('MXDRVm.dll hCo',DCT_SoundMXDRV_SelectMoonlight,MXDRVgINI.Enabled=False);
  AddItem('MXDRVg.dll GORRYlhCo',DCT_SoundMXDRV_SelectGORRY,MXDRVgINI.Enabled=True);
  AddItem('MXDRVݒEBhEJ',DCT_SoundMXDRV_Config,False);
  AddItem('-',DCT_nil,False);

  ParentItem:=TMenuItem.Create(PCMOutMenu);
  ParentItem.Caption:='gϊASY';
  PCMOutMenu.Items.Add(ParentItem);

  i:=MainINI.UseSRCMode;
  AddItemParent('ŋߖT⊮ (CPUy/)',DCT_SoundSRC_Nearest,i=SRCMode_Nearest);
  AddItemParent('`⊮ (CPU/)',DCT_SoundSRC_Liner,i=SRCMode_Liner);
  AddItemParent('XvC⊮ (CPUd/)',DCT_SoundSRC_Spline,i=SRCMode_Spline);
  AddItem('-',DCT_nil,False);

  i:=Main.NowUseDSound;
  AddItem('output Null',DCT_SoundOutNull,i=PCMOut_Null);
  AddItem('output WindowsSoundSystem',DCT_SoundOutWSS,i=PCMOut_WindowsSound);
  AddItem('output DirectSound',DCT_SoundOutDS,i=PCMOut_DirectSound);
  AddItem('output ASIO2',DCT_SoundOutASIO2,i=PCMOut_ASIO);
  AddItem('output ASIO2 Setting',DCT_SoundOutASIO2Set,False);
  AddItem('output WinAMPOutput',DCT_SoundOutWA,i=PCMOut_WinAMPOutput);

  ParentItem:=TMenuItem.Create(PCMOutMenu);
  ParentItem.Caption:='output WinAMPOutput Setting';
  PCMOutMenu.Items.Add(ParentItem);

  AddItemParent('Configure',DCT_SoundOutWASet,False);
  AddItemParent('About',DCT_SoundOutWAAbout,False);
  AddItemParent('-',DCT_nil,False);

  for cnt:=0 to PCMOut.WAOUT_GetModulesCount-1 do begin
    NewItem:=TMenuItem.Create(ParentItem);
    NewItem.Enabled:=True;
    NewItem.Caption:=PCMOut.WAOUT_GetModuleDLLName(cnt);
    NewItem.Tag:=-1;
    if AnsiLowerCase(PCMOut.WAOUT_GetModuleDLLName(cnt))=AnsiLowerCase(Main.NowWAO_DLLName) then begin
      NewItem.Checked:=True;
      end else begin
      NewItem.Checked:=False;
    end;
    NewItem.OnClick:=PCMOutMenu_SelectDLL;
    ParentItem.Add(NewItem);
  end;

  GetCursorPos(pos);
  PCMOutMenu.Popup(pos.X,pos.Y);
end;

end.
