unit _SPC;

interface

uses
  Windows, SysUtils,
  _SndDrv_const, _SNESAPU_Moonlight,_Vis_const;

type
  TInfomation=record
    FileSize:integer;
  end;

type
  TSPC = class
  private
    { Private 錾 }
    MemSync:TMultiReadExclusiveWriteSynchronizer;
    MesureClock:integer;
    MCh:array[0..7] of TMCh;
    NowPCMRate:dword;
    TransTempo:integer;
    function  GetParamStr0(Ch:integer):string;
    function  GetParamStr1(Ch:integer):string;
    function  GetLoopCount:integer;
    function  GetTotalms:integer;
    function  GetTempo:integer;
  public
    { Public 錾 }
    Infomation:TInfomation;
    SPCInfo:TSPCInfo;
    function  Init(PCMRate:integer):boolean;
    function  ChangeRate(rate:integer):boolean;
    procedure RefrectionSetting;
    procedure FreeDLL;
    procedure SPC_GetPCMData(var buf:SmallInt;len:integer);
    function  GetTitle(Filename:string):string;
    function  SPCPlay:boolean;
    procedure SPCStop;
    procedure StartFadeout;
    procedure MMLSeek(SeekClock:integer);
    procedure MMLTrap;
    procedure SetMute(ch:integer;flag:boolean);
    procedure GetVisual(var pSetVisual:pVisual);
    procedure GetVisualSystem(var pSetVisual:pVisual);
    function  GetTotalClock:integer;
    function  GetMesureClock:integer;
    function  GetDispClock:integer;
    function  GetCopyright:string;
    procedure LoadInfomation;
    procedure SetTransTempo(_TransTempo:integer);
  end;

implementation

uses MainWin,
     _MDXWinINI, _m_Tools,_const,_Vis;

// ---------------------------
// private
// ---------------------------

function TSPC.GetParamStr0(Ch:integer):string;
begin
  if Ch>=8 then begin
    Result:='';
    exit;
  end;

  MemSync.BeginRead;

  with pSNESData.pMix[Ch] do begin
    Result:=format('Rate:%6x Block:%2x ',[mRate,bHdr]);
  end;
  with pSNESData.pDSP.voice[Ch] do begin
    Result:=Result+format('Pitch:%4x Wave:%2x  ',[Pitch,Wave]);
  end;

  MemSync.EndRead;
end;

function TSPC.GetParamStr1(Ch:integer):string;
begin
  if Ch>=8 then begin
    Result:='';
    exit;
  end;

  MemSync.BeginRead;

  with pSNESData.pMix[Ch] do begin
    Result:=format('VolL:%3d R:%3d ',[mChnL,mChnR]);
  end;
  with pSNESData.pDSP.global do begin
    if (kon and (1 shl Ch))=$00 then begin
      Result:=Result+'KeyON  ';
      end else begin
      Result:=Result+'KeyOff ';
    end;
    if (eon and (1 shl Ch))=$00 then begin
      Result:=Result+'EchoON  ';
      end else begin
      Result:=Result+'EchoOff ';
    end;
    if (endx and (1 shl Ch))=$00 then begin
      Result:=Result+'BBRON  ';
      end else begin
      Result:=Result+'BBROff ';
    end;
  end;
  Result:=Result+'   ';

  MemSync.EndRead;
end;

function TSPC.GetTotalms:integer;
begin
  Result:=integer(pSNESData.pT64Cnt^ div (64000 div 1000));
end;

function TSPC.GetTempo:integer;
begin
  Result:=0;
end;

function TSPC.GetLoopCount:integer;
begin
  if dword(GetTotalms)>(SPCInfo.ID666.SongLenSec*1000) then
    Result:=1
    else
    Result:=0;
end;

// ---------------------------
// public
// ---------------------------

function TSPC.Init(PCMRate:integer):boolean;
var
  res:boolean;
begin
  MemSync:=TMultiReadExclusiveWriteSynchronizer.Create;

  MemSync.BeginWrite;

  res:=SNESAPU_LoadDLL;
  if res=False then begin
    Result:=False;
    end else begin
    Result:=True;
    SNESAPU_Init;
    NowPCMRate:=PCMRate;
    RefrectionSetting;
  end;

  TransTempo:=0;

  MemSync.EndWrite;
end;

function TSPC.ChangeRate(rate:integer):boolean;
begin
  MemSync.BeginWrite;
  NowPCMRate:=rate;
  MemSync.EndWrite;
  Result:=True;
end;

procedure TSPC.RefrectionSetting;
var
  _DSPPitch:dword;
  _DSPOpt:dword;
begin
  MemSync.BeginWrite;

  with SPCINI do begin
    _DSPOpt:=0;
    if DSPOpt_LowpassFilter=True then inc(_DSPOpt,DSP_LOW);
    if DSPOpt_OldADPCMDecompress=True then inc(_DSPOpt,DSP_OLDSMP);
    if DSPOpt_SurroundSound=True then inc(_DSPOpt,DSP_SURND);
    if DSPOpt_ReverseStereo=True then inc(_DSPOpt,DSP_REVERSE);

    case DSPPitch of
      DSPPitch_Normal:   _DSPPitch:=DSPPitchInt_Normal;
      DSPPitch_OldSB:    _DSPPitch:=DSPPitchInt_OldSB;
      DSPPitch_OldZSNES: _DSPPitch:=DSPPitchInt_OldZSNES;
      else               _DSPPitch:=DSPPitchInt_Normal;
    end;

    SetAPUOpt(MixMode,2,16,NowPCMRate,IntMode,_DSPOpt);
    SetDSPPitch(_DSPPitch);
  end;

  MemSync.EndWrite;
end;

procedure TSPC.FreeDLL;
begin
  MemSync.BeginWrite;
  SNESAPU_FreeDLL;
  MemSync.EndWrite;

  MemSync.Free;
end;

procedure TSPC.SPC_GetPCMData(var buf:SmallInt;len:integer);
begin
  SetTransTempo(TransTempo);
  MemSync.BeginWrite;
  EmuAPU(@buf,len,True);
  MemSync.EndWrite;
end;

function TSPC.SPCPlay;
begin
  MemSync.BeginWrite;

  MesureClock:=0;

  with SPCINI do begin
    Result:=SNESAPU_LoadSPC(Main.gFileInfo.GetPlayPath,SPCInfo,EnabledID666Length,DefaultSongLenSec,DefaultFadeoutLenSec);
  end;

  if Result=True then begin
    MesureClock:=SPCInfo.TotalLenMSec;
    LoadInfomation;
  end;

  MemSync.EndWrite;
end;

procedure TSPC.SPCStop;
begin
  MemSync.BeginWrite;
  MemSync.EndWrite;
end;

function TSPC.GetTitle(Filename:string):string;
var
  SPCInfo:TSPCInfo;
  res:integer;
  ShowFilename:string;
begin
  res:=SNESAPU_LoadSPCInfo(Filename,SPCInfo);

  case res of
    SPCInfoOK: begin
      ShowFilename:='['+ExtractFilename(Main.gFileInfo.GetFullPath)+']';
      if SPCInfo.ID666Exists=False then begin
        Result:=ShowFilename;
        end else begin
        with SPCInfo.ID666 do begin
          if (SongTitle='') and (GameTitle='') and (DumperName='') and (Comments='') then begin
            Result:=ShowFilename;
            end else begin
            if SongTitle='' then begin
              Result:=ShowFilename+'|'+GameTitle+'|'+DumperName+'|'+Comments;
              end else begin
              Result:=SongTitle+'|'+GameTitle+'|'+DumperName+'|'+Comments;
            end;
          end;
        end;
      end;
    end;
    SPCInfoInvalidHeader: begin
      Result:='SPCError:InvalidHeader';
    end;
    SPCInfoInvalidMinorVersion: begin
      Result:='SPCError:InvalidMinorVersion';
    end;
  end;
end;

function TSPC.GetTotalClock:integer;
begin
  MemSync.BeginRead;
  Result:=GetTotalms;
  MemSync.EndRead;
end;

function TSPC.GetMesureClock:integer;
begin
  MemSync.BeginRead;
  Result:=MesureClock;
  MemSync.EndRead;
end;

function TSPC.GetDispClock:integer;
begin
  MemSync.BeginRead;
  Result:=GetTotalms;
  MemSync.EndRead;
end;

procedure TSPC.StartFadeout;
begin
  MemSync.BeginWrite;
  if sdFadeout=False then begin
    sdFadeout:=True;
  end;
  MemSync.EndWrite;
end;

procedure TSPC.MMLSeek(SeekClock:integer);
var
  Result:boolean;
begin
  MemSync.BeginWrite;
  with SPCINI do begin
    Result:=SNESAPU_LoadSPC(Main.gFileInfo.GetPlayPath,SPCInfo,EnabledID666Length,DefaultSongLenSec,DefaultFadeoutLenSec);
  end;
  if Result=True then SeekAPU(SNESAPU_MSecToAPUClock(SeekClock),True);
  MemSync.EndWrite;
end;

procedure TSPC.MMLTrap;
begin
  if sdEnd=True then begin
    MemSync.BeginWrite;
    sdLoop:=0;
    sdFadeout:=False;
    sdEnd:=True;
    MemSync.EndWrite;
    exit;
  end;

  MemSync.BeginWrite;

  sdLoop:=GetLoopCount;

  if MesureClock<GetTotalms then begin
    sdEnd:=True;
    end else begin
    sdEnd:=False;
  end;

  MemSync.EndWrite;
end;

procedure TSPC.SetMute(ch:integer;flag:boolean);
var
  bf:byte;
begin
  if (ch<0) or (8<=ch) then exit;
  if pSNESData.pMix=nil then exit;

  MemSync.BeginWrite;

  with pSNESData.pMix[ch] do begin
    bf:=1;
    if flag=True then begin
      mFlg:=mFlg or bf;
      end else begin
      mFlg:=mFlg and (not bf);
    end;
  end;

  MemSync.EndWrite;
end;

procedure TSPC.GetVisual(var pSetVisual:pVisual);
var
  Ch:integer;
  KOFFPack:byte;
  tPitch,tNoteNo,tVoiceNo:integer;
  vl,vr:integer;
begin
  MemSync.BeginRead;

  KOFFPack:=pSNESData.pDSP.global.koff;

  for Ch:=0 to 7 do begin
    with pSetVisual.Channel[ch] do begin
      mes0:=GetParamStr0(Ch);
      mes1:=GetParamStr1(Ch);
    end;
    with MCH[Ch] do begin
      if (KOFFPack and (1 shl Ch))<>$00 then begin // noteoff
        NoteonFlag:=False;
        Vis.SetAnalyzeNoteoff(Ch);
        end else begin
        tPitch:=integer(pSNESData.pDSP.voice[Ch].Pitch);
        tNoteNo:=(tPitch*128) div 16384;
        tVoiceNo:=pSNESData.pDSP.voice[Ch].Wave;
        PSetVisual.NoteKeyno[Ch]:=(tPitch*128*64) div 16384;
        if (NoteonFlag=False) or (Noteno<>tNoteNo) or (Voiceno<>tVoiceNo) then begin // noteon
          NoteonFlag:=True;
          Noteno:=tNoteNo;
          Voiceno:=tVoiceNo;

          vl:=abs(pSNESData.pMix[Ch].mChnL);
          vr:=abs(pSNESData.pMix[Ch].mChnR);
          if vl>vr then begin
            Vis.SetAnalyzeVolume(Ch,vl*2);
            end else begin
            Vis.SetAnalyzeVolume(Ch,vr*2);
          end;

          with PSetVisual.Channel[Ch] do begin
            Panpot:=3;
            if vl>vr then Panpot:=1;
            if vl<vr then Panpot:=2;
            Voice:=tVoiceNo;
            Keycode:=tNoteNo;
          end;
        end;
      end;
    end;
  end;

  MemSync.EndRead;
end;

procedure TSPC.GetVisualSystem(var pSetVisual:pVisual);
begin
  MemSync.BeginRead;

  pSetVisual.PlayTime:=GetTotalms;
  pSetVisual.TotalClock:=GetTotalClock;
  pSetVisual.MesureClock:=GetMesureClock;
  pSetVisual.DispClock:=GetDispClock;
  pSetVisual.Tempo:=GetTempo;
  pSetVisual.LoopCount:=GetLoopCount;

  MemSync.EndRead;
end;

function TSPC.GetCopyright:string;
begin
  MemSync.BeginRead;

  Result:=SNESAPU_GetVersion+CRLF+CRLF;
  Result:=Result+'Super Nintendo Entertainment System(tm)'+CRLF;
  Result:=Result+'Audio Processing Unit Emulator'+CRLF;
  Result:=Result+'SNESAPU is copyright (C)2003 Alpha-II Productions (www.alpha-ii.com)'+CRLF+CRLF;
  Result:=Result+'"SNES" and "Super Nintendo Entertainment System"'+CRLF;
  Result:=Result+'are registered trademarks of Nintendo (www.nintendo.com)'+CRLF;

  MemSync.EndRead;
end;

procedure TSPC.LoadInfomation;
begin
  MemSync.BeginWrite;

  if FileExists(Main.gFileInfo.GetPlayPath)=False then begin
    Infomation.FileSize:=0;
    end else begin
    Infomation.FileSize:=GetFileSize(Main.gFileInfo.GetPlayPath);
  end;

  MemSync.EndWrite;
end;

procedure TSPC.SetTransTempo(_TransTempo:integer);
var
  t:integer;
begin
  MemSync.BeginWrite;
  TransTempo:=_TransTempo;
  t:=64000+trunc(TransTempo*4000);
  if t<=1 then t:=1;
  SetAPUSmpClk(t);
  MemSync.EndWrite;
end;

end.
