unit _SimpleDialog;

{$WARN UNIT_PLATFORM OFF}
{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  Windows, Graphics, SysUtils, Forms, Classes, Controls, StdCtrls, Buttons, ComCtrls;

const MB_STOP=$0010;
const MB_QUESTION=$0020;
const MB_EXCLAMATION=$0030;
const MB_INFOMATION=$0040;
const MB_Warrning=MB_Exclamation;

const ID_OK=1;
const ID_IDCANCEL=2;
const ID_ABORT=3;
const ID_RETRY=4;
const ID_IGNORE=5;
const ID_YES=6;
const ID_NO=7;
const ID_TRYAGAIN=10;
const ID_CONTINUE=11;

procedure SetShowMessageHandle(h:HWND);
procedure ShowMessage(title,msg:string);
function InputQuery(const ACaption, APrompt: string; var Value: string): Boolean;
function InputBox(const ACaption, APrompt, ADefault: string): string;
function MessageDlgisOK(title,msg:string;MB:integer):boolean;

implementation

var
  ShowMessageHandle:HWND;

const SMsgDlgOK = 'OK';
const SMsgDlgCancel = 'LZ';

// private

function GetAveCharSize(Canvas: TCanvas): TPoint;
var
  I: Integer;
  Buffer: array[0..51] of Char;
begin
  for I := 0 to 25 do Buffer[I] := Chr(I + Ord('A'));
  for I := 0 to 25 do Buffer[I + 26] := Chr(I + Ord('a'));
  GetTextExtentPoint(Canvas.Handle, Buffer, 52, TSize(Result));
  Result.X := Result.X div 52;
end;

// public

procedure SetShowMessageHandle(h:HWND);
begin
  ShowMessageHandle:=h;
end;

procedure ShowMessage(title,msg:string);
begin
  MessageBox(ShowMessageHandle,pchar(msg),pchar(title),MB_OK);
end;

function InputQuery(const ACaption, APrompt: string;
  var Value: string): Boolean;
var
  Form: TForm;
  Prompt: TLabel;
  Edit: TEdit;
  DialogUnits: TPoint;
  ButtonTop, ButtonWidth, ButtonHeight: Integer;
begin
  Result := False;
  Form := TForm.Create(Application);
  with Form do
    try
      Canvas.Font := Font;
      DialogUnits := GetAveCharSize(Canvas);
      BorderStyle := bsDialog;
      Caption := ACaption;
      ClientWidth := MulDiv(180, DialogUnits.X, 4);
      Position := poScreenCenter;
      Prompt := TLabel.Create(Form);
      with Prompt do
      begin
        Parent := Form;
        Caption := APrompt;
        Left := MulDiv(8, DialogUnits.X, 4);
        Top := MulDiv(8, DialogUnits.Y, 8);
        Constraints.MaxWidth := MulDiv(164, DialogUnits.X, 4);
        WordWrap := True;
      end;
      Edit := TEdit.Create(Form);
      with Edit do
      begin
        Parent := Form;
        Left := Prompt.Left;
        Top := Prompt.Top + Prompt.Height + 5;
        Width := MulDiv(164, DialogUnits.X, 4);
        MaxLength := 255;
        Text := Value;
        SelectAll;
      end;
      ButtonTop := Edit.Top + Edit.Height + 15;
      ButtonWidth := MulDiv(50, DialogUnits.X, 4);
      ButtonHeight := MulDiv(14, DialogUnits.Y, 8);
      with TButton.Create(Form) do
      begin
        Parent := Form;
        Caption := SMsgDlgOK;
        ModalResult := mrOk;
        Default := True;
        SetBounds(MulDiv(38, DialogUnits.X, 4), ButtonTop, ButtonWidth,
          ButtonHeight);
      end;
      with TButton.Create(Form) do
      begin
        Parent := Form;
        Caption := SMsgDlgCancel;
        ModalResult := mrCancel;
        Cancel := True;
        SetBounds(MulDiv(92, DialogUnits.X, 4), Edit.Top + Edit.Height + 15,
          ButtonWidth, ButtonHeight);
        Form.ClientHeight := Top + Height + 13;          
      end;
      if ShowModal = mrOk then
      begin
        Value := Edit.Text;
        Result := True;
      end;
    finally
      Form.Free;
    end;
end;

function InputBox(const ACaption, APrompt, ADefault: string): string;
begin
  Result := ADefault;
  InputQuery(ACaption, APrompt, Result);
end;

function MessageDlgisOK(title,msg:string;MB:integer):boolean;
var
  res:integer;
begin
  res:=MessageBox(HWND(0),pchar(msg),pchar(title),MB_OKCancel or MB);

  case res of
    ID_OK:       Result:=True;
    ID_IDCANCEL: Result:=False;
    ID_ABORT:    Result:=False;
    ID_RETRY:    Result:=True;
    ID_IGNORE:   Result:=True;
    ID_YES:      Result:=True;
    ID_NO:       Result:=False;
    ID_TRYAGAIN: Result:=True;
    ID_CONTINUE: Result:=True;
    else Result:=False;
  end;
end;

end.
