unit _WADSPPlugin;

interface

uses
  Windows,SysUtils,Registry, _WM_DSP;

type
  TWADSPPlugin = class
  private
    { Private 錾 }
    PWM_DSPHeader:PwinampDSPHeader;
    PWM_DSPModule:PwinampDSPModule;
    HDSP:HMODULE;
  public
    { Public 錾 }
    procedure InitRegistry(AlredyInit:boolean);
    function Init(Handle:THandle):boolean;
    procedure Close;
    procedure Render(var buf:array of smallint;len:cardinal;PCMRate:dword);
    procedure ShowConfig;
  end;

var
  WADSPPlugin:TWADSPPlugin;
  WADSPPluginLoaded:boolean;

implementation

uses _WM_RESOURCE,_const;

procedure TWADSPPlugin.Render(var buf:array of smallint;len:cardinal;PCMRate:dword);
begin
  PWM_DSPModule.ModifySamples(PWM_DSPModule,addr(buf),(len div 4),16,2,PCMRate);
end;

procedure TWADSPPlugin.InitRegistry(AlredyInit:boolean);
var
  reg:TRegistry;
  path:string;
  skinfn:string;
begin
  Reg:=TRegistry.Create;
  Reg.RootKey:=HKEY_LOCAL_MACHINE;
  path:='\SOFTWARE\Ioscasoft\Enhancer\Version 017';
  if (AlredyInit<>False) or (Reg.KeyExists(path)<>True) then begin
    if Reg.OpenKey(path, True)=True then begin
      Reg.WriteInteger('Volume',$00000028);
      Reg.WriteInteger('Harm Bass',$00000018);
      Reg.WriteInteger('Harm Bass range',$00000064);
      Reg.WriteInteger('Drum Bass',$0000003d);
      Reg.WriteInteger('Drum Bass range',$00000047);
      Reg.WriteInteger('Dry Signal',$00000064);
      Reg.WriteInteger('Harm Treble',$00000027);
      Reg.WriteInteger('Harm Treble Range',$0000003e);
      Reg.WriteInteger('Ambience',$0000000b);
      Reg.WriteInteger('Ambience Range',$00000064);
      Reg.WriteInteger('Boosted',$00000001);
      Reg.WriteInteger('Window X',$00000000);
      Reg.WriteInteger('Window Y',$00000000);
      Reg.CloseKey;
    end;
  end;
  Reg.Free;

  Reg:=TRegistry.Create;
  Reg.RootKey:=HKEY_LOCAL_MACHINE;
  path:='\SOFTWARE\Ioscasoft\Enhancer\Version 017';
  if Reg.OpenKey(path, True)=True then begin
    Reg.WriteInteger('Window State',$00000002);
    Reg.CloseKey;
  end;
  Reg.Free;

  Reg:=TRegistry.Create;
  Reg.RootKey:=HKEY_LOCAL_MACHINE;
  path:='\SOFTWARE\Ioscasoft\Enhancer\Version 017\Skin File';
  if Reg.OpenKey(path, True)=True then begin
    if FileExists(Reg.ReadString(''))=False then begin
      skinfn:=StartPath+'Plugins\Enhancer\017\formdxwin.bmp';
      Reg.WriteString('',skinfn);
    end;
    Reg.CloseKey;
  end;
  Reg.Free;
end;

function TWADSPPlugin.Init(Handle:THandle):boolean;
begin
  Result:=False;
  InitRegistry(False);

  HDSP:=LoadLibrary('Plugins\dsp_enh.dll');
  if HDSP=0 then exit;

  winampDSPGetHeader2:=GetProcAddress(HDSP,'winampDSPGetHeader2');
  if winampDSPGetHeader2.description<>'Enhancer v0.17' then exit;

  PWM_DSPHeader:=winampDSPGetHeader2;

  PWM_DSPModule:=PWM_DSPHeader.getModule(0);
  PWM_DSPModule.hwndParent:=Handle;
  PWM_DSPModule.hDllInstance:=FindHInstance(winampDSPGetHeader2);

  if PWM_DSPModule.init(PWM_DSPModule)<>0 then exit;

//  ShowConfig;
//  PWM_DSPModule.Quit(PWM_DSPModule);
//  FreeLibrary(HDSP);

  Result:=True;
end;

procedure TWADSPPlugin.Close;
begin
  PWM_DSPModule.Quit(PWM_DSPModule);
  FreeLibrary(HDSP);
end;

procedure TWADSPPlugin.ShowConfig;
begin
  PWM_DSPModule.config(PWM_DSPModule);
end;

initialization
  WADSPPlugin:=nil;
  WADSPPluginLoaded:=False;
  
end.

