unit _WinFMP_Moonlight;

interface

uses
  Windows, ActiveX, SysUtils, _SimpleDialog,_const;

const
  _MAX_PATH=260;

  SOUND_55K=55555;
  SOUND_48K=48000;
  SOUND_44K=44100;
  SOUND_22K=22050;
  SOUND_11K=11025;

  PPZ8_i0=44100;
  PPZ8_i1=33080;
  PPZ8_i2=22050;
  PPZ8_i3=16540;
  PPZ8_i4=11025;
  PPZ8_i5= 8270;
  PPZ8_i6= 5513;
  PPZ8_i7= 4135;

type
  PPChar=^PChar;
  PByte=^Byte;
  Pword=^Word;
  PSmallInt=^SmallInt;

type
//=============================================================================
// IPCMMUSICDRIVER : hCo̊{IȃC^[tFCX`NX
//=============================================================================
  IPCMMUSICDRIVER = interface
    ['{9D4D6317-F40A-455E-9E2C-CB517556BA02}']
    function init(path : PChar) : Boolean; stdcall;
    function music_load(filename : PChar) : Integer; stdcall;
    function music_load2(musdata : Pointer; size : Integer) : Integer; stdcall;
    function getmusicfilename(dest : PChar): PChar; stdcall;
    procedure music_start; stdcall;
    procedure music_stop; stdcall;
    function getloopcount : Integer; stdcall;
    function getlength(filename : PChar; var length : Integer; var loop : Integer) : Boolean; stdcall;
    function getpos : Integer; stdcall;
    procedure setpos(pos : Integer); stdcall;
    procedure getpcmdata(buf : PSmallInt; nsamples : Integer); stdcall;
  end;

//=============================================================================
// IFMPMD : WinFMP, PMDWin ɋʂȃC^[tFCX`NX
//=============================================================================
  IFMPMD = interface(IPCMMUSICDRIVER)
    ['{81977D60-9496-4F20-A3BB-19B19943DA6D}']
    function loadrhythmsample(path : PChar) : Boolean; stdcall;
    function setpcmdir(pcmdir : PChar) : Boolean; stdcall;
    procedure setpcmrate(rate : Integer); stdcall;
    procedure setppzrate(rate : Integer); stdcall;
    procedure setfmcalc55k(flag : Boolean); stdcall;
    procedure setppzinterpolation(ip : Boolean); stdcall;
    procedure setfmwait(nsec : Integer); stdcall;
    procedure setssgwait(nsec : Integer); stdcall;
    procedure setrhythmwait(nsec : Integer); stdcall;
    procedure setadpcmwait(nsec : Integer); stdcall;
    procedure fadeout(speed : Integer); stdcall;
    procedure fadeout2(speed : Integer); stdcall;
    function getlength2(filename : PChar; var length : Integer; var loop : Integer) : Boolean; stdcall;
    function getpos2 : Integer; stdcall;
    procedure setpos2(pos : Integer); stdcall;
    function getpcmfilename(dest : PChar) : PChar; stdcall;
    function getppzfilename(dest : PChar; bufnum : Integer) : PChar; stdcall;
  end;

const IID_IPCMMUSICDRIVER:TIID=(D1:$9D4D6317; D2:$F40A; D3:$455E; D4:($9E,$2C,$CB,$51,$75,$56,$BA,$02));
const IID_IFMPMD:TIID=(D1:$81977D60; D2:$9496; D3:$4F20; D4:($A3,$BB,$19,$B1,$99,$43,$DA,$6D));

const WINFMP_DLLNAME='WinFMP.dll';
const WINFMP_MININTERFACEVERSION=007;
const WINFMP_MAXINTERFACEVERSION=100;
const FMP_InterfaceVersion=007;

const WINFMP_OK=0; // I
const FMP_ERR_OPEN_MUSIC_FILE=1; //  f[^JȂ
const FMP_ERR_WRONG_MUSIC_FILE=2; // PMD ̋ȃf[^ł͂Ȃ
const FMP_ERR_OPEN_PVI_FILE=3; // PVI JȂ
const FMP_ERR_OPEN_PPZ1_FILE=6; // PPZ1 JȂ
const FMP_ERR_WRONG_PVI_FILE=8; // PVI ł͂Ȃ
const FMP_ERR_WRONG_PPZ1_FILE=11; // PVI ł͂Ȃ(PPZ1)
const FMP_WARNING_PVI_ALREADY_LOAD=13; // PVI ͂łɓǂݍ܂Ă
const FMP_WARNING_PPZ1_ALREADY_LOAD=16; // PPZ1 ͂łɓǂݍ܂Ă

const FMP_ERR_WRONG_PARTNO=30; // p[gԍsK
const FMP_ERR_ALREADY_MASKED=31; // wp[g͂łɃ}XNĂ
const FMP_ERR_NOT_MASKED=32; // wp[g̓}XNĂȂ
const FMP_ERR_MUSIC_STOPPED=33; // Ȃ~܂Ă̂Ƀ}XN

const FMP_ERR_OUT_OF_MEMORY=99; // Ȃ

const FMP_MAX_PCMDIR=64;

const FMP_NumOfFMPart=6;
const FMP_NumOfSSGPart=3;
const FMP_NumOfADPCMPart=1;
const FMP_NumOFOPNARhythmPart=1;
const FMP_NumOfExtPart=3;
const FMP_NumOfPPZ8Part=8;
const FMP_NumOfAllPart=(FMP_NumOfFMPart+FMP_NumOfSSGPart+FMP_NumOfADPCMPart+FMP_NumOFOPNARhythmPart+FMP_NumOfExtPart+FMP_NumOfPPZ8Part);

const FMP_MUSDATASIZE=65536; // őȃf[^TCY
const FMP_COMMENTDATASIZE=8192; // őRsRgTCY

const FMP_SYS_PPZ8USE=$0040; // ooyWt@Cgp
const FMP_SYS_FADE=$2000; // tF[hAEg
const FMP_SYS_LOOP=$4000; // [v
const FMP_SYS_STOP=$8000; // t~
const FMP_SYS_INIT=FMP_SYS_STOP;

const FMP_PCM_USEV1=$0001; // ouhPgp
const FMP_PCM_USEZ1=$0010; // ooyPgp
const FMP_WLFO_SYNC=$0080; // VNrbg

type
  // ken[N\̒`
  PLFOS=^TLFOS;
  TLFOS=record
    LfoSdelay  :Integer; // ru[g fBCl
    LfoSspeed  :Integer; // ru[g Xs[h
    LfoScnt_dly:Integer; // ru[g fBCJE^
    LfoScnt_spd:Integer; // ru[g Xs[hJE^
    LfoSdepth  :Integer; // ru[g 炵JEgl
    LfoScnt_dep:Integer; // ru[g 炵JE^
    LfoSrate1  :Integer; // ru[g l
    LfoSrate2  :Integer; // ru[g liTuj
    LfoSwave   :Integer; // ru[g g`
  end;
  PALFOS=^TALFOS;
  TALFOS=record
    AlfoSdelay	 :Integer; // g fBCl
    AlfoSspeed	 :Integer; // g Xs[h
    AlfoScnt_dly :Integer; // g fBCJE^
    AlfoScnt_spd :Integer; // g Xs[h
    AlfoSdepth	 :Integer; // g ω
    AlfoScnt_dep :Integer; // g ωʃJE^
    AlfoSrate	 :Integer; // g l
    AlfoSrate_org:Integer; // g l
  end;
  PWLFOS=^TWLFOS;
  TWLFOS=record
    WlfoSdelay	 :Integer; // EE fBCl
    WlfoSspeed	 :Integer; // EE Xs[h
    WlfoScnt_dly :Integer; // EE fBCJE^
    WlfoScnt_spd :Integer; // EE Xs[hJE^
    WlfoSdepth	 :Integer; // EE ω
    WlfoScnt_dep :Integer; // EE ωʃJE^
    WlfoSrate	 :Integer; // EE l
    WlfoSrate_org:Integer; // EE ݂̂炵l
    WlfoSrate_now:Integer; // EE ݂̂炵l
    WlfoSsync	 :Integer; // EE VN^}XN
  end;
  PPITS=^TPITS;
  TPITS=record
    PitSdat   :Integer; // sb`xhωl
    PitSdelay :Integer; // fBCl
    PitSspeed :Integer; // Xs[h
    PitScnt   :Integer; // Xs[hJE^
    PitSwave  :Integer; // ڕWg
    PitStarget:Integer; // ڕWK
  end;

  PENVS=^TENVS;
  TENVS=record
    EnvSsv:Integer; // X^[gH[
    EnvSar:Integer; // A^bN[g
    EnvSdr:Integer; // fBPC[g
    EnvSsl:Integer; // TXeBx
    EnvSsr:Integer; // TXeB[g
    EnvSrr:Integer; // [X[g
  end;

  // p[g[N\̒`
  PCPATS=^TCPATS;
  TCPATS=record
    PartSlfo_f :Integer; // kenԃtO
    PartSdeflen:Integer; // ftHg̉
    PartSvol   :Integer; // ݂̉
    PartSdat_q :Integer; // Q[grl
    PartScnt   :Integer; // JE^
    PartSorg_q :Integer; // Q[gpJE^
    PartStmpvol:Integer; // ۂ̏o͉
    PartSdat_k :Integer; // jx点l
    PartScnt_k :Integer; // jx点pJE^
    PartSbefore:Integer; // PỎ
    PartSstatus:Integer; // ԃtO
    PartSsync  :Integer; // VNtO
    PartSdetune:Integer; // f`[l
    PartSpitch :TPITS;   // sb`xhp[N
    PartSlfo   :Array[0..3-1] of TLFOS; // ru[gkeniOCPCQj
    PartSwave  :Integer; // ۂ̏o͎g
    PartSwave2 :Integer; // PȌo͎g
    PartSxtrns :Integer; // K̂p
    PartStone  :Integer; // ݂̉Fԍ
    PartSkeyon :Integer; // Oj擾p
    PartSpan   :Integer; // p擾p
    PartSalg   :Integer; // ݂̃ASYԍ
    PartSio    :Integer; // o͂h^nAhX
    PartSpoint :Pointer; // ǂݍ݃|C^
    PartSloop  :Pointer; // Ԃ|C^
    PartSchan  :Integer; // `lʗp
    PartSbit   :Integer; // `lbit
    PartSport  :Integer; // elAhXANZXp
  end;

  // elp[g[N\
  PFPATS=^TFPATS;
  TFPATS=record
    FpatSaddr	 :Pointer; // skAhX
    FpatSalfo	 :TALFOS;  // gp[N
    FpatSwlfo	 :TWLFOS;  // EEp[N
    FpatS_hdly	 :Integer; // gkenfBC
    FpatS_hdlycnt:Integer; // gkenJE^
    FpatS_hfreq	 :Integer; // gken@
    FpatS_hapms	 :Integer; // gken@olr^`lr
    FpatSextend	 :Integer; // extend[h
    FpatSslot_v	 :Array[0..4-1] of Integer; // XbgƂ̑Βl
  end;

  // rrfp[g[N\
  PSPATS=^TSPATS;
  TSPATS=record
    SpatSnow_vol:Integer; // ݂̉
    SpatSflg	:Integer; // GF[vԃtO
    SpatSoct	:Integer; // IN^[u
    SpatSvol	:Integer; // ݂̏o͉
    SpatSenv	:TENVS;   // \tgEFAGx[v
    SpatSenvadr	:PENVS;   // SSG Env pattern Address
  end;

  // `coblp[g[N\
  PAPATS=^TAPATS;
  TAPATS=record
    ApatSstart:Integer; // obl X^[gAhX
    ApatSend  :Integer; // obl GhAhX
    ApatSdelta:Integer; // obl ml
  end;

  // p[g[N\
  PPARTS=^TPARTS;
  TPARTS=record
    CPatS:TCPATS; // ʃ[N
    case Integer of
      0: (FPatS:TFPATS;); // elp[g[N\
      1: (SPatS:TSPATS;); // rrfp[g[N\
      2: (APatS:TAPATS;); // `coblp[g[N\
  end;

  // tF[hAEgf[^\
  PFADES=^TFADES;
  TFADES=record
    FadeSfm  :Integer;
    FadeSssg :Integer;
    FadeSrhy :Integer;
    FadeSapcm:Integer;
  end;

  // O[N\
  PSYNCS = ^TSYNCS;
  TSYNCS = record
    SyncSdat:Integer; // f[^
    SyncScnt:Integer; // JEg
  end;

  // elo[N\
  PFMPS=^TFMPS;
  TFMPS=record
    FmpStempo  :Integer; // 00 ݂̃e|
    FmpSsync   :TSYNCS;  // 01 Of[^
    FmpSsysbit :Integer; // 0a eloXe[^X
    FmpScnt_c  :Integer; // 0c ȉtNbN
    FmpScnt_t  :Integer; // 0e ҂JE^
    FmpSfade   :TFADES;  // 0f tF[hAEg
    FmpSfade_o :TFADES;  // 13 tF[hAEgʁiIWij
    FmpSloop_c :Integer; // 14 ȃ[v
    FmpStempo_t:Integer; // 17 ݂̃e|i\j
    FmpSmix_s  :Integer; // 18 ??FEDFED
    FmpStimer  :Integer; // 19 ^C}[[hl
    FmpSnoise  :Integer; // 1a rrf̃mCYg
    FmpSsho    :Integer; // 1b ߃JE^
    FmpSpcmuse :Integer; // 1d oblgp
    FmpScnt_ct :Integer; // 1f ȑS̃JEg
    FmpScnt_cl :Integer; // 23 ȃ[vJEg
    FmpSmix_e  :Integer; // 29 ʉmixer
    FmpStempo_e:Integer; // 2a ʉ̃ftHge|
  end;

  // S̃[N
  PWORKS=^TWORKS;
  TWORKS=record
    ExtBuff:TFMPS; // OQƋ[N
    _F:Array[0..FMP_NumOfFMPart  -1] of TPARTS; // el[N
    _A:TPARTS; // `cobl[N
    _X:Array[0..FMP_NumOfExtPart -1] of TPARTS; // elextend[N
    _P:Array[0..FMP_NumOfPPZ8Part-1] of TPARTS; // obl(ppz8)[N
    _S:Array[0..FMP_NumOfSSGPart -1] of TPARTS; // rrf[N

    // Y[N
    R_key      :Array[0..16-1] of Integer; // ΂ɕςȂ
    R_mask     :Integer;
    R_Oncho_cnt:Integer;
    R_Oncho_def:Integer;
    RTL_vol    :Integer;
    R_vol      :Array[0..6-1] of Integer;
    R_pan      :Array[0..6-1] of Integer;
    R_Loop_now :Integer;
    R_Sync_flg :Integer;
    R_State_flg:Integer; // Cl[utO
    _R         :TPARTS;

    // f[^[N
    TotalLoop    :Integer; // [vIJE^
    Loop_cnt     :Integer; // [vI
    Int_fcT      :Integer; // 荞݃tF[hJE^
    Int_fc       :Integer; // 荞݃tF[hJE^
    TimerA_cnt   :Integer; // sfBC
    Ver          :Integer; // ȃf[^o[W
    NowPPZmode   :Integer; // ݂̂ooy̍Đ[h
    MusicClockCnt:Integer; // Ȃ̃NbNJEg(C??)
    ClockCnt     :Integer; // NbNJEg
    PcmHardVol   :Integer; // obln[h
    ExtendKeyon  :Integer; // extendԂ3chkeyon
    ExtendAlg    :Integer; // extend`l̃ASY

    // f[^[N
    FM_effect_dat:Array[0..4-1] of Integer; // ʉ[h炵l
    Play_flg     :Integer; // ttO
    Loop_flg     :Integer; // [vtO
    Int_CX       :Integer; // 荞݃tF[hJE^

    // `lʃ[NAhXe[u
    Chan_tbl_R:PPARTS; // Y
    Chan_tbl  :Array[0..FMP_NumOfFMPart+FMP_NumOfSSGPart+FMP_NumOfPPZ8Part+1+FMP_NumOfExtPart+1-1] of PPARTS;

    EnvAddr:Array[0..FMP_NumOfSSGPart - 1] of TENVS; // rrfGx[v[N

    Music_name:Array[0.._MAX_PATH-1] of Char;	// t̋Ȃ̃t@C
    PVI_name:Array[0.._MAX_PATH-1] of Char;   // ݂̂oblt@C

    // vhmelopf[^
    rate           :Integer; // PCM o͎g(11k, 22k, 44k, 55k)
    ppz8ip         :Boolean; // PPZ8 ŕ⊮邩
    fadeout2_speed :Integer; // fadeout()speed(>0 fadeout)
    lastSyncExtTime:Integer; // Ō Sync_Ext s(ms/JIPpj
    pcmdir         :Array[0..FMP_MAX_PCMDIR+1-1, 0.._MAX_PATH-1] of char; // PCM fBNg
  end;


  //--------------------------------------------------------------------------
  //	RsRg|C^[N
  //--------------------------------------------------------------------------
  PComment=^TComment;
  TComment=Array[0..3-1] of PChar;


  //===========================================================================
  // IWINFMP : WINFMP  Interface Class
  //===========================================================================
  IWINFMP = interface(IFMPMD)
    ['{B7910277-0295-4052-9A65-5AD48D0F3477}']
    function maskon(rhythm_flag : Boolean; ah : Integer) : Integer; stdcall;
    function maskoff(rhythm_flag : Boolean; ah : Integer) : Integer; stdcall;
    procedure setfmvoldown(voldown : Integer); stdcall;
    procedure setssgvoldown(voldown : Integer); stdcall;
    procedure setrhythmvoldown(voldown : Integer); stdcall;
    procedure setadpcmvoldown(voldown : Integer); stdcall;
    procedure setppzvoldown(voldown : Integer); stdcall;
    function getfmvoldown : Integer; stdcall;
    function getssgvoldown : Integer; stdcall;
    function getrhythmvoldown : Integer; stdcall;
    function getadpcmvoldown : Integer; stdcall;
    function getppzvoldown : Integer; stdcall;
    procedure setpos(pos:Integer); stdcall;
    procedure setpos2(pos:Integer); stdcall;
    function getpos:Integer; stdcall;
    function getpos2:Integer; stdcall;
    function getcomment(dest : PChar; musdata : Pointer; size : Integer) : PChar; stdcall;
    function getcomment2(dest : PChar; musdata : Pointer; size : Integer) : PChar; stdcall;
    function getcomment3(dest : TComment; musdata : Pointer; size : Integer) : PComment; stdcall;
    function fgetcomment(dest : PChar; filename : PChar) : Integer; stdcall;
    function fgetcomment2(dest : PChar; filename : PChar)  : Integer; stdcall;
    function fgetcomment3(dest : TComment; filename : PChar)  : Integer; stdcall;
    function getdefinedpcmfilename(dest : PChar; musdata : Pointer; size : Integer) : PChar; stdcall;
    function getdefinedppzfilename(dest : PChar; musdata : Pointer; size : Integer; bufnum : Integer) : PChar; stdcall;
    function fgetdefinedpcmfilename(dest : PChar; filename : PChar) : Integer; stdcall;
    function fgetdefinedppzfilename(dest : PChar; filename : PChar; bufnum : Integer) : Integer; stdcall;
    function getsyncscnt : Integer; stdcall;
    function getlastsyncexttime : Integer; stdcall;
    function getworks : PWORKS; stdcall;
    procedure setadpcmppz8emulate(flag : Boolean); stdcall;
  end;

const
  IID_IWINFMP:TIID=(D1:$B7910277; D2:$0295; D3:$4052; D4:($9A,$65,$5A,$D4,$8D,$0F,$34,$77));
  CLSID_WINFMP:TCLSID=(D1:$3E7816B4; D2:$EB8F; D3:$435F; D4:($BC,$37,$01,$CE,$DB,$F4,$22,$87));

//=============================================================================
// DLL Interface
//=============================================================================
var
  HWinFMP : HMODULE;

  fmp_getversion:function:Integer;stdcall;
  fmp_getinterfaceversion:function:Integer;stdcall;
  fmp_CoCreateInstance:function(const rclsid:TCLSID;pUnkOuter:IUnknown;dwClsContext:Longint;const riid:TIID;var ppv):HResult;stdcall;

  fmp_init:function(path:PChar):Boolean;stdcall;
  fmp_load:function(filename:PChar):Integer;stdcall;
  fmp_load2:function(musdata:Pointer;size:Integer):Integer;stdcall;
  fmp_start:procedure;stdcall;
  fmp_stop:procedure;stdcall;
  fmp_getpcmdata:procedure(buf:PSmallInt;nsamples:Integer);stdcall;
  fmp_maskon:function(rhythm_flag:Boolean;ah:Integer):Integer;stdcall;
  fmp_maskoff:function(rhythm_flag:Boolean;ah:Integer):Integer;stdcall;
  fmp_loadrhythmsample:function(path:PChar):Boolean;stdcall;
  fmp_setpcmdir:function(pcmdir:PChar):Boolean;stdcall;
  fmp_setpcmrate:procedure(rate:Integer);stdcall;
  fmp_setppzrate:procedure(rate:Integer);stdcall;
  fmp_fadeout:procedure(speed:Integer);stdcall;
  fmp_fadeout2:procedure(speed:Integer);stdcall;
  fmp_setfmcalc55k:procedure(flag:Boolean);stdcall;
  fmp_setppzinterpolation:procedure(ip:Boolean);stdcall;
  fmp_setadpcmppz8emulate:procedure(flag:Boolean);stdcall;
  fmp_getcomment:function(dest:PChar;musdata:Pointer;size:Integer):PChar;stdcall;
  fmp_getcomment2:function(dest:PChar;musdata:Pointer;size:Integer):PChar;stdcall;
  fmp_getcomment3:function(dest:TComment;musdata:Pointer;size:Integer):PComment;stdcall;
  fmp_fgetcomment:function(dest:PChar;filename:PChar):Integer;stdcall;
  fmp_fgetcomment2:function(dest:PChar;filename:PChar):Integer;stdcall;
  fmp_fgetcomment3:function(dest:TComment;filename:PChar):Integer;stdcall;
  fmp_getdefinedpcmfilename:function(dest:PChar;musdata:Pointer;size:Integer):PChar;stdcall;
  fmp_getdefinedppzfilename:function(dest:PChar;musdata:Pointer;size:Integer;bufnum:Integer):PChar;stdcall;
  fmp_fgetdefinedpcmfilename:function(dest:PChar;filename:PChar):Integer;stdcall;
  fmp_fgetdefinedppzfilename:function(dest:PChar;filename:PChar;bufnum:Integer):Integer;stdcall;
  fmp_getmusicfilename:function(dest:PChar):PChar;stdcall;
  fmp_getpcmfilename:function(dest:PChar):PChar;stdcall;
  fmp_getppzfilename:function(dest:PChar;bufnum:Integer):PChar;stdcall;
  fmp_setfmvoldown:procedure(voldown:Integer);stdcall;
  fmp_setssgvoldown:procedure(voldown:Integer);stdcall;
  fmp_setrhythmvoldown:procedure(voldown:Integer);stdcall;
  fmp_setadpcmvoldown:procedure(voldown:Integer);stdcall;
  fmp_setppzvoldown:procedure(voldown:Integer);stdcall;
  fmp_getfmvoldown:function:Integer;stdcall;
  fmp_getssgvoldown:function:Integer;stdcall;
  fmp_getrhythmvoldown:function:Integer;stdcall;
  fmp_getadpcmvoldown:function:Integer;stdcall;
  fmp_getppzvoldown:function:Integer;stdcall;
  fmp_setpos:procedure(pos:Integer);stdcall;
  fmp_setpos2:procedure(pos:Integer);stdcall;
  fmp_getpos:function:Integer;stdcall;
  fmp_getpos2:function:Integer;stdcall;
  fmp_getlength:function(filename:PChar;var length:Integer;var loop:Integer):Boolean;stdcall;
  fmp_getlength2:function(filename:PChar;var length:Integer;var loop:Integer):Boolean;stdcall;
  fmp_getloopcount:function:Integer;stdcall;
  fmp_setfmwait:procedure(nsec:Integer);stdcall;
  fmp_setssgwait:procedure(nsec:Integer);stdcall;
  fmp_setrhythmwait:procedure(nsec:Integer);stdcall;
  fmp_setadpcmwait:procedure(nsec:Integer);stdcall;
  fmp_getsyncscnt:function:Integer;stdcall;
  fmp_getlastsyncexttime:function:Integer;stdcall;
  fmp_getworks:function:PWORKS;stdcall;

function FMP_LoadDLL:boolean;
procedure FMP_FreeDLL;
function FMP_GetCopyright:string;

implementation

function GetProcAddress2(hModule: HMODULE; lpProcName: LPCSTR): FARPROC; stdcall;
begin
  Result:=GetProcAddress(hModule,lpProcName);
  if(result=nil) then begin // ֐AhX擾łȂƋI
    ShowMessage('WinFMP.DLLǂݍ݃G[','WinFMP.DLLjĂ܂B');
    Halt;
  end;
end;

function FMP_LoadDLL:boolean;
begin
  HWinFMP := LoadLibrary(WINFMP_DLLNAME);
  if(HWinFMP = 0) then begin
    Result:=False;
    exit;
  end;

  // o[W`FbN
  fmp_getversion := GetProcAddress2(HWinFMP, 'fmp_getversion');
  fmp_getinterfaceversion := GetProcAddress2(HWinFMP, 'fmp_getinterfaceversion');

  if(fmp_getinterfaceversion < WINFMP_MININTERFACEVERSION) then begin
    ShowMessage('WinFMP.DLLǂݍ݃G[','WinFMP.DLLVer0.07`0.99gpĂB');
    Result:=False;
    exit;
  end;

  if(fmp_getinterfaceversion >= WINFMP_MAXINTERFACEVERSION) then begin
    ShowMessage('WinFMP.DLLǂݍ݃G[','WinFMP.DLLVer0.07`0.99gpĂB');
    Result:=False;
    exit;
  end;

  if (fmp_getversion=014) then begin
    ShowMessage('WinFMP.DLLǂݍ݃G[','WinFMP.DLL Ver0.14͐Ȃo[WłB'+chr(13)+'Ver0.13ȑOVer0.15ȍ~gƂ߂܂B');
  end;

  // CX^X擾֐
  fmp_CoCreateInstance:=GetProcAddress2(HWinFMP,'fmp_CoCreateInstance');

  // c̊֐AhX̎擾
  fmp_init:=GetProcAddress2(HWinFMP,'fmp_init');
  fmp_load:=GetProcAddress2(HWinFMP,'fmp_load');
  fmp_load2:=GetProcAddress2(HWinFMP,'fmp_load2');
  fmp_start:=GetProcAddress2(HWinFMP,'fmp_start');
  fmp_stop:=GetProcAddress2(HWinFMP,'fmp_stop');
  fmp_getpcmdata:=GetProcAddress2(HWinFMP,'fmp_getpcmdata');
  fmp_maskon:=GetProcAddress2(HWinFMP,'fmp_maskon');
  fmp_maskoff:=GetProcAddress2(HWinFMP,'fmp_maskoff');
  fmp_loadrhythmsample:=GetProcAddress2(HWinFMP,'fmp_loadrhythmsample');
  fmp_setpcmdir:=GetProcAddress2(HWinFMP,'fmp_setpcmdir');
  fmp_setpcmrate:=GetProcAddress2(HWinFMP,'fmp_setpcmrate');
  fmp_setppzrate:=GetProcAddress2(HWinFMP,'fmp_setppzrate');
  fmp_fadeout:=GetProcAddress2(HWinFMP,'fmp_fadeout');
  fmp_fadeout2:=GetProcAddress2(HWinFMP,'fmp_fadeout2');
  fmp_setfmcalc55k:=GetProcAddress2(HWinFMP,'fmp_setfmcalc55k');
  fmp_setppzinterpolation:=GetProcAddress2(HWinFMP,'fmp_setppzinterpolation');
  fmp_setadpcmppz8emulate:=GetProcAddress2(HWinFMP,'fmp_setadpcmppz8emulate');
  fmp_getcomment:=GetProcAddress2(HWinFMP,'fmp_getcomment');
  fmp_getcomment2:=GetProcAddress2(HWinFMP,'fmp_getcomment2');
  fmp_getcomment3:=GetProcAddress2(HWinFMP,'fmp_getcomment3');
  fmp_fgetcomment:=GetProcAddress2(HWinFMP,'fmp_fgetcomment');
  fmp_fgetcomment2:=GetProcAddress2(HWinFMP,'fmp_fgetcomment2');
  fmp_fgetcomment3:=GetProcAddress2(HWinFMP,'fmp_fgetcomment3');
  fmp_getdefinedpcmfilename:=GetProcAddress2(HWinFMP,'fmp_getdefinedpcmfilename');
  fmp_getdefinedppzfilename:=GetProcAddress2(HWinFMP,'fmp_getdefinedppzfilename');
  fmp_fgetdefinedpcmfilename:=GetProcAddress2(HWinFMP,'fmp_fgetdefinedpcmfilename');
  fmp_fgetdefinedppzfilename:=GetProcAddress2(HWinFMP,'fmp_fgetdefinedppzfilename');
  fmp_getmusicfilename:=GetProcAddress2(HWinFMP,'fmp_getmusicfilename');
  fmp_getpcmfilename:=GetProcAddress2(HWinFMP,'fmp_getpcmfilename');
  fmp_getppzfilename:=GetProcAddress2(HWinFMP,'fmp_getppzfilename');
  fmp_setfmvoldown:=GetProcAddress2(HWinFMP,'fmp_setfmvoldown');
  fmp_setssgvoldown:=GetProcAddress2(HWinFMP,'fmp_setssgvoldown');
  fmp_setrhythmvoldown:=GetProcAddress2(HWinFMP,'fmp_setrhythmvoldown');
  fmp_setadpcmvoldown:=GetProcAddress2(HWinFMP,'fmp_setadpcmvoldown');
  fmp_setppzvoldown:=GetProcAddress2(HWinFMP,'fmp_setppzvoldown');
  fmp_getfmvoldown:=GetProcAddress2(HWinFMP,'fmp_getfmvoldown');
  fmp_getssgvoldown:=GetProcAddress2(HWinFMP,'fmp_getssgvoldown');
  fmp_getrhythmvoldown:=GetProcAddress2(HWinFMP,'fmp_getrhythmvoldown');
  fmp_getadpcmvoldown:=GetProcAddress2(HWinFMP,'fmp_getadpcmvoldown');
  fmp_getppzvoldown:=GetProcAddress2(HWinFMP,'fmp_getppzvoldown');
  fmp_setpos:=GetProcAddress2(HWinFMP,'fmp_setpos');
  fmp_setpos2:=GetProcAddress2(HWinFMP,'fmp_setpos2');
  fmp_getpos:=GetProcAddress2(HWinFMP,'fmp_getpos');
  fmp_getpos2:=GetProcAddress2(HWinFMP,'fmp_getpos2');
  fmp_getlength:=GetProcAddress2(HWinFMP,'fmp_getlength');
  fmp_getlength2:=GetProcAddress2(HWinFMP,'fmp_getlength2');
  fmp_getloopcount:=GetProcAddress2(HWinFMP,'fmp_getloopcount');
  fmp_setfmwait:=GetProcAddress2(HWinFMP,'fmp_setfmwait');
  fmp_setssgwait:=GetProcAddress2(HWinFMP,'fmp_setssgwait');
  fmp_setrhythmwait:=GetProcAddress2(HWinFMP,'fmp_setrhythmwait');
  fmp_setadpcmwait:=GetProcAddress2(HWinFMP,'fmp_setadpcmwait');
  fmp_getsyncscnt:=GetProcAddress2(HWinFMP,'fmp_getsyncscnt');
  fmp_getlastsyncexttime:=GetProcAddress2(HWinFMP,'fmp_getlastsyncexttime');
  fmp_getworks:=GetProcAddress2(HWinFMP,'fmp_getworks');
  
  Result:=True;
end;

procedure FMP_FreeDLL;
begin
  if(HWinFMP<>0) then
    FreeLibrary(HWinFMP);
end;

function FMP_GetCopyright:string;
begin
  Result:='FMP for Windows uFMPWinv'+format('Ver%1.2f InterfaceVer%1.2f',[fmp_getversion/100,fmp_getinterfaceversion/100])+CRLF;
  Result:=Result+'Copyright & Programmed by C60'+CRLF+CRLF;

  Result:=Result+'FM Sound Generator with OPN/OPM interface (fmgen 007a)'+CRLF;
  Result:=Result+'Copyright (C) by cisc 1998, 2003.'+CRLF+CRLF;

  Result:=Result+'FMP by Guu'+CRLF+'PPZ8 by Ukky'+CRLF+CRLF;
end;

end.

