// ̃jbgɊ܂܂֐́AC^[tF[XύXȂŉB

unit _fsTools;

interface

{$WARN UNIT_PLATFORM OFF}
{$WARN SYMBOL_PLATFORM OFF}

uses
  Windows,Classes;

function GetStreamMString(var fs:TFileStream):string;
function GetStreamByte(var fs:TFileStream):byte;
function GetStreamWord(var fs:TFileStream):word;
function GetStreamDWord(var fs:TFileStream):dword;
function GetStreamInteger(var fs:TFileStream):integer;
function GetStreamBoolean(var fs:TFileStream):boolean;
function GetStreamDateTime(var fs:TFileStream):TDateTime;
function GetStreamSingle(var fs:TFileStream):single;
procedure SetStreamMString(var fs:TFileStream;const MString:string);
procedure SetStreamByte(var fs:TFileStream;const b:byte);
procedure SetStreamWord(var fs:TFileStream;const w:word);
procedure SetStreamDWord(var fs:TFileStream;const dw:dword);
procedure SetStreamInteger(var fs:TFileStream;const int:integer);
procedure SetStreamBoolean(var fs:TFileStream;const bool:boolean);
procedure SetStreamDateTime(var fs:TFileStream;const dt:TDateTime);
procedure SetStreamSingle(var fs:TFileStream;const s:single);

function isAnkChar(c:byte):boolean;

implementation

function GetStreamMString(var fs:TFileStream):string;
var
  len:byte;
begin
  len:=GetStreamByte(fs);
  if len=0 then begin
    Result:='';
    end else begin
    SetLength(Result,len);
    fs.ReadBuffer(Result[1],len);
  end;
end;

function GetStreamByte(var fs:TFileStream):byte;
begin
  fs.Read(Result,1);
end;

function GetStreamWord(var fs:TFileStream):word;
begin
  fs.Read(result,2);
end;

function GetStreamDWord(var fs:TFileStream):dword;
begin
  fs.Read(result,4);
end;

function GetStreamInteger(var fs:TFileStream):integer;
begin
  fs.Read(result,4);
end;

function GetStreamBoolean(var fs:TFileStream):boolean;
begin
  if GetStreamByte(fs)=$00 then begin
    Result:=True;
    end else begin
    Result:=False;
  end;
end;

function GetStreamDateTime(var fs:TFileStream):TDateTime;
begin
  fs.Read(result,8);
end;

function GetStreamSingle(var fs:TFileStream):single;
begin
  fs.Read(result,4);
end;

procedure SetStreamMString(var fs:TFileStream;const MString:string);
var
  len:byte;
begin
  len:=length(MString);
  fs.Write(len,1);
  if len<>0 then begin
    fs.WriteBuffer(MString[1],len);
  end;
end;

procedure SetStreamByte(var fs:TFileStream;const b:byte);
begin
  fs.Write(b,1);
end;

procedure SetStreamWord(var fs:TFileStream;const w:word);
begin
  fs.Write(w,2);
end;

procedure SetStreamDWord(var fs:TFileStream;const dw:dword);
begin
  fs.Write(dw,4);
end;

procedure SetStreamInteger(var fs:TFileStream;const int:integer);
begin
  fs.Write(int,4);
end;

procedure SetStreamBoolean(var fs:TFileStream;const bool:boolean);
begin
  if bool=True then begin
    SetStreamByte(fs,$00);
    end else begin
    SetStreamByte(fs,$ff);
  end;
end;

procedure SetStreamDateTime(var fs:TFileStream;const dt:TDateTime);
begin
  fs.Write(dt,8);
end;

procedure SetStreamSingle(var fs:TFileStream;const s:single);
begin
  fs.Write(s,4);
end;

function isAnkChar(c:byte):boolean;
begin
  if (c<=$7f) then begin
    Result:=True;
    exit;
  end;
  if (c<=$9f) then begin
    Result:=False;
    exit;
  end;
  if (c<=$df) then begin
    Result:=True;
    exit;
  end;

  case c of
    $E0: Result:=False;
    $E1: Result:=False;
    $E2: Result:=False;
    $E3: Result:=False;
    $E4: Result:=False;
    $E5: Result:=False;
    $E6: Result:=False;
    $E7: Result:=False;
    $E8: Result:=False;
    $E9: Result:=False;
    $EA: Result:=False;
    $EB: Result:=True;
    $EC: Result:=True;
    $ED: Result:=False;
    $EE: Result:=False;
    $EF: Result:=True;
    $F0: Result:=False;
    $F1: Result:=False;
    $F2: Result:=False;
    $F3: Result:=False;
    $F4: Result:=True;
    $F5: Result:=True;
    $F6: Result:=True;
    $F7: Result:=True;
    $F8: Result:=True;
    $F9: Result:=True;
    $FA: Result:=False;
    $FB: Result:=False;
    $FC: Result:=False;
    $FD: Result:=True;
    $FE: Result:=True;
    $FF: Result:=True;
    else Result:=True;
  end;
end;

end.

