unit _termlog;

interface

uses
  Windows, SysUtils, Classes, Forms;

{$WARN UNIT_PLATFORM OFF}
{$WARN SYMBOL_PLATFORM OFF}

procedure TermLog(prc,msg:string);

implementation

var
  MemSync:TMultiReadExclusiveWriteSynchronizer;
  lgt:dword;
  wfn:string;

procedure TermLog(prc,msg:string);
var
  ngt:dword;
  T:TextFile;
begin
  MemSync.BeginWrite;

  ngt:=GetTickCount;
  AssignFile(T,wfn);
  if FileExists(wfn)=False then
    Rewrite(T)
    else
    Append(T);
  Writeln(T,formatdatetime('yyyymmdd-hhnnss',now)+'('+inttostr(ngt-lgt)+'):['+prc+'] '+msg);
  Flush(T);
  CloseFile(T);
  lgt:=ngt;

  MemSync.EndWrite;
end;

initialization
  MemSync:=TMultiReadExclusiveWriteSynchronizer.Create;
  lgt:=GetTickCount;
  wfn:=ExtractFilePath(Application.ExeName)+'terminal.log';
  if FileExists(wfn)=True then DeleteFile(wfn);
  TermLog('Start','terminal.log');

finalization
  MemSync.Free;
  MemSync:=nil;

end.
