unit oggencPrgDlg;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  ToggencPrg = class(TForm)
    procedure FormCreate(Sender: TObject);
  private
    { Private 錾 }
    str:string;
    LineHeight:integer;
    procedure DrawChar(c:char);
  public
    { Public 錾 }
    procedure DrawText(msg:string);
  end;

var
  oggencPrg: ToggencPrg;

implementation

{$R *.dfm}

procedure ToggencPrg.FormCreate(Sender: TObject);
begin
  str:='';

  oggencPrg.Color:=$000000;

  with oggencPrg.Canvas do begin
    Brush.Color:=$000000;
    Brush.Style:=bsSolid;
    Pen.Color:=$ffffff;
    Font.Color:=Pen.Color;
    FillRect(Bounds(0,0,ClientWidth,ClientHeight));
    LineHeight:=oggencPrg.Canvas.TextHeight('0')+4;
  end;

end;

procedure ToggencPrg.DrawText(msg:string);
var
  cnt:integer;
begin
  for cnt:=1 to length(msg) do begin
    DrawChar(msg[cnt]);
  end;
end;

procedure ToggencPrg.DrawChar(c:char);
begin
  if c=char($0d) then begin
    oggencPrg.Canvas.TextOut(8,ClientHeight-LineHeight,str);
    str:='';
    exit;
  end;

  if c=char($0a) then begin
    with oggencPrg do begin
      BitBlt(Canvas.Handle,0,0,ClientWidth,ClientHeight-LineHeight,Canvas.Handle,0,LineHeight,SRCCOPY);
      Canvas.FillRect(Bounds(0,ClientHeight-LineHeight,ClientWidth,14));
    end;
    exit;
  end;

  if c=char($09) then begin
    str:=str+'    ';
    exit;
  end;

  str:=str+c;
end;

end.
