unit CopyRightWin;

{$WARN UNIT_PLATFORM OFF}
{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  Windows, SysUtils, Forms, Dialogs, Classes, Controls, StdCtrls, Buttons,
  ComCtrls, ShellAPI;

type
  TCopyright = class(TForm)
    PageControl: TPageControl;
    TabSheet1: TTabSheet;
    MXDRVMemo: TMemo;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    TabSheet4: TTabSheet;
    FMPMemo: TMemo;
    PMDMemo: TMemo;
    FFTMemo: TMemo;
    URLTab: TTabSheet;
    TabSheet6: TTabSheet;
    InfomationMemo: TMemo;
    TabSheet8: TTabSheet;
    MP3Memo: TMemo;
    URLLst: TListBox;
    URLgoBtn: TBitBtn;
    URLLbl: TLabel;
    TabSheet9: TTabSheet;
    SPCMemo: TMemo;
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure FormCreate(Sender: TObject);
    procedure LstClick(Sender: TObject);
    procedure URLLblClick(Sender: TObject);
    procedure URLgoBtnClick(Sender: TObject);
    procedure URLLstDblClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    { Private 錾 }
    function CRLFConv(mes:string):string;
  public
    { Public 錾 }
    procedure RefreshCopyright;
  end;

var
  Copyright: TCopyright;

implementation

uses _CSkin,_SndDrv,_MDXWinINI,_SndDrv_const;

{$R *.DFM}

procedure TCopyright.FormCreate(Sender: TObject);
  procedure InitMemo(var Memo:TMemo);
  begin
    with Memo do begin
      Clear;
      Color:=CSkin.dwEtcBG;
      Font.Color:=CSkin.dwEtcBright;
      ReadOnly:=True;
    end;
  end;
  procedure InitList(var List:TListBox);
  begin
    with List do begin
      Clear;
      Color:=CSkin.dwEtcBG;
      Font.Color:=CSkin.dwEtcBright;
    end;
  end;
begin
  InitMemo(InfomationMemo);
  InitMemo(MXDRVMemo);
  InitMemo(FMPMemo);
  InitMemo(PMDMemo);
  InitMemo(SPCMemo);
  InitMemo(FFTMemo);
  InitMemo(MP3Memo);
  InitList(URLLst);
  PageControl.ActivePageIndex:=0;
end;

function TCopyright.CRLFConv(mes:string):string;
var
  cnt:integer;
  res:string;
begin
  mes:=chr(13)+mes;
  res:='';
  for cnt:=1 to length(mes) do begin
     if mes[cnt]=char(13) then
      res:=res+chr(13)+chr(10)
      else
      res:=res+mes[cnt];
  end;
  Result:=res;
end;

procedure TCopyright.RefreshCopyright;
var
  Copyright:string;
begin
  InfomationMemo.Clear;
  InfomationMemo.Text:=sdGetDriverInfomation;

  MXDRVMemo.Clear;
  if MXDRVm<>nil then MXDRVMemo.Text:=sdGetCopyright(DriverModeMXDRVm);
  if MXDRVg<>nil then MXDRVMemo.Text:=sdGetCopyright(DriverModeMXDRVg);
  FMPMemo.Clear;
  FMPMemo.Text:=sdGetCopyright(DriverModeFMP);
  PMDMemo.Clear;
  PMDMemo.Text:=sdGetCopyright(DriverModePMD);
  SPCMemo.Clear;
  SPCMemo.Text:=sdGetCopyright(DriverModeSPC);

  Copyright:='FFT jbg Ver.0.10 PascalConverted by C60'+chr(13);
  Copyright:=Copyright+'original by FuCɂASYv'+chr(13)+chr(13);
  Copyright:=Copyright+'Speana jbg Ver.0.11 Copyright & Programmed by C60'+chr(13);
  Copyright:=Copyright+'Included by Moonlight.'+chr(13)+chr(13);
  FFTMemo.Clear;
  FFTMemo.Text:=CRLFConv(Copyright);

  Copyright:='Gogo.dll ߌ̂` MP3GR[hGW By PEN@CL,ւ'+chr(13);
  Copyright:=Copyright+'  mFo[W gogo.dll ver. 2.39c (Dec 31 2000)'+chr(13)+chr(13);
  Copyright:=Copyright+'TGogoTea  GogoDLL Support Component version 1.00'+chr(13);
  Copyright:=Copyright+'  programmed by M.yanagisawa.(MoroboshiLUM  elfin@mth.biglobe.ne.jp)'+chr(13);
  MP3Memo.Clear;
  MP3Memo.Text:=CRLFConv(Copyright);

  URLLst.Clear;
  with URLLst.Items do begin
    Add('');
    Add('C60̃z[y[W');
    Add('http://www.fmp.jp/~c60/');
    Add('');
    Add('m_puusañz[y[W');
    Add('http://homepage1.nifty.com/mpuusan/x68sound/');
    Add('');
    Add('SANDMAÑz[y[W');
    Add('http://www-fu.magma.ne.jp/~hayase/');
    Add('');
    Add('PEN@CLAւ݂̃z[y[W');
    Add('http://www.marinecat.net/');
    Add('');
    Add('ڂނ̃z[y[W');
    Add('http://homepage2.nifty.com/~maid/');
    Add('');
    Add('Alpha-II Productions HomePage');
    Add('http://www.alpha-ii.com/');
    Add('');
    Add('Moonlight()̃z[y[W');
    Add('http://home.att.ne.jp/blue/moonlight/index.html');
  end;
  URLgoBtn.Enabled:=False;
  URLLbl.Caption:='';
end;

procedure TCopyright.FormKeyPress(Sender: TObject; var Key: Char);
begin
  if (Key=char(VK_Return)) or (Key=char(VK_ESCAPE)) then ModalResult:=mrOK;
end;

procedure TCopyright.LstClick(Sender: TObject);
var
  mes:string;
begin
  mes:=URLLst.Items[URLLst.ItemIndex];
  if copy(mes,1,7)='http://' then begin
    URLgoBtn.Enabled:=True;
    URLLbl.Caption:=mes;
    end else begin
    URLgoBtn.Enabled:=False;
    URLLbl.Caption:='';
  end;
end;

procedure TCopyright.URLLblClick(Sender: TObject);
begin
  if URLgoBtn.Enabled=True then URLgoBtnClick(Sender);
end;

procedure TCopyright.URLgoBtnClick(Sender: TObject);
var
  URL:string;
begin
  URL:=URLLbl.Caption;
  ShellExecute(0,'',PChar(URL),nil, nil,SW_SHOW);
end;

procedure TCopyright.URLLstDblClick(Sender: TObject);
begin
  if URLgoBtn.Enabled=True then URLgoBtnClick(Sender);
end;

procedure TCopyright.FormResize(Sender: TObject);
begin
  URLLbl.Top:=URLTab.ClientHeight-URLLbl.Height-8;
  URLgoBtn.Top:=URLTab.ClientHeight-URLgoBtn.Height-8;
  URLgoBtn.Left:=URLTab.ClientWidth-URLgoBtn.Width-8;

  with URLLst do begin
    Width:=URLTab.ClientWidth;
    Height:=URLgoBtn.Top-8;
  end;
end;

end.
