unit FolderDlgWin;

{$WARN UNIT_PLATFORM OFF}
{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  Windows, SysUtils, Forms, Classes, Controls, StdCtrls, Buttons, ComCtrls,
  _SimpleDialog,_const, FileCtrl;

type
  TFolderDlg = class(TForm)
    DriveLst: TDriveComboBox;
    DirectoryLst: TDirectoryListBox;
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    StatusBar: TStatusBar;
    FileLst: TFileListBox;
    CreateBtn: TBitBtn;
    procedure FormResize(Sender: TObject);
    procedure DirectoryLstChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CreateBtnClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private 錾 }
    DecDirLstHeight:integer;
    DecBtnTop:integer;
    StartDir:string;
  public
    { Public 錾 }
    procedure OpenDlg(DefPath:string);
  end;

var
  FolderDlg: TFolderDlg;

implementation

{$R *.DFM}

procedure TFolderDlg.OpenDlg(DefPath:string);
begin
  if DirectoryExists(DefPath)=False then DefPath:=StartDir;
  DriveLst.Drive:=DefPath[1];
  DirectoryLst.Directory:=DefPath;
  FolderDlg.Visible:=False;
end;

procedure TFolderDlg.FormResize(Sender: TObject);
var
  Width,Height:integer;
begin
  Width:=FolderDlg.ClientWidth;
  Height:=FolderDlg.ClientHeight;

  DriveLst.Width:=Width;
  DirectoryLst.Width:=Width div 2;
  DirectoryLst.Height:=Height-DecDirLstHeight;
  FileLst.Left:=Width div 2;
  FileLst.Width:=Width div 2;
  FileLst.Height:=Height-DecDirLstHeight;
  DirectoryLst.Height:=Height-DecDirLstHeight;
  OKBtn.Top:=Height-DecBtnTop;
  CancelBtn.Top:=OKBtn.Top;
end;

procedure TFolderDlg.DirectoryLstChange(Sender: TObject);
begin
  StatusBar.SimpleText:=DirectoryLst.Directory;
end;

procedure TFolderDlg.FormCreate(Sender: TObject);
begin
  StartDir:=ExtractFileDir(Application.ExeName)+'\';
  DecDirLstHeight:=FolderDlg.ClientHeight-DirectoryLst.Height;
  DecBtnTop:=FolderDlg.ClientHeight-OKBtn.Top;
end;

procedure TFolderDlg.CreateBtnClick(Sender: TObject);
var
  NewDir:string;
begin
  NewDir:='';
  if InputQuery('tH_̐VK쐬','쐬tH_͂ĂB',NewDir)=True then begin
    if NewDir='' then exit;
    if (AnsiPos('\',NewDir)<>0) or (AnsiPos('.',NewDir)<>0) or (AnsiPos('/',NewDir)<>0) or (AnsiPos('.',NewDir)<>0) then begin
      ShowMessage('MDXWin.exe','tH_Ɏgps\ȕ܂B');
      exit;
    end;
    NewDir:=DirectoryLst.Directory+'\'+NewDir;
    if DirectoryExists(NewDir)=True then begin
      ShowMessage('MDXWin.exe','w肳ꂽtH_͊ɑ݂܂B');
      exit;
    end;
    if CreateDir(NewDir)=False then begin
      ShowMessage('MDXWin.exe','`ĂȂG[ɂătH_쐬ł܂łB');
      end else begin
      ShowMessage('MDXWin.exe','tH_['+NewDir+']쐬܂B');
      DirectoryLst.Directory:=NewDir;
      DirectoryLst.Update;
    end;
  end;
end;

procedure TFolderDlg.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  FolderDlg.Release;
end;

end.
