unit KeySetupWin;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, StdCtrls, Buttons,_KeyDef_const;

type
  TKeySetup = class(TForm)
    KeysGrid: TStringGrid;
    KeyGroup: TGroupBox;
    SetNameLbl: TLabel;
    SetInfoLbl: TLabel;
    SetShiftChk: TCheckBox;
    SetCtrlChk: TCheckBox;
    SetAltChk: TCheckBox;
    SetVKLst: TComboBox;
    SetDefBtn: TButton;
    KeyAllInitBtn: TButton;
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    SetRegKeyBtn: TButton;
    Label1: TLabel;
    Label2: TLabel;
    ApplyBtn: TButton;
    Label5: TLabel;
    Label6: TLabel;
    procedure SetRegKeyBtnClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure KeysGridClick(Sender: TObject);
    procedure SetVKLstExit(Sender: TObject);
    procedure SetClick(Sender: TObject);
    procedure SetDefBtnClick(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure KeyAllInitBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure ApplyBtnClick(Sender: TObject);
    procedure SetVKLstChange(Sender: TObject);
    procedure SetVKLstSelect(Sender: TObject);
  private
    { Private 錾 }
    Change:boolean;
    cDefine:TDefine;
    procedure ChangeKeysGrid(idx:integer);
    procedure ChangeKeyGroup(idx:integer);
  public
    { Public 錾 }
    procedure Init;
  end;

var
  KeySetup: TKeySetup;

implementation

uses _KeyDef,_GridTool;

{$R *.dfm}

procedure TKeySetup.Init;
var
  cnt:integer;
begin
  CopyDefine(KeyDef.Define,cDefine);
  ApplyBtn.Enabled:=False;

  Change:=True;
  SetVKLst.Clear;
  for cnt:=$00 to $ff do begin
    SetVKLst.Items.Add('$'+inttohex(cnt,2)+' '+VKtoStr(cnt));
  end;
  SetVKLst.ItemIndex:=0;
  Change:=False;

  KeySetup.OnKeyDown:=nil;

  KeysGrid.ColCount:=5;
  KeysGrid.RowCount:=cDefine.CommandCount+1;

  with KeysGrid do begin
    Cells[0,0]:='idx';
    ColWidths[0]:=Canvas.TextWidth(StringOfChar('0',4))+3;
    Cells[1,0]:='DCT';
    ColWidths[1]:=Canvas.TextWidth(StringOfChar('0',5))+4;
    Cells[2,0]:='CommandName';
    ColWidths[2]:=Canvas.TextWidth(StringOfChar('0',16))+4;
    Cells[3,0]:='Information';
    ColWidths[3]:=Canvas.TextWidth(StringOfChar('0',46))+4;
    Cells[4,0]:='AssignKey';
    ColWidths[4]:=Canvas.TextWidth(StringOfChar('0',18))+4;
    DefaultRowHeight:=Canvas.TextHeight('0123456789')+4;
  end;

  for cnt:=0 to cDefine.CommandCount-1 do begin
    ChangeKeysGrid(cnt);
  end;

  Grid_MoveIndex(KeysGrid,1);
  ChangeKeyGroup(0);

  KeySetup.Visible:=True;
  SetActiveWindow(KeySetup.Handle);
end;

procedure TKeySetup.ChangeKeysGrid(idx:integer);
begin
  if (idx<0) or (cDefine.CommandCount<=idx) then exit;

  with cDefine.Command[idx] do begin
    KeysGrid.Cells[0,idx+1]:=inttostr(idx);
    KeysGrid.Cells[1,idx+1]:=inttostr(DCT);
    KeysGrid.Cells[2,idx+1]:=Name;
    KeysGrid.Cells[3,idx+1]:=Info;
    KeysGrid.Cells[4,idx+1]:=KeytoStr(VK,Shift,Ctrl,Alt);
  end;
end;

procedure TKeySetup.SetRegKeyBtnClick(Sender: TObject);
begin
  KeySetup.OnKeyDown:=FormKeyDown;
  KeySetup.ActiveControl:=SetVKLst;
  SetRegKeyBtn.Enabled:=False;
end;

procedure TKeySetup.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (Key and $ff00)<>0 then Key:=$00;
  if (Key=VK_LBUTTON) or (Key=VK_RBUTTON) or (Key=VK_MBUTTON) then exit;

  Change:=True;
  SetVKLst.ItemIndex:=Key;
  Change:=False;
  SetClick(Sender);
  ApplyBtn.Enabled:=True;

  KeySetup.OnKeyDown:=nil;
  SetRegKeyBtn.Enabled:=True;

  Key:=0;
end;

procedure TKeySetup.KeysGridClick(Sender: TObject);
begin
  ChangeKeyGroup(Grid_GetIndex(KeysGrid)-1);
end;

procedure TKeySetup.ChangeKeyGroup(idx:integer);
begin
  if (idx<0) or (cDefine.CommandCount<=idx) then begin
    KeyGroup.Caption:='͈͊OځiG[̉\j';
    SetNameLbl.Caption:='';
    SetInfoLbl.Caption:='';
    exit;
  end;

  Change:=True;
  with cDefine.Command[idx] do begin
    KeyGroup.Caption:='Index:'+inttostr(idx)+' CommandType:'+inttostr(DCT);
    SetNameLbl.Caption:=Name;
    SetInfoLbl.Caption:=Info;
    SetVKLst.ItemIndex:=VK and $ff;
    SetShiftChk.Checked:=Shift;
    SetCtrlChk.Checked:=Ctrl;
    SetAltChk.Checked:=Alt;
  end;
  Change:=False;
end;

procedure TKeySetup.SetVKLstExit(Sender: TObject);
begin
  KeySetup.OnKeyDown:=nil;
  SetRegKeyBtn.Enabled:=True;
end;

procedure TKeySetup.SetClick(Sender: TObject);
var
  idx:integer;
begin
  if Change=True then exit;

  idx:=Grid_GetIndex(KeysGrid)-1;
  if (idx<0) or (cDefine.CommandCount<=idx) then exit;

  with cDefine.Command[idx] do begin
    VK:=SetVKLst.ItemIndex;
    Shift:=SetShiftChk.Checked;
    Ctrl:=SetCtrlChk.Checked;
    Alt:=SetAltChk.Checked;
  end;
  ChangeKeysGrid(idx);
  ApplyBtn.Enabled:=True;
end;

procedure TKeySetup.SetDefBtnClick(Sender: TObject);
var
  idx:integer;
begin
  idx:=Grid_GetIndex(KeysGrid)-1;
  if (idx<0) or (cDefine.CommandCount<=idx) then exit;

  DC_SetDefault(cDefine.Command[idx],cDefine.Command[idx].DCT);
  ChangeKeysGrid(idx);
  ChangeKeyGroup(idx);
  ApplyBtn.Enabled:=True;
end;

procedure TKeySetup.OKBtnClick(Sender: TObject);
begin
  ApplyBtnClick(Sender);
  KeySetup.Close;
end;

procedure TKeySetup.KeyAllInitBtnClick(Sender: TObject);
var
  cnt:integer;
  idx:integer;
begin
  for cnt:=0 to cDefine.CommandCount-1 do begin
    DC_SetDefault(cDefine.Command[cnt],cDefine.Command[cnt].DCT);
    ChangeKeysGrid(cnt);
  end;

  idx:=Grid_GetIndex(KeysGrid)-1;
  if (idx<0) or (cDefine.CommandCount<=idx) then exit;
  ChangeKeyGroup(idx);
  ApplyBtn.Enabled:=True;
end;

procedure TKeySetup.CancelBtnClick(Sender: TObject);
begin
  KeySetup.Close;
end;

procedure TKeySetup.ApplyBtnClick(Sender: TObject);
begin
  CopyDefine(cDefine,KeyDef.Define);
  ApplyBtn.Enabled:=False;
end;

procedure TKeySetup.SetVKLstChange(Sender: TObject);
begin
  if Change=True then exit;
  SetClick(Sender);
end;

procedure TKeySetup.SetVKLstSelect(Sender: TObject);
begin
  if Change=True then exit;
  SetClick(Sender);
end;

end.
