unit PathHistWin;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls, ComCtrls, Menus;

type
  TPathHist = class(TForm)
    PageControl1: TPageControl;
    HistoryTab: TTabSheet;
    HistLst: TListBox;
    FavTab: TTabSheet;
    FavLst: TListBox;
    HistMenu: TPopupMenu;
    HistMenu_AddFav: TMenuItem;
    procedure HistMenu_AddFavClick(Sender: TObject);
    procedure FavLstDblClick(Sender: TObject);
    procedure HistLstDblClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
    procedure AddPath(path:string);
  end;

var
  PathHist: TPathHist;

implementation

uses _MainFileCtl;

{$R *.dfm}

procedure TPathHist.FormCreate(Sender: TObject);
begin
  HistLst.Items.Add('݃qXg[Xg͕ۑ܂B');
  FavLst.Items.Add('݂Cɓ胊Xg͕ۑ܂B');
end;

procedure TPathHist.AddPath(path:string);
var
  cnt:integer;
  tmp:string;
begin
  // History󂾂ǉB
  if HistLst.Items.Count=0 then begin
    HistLst.Items.Add(path);
  end;

  // ܂path擪ɎĂB
  for cnt:=0 to HistLst.Items.Count-1 do begin
    if path=HistLst.Items[cnt] then begin
      if cnt<>0 then HistLst.Items.Move(cnt,0);
      exit;
    end;
  end;

  // path̕History蒷XVB
  for cnt:=0 to HistLst.Items.Count-1 do begin
    tmp:=copy(path,1,length(HistLst.Items[cnt]));
    if tmp=HistLst.Items[cnt] then begin
      HistLst.Items.Delete(cnt);
      HistLst.Items.Insert(0,path);
      exit;
    end;
  end;

  // ǂɂȂ擪ɒǉB
  HistLst.Items.Insert(0,path);
end;

procedure TPathHist.HistMenu_AddFavClick(Sender: TObject);
begin
  if HistLst.ItemIndex=-1 then exit;
  FavLst.Items.Add(HistLst.Items[HistLst.ItemIndex]);
end;

procedure TPathHist.FavLstDblClick(Sender: TObject);
begin
  if FavLst.ItemIndex=-1 then exit;
  MainFileCtl.ChangeDir(FavLst.Items[FavLst.ItemIndex]);
end;

procedure TPathHist.HistLstDblClick(Sender: TObject);
begin
  if HistLst.ItemIndex=-1 then exit;
  MainFileCtl.ChangeDir(HistLst.Items[HistLst.ItemIndex]);
end;

end.
