unit PeekWin;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Menus;

type
  TPeek = class(TForm)
    PeekTimer: TTimer;
    PrvImg: TImage;
    GripImg: TImage;
    PopupMenu: TPopupMenu;
    C1: TMenuItem;
    procedure PeekTimerTimer(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure PrvImgMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure PrvImgMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure PrvImgMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure C1Click(Sender: TObject);
  private
    { Private 錾 }
    MMoveFlag,MGripFlag:boolean;
    MMoveX,MMoveY:integer;
  public
    { Public 錾 }
    procedure Init;
    procedure RefreshPeek;
  end;

var
  Peek: TPeek;

implementation

uses _Images,_SndDrv,_MDXWinINI,_PicTools,_CSkin;

{$R *.dfm}

procedure TPeek.Init;
begin
  Peek.Color:=CSkin.dwEtcBG;
  Peek.ClientHeight:=3*24+8;

  PeekLevel.SetEnabled(True);

  PeekTimer.Interval:=MainINI.DSoundSafeTime;
  PeekTimer.Enabled:=True;

  Peek.Visible:=True;
end;

procedure TPeek.PeekTimerTimer(Sender: TObject);
begin
  RefreshPeek;
end;

procedure TPeek.RefreshPeek;
var
  cnt:integer;
  msg:string;
  v:integer;
  x,y:integer;
  BarPeek,BarWidth,BarX,BarY:integer;
  pBarRGB:array[0..16] of PRGB;
  col0,col1:TRGB;
begin
  with PrvImg do begin
    DrawFlameCanvas(Canvas,Width,Height,CSkin.ColEtcFrameBright,CSkin.ColEtcFrameMask);
  end;

  with GripImg do begin
    BitBlt(PrvImg.Canvas.Handle,PrvImg.Width-Width-1,PrvImg.Height-Height-1,Width,Height,Canvas.Handle,0,0,SRCCOPY);
  end;

  col0.r:=$c0;
  col0.g:=$60;
  col0.b:=$60;
  col1.r:=$30;
  col1.g:=$10;
  col1.b:=$10;

  BarWidth:=Peek.ClientWidth-(8*2);

  for cnt:=0 to 2 do begin
    case cnt of
      0: begin
        v:=PeekLevel.GetVolBoot;
        msg:='at Boot.';
      end;
      1: begin
        v:=PeekLevel.GetVolCurrent;
        msg:='at Current.';
      end;
      2: begin
        v:=PeekLevel.GetVolLast;
        msg:='';
      end;
      else begin
        v:=0;
        msg:='';
      end;
    end;
    if (cnt=0) or (cnt=1) then begin
      msg:=format('%5dlev. norm=%5dvol.',[v,PeekLevel.GetSetVolume(v)])+' '+msg;
      end else begin
      msg:=format('%5dlev.',[v]);
    end;
    x:=8;
    y:=cnt*24+8;
    Images.WriteX68kString(PrvImg.Canvas,x+8,y,msg,False);
    for BarY:=0 to 16-1 do begin
      pBarRGB[BarY]:=PrvImg.Picture.Bitmap.ScanLine[y+BarY];
      inc(pBarRGB[BarY],x);
    end;
    BarPeek:=v*BarWidth div $7fff;
    if BarPeek>=BarWidth then BarPeek:=BarWidth-1;
    for BarY:=0 to 16-1 do begin
      for BarX:=0 to BarPeek-1 do begin
        if pBarRGB[BarY]^.r=$00 then pBarRGB[BarY]^:=col0;
        inc(pBarRGB[BarY]);
      end;
      for BarX:=BarPeek to BarWidth-1 do begin
        if pBarRGB[BarY]^.r=$00 then pBarRGB[BarY]^:=col1;
        inc(pBarRGB[BarY]);
      end;
    end;
  end;

  PrvImg.Refresh;
end;

procedure TPeek.FormResize(Sender: TObject);
begin
  MakeBlankImg(PrvImg,pf24bit);
  with PrvImg.Canvas do begin
    Brush.Color:=CSkin.dwEtcBG;
    FillRect(Rect(0,0,PrvImg.Width,PrvImg.Height));
  end;
end;

procedure TPeek.PrvImgMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  pos:TPoint;
begin
  if Button=mbRight then begin
    GetCursorPos(pos);
    PopupMenu.Popup(pos.X,pos.Y);
    exit;
  end;
  
  if ((Peek.Width-16)<=x) and ((Peek.Height-16)<=y) then begin
    MGripFlag:=True;
    end else begin
    MMoveFlag:=True;
  end;
  MMoveX:=X;
  MMoveY:=Y;
end;

procedure TPeek.PrvImgMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var
  wx,wy:integer;
begin
  if MMoveFlag=True then begin
    wx:=Peek.Left+(X-MMoveX);
    wy:=Peek.Top+(Y-MMoveY);
    MoveWindow(Peek.Handle,wx,wy,Peek.Width,Peek.Height,True);
    exit;
  end;

  if MGripFlag=True then begin
    Peek.Width:=Peek.Width+(X-MMoveX);
  end;

  MMoveX:=X;
  MMoveY:=Y;
  if ((Peek.Width-16)<=x) and ((Peek.Height-16)<=y) then begin
    PrvImg.Cursor:=crSizeWE;
    end else begin
    PrvImg.Cursor:=crDefault;
  end;
end;

procedure TPeek.PrvImgMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  MMoveFlag:=False;
  MGripFlag:=False;
  PrvImg.Cursor:=crDefault;
end;

procedure TPeek.C1Click(Sender: TObject);
begin
  PeekLevel.ResetAll;
end;

end.
