unit SKIDlgWin;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls;

type
  TSKIDlg = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    PreviewImg: TImage;
    SkinNameLbl: TLabel;
    CreatorLbl: TLabel;
    LastDateLbl: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    FormatLbl: TLabel;
    VersionLbl: TLabel;
    procedure FormCreate(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
    procedure LoadID(SKIFilename:string);
  end;

var
  SKIDlg: TSKIDlg;

implementation

{$R *.dfm}

uses _CSkin;

procedure TSKIDlg.LoadID(SKIFilename:string);
var
  CSkin:TCSkin;
begin
  if FileExists(SKIFilename)=False then exit;
  
  CSkin:=TCSkin.Create;
  CSkin.LoadSkin(SKIFilename);

  FormatLbl.Caption:=CSkin.sFormat;
  VersionLbl.Caption:=CSkin.sVersion;
  SkinNameLbl.Caption:=CSkin.sSkinName;
  CreatorLbl.Caption:=CSkin.sCreator;
  LastDateLbl.Caption:=CSkin.sLastDate;

  CSkin.LoadBitmap('Preview.bmp',PreviewImg.Picture.Bitmap,256,128,pf24bit);
  PreviewImg.Refresh;

  CSkin.Free;
end;

procedure TSKIDlg.FormCreate(Sender: TObject);
begin
  SKIDlg.Top:=0;
  SKIDlg.Left:=0;
  SKIDlg.Caption:='SimpleSkin PreviewWindow.';
  
  FormatLbl.Caption:='';
  VersionLbl.Caption:='';
  SkinNameLbl.Caption:='';
  CreatorLbl.Caption:='';
  LastDateLbl.Caption:='';
end;

end.
