unit ToolTipWin;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TToolTip = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    HideTimer: TTimer;
    BGShape: TShape;
    procedure HideTimerTimer(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormPaint(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
    procedure SetText(t1,t2:string);
  end;

var
  ToolTip: TToolTip;

implementation

uses _MDXWinINI,_CSkin;

{$R *.dfm}

procedure TToolTip.SetText(t1,t2:string);
var
  x,y:integer;
  udt:TRect;
  udtWidth,udtHeight:integer;
begin
  Label1.Caption:=t1;
  Label2.Caption:=t2;

  if (t1='') and (t2='') then exit;

  udt:=Screen.WorkAreaRect;
  udtWidth:=udt.Right-udt.Left;
  udtHeight:=udt.Bottom-udt.Top;

  Label1.Left:=2;
  Label1.Top:=2;
  Label2.Left:=2;
  Label2.Top:=Label1.Height+2;

  if Label1.Width>Label2.Width then begin
    x:=Label1.Width+2;
    end else begin
    x:=Label2.Width+2;
  end;
  y:=Label2.Top+Label2.Height+2;

  if x>udtWidth then x:=udtWidth;
  if y>udtHeight then y:=udtHeight;

  ToolTip.ClientWidth:=x;
  ToolTip.ClientHeight:=y;
  ToolTip.Left:=udt.Left+udtWidth-x-2;
  ToolTip.Top:=udt.Top+udtHeight-y-2;

  BGShape.Pen.Color:=CSkin.dwBright;
  BGShape.Brush.Color:=CSkin.dwBG;
  Label1.Font.Color:=CSkin.dwText;
  Label2.Font.Color:=CSkin.dwText;

  ToolTip.Visible:=False;
  if (MainINI.ToolTipTransparentLevel<$00) or ($ff<=MainINI.ToolTipTransparentLevel) then begin
    ToolTip.AlphaBlend:=False;
    ToolTip.AlphaBlendValue:=$ff;
    end else begin
    ToolTip.AlphaBlend:=True;
    ToolTip.AlphaBlendValue:=MainINI.ToolTipTransparentLevel;
  end;
  ToolTip.Visible:=True;
  HideTimer.Enabled:=False;
  HideTimer.Enabled:=True;
end;

procedure TToolTip.HideTimerTimer(Sender: TObject);
begin
  HideTimer.Enabled:=False;
  ToolTip.Visible:=False;
end;

procedure TToolTip.FormMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  HideTimerTimer(Sender);
end;

procedure TToolTip.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  HideTimerTimer(Sender);
end;

procedure TToolTip.FormPaint(Sender: TObject);
begin
  SetWindowPos(ToolTip.Handle,HWND_TOPMOST,0,0,0,0,SWP_NOSIZE or SWP_NOMOVE);
end;

end.
