unit VisSetupWin;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, Buttons, ExtCtrls;

type
  TVisSetup = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    SetAlreadyRefresh: TCheckBox;
    SetEffect: TCheckBox;
    SetGradEnabled: TCheckBox;
    SetAnalyzeFrame: TComboBox;
    Label8: TLabel;
    Label9: TLabel;
    SetAnalyzeFFT: TComboBox;
    TabSheet2: TTabSheet;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    GroupBox3: TGroupBox;
    GroupBox4: TGroupBox;
    SetSpeanaWaveAntialias: TCheckBox;
    SetSpeanaWaveZeroAjust: TCheckBox;
    SetSpeanaLineAntialias: TCheckBox;
    SetSpeanaBarDoubleSide: TCheckBox;
    Label1: TLabel;
    TabSheet3: TTabSheet;
    SetSonarAntialias: TCheckBox;
    SetSonarBaseColorLbl: TLabel;
    SetSonarBaseColorMorphLbl: TLabel;
    SetSonarBaseColorMorph: TTrackBar;
    SetSonarBaseColorPreview: TShape;
    SonarColorTestImg: TImage;
    Label2: TLabel;
    TabSheet4: TTabSheet;
    SetKeyboardUseFadeout: TCheckBox;
    SonarDefaultBtn: TButton;
    SetKeyboardRealKeys: TCheckBox;
    KeyboardDefaultBtn: TButton;
    SetKeyboardDraw9to16trk: TCheckBox;
    procedure OKBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure SetSonarBaseColorMorphChange(Sender: TObject);
    procedure SetSonarBaseColorPreviewMouseUp(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure SonarDefaultBtnClick(Sender: TObject);
    procedure KeyboardDefaultBtnClick(Sender: TObject);
  private
    SetSonarBaseColor:dword;
    procedure SetupCancel;
    procedure SetupSave;
    procedure RefreshSetSonarBaseColor;
  public
    procedure SetCreate;
  end;

var
  VisSetup: TVisSetup;

implementation

uses ColorPickWin,
     _MDXWinINI,_const,_PicTools,_Vis;

{$R *.dfm}

procedure TVisSetup.RefreshSetSonarBaseColor;
var
  x:integer;
  rgb:TRGB;
  chcol:TRGB;
  c:smallint;
  morph:integer;
begin
  SetSonarBaseColorMorphLbl.Caption:='J[[tBO ($'+inttohex(SetSonarBaseColorMorph.Position,2)+')';
  SetSonarBaseColorLbl.Caption:='x[XJ[ ($'+inttohex(SetSonarBaseColor,8)+')';
  SetSonarBaseColorPreview.Brush.Color:=SetSonarBaseColor;

  rgb:=dword2rgb(SetSonarBaseColor);
  morph:=SetSonarBaseColorMorph.Position;

  with SonarColorTestImg do begin
    for x:=0 to (Width div 4)-1 do begin
      c:=integer(rgb.b)+(random(morph)-(morph div 2));
      if c<$00 then c:=$00;
      if c>$ff then c:=$ff;
      chcol.b:=c;
      c:=integer(rgb.g)+(random(morph)-(morph div 2));
      if c<$00 then c:=$00;
      if c>$ff then c:=$ff;
      chcol.g:=c;
      c:=integer(rgb.r)+(random(morph)-(morph div 2));
      if c<$00 then c:=$00;
      if c>$ff then c:=$ff;
      chcol.r:=c;

      Canvas.Brush.Color:=rgb2dword(chcol);
      Canvas.FillRect(bounds(x*4,0,4,Height));
    end;
  end;
end;

procedure TVisSetup.SetCreate;
begin
  MDXWinINIFilesave(ExtractFileDir(Application.ExeName)+'\MDXWin.ini');

  PageControl1.ActivePageIndex:=VisINI.SetupLastPage;

  with VisINI do begin
    SetEffect.Checked:=UseEffect;
    SetGradEnabled.Checked:=GradEnabled;
    case AnalyzeFrame of
      10: SetAnalyzeFrame.ItemIndex:=0;
      20: SetAnalyzeFrame.ItemIndex:=1;
      30: SetAnalyzeFrame.ItemIndex:=2;
      50: SetAnalyzeFrame.ItemIndex:=3;
      60: SetAnalyzeFrame.ItemIndex:=4;
      70: SetAnalyzeFrame.ItemIndex:=5;
      90: SetAnalyzeFrame.ItemIndex:=6;
      100: SetAnalyzeFrame.ItemIndex:=7;
      else SetAnalyzeFrame.ItemIndex:=1;
    end;
    SetAnalyzeFFT.ItemIndex:=AnalyzeFFT-1;
    SetAlreadyRefresh.Checked:=AlreadyRefresh;
  end;

  with VisINI do begin
    SetKeyboardUseFadeout.Checked:=KeyboardUseFadeout;
    SetKeyboardDraw9to16trk.Checked:=KeyboardDraw9to16trk;
    SetKeyboardRealKeys.Checked:=KeyboardRealKeys;
  end;

  with VisINI do begin
    SetSpeanaWaveAntialias.Checked:=SpeanaWaveAntialias;
    SetSpeanaWaveZeroAjust.Checked:=SpeanaWaveZeroAjust;
    SetSpeanaBarDoubleSide.Checked:=SpeanaBarDoubleSide;
    SetSpeanaLineAntialias.Checked:=SpeanaLineAntialias;
  end;

  with VisINI do begin
    SetSonarAntialias.Checked:=SonarAntialias;
    SetSonarBaseColor:=SonarBaseColor;
    SetSonarBaseColorMorph.Position:=SonarBaseColorMorph;
  end;

  RefreshSetSonarBaseColor;
end;

procedure TVisSetup.SetupCancel;
begin
  MDXWinINIFileload(ExtractFileDir(Application.ExeName)+'\MDXWin.ini');
  VisINI.SetupLastPage:=PageControl1.ActivePageIndex;
  ModalResult:=mrCancel;
end;

procedure TVisSetup.SetupSave;
var
  RequestReset:boolean;
begin
  RequestReset:=False;
  with VisINI do begin
    if AnalyzeFrame<>StrToIntDef(SetAnalyzeFrame.Text,20) then RequestReset:=True;
    if AnalyzeFFT<>StrToIntDef(SetAnalyzeFFT.Text,2) then RequestReset:=True;
  end;

  if RequestReset=True then begin
    MessageDlg('ʃGtFNgbԃt[AFFTAiCU[͊ԈύX܂B'+CRLF+'ȂĐOMDXWinċNĂB',mtWarning,[mbOK],0);
  end;

  VisINI.SetupLastPage:=PageControl1.ActivePageIndex;

  with VisINI do begin
    UseEffect:=SetEffect.Checked;
    GradEnabled:=SetGradEnabled.Checked;
    AnalyzeFrame:=StrToIntDef(SetAnalyzeFrame.Text,20);
    AnalyzeFFT:=StrToIntDef(SetAnalyzeFFT.Text,2);
    AlreadyRefresh:=SetAlreadyRefresh.Checked;
  end;

  with VisINI do begin
    KeyboardUseFadeout:=SetKeyboardUseFadeout.Checked;
    KeyboardDraw9to16trk:=SetKeyboardDraw9to16trk.Checked;
    KeyboardRealKeys:=SetKeyboardRealKeys.Checked;
  end;

  with VisINI do begin
    SpeanaWaveAntialias:=SetSpeanaWaveAntialias.Checked;
    SpeanaWaveZeroAjust:=SetSpeanaWaveZeroAjust.Checked;
    SpeanaBarDoubleSide:=SetSpeanaBarDoubleSide.Checked;
    SpeanaLineAntialias:=SetSpeanaLineAntialias.Checked;
  end;

  with VisINI do begin
    SonarAntialias:=SetSonarAntialias.Checked;
    SonarBaseColor:=SetSonarBaseColor;
    SonarBaseColorMorph:=SetSonarBaseColorMorph.Position;
  end;

  Vis.Init(VisINI.AnalyzeFrame);

  ModalResult:=mrOk;
end;

procedure TVisSetup.OKBtnClick(Sender: TObject);
begin
  SetupSave;
end;

procedure TVisSetup.CancelBtnClick(Sender: TObject);
begin
  SetupCancel;
end;

procedure TVisSetup.SetSonarBaseColorMorphChange(Sender: TObject);
begin
  RefreshSetSonarBaseColor;
end;

procedure TVisSetup.SetSonarBaseColorPreviewMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  Application.CreateForm(TColorPick, ColorPick);
  ColorPick.StartPick(SetSonarBaseColor);
  ColorPick.ShowModal;
  SetSonarBaseColor:=ColorPick.PickColor;
  ColorPick.Release;
  RefreshSetSonarBaseColor;
end;

procedure TVisSetup.SonarDefaultBtnClick(Sender: TObject);
begin
  SetSonarAntialias.Checked:=True;
  SetSonarBaseColor:=$ffc0c0;
  SetSonarBaseColorMorph.Position:=$40;
end;

procedure TVisSetup.KeyboardDefaultBtnClick(Sender: TObject);
begin
  SetKeyboardUseFadeout.Checked:=True;
  SetKeyboardDraw9to16trk.Checked:=False;
  SetKeyboardRealKeys.Checked:=False;
end;

end.
