//
//  Gogo DLL  basic defination unit.
//  programmed by M.yanagisawa.
//  this program is based on dgogo.zip - gogodll.pas.
//
//  Tab columns = 4
//
unit GogoDefs;

// ]vȒ`͍폜 & ϊ̌ɂ̂C @myan.
// _Ci~bN[hɏCB

interface

uses
  Windows,Registry,SysUtils;

type
  MERET = Integer;
  MPARAM = LongInt;
  UPARAM = LongInt;

// ERROR CODES
const
  ME_NOERR				= 0;	// I
  ME_EMPTYSTREAM		= 1;	// Xg[ŌɒB
  ME_HALTED				= 2;	// ([U[̎ɂ)fꂽ

  ME_INTERNALERROR		= 10;	// G[
  ME_PARAMERROR 		= 11;	// ݒŃp[^[G[
  ME_NOFPU				= 12;	// FPU𑕒ĂȂ!!
  ME_INFILE_NOFOUND		= 13;	// ̓t@C𐳂JȂ
  ME_OUTFILE_NOFOUND	= 14;	// o̓t@C𐳂JȂ
  ME_FREQERROR			= 15;	// o͎gȂ
  ME_BITRATEERROR		= 16;	// o̓rbg[gȂ
  ME_WAVETYPE_ERR		= 17;	// EF[u^CvȂ
  ME_CANNOT_SEEK		= 18;	// V[NoȂ
  ME_BITRATE_ERR		= 19;	// rbg[gݒ肪Ȃ
  ME_BADMODEORLAYER		= 20;	// [hEC̐ݒُ
  ME_NOMEMORY			= 21;	// A[P[Vs
  ME_CANNOT_SET_SCOPE	= 22;	// XbhG[(pthread only)
  ME_CANNOT_CREATE_THREAD = 23;	// XbhG[
  ME_WRITEERROR			= 24;	// L}̗̂eʕs

type
  MPGE_USERFUNC = function(Buf: Pointer; nLength: DWORD ):MERET; cdecl;
  TMpgeUserFunc = MPGE_USERFUNC;

////////////////////////////////////////////////////////////////////////////
/// ݒp
////////////////////////////////////////////////////////////////////////////
/// ̓t@Cݒ ()
const

  MC_INPUTFILE			= 1;
/// para1 ̓foCX̑I
  MC_INPDEV_FILE		= 0; // ̓foCX̓t@C
  MC_INPDEV_STDIO		= 1; // ̓foCX͕W
  MC_INPDEV_USERFUNC	= 2; // ̓foCX̓[U[`

/// para2 (Kvł)t@CB|C^w肷
/// GR[h͈̎ȉ̍\̂̃|C^w肷.
type
  MCP_INPDEV_USERFUNC = record
    pUserFunc: TMpgeUserFunc;
    nSize: DWORD;
    nBit: Integer;
    nFreq: Integer;
    nChn: Integer;
  end {MCP_INPDEV_USERFUNC};
  TMcpInpdevUserFunc = MCP_INPDEV_USERFUNC;
  PMcpInpdevUserFunc = ^MCP_INPDEV_USERFUNC;

const
  MC_INPDEV_MEMORY_NOSIZE = $FFFFFFFF; {(UINT_MAX);} // TCYs̎͂nSizeɓ

////////////////////////////////////////////////////////////////////////////
/// o̓t@Cݒ (stdoutT|[g) 
const
  MC_OUTPUTFILE		= 2;

/// para1 o̓foCXݒ
  MC_OUTDEV_FILE	= 0; // o̓foCX̓t@C
  MC_OUTDEV_STDOUT	= 1; // o̓foCX͕Wo
  MC_OUTDEV_USERFUNC = 2; // o̓foCX̓[U[`
/// para2 (Kvł)t@CB|C^w

////////////////////////////////////////////////////////////////////////////
/// GR[h^Cv
const
  MC_ENCODEMODE		= 3;
/// para1 [hݒ
  MC_MODE_MONO		= 0; // m
  MC_MODE_STEREO	= 1; // XeI
  MC_MODE_JOINT		= 2; // WCg
  MC_MODE_MSSTEREO	= 3; // ~bhTCh
  MC_MODE_DUALCHANNEL = 4; // fA`l

////////////////////////////////////////////////////////////////////////////
/// rbg[gݒ
const
  MC_BITRATE		= 4;
/// para1 rbg[g lw

////////////////////////////////////////////////////////////////////////////
/// ͂ŗpTvg̋w
const
  MC_INPFREQ		= 5;
/// para1 o͂ŗpf[^

////////////////////////////////////////////////////////////////////////////
/// o͂ŗpTvg̋w
const
  MC_OUTFREQ		= 6;
/// para1 o͂ŗpf[^

////////////////////////////////////////////////////////////////////////////
/// GR[hJnʒűw(wb_𖳎鎞)
const
  MC_STARTOFFSET	=7;

////////////////////////////////////////////////////////////////////////////
/// S ON/OFF
const
  MC_USEPSY			= 8;
/// PARA1 BOOLl(TRUE/FALSE)

////////////////////////////////////////////////////////////////////////////
/// 16KHzшtB^ ON/OFF
const
  MC_USELPF16		= 9;
/// PARA1 BOOLl(TRUE/FALSE)

////////////////////////////////////////////////////////////////////////////
/// jbgw para1:BOOLl
const
  MC_USEMMX			= 10; // MMX@\̎gpݒ
  MC_USE3DNOW		= 11; // 3DNow!@\̎gpݒ
  MC_USEKNI			= 12; // KNI@\̎gpݒ
  MC_USEE3DNOW		= 13; // Extend 3D Now!@\̎gpݒ
  MC_USESPC1		= 14; // XCb`gpݒ
  MC_USESPC2		= 15; // XCb`gpݒ

////////////////////////////////////////////////////////////////////////////
/// t@C^Ot
const
  MC_ADDTAG			= 16;
/// dwPara1 ^O
/// dwPara2 ^Of[^̃|C^

////////////////////////////////////////////////////////////////////////////
/// Gt@VX^Cv̐ݒ
const
  MC_EMPHASIS		= 17;
/// para1 Gt@VX^Cv̐ݒ
  MC_EMP_NONE		= 0; // Gt@VXȂ(dflt)
  MC_EMP_5015MS		= 1; // Gt@VX50/15ms
  MC_EMP_CCITT		= 3; // Gt@VXCCITT

////////////////////////////////////////////////////////////////////////////
/// VBR^Cv̐ݒ
const
  MC_VBR			= 18;

////////////////////////////////////////////////////////////////////////////
/// SMP support para1: interger
const
  MC_CPU			= 19;

////////////////////////////////////////////////////////////////////////////
/// ȉ4RAW-PCM̐ݒ̂
/// PCM͎low, high bit ϊ
const
  MC_BYTE_SWAP		= 20;

////////////////////////////////////////////////////////////////////////////
/// 8bit PCM ͎
const
  MC_8BIT_PCM		= 21;

////////////////////////////////////////////////////////////////////////////
/// mono PCM ͎
const
  MC_MONO_PCM		= 22;

////////////////////////////////////////////////////////////////////////////
/// Towns SND ͎
const
  MC_TOWNS_SND		= 23;

///////////////////////////////////////////////////////////////////////////
// BeOS & Win32 Encode thread priority
const
  MC_THREAD_PRIORITY	= 24;
// (WIN32) dwPara1 MULTITHREAD Priority (THREAD_PRIORITY_**** at WinBASE.h )

///////////////////////////////////////////////////////////////////////////
// BeOS Read thread priority
//#if	defined(USE_BTHREAD)
const
	MC_READTHREAD_PRIORITY = 25;
//#endif

///////////////////////////////////////////////////////////////////////////
// output format 
const
	MC_OUTPUT_FORMAT	=	26;
// para1 
	MC_OUTPUT_NORMAL	= 	0;				// mp3+TAG(see MC_ADDTAG)
	MC_OUTPUT_RIFF_WAVE	=	1;				// RIFF/WAVE
	MC_OUTPUT_RIFF_RMP	=	2;				// RIFF/RMP

///////////////////////////////////////////////////////////////////////////
// LIST/INFO chunk of RIFF/WAVE or RIFF/RMP 
const
	MC_RIFF_INFO		=	27;
// para1 size of info(include info name)
// para2 pointer to info
//   offset            contents
//   0..3              info name
//   4..size of info-1 info

///////////////////////////////////////////////////////////////////////////
// verify and overwrite
const
	MC_VERIFY			= 	28;

///////////////////////////////////////////////////////////////////////////
// output directory
const
	MC_OUTPUTDIR		=	29;

///////////////////////////////////////////////////////////////////////////
// VBR̍Œ/ōrbg[g̐ݒ
const
	MC_VBRBITRATE		=	30;
// para1 Œrbg[g (kbps)
// para2 ōrbg[g (kbps)

///////////////////////////////////////////////////////////////////////////
// gtB^̎gp LPF1, LPF2
const
	MC_ENHANCEDFILTER	=	31;
// para1 LPF1 (0-100)
// para2 LPF2 (0-100)

///////////////////////////////////////////////////////////////////////////
// Joint-stereoɂAXeI/MSXeI̐؂ւ臒l
const
	MC_MSTHRESHOLD	 	=	32;
// para1 threshold  (0-100)
// para2 mspower    (0-100)

///////////////////////////////////////////////////////////////////////////
// Language
const
	MC_LANG				=	33;

/////////////////////////////////////////////////////////////////////////////
/// ݒ擾p
/////////////////////////////////////////////////////////////////////////////
/// 
const
  MG_INPUTFILE		= 1; // ̓t@C擾
  MG_OUTPUTFILE		= 2; // o̓t@C擾
  MG_ENCODEMODE		= 3; // GR[h[h
  MG_BITRATE		= 4; // rbg[g
  MG_INPFREQ		= 5; // ͎g
  MG_OUTFREQ		= 6; // o͎g
  MG_STARTOFFSET	= 7; // X^[gItZbg()
  MG_USEPSY			= 8; // S͂gp/Ȃ
  MG_USEMMX			= 9; // MMX@\̎gpݒ
  MG_USE3DNOW		= 10; // 3DNow!@\̎gpݒ
  MG_USEKNI			= 11; // KNI@\̎gpݒ
  MG_USEE3DNOW		= 12; // Extend 3DNow!@\̎gpݒ
  MG_USESPC1		= 13; // XCb`gpݒ
  MG_USESPC2		= 14; // XCb`gpݒ
  MG_COUNT_FRAME	= 15; // Ŝ̃t[擾
  MG_MPEG_VERSION	= 17; //MPEG VERSION擾
  MG_READTHREAD_PRIORITY = 18; // thread priority to read for BeOS

////////////////////////////////////////////////////////////////////////////
/// MPGE_getUnitStates p
const
  tFPU		= $00000001;
  tMMX		= $00000002;
  t3DN		= $00000004;
  tSSE		= $00000008;
  tCMOV		= $00000010;
  tE3DN		= $00000020;   // Athlonp(Externd 3D Now!)
  tEMMX		= $00000040;   // EMMX=E3DNow!_INT=SSE_INT

  tINTEL 	= $00000100;
  tAMD	 	= $00000200;
  tCYRIX	= $00000400;
  tIDT	 	= $00000800;
  tUNKNOWN	= $00008000; // x_[s

  tSPC1		= $00010000;  // ʂȃXCb`
  tSPC2		= $00020000;  // pr͌܂ĂȂ

  tFAMILY4	= $00100000;  // 486 ̎x_[͓ĂɂȂȂ
  tFAMILY5	= $00200000;  // 586 (P5, P5-MMX, K6, K6-2, K6-III)
  tFAMILY6	= $00400000;  // 686ȍ~ P-Pro, P-II, P-III, Athlon

type
  FMPGE_MERRETreturnedonly = function:MERET  ;cdecl;
  FMPGE_setConfigure = function (mode: MPARAM; dwPara1: UPARAM; dwPara2: UPARAM): MERET  ;cdecl;
  FMPGE_getConfigure = function (mode: MPARAM; var para1): MERET  ;cdecl;
  FMPGE_getUnitStates = function (var units: LongInt): MERET  ;cdecl;
  FMPGE_getVersion = function (var vercode: LongInt; verstring: PChar): MERET; cdecl;
/// vercode = 0x125 -> version 1.25
/// verstring -> "ver 1.25 1999/09/25" (260byteȏ̗̈pӂ邱)

// GogoDLL Apis
var
  MPGE_initializeWork : FMPGE_MERRETreturnedonly;
  MPGE_setConfigure : FMPGE_setConfigure;
  MPGE_getConfigure : FMPGE_getConfigure;
  MPGE_detectConfigure: FMPGE_MERRETreturnedonly;
  MPGE_processFrame: FMPGE_MERRETreturnedonly;
  MPGE_closeCoder: FMPGE_MERRETreturnedonly;
  MPGE_endCoder: FMPGE_MERRETreturnedonly;
  MPGE_getUnitStates : FMPGE_getUnitStates;
  MPGE_getVersion : FMPGE_getVersion;
//
  GogoDLLPath : string;

function InitGogoDefs:boolean;
procedure DeallocateGogoDLL;

implementation

var
  hDLLHandle : THandle;
  DLLOpenCnt : integer;	// DLLQƃJE^

function InitGogoDefs:boolean;
var
  s : string;
  Reg : TRegistry;
begin
  Result:=FALSE;
  if DLLOpenCnt>0 then begin
    inc(DLLOpenCnt);	// QƃJE^+1
    Result:=TRUE;
    exit;
  end;
  GogoDLLPath:='';
  s:='';
  hDLLHandle:=LoadLibrary('GOGO.DLL');
  if hDLLHandle=0 then begin
    // registry̎wꏊB
    Reg:=TRegistry.Create;
    try
      with Reg do begin
        RootKey:= HKEY_CURRENT_USER;
        if OpenKey('Software\MarineCat\GOGO_DLL',FALSE) then begin
          s:=ReadString('INSTPATH');
          CloseKey;
        end;
      end;
    Finally
      Reg.Free;
    end;
    if s<>'' then hDLLHandle:=LoadLibrary(PChar(s));
  end;
  if hDLLHandle<>0 then begin
    @MPGE_initializeWork:=GetProcAddress(hDLLHandle,'MPGE_initializeWork');
    @MPGE_setConfigure:=GetProcAddress(hDLLHandle,'MPGE_setConfigure');
    @MPGE_getConfigure:=GetProcAddress(hDLLHandle,'MPGE_getConfigure');
    @MPGE_detectConfigure:=GetProcAddress(hDLLHandle,'MPGE_detectConfigure');
    @MPGE_processFrame:=GetProcAddress(hDLLHandle,'MPGE_processFrame');
    @MPGE_closeCoder:=GetProcAddress(hDLLHandle,'MPGE_closeCoder');
    @MPGE_endCoder:=GetProcAddress(hDLLHandle,'MPGE_endCoder');
    @MPGE_getUnitStates:=GetProcAddress(hDLLHandle,'MPGE_getUnitStates');
    @MPGE_getVersion:=GetProcAddress(hDLLHandle,'MPGE_getVersion');
    if (@MPGE_initializeWork=NIL)
      or (@MPGE_setConfigure=NIL)
      or (@MPGE_getConfigure=NIL)
      or (@MPGE_detectConfigure=NIL)
      or (@MPGE_processFrame=NIL)
      or (@MPGE_closeCoder=NIL)
      or (@MPGE_endCoder=NIL)
      or (@MPGE_getUnitStates=NIL)
      or (@MPGE_getVersion=NIL) then begin
	  FreeLibrary(hDLLHandle);
	  DLLOpenCnt:=0;
	  hDLLHandle:=0;
    end
    else begin
      DLLOpenCnt:=1;
      GogoDLLPath:=s;
      Result:=TRUE; // I
	end;
  end;
end;

procedure DeallocateGogoDLL;
  begin
    if DLLOpenCnt=1 then begin
      if hDLLHandle<>0 then FreeLibrary(hDLLHandle);
      hDLLHandle:=0;
    end;
    dec(DLLOpenCnt);
  end;

initialization
  hDLLHandle:=0;
  DLLOpenCnt:=0;

finalization
  // ꉞAn
  DLLOpenCnt:=1; // JĂKDeAllocate
  DeallocateGogoDLL;

end.
